/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.catalog;

import com.google.auto.service.AutoService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.converter.BasicTypeConverter;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.converter.TypeConverter;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.client.EsType;

@AutoService(value={TypeConverter.class})
public class ElasticSearchTypeConverter
implements BasicTypeConverter<BasicTypeDefine<EsType>> {
    public static final ElasticSearchTypeConverter INSTANCE = new ElasticSearchTypeConverter();

    public String identifier() {
        return "Elasticsearch";
    }

    public Column convert(BasicTypeDefine<EsType> typeDefine) {
        String type;
        PhysicalColumn.PhysicalColumnBuilder builder = PhysicalColumn.builder().name(typeDefine.getName()).sourceType(typeDefine.getColumnType()).nullable(typeDefine.isNullable()).defaultValue(typeDefine.getDefaultValue()).comment(typeDefine.getComment());
        switch (type = typeDefine.getDataType().toLowerCase()) {
            case "aggregate_metric_double": {
                List metrics = (List)((EsType)typeDefine.getNativeType()).getOptions().get("metrics");
                builder.dataType((SeaTunnelDataType)new SeaTunnelRowType(metrics.toArray(new String[0]), (SeaTunnelDataType[])metrics.stream().map(s2 -> BasicType.DOUBLE_TYPE).toArray(SeaTunnelDataType[]::new)));
                break;
            }
            case "dense_vector": {
                String elementType = ((EsType)typeDefine.getNativeType()).getOptions().get("element_type").toString();
                if (elementType.equals("byte")) {
                    builder.dataType((SeaTunnelDataType)ArrayType.BYTE_ARRAY_TYPE);
                    break;
                }
                builder.dataType((SeaTunnelDataType)ArrayType.FLOAT_ARRAY_TYPE);
                break;
            }
            case "byte": {
                builder.dataType((SeaTunnelDataType)BasicType.BYTE_TYPE);
                break;
            }
            case "boolean": {
                builder.dataType((SeaTunnelDataType)BasicType.BOOLEAN_TYPE);
                break;
            }
            case "date": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE);
                builder.scale(Integer.valueOf(3));
                break;
            }
            case "date_nanos": {
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE);
                builder.scale(Integer.valueOf(9));
                break;
            }
            case "double": 
            case "rank_feature": {
                builder.dataType((SeaTunnelDataType)BasicType.DOUBLE_TYPE);
                break;
            }
            case "float": 
            case "half_float": {
                builder.dataType((SeaTunnelDataType)BasicType.FLOAT_TYPE);
                break;
            }
            case "histogram": {
                SeaTunnelRowType rowType = new SeaTunnelRowType(new String[]{"values", "counts"}, new SeaTunnelDataType[]{ArrayType.DOUBLE_ARRAY_TYPE, ArrayType.LONG_ARRAY_TYPE});
                builder.dataType((SeaTunnelDataType)rowType);
                break;
            }
            case "integer": 
            case "token_count": {
                builder.dataType((SeaTunnelDataType)BasicType.INT_TYPE);
                break;
            }
            case "long": {
                builder.dataType((SeaTunnelDataType)BasicType.LONG_TYPE);
                break;
            }
            case "short": {
                builder.dataType((SeaTunnelDataType)BasicType.SHORT_TYPE);
                break;
            }
            case "object": {
                Map<String, Object> typeInfo = ((EsType)typeDefine.getNativeType()).getOptions();
                SeaTunnelRowType object = new SeaTunnelRowType(typeInfo.keySet().toArray(new String[0]), (SeaTunnelDataType[])typeInfo.values().stream().map(this::convert).map(Column::getDataType).toArray(SeaTunnelDataType[]::new));
                builder.dataType((SeaTunnelDataType)object);
                break;
            }
            case "integer_range": {
                builder.dataType((SeaTunnelDataType)new MapType((SeaTunnelDataType)BasicType.STRING_TYPE, (SeaTunnelDataType)BasicType.INT_TYPE));
                break;
            }
            case "float_range": {
                builder.dataType((SeaTunnelDataType)new MapType((SeaTunnelDataType)BasicType.STRING_TYPE, (SeaTunnelDataType)BasicType.FLOAT_TYPE));
                break;
            }
            case "long_range": {
                builder.dataType((SeaTunnelDataType)new MapType((SeaTunnelDataType)BasicType.STRING_TYPE, (SeaTunnelDataType)BasicType.LONG_TYPE));
                break;
            }
            case "double_range": {
                builder.dataType((SeaTunnelDataType)new MapType((SeaTunnelDataType)BasicType.STRING_TYPE, (SeaTunnelDataType)BasicType.DOUBLE_TYPE));
                break;
            }
            case "date_range": {
                builder.dataType((SeaTunnelDataType)new MapType((SeaTunnelDataType)BasicType.STRING_TYPE, (SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE));
                break;
            }
            case "ip_range": {
                builder.dataType((SeaTunnelDataType)new MapType((SeaTunnelDataType)BasicType.STRING_TYPE, (SeaTunnelDataType)BasicType.STRING_TYPE));
                break;
            }
            case "unsigned_long": {
                builder.dataType((SeaTunnelDataType)new DecimalType(20, 0));
                builder.columnLength(Long.valueOf(20L));
                builder.scale(Integer.valueOf(0));
                break;
            }
            default: {
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
            }
        }
        return builder.build();
    }

    public BasicTypeDefine<EsType> reconvert(Column column) {
        BasicTypeDefine.BasicTypeDefineBuilder builder = BasicTypeDefine.builder().name(column.getName()).nullable(column.isNullable()).comment(column.getComment()).defaultValue(column.getDefaultValue());
        switch (column.getDataType().getSqlType()) {
            case BOOLEAN: {
                builder.columnType("boolean");
                builder.dataType("boolean");
                builder.nativeType((Object)new EsType("boolean", new HashMap<String, Object>()));
                break;
            }
            case BYTES: {
                builder.columnType("binary");
                builder.dataType("binary");
                builder.nativeType((Object)new EsType("binary", new HashMap<String, Object>()));
                break;
            }
            case TINYINT: {
                builder.columnType("byte");
                builder.dataType("byte");
                builder.nativeType((Object)new EsType("byte", new HashMap<String, Object>()));
                break;
            }
            case SMALLINT: {
                builder.columnType("short");
                builder.dataType("short");
                builder.nativeType((Object)new EsType("short", new HashMap<String, Object>()));
                break;
            }
            case INT: {
                builder.columnType("integer");
                builder.dataType("integer");
                builder.nativeType((Object)new EsType("integer", new HashMap<String, Object>()));
                break;
            }
            case BIGINT: {
                builder.columnType("long");
                builder.dataType("long");
                builder.nativeType((Object)new EsType("long", new HashMap<String, Object>()));
                break;
            }
            case FLOAT: {
                builder.columnType("float");
                builder.dataType("float");
                builder.nativeType((Object)new EsType("float", new HashMap<String, Object>()));
                break;
            }
            case DOUBLE: {
                builder.columnType("double");
                builder.dataType("double");
                builder.nativeType((Object)new EsType("double", new HashMap<String, Object>()));
                break;
            }
            case DATE: 
            case TIMESTAMP: {
                HashMap<String, Object> option = new HashMap<String, Object>();
                if (column.getScale() != null && column.getScale() > 3) {
                    option.put("format", "strict_date_optional_time||epoch_millis");
                    builder.columnType("date_nanos");
                    builder.dataType("date_nanos");
                    builder.nativeType((Object)new EsType("date_nanos", option));
                    break;
                }
                option.put("format", "strict_date_optional_time_nanos||epoch_millis");
                builder.columnType("date");
                builder.dataType("date");
                builder.nativeType((Object)new EsType("date", option));
                break;
            }
            case DECIMAL: {
                builder.columnType("text");
                builder.dataType("text");
                builder.nativeType((Object)new EsType("text", new HashMap<String, Object>()));
                break;
            }
            case MAP: {
                builder.columnType("flattened");
                builder.dataType("flattened");
                builder.nativeType((Object)new EsType("flattened", new HashMap<String, Object>()));
                break;
            }
            case ARRAY: {
                SeaTunnelDataType type = ((ArrayType)column.getDataType()).getElementType();
                if (type.equals(BasicType.BYTE_TYPE)) {
                    builder.columnType("binary");
                    builder.dataType("binary");
                    builder.nativeType((Object)new EsType("binary", new HashMap<String, Object>()));
                    break;
                }
                if (type.equals(BasicType.SHORT_TYPE)) {
                    builder.columnType("short");
                    builder.dataType("short");
                    builder.nativeType((Object)new EsType("short", new HashMap<String, Object>()));
                    break;
                }
                if (type.equals(BasicType.INT_TYPE)) {
                    builder.columnType("integer");
                    builder.dataType("integer");
                    builder.nativeType((Object)new EsType("integer", new HashMap<String, Object>()));
                    break;
                }
                if (type.equals(BasicType.LONG_TYPE)) {
                    builder.columnType("long");
                    builder.dataType("long");
                    builder.nativeType((Object)new EsType("long", new HashMap<String, Object>()));
                    break;
                }
                if (type.equals(BasicType.FLOAT_TYPE)) {
                    builder.columnType("float");
                    builder.dataType("float");
                    builder.nativeType((Object)new EsType("float", new HashMap<String, Object>()));
                    break;
                }
                if (type.equals(BasicType.DOUBLE_TYPE)) {
                    builder.columnType("double");
                    builder.dataType("double");
                    builder.nativeType((Object)new EsType("double", new HashMap<String, Object>()));
                    break;
                }
                if (type.equals(BasicType.STRING_TYPE)) {
                    builder.columnType("text");
                    builder.dataType("text");
                    builder.nativeType((Object)new EsType("text", new HashMap<String, Object>()));
                    break;
                }
                builder.columnType("text");
                builder.dataType("text");
                builder.nativeType((Object)new EsType("text", new HashMap<String, Object>()));
                break;
            }
            case ROW: {
                builder.columnType("object");
                builder.dataType("object");
                SeaTunnelRowType row = (SeaTunnelRowType)column.getDataType();
                HashMap<String, Object> typeInfo = new HashMap<String, Object>();
                for (int i = 0; i < row.getFieldNames().length; ++i) {
                    typeInfo.put(row.getFieldName(i), this.reconvert((Column)PhysicalColumn.of((String)row.getFieldName(i), (SeaTunnelDataType)row.getFieldType(i), (Long)null, (boolean)true, null, null)));
                }
                builder.nativeType((Object)new EsType("object", typeInfo));
                break;
            }
            default: {
                builder.columnType("text");
                builder.dataType("text");
                builder.nativeType((Object)new EsType("text", new HashMap<String, Object>()));
            }
        }
        return builder.build();
    }
}

