/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.scp.server;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Objects;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.scp.common.ScpException;
import org.apache.sshd.scp.common.ScpFileOpener;
import org.apache.sshd.scp.common.ScpHelper;
import org.apache.sshd.scp.common.ScpTransferEventListener;
import org.apache.sshd.scp.common.helpers.DefaultScpFileOpener;
import org.apache.sshd.scp.common.helpers.ScpAckInfo;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.channel.ServerChannelSessionHolder;
import org.apache.sshd.server.command.AbstractFileSystemCommand;
import org.apache.sshd.server.session.ServerSession;

public class ScpCommand
extends AbstractFileSystemCommand
implements ServerChannelSessionHolder {
    protected final int sendBufferSize;
    protected final int receiveBufferSize;
    protected final ScpFileOpener opener;
    protected boolean optR;
    protected boolean optT;
    protected boolean optF;
    protected boolean optD;
    protected boolean optP;
    protected String path;
    protected IOException error;
    protected ScpTransferEventListener listener;
    private final ChannelSession channelSession;

    public ScpCommand(ChannelSession channelSession, String command, CloseableExecutorService executorService, int sendSize, int receiveSize, ScpFileOpener fileOpener, ScpTransferEventListener eventListener) {
        super(command, executorService);
        this.channelSession = Objects.requireNonNull(channelSession, "No channel session provided");
        if (sendSize < 127) {
            throw new IllegalArgumentException("<ScpCommmand>(" + command + ") send buffer size (" + sendSize + ") below minimum required (" + 127 + ")");
        }
        this.sendBufferSize = sendSize;
        if (receiveSize < 127) {
            throw new IllegalArgumentException("<ScpCommmand>(" + command + ") receive buffer size (" + sendSize + ") below minimum required (" + 127 + ")");
        }
        this.receiveBufferSize = receiveSize;
        this.opener = fileOpener == null ? DefaultScpFileOpener.INSTANCE : fileOpener;
        this.listener = eventListener == null ? ScpTransferEventListener.EMPTY : eventListener;
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("Executing command {}", (Object)command);
        }
        String[] args = GenericUtils.split(command, ' ');
        int numArgs = GenericUtils.length(args);
        for (int i = 1; i < numArgs; ++i) {
            char endDelim;
            String argVal = args[i];
            if (argVal.charAt(0) == '-') {
                block8: for (int j = 1; j < argVal.length(); ++j) {
                    char option = argVal.charAt(j);
                    switch (option) {
                        case 'f': {
                            this.optF = true;
                            continue block8;
                        }
                        case 'p': {
                            this.optP = true;
                            continue block8;
                        }
                        case 'r': {
                            this.optR = true;
                            continue block8;
                        }
                        case 't': {
                            this.optT = true;
                            continue block8;
                        }
                        case 'd': {
                            this.optD = true;
                            continue block8;
                        }
                        default: {
                            if (!debugEnabled) continue block8;
                            this.log.debug("Unknown flag ('{}') in command={}", (Object)Character.valueOf(option), (Object)command);
                        }
                    }
                }
                continue;
            }
            String prevArg = args[i - 1];
            this.path = command.substring(command.indexOf(prevArg) + prevArg.length() + 1);
            int pathLen = this.path.length();
            char startDelim = this.path.charAt(0);
            char c = endDelim = pathLen > 2 ? this.path.charAt(pathLen - 1) : (char)'\u0000';
            if (pathLen <= 2 || startDelim != endDelim || startDelim != '\'' && startDelim != '\"') break;
            this.path = this.path.substring(1, pathLen - 1);
            break;
        }
        if (!this.optF && !this.optT) {
            this.error = new IOException("Either -f or -t option should be set for " + command);
        }
    }

    @Override
    public ChannelSession getServerChannelSession() {
        return this.channelSession;
    }

    @Override
    public void start(ChannelSession channel, Environment env) throws IOException {
        if (this.error != null) {
            throw this.error;
        }
        super.start(channel, env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String exitMessage;
        int exitValue;
        block14: {
            exitValue = 0;
            exitMessage = null;
            ServerSession session = this.getServerSession();
            String command = this.getCommand();
            ScpHelper helper = new ScpHelper(session, this.getInputStream(), this.getOutputStream(), this.fileSystem, this.opener, this.listener);
            try {
                if (this.optT) {
                    helper.receive(helper.resolveLocalPath(this.path), this.optR, this.optD, this.optP, this.receiveBufferSize);
                    break block14;
                }
                if (this.optF) {
                    helper.send(Collections.singletonList(this.path), this.optR, this.optP, this.sendBufferSize);
                    break block14;
                }
                throw new IOException("Unsupported mode");
            }
            catch (IOException e) {
                try {
                    boolean debugEnabled = this.log.isDebugEnabled();
                    try {
                        Integer statusCode = null;
                        if (e instanceof ScpException) {
                            statusCode = ((ScpException)e).getExitStatus();
                        }
                        int n = exitValue = statusCode == null ? 2 : statusCode;
                        if (exitValue == 0 || exitValue == 1) {
                            if (debugEnabled) {
                                this.log.debug("run({})[{}] normalize status code={}", new Object[]{session, command, exitValue});
                            }
                            exitValue = 2;
                        }
                        exitMessage = GenericUtils.trimToEmpty(e.getMessage());
                        this.writeCommandResponseMessage(command, exitValue, exitMessage);
                    }
                    catch (IOException e2) {
                        this.error("run({})[{}] Failed ({}) to send error response: {}", session, command, e.getClass().getSimpleName(), e.getMessage(), e2);
                    }
                    this.error("run({})[{}] Failed ({}) to run command: {}", session, command, e.getClass().getSimpleName(), e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    ExitCallback callback = this.getExitCallback();
                    if (callback != null) {
                        callback.onExit(exitValue, GenericUtils.trimToEmpty(exitMessage));
                    }
                    throw throwable;
                }
                ExitCallback callback = this.getExitCallback();
                if (callback != null) {
                    callback.onExit(exitValue, GenericUtils.trimToEmpty(exitMessage));
                }
            }
        }
        ExitCallback callback = this.getExitCallback();
        if (callback != null) {
            callback.onExit(exitValue, GenericUtils.trimToEmpty(exitMessage));
        }
    }

    protected void writeCommandResponseMessage(String command, int exitValue, String exitMessage) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("writeCommandResponseMessage({}) command='{}', exit-status={}: {}", new Object[]{this.getServerSession(), command, exitValue, exitMessage});
        }
        ScpAckInfo.sendAck(this.getOutputStream(), StandardCharsets.UTF_8, exitValue, exitMessage);
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.getSession() + "]";
    }
}

