/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.scp.common.helpers;

import java.nio.file.attribute.FileTime;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.scp.common.helpers.AbstractScpCommandDetails;

public class ScpTimestampCommandDetails
extends AbstractScpCommandDetails {
    public static final char COMMAND_NAME = 'T';
    private final long lastModifiedTime;
    private final long lastAccessTime;

    public ScpTimestampCommandDetails(String header) {
        super('T');
        if (header.charAt(0) != 'T') {
            throw new IllegalArgumentException("Expected a 'T' but got '" + header + "'");
        }
        String[] numbers = GenericUtils.split(header.substring(1), ' ');
        this.lastModifiedTime = TimeUnit.SECONDS.toMillis(Long.parseLong(numbers[0]));
        this.lastAccessTime = TimeUnit.SECONDS.toMillis(Long.parseLong(numbers[2]));
    }

    public ScpTimestampCommandDetails(FileTime modTime, FileTime accTime) {
        this(modTime.to(TimeUnit.MILLISECONDS), accTime.to(TimeUnit.MILLISECONDS));
    }

    public ScpTimestampCommandDetails(long modTime, long accTime) {
        super('T');
        this.lastModifiedTime = modTime;
        this.lastAccessTime = accTime;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public String toHeader() {
        return Character.toString(this.getCommand()) + TimeUnit.MILLISECONDS.toSeconds(this.getLastModifiedTime()) + " 0 " + TimeUnit.MILLISECONDS.toSeconds(this.getLastAccessTime()) + " 0";
    }

    public int hashCode() {
        return Long.hashCode(this.getLastModifiedTime()) + 31 * Long.hashCode(this.getLastAccessTime());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScpTimestampCommandDetails other = (ScpTimestampCommandDetails)obj;
        return this.getLastModifiedTime() == other.getLastModifiedTime() && this.getLastAccessTime() == other.getLastAccessTime();
    }

    public String toString() {
        return "modified=" + new Date(this.lastModifiedTime) + ";accessed=" + new Date(this.lastAccessTime);
    }

    public static ScpTimestampCommandDetails parse(String line) throws NumberFormatException {
        return GenericUtils.isEmpty(line) ? null : new ScpTimestampCommandDetails(line);
    }
}

