/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.scp.common.helpers;

import java.nio.file.attribute.PosixFilePermission;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.scp.common.helpers.AbstractScpCommandDetails;

public abstract class ScpPathCommandDetailsSupport
extends AbstractScpCommandDetails
implements NamedResource {
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;
    private Set<PosixFilePermission> permissions;
    private long length;
    private String name;

    protected ScpPathCommandDetailsSupport(char command) {
        super(command);
    }

    protected ScpPathCommandDetailsSupport(char command, String header) {
        super(command);
        ValidateUtils.checkNotNullAndNotEmpty(header, "No header provided");
        if (header.charAt(0) != command) {
            throw new IllegalArgumentException("Expected a '" + command + "' message but got '" + header + "'");
        }
        this.permissions = ScpPathCommandDetailsSupport.parseOctalPermissions(header.substring(1, 5));
        this.length = Long.parseLong(header.substring(6, header.indexOf(32, 6)));
        this.name = header.substring(header.indexOf(32, 6) + 1);
    }

    public Set<PosixFilePermission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<PosixFilePermission> permissions) {
        this.permissions = permissions;
    }

    public long getLength() {
        return this.length;
    }

    protected long getEffectiveLength() {
        return this.getLength();
    }

    public void setLength(long length) {
        this.length = length;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toHeader() {
        return this.getCommand() + ScpPathCommandDetailsSupport.getOctalPermissions(this.getPermissions()) + " " + this.getEffectiveLength() + " " + this.getName();
    }

    public int hashCode() {
        return Character.hashCode(this.getCommand()) + 31 * Objects.hashCode(this.getName()) + 37 * Long.hashCode(this.getEffectiveLength()) + 41 * GenericUtils.size(this.getPermissions());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScpPathCommandDetailsSupport other = (ScpPathCommandDetailsSupport)obj;
        return this.getCommand() == other.getCommand() && this.getEffectiveLength() == other.getEffectiveLength() && Objects.equals(this.getName(), other.getName()) && GenericUtils.equals(this.getPermissions(), other.getPermissions());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getName() + ", len=" + this.getLength() + ", perms=" + this.getPermissions() + "]";
    }

    public static String getOctalPermissions(Collection<PosixFilePermission> perms) {
        int pf = 0;
        for (PosixFilePermission p : perms) {
            switch (p) {
                case OWNER_READ: {
                    pf |= 0x100;
                    break;
                }
                case OWNER_WRITE: {
                    pf |= 0x80;
                    break;
                }
                case OWNER_EXECUTE: {
                    pf |= 0x40;
                    break;
                }
                case GROUP_READ: {
                    pf |= 0x20;
                    break;
                }
                case GROUP_WRITE: {
                    pf |= 0x10;
                    break;
                }
                case GROUP_EXECUTE: {
                    pf |= 8;
                    break;
                }
                case OTHERS_READ: {
                    pf |= 4;
                    break;
                }
                case OTHERS_WRITE: {
                    pf |= 2;
                    break;
                }
                case OTHERS_EXECUTE: {
                    pf |= 1;
                    break;
                }
            }
        }
        return String.format("%04o", pf);
    }

    public static Set<PosixFilePermission> parseOctalPermissions(String str) {
        int perms = Integer.parseInt(str, 8);
        EnumSet<PosixFilePermission> p = EnumSet.noneOf(PosixFilePermission.class);
        if ((perms & 0x100) != 0) {
            p.add(PosixFilePermission.OWNER_READ);
        }
        if ((perms & 0x80) != 0) {
            p.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((perms & 0x40) != 0) {
            p.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((perms & 0x20) != 0) {
            p.add(PosixFilePermission.GROUP_READ);
        }
        if ((perms & 0x10) != 0) {
            p.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((perms & 8) != 0) {
            p.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((perms & 4) != 0) {
            p.add(PosixFilePermission.OTHERS_READ);
        }
        if ((perms & 2) != 0) {
            p.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((perms & 1) != 0) {
            p.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return p;
    }
}

