/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CreateTableParser {
    private static final Pattern COLUMN_PATTERN = Pattern.compile("`?(\\w+)`?\\s*([\\w|\\W]*)");

    public static Map<String, ColumnInfo> getColumnList(String createTableSql) {
        HashMap<String, ColumnInfo> columns = new HashMap<String, ColumnInfo>();
        StringBuilder columnBuilder = new StringBuilder();
        int startIndex = createTableSql.indexOf("(");
        createTableSql = createTableSql.substring(startIndex + 1);
        boolean insideParentheses = false;
        for (int i = 0; i < createTableSql.length(); ++i) {
            char c = createTableSql.charAt(i);
            if (c == '(') {
                insideParentheses = true;
                columnBuilder.append(c);
                continue;
            }
            if (!(c != ',' && c != ')' || insideParentheses)) {
                CreateTableParser.parseColumn(columnBuilder.toString(), columns, startIndex + i + 1);
                columnBuilder.setLength(0);
                if (c != ')') continue;
                break;
            }
            if (c == ')') {
                insideParentheses = false;
                columnBuilder.append(c);
                continue;
            }
            columnBuilder.append(c);
        }
        return columns;
    }

    private static void parseColumn(String columnString, Map<String, ColumnInfo> columnList, int suffixIndex) {
        Matcher matcher = COLUMN_PATTERN.matcher(columnString.trim());
        if (matcher.matches()) {
            String columnName = matcher.group(1);
            String otherInfo = matcher.group(2).trim();
            StringBuilder columnBuilder = new StringBuilder(columnName).append(" ").append(otherInfo);
            if (columnBuilder.toString().toUpperCase().contains("PRIMARY KEY") || columnBuilder.toString().toUpperCase().contains("CREATE TABLE")) {
                return;
            }
            int endIndex = suffixIndex - columnString.substring(columnString.indexOf(columnName) + columnName.length()).length();
            int startIndex = suffixIndex - columnString.substring(columnString.indexOf(columnName)).length();
            columnList.put(columnName, new ColumnInfo(columnName, otherInfo, startIndex, endIndex));
        }
    }

    public static final class ColumnInfo {
        String name;
        String info;
        int startIndex;
        int endIndex;

        public ColumnInfo(String name, String info, int startIndex, int endIndex) {
            this.name = name;
            this.info = info;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        public String getName() {
            return this.name;
        }

        public String getInfo() {
            return this.info;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }
    }
}

