/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.source;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.source.ClickhouseSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.state.ClickhouseSourceState;

public class ClickhouseSourceSplitEnumerator
implements SourceSplitEnumerator<ClickhouseSourceSplit, ClickhouseSourceState> {
    private final SourceSplitEnumerator.Context<ClickhouseSourceSplit> context;
    private final Set<Integer> readers;
    private volatile int assigned = -1;

    ClickhouseSourceSplitEnumerator(SourceSplitEnumerator.Context<ClickhouseSourceSplit> enumeratorContext) {
        this.context = enumeratorContext;
        this.readers = new HashSet<Integer>();
    }

    public void open() {
    }

    public void run() throws Exception {
    }

    public void close() throws IOException {
    }

    public void addSplitsBack(List<ClickhouseSourceSplit> splits, int subtaskId) {
        if (splits.isEmpty()) {
            return;
        }
        if (subtaskId == this.assigned) {
            Optional<Integer> otherReader = this.readers.stream().filter(r -> r != subtaskId).findAny();
            if (otherReader.isPresent()) {
                this.context.assignSplit(otherReader.get().intValue(), splits);
            } else {
                this.assigned = -1;
            }
        }
    }

    public int currentUnassignedSplitSize() {
        return this.assigned < 0 ? 0 : 1;
    }

    public void handleSplitRequest(int subtaskId) {
    }

    public void registerReader(int subtaskId) {
        this.readers.add(subtaskId);
        if (this.assigned < 0) {
            this.assigned = subtaskId;
            this.context.assignSplit(subtaskId, (SourceSplit)new ClickhouseSourceSplit());
        }
        this.context.signalNoMoreSplits(subtaskId);
    }

    public ClickhouseSourceState snapshotState(long checkpointId) throws Exception {
        return null;
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
    }
}

