/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.client.executor;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.client.executor.BufferedBatchStatementExecutor;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.client.executor.FieldNamedPreparedStatement;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.client.executor.InsertOrUpdateBatchStatementExecutor;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.client.executor.JdbcBatchStatementExecutor;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.client.executor.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.client.executor.ReduceBufferedBatchStatementExecutor;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.client.executor.SimpleBatchStatementExecutor;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.sink.client.executor.SqlUtils;

public class JdbcBatchStatementExecutorBuilder {
    private static final String MERGE_TREE_ENGINE_SUFFIX = "MergeTree";
    private static final String REPLACING_MERGE_TREE_ENGINE_SUFFIX = "ReplacingMergeTree";
    private String table;
    private String tableEngine;
    private SeaTunnelRowType rowType;
    private String[] primaryKeys;
    private Map<String, String> clickhouseTableSchema;
    private boolean supportUpsert;
    private boolean allowExperimentalLightweightDelete;
    private boolean clickhouseServerEnableExperimentalLightweightDelete;
    private String[] orderByKeys;

    private boolean supportMergeTreeEngineExperimentalLightweightDelete() {
        return this.tableEngine.endsWith(MERGE_TREE_ENGINE_SUFFIX) && this.allowExperimentalLightweightDelete;
    }

    private boolean supportReplacingMergeTreeTableUpsert() {
        return this.tableEngine.endsWith(REPLACING_MERGE_TREE_ENGINE_SUFFIX) && Arrays.equals(this.primaryKeys, this.orderByKeys);
    }

    private String[] getDefaultProjectionFields() {
        List<String> fieldNames = Arrays.asList(this.rowType.getFieldNames());
        return (String[])fieldNames.stream().filter(this.clickhouseTableSchema::containsKey).toArray(String[]::new);
    }

    public JdbcBatchStatementExecutor build() {
        Objects.requireNonNull(this.table);
        Objects.requireNonNull(this.tableEngine);
        Objects.requireNonNull(this.rowType);
        Objects.requireNonNull(this.clickhouseTableSchema);
        JdbcRowConverter valueRowConverter = new JdbcRowConverter(this.rowType, this.clickhouseTableSchema, this.getDefaultProjectionFields());
        if (this.primaryKeys == null || this.primaryKeys.length == 0) {
            return JdbcBatchStatementExecutorBuilder.createInsertBufferedExecutor(this.table, this.rowType, valueRowConverter);
        }
        int[] pkFields = Arrays.stream(this.primaryKeys).mapToInt(Arrays.asList(this.rowType.getFieldNames())::indexOf).toArray();
        SeaTunnelDataType[] pkTypes = JdbcBatchStatementExecutorBuilder.getKeyTypes(pkFields, this.rowType);
        JdbcRowConverter pkRowConverter = new JdbcRowConverter(new SeaTunnelRowType(this.primaryKeys, pkTypes), this.clickhouseTableSchema, this.primaryKeys);
        Function<SeaTunnelRow, SeaTunnelRow> pkExtractor = JdbcBatchStatementExecutorBuilder.createKeyExtractor(pkFields);
        if (this.supportMergeTreeEngineExperimentalLightweightDelete()) {
            boolean convertUpdateBeforeEventToDeleteAction;
            JdbcBatchStatementExecutor updateExecutor;
            JdbcBatchStatementExecutor deleteExecutor = JdbcBatchStatementExecutorBuilder.createDeleteExecutor(this.table, this.primaryKeys, pkRowConverter, !this.clickhouseServerEnableExperimentalLightweightDelete);
            if (this.supportReplacingMergeTreeTableUpsert()) {
                updateExecutor = JdbcBatchStatementExecutorBuilder.createInsertExecutor(this.table, this.rowType, valueRowConverter);
                convertUpdateBeforeEventToDeleteAction = false;
            } else {
                updateExecutor = this.supportUpsert ? JdbcBatchStatementExecutorBuilder.createUpsertExecutor(this.table, this.rowType, this.primaryKeys, pkExtractor, pkRowConverter, valueRowConverter) : JdbcBatchStatementExecutorBuilder.createInsertExecutor(this.table, this.rowType, valueRowConverter);
                convertUpdateBeforeEventToDeleteAction = true;
            }
            return new ReduceBufferedBatchStatementExecutor(updateExecutor, deleteExecutor, pkExtractor, Function.identity(), !convertUpdateBeforeEventToDeleteAction);
        }
        JdbcBatchStatementExecutor deleteExecutor = JdbcBatchStatementExecutorBuilder.createAlterTableDeleteExecutor(this.table, this.primaryKeys, pkRowConverter);
        JdbcBatchStatementExecutor updateExecutor = this.supportReplacingMergeTreeTableUpsert() ? JdbcBatchStatementExecutorBuilder.createInsertExecutor(this.table, this.rowType, valueRowConverter) : (this.supportUpsert ? JdbcBatchStatementExecutorBuilder.createUpsertExecutor(this.table, this.rowType, this.primaryKeys, pkExtractor, pkRowConverter, valueRowConverter) : JdbcBatchStatementExecutorBuilder.createInsertOrUpdateExecutor(this.table, this.rowType, this.primaryKeys, valueRowConverter));
        return new ReduceBufferedBatchStatementExecutor(updateExecutor, deleteExecutor, pkExtractor, Function.identity(), true);
    }

    private static JdbcBatchStatementExecutor createInsertBufferedExecutor(String table, SeaTunnelRowType rowType, JdbcRowConverter rowConverter) {
        return new BufferedBatchStatementExecutor(JdbcBatchStatementExecutorBuilder.createInsertExecutor(table, rowType, rowConverter), Function.identity());
    }

    private static JdbcBatchStatementExecutor createInsertOrUpdateExecutor(String table, SeaTunnelRowType rowType, String[] pkNames, JdbcRowConverter rowConverter) {
        return new InsertOrUpdateBatchStatementExecutor(connection -> FieldNamedPreparedStatement.prepareStatement(connection, SqlUtils.getInsertIntoStatement(table, rowType.getFieldNames()), rowType.getFieldNames()), connection -> FieldNamedPreparedStatement.prepareStatement(connection, SqlUtils.getAlterTableUpdateStatement(table, rowType.getFieldNames(), pkNames), rowType.getFieldNames()), rowConverter);
    }

    private static JdbcBatchStatementExecutor createUpsertExecutor(String table, SeaTunnelRowType rowType, String[] pkNames, Function<SeaTunnelRow, SeaTunnelRow> keyExtractor, JdbcRowConverter keyConverter, JdbcRowConverter valueConverter) {
        return new InsertOrUpdateBatchStatementExecutor(connection -> FieldNamedPreparedStatement.prepareStatement(connection, SqlUtils.getRowExistsStatement(table, pkNames), pkNames), connection -> FieldNamedPreparedStatement.prepareStatement(connection, SqlUtils.getInsertIntoStatement(table, rowType.getFieldNames()), rowType.getFieldNames()), connection -> FieldNamedPreparedStatement.prepareStatement(connection, SqlUtils.getAlterTableUpdateStatement(table, rowType.getFieldNames(), pkNames), rowType.getFieldNames()), keyExtractor, keyConverter, valueConverter);
    }

    private static JdbcBatchStatementExecutor createInsertExecutor(String table, SeaTunnelRowType rowType, JdbcRowConverter rowConverter) {
        String insertSQL = SqlUtils.getInsertIntoStatement(table, rowType.getFieldNames());
        return new SimpleBatchStatementExecutor(connection -> FieldNamedPreparedStatement.prepareStatement(connection, insertSQL, rowType.getFieldNames()), rowConverter);
    }

    private static JdbcBatchStatementExecutor createDeleteExecutor(String table, String[] primaryKeys, JdbcRowConverter rowConverter, boolean enableExperimentalLightweightDelete) {
        String deleteSQL = SqlUtils.getDeleteStatement(table, primaryKeys, enableExperimentalLightweightDelete);
        return new SimpleBatchStatementExecutor(connection -> FieldNamedPreparedStatement.prepareStatement(connection, deleteSQL, primaryKeys), rowConverter);
    }

    private static JdbcBatchStatementExecutor createAlterTableDeleteExecutor(String table, String[] primaryKeys, JdbcRowConverter rowConverter) {
        String alterTableDeleteSQL = SqlUtils.getAlterTableDeleteStatement(table, primaryKeys);
        return new SimpleBatchStatementExecutor(connection -> FieldNamedPreparedStatement.prepareStatement(connection, alterTableDeleteSQL, primaryKeys), rowConverter);
    }

    private static SeaTunnelDataType[] getKeyTypes(int[] pkFields, SeaTunnelRowType rowType) {
        return (SeaTunnelDataType[])Arrays.stream(pkFields).mapToObj(arg_0 -> ((SeaTunnelRowType)rowType).getFieldType(arg_0)).toArray(SeaTunnelDataType[]::new);
    }

    private static Function<SeaTunnelRow, SeaTunnelRow> createKeyExtractor(int[] pkFields) {
        return row -> {
            Object[] fields = new Object[pkFields.length];
            for (int i = 0; i < pkFields.length; ++i) {
                fields[i] = row.getField(pkFields[i]);
            }
            SeaTunnelRow newRow = new SeaTunnelRow(fields);
            newRow.setTableId(row.getTableId());
            newRow.setRowKind(row.getRowKind());
            return newRow;
        };
    }

    public JdbcBatchStatementExecutorBuilder setTable(String table) {
        this.table = table;
        return this;
    }

    public JdbcBatchStatementExecutorBuilder setTableEngine(String tableEngine) {
        this.tableEngine = tableEngine;
        return this;
    }

    public JdbcBatchStatementExecutorBuilder setRowType(SeaTunnelRowType rowType) {
        this.rowType = rowType;
        return this;
    }

    public JdbcBatchStatementExecutorBuilder setPrimaryKeys(String[] primaryKeys) {
        this.primaryKeys = primaryKeys;
        return this;
    }

    public JdbcBatchStatementExecutorBuilder setClickhouseTableSchema(Map<String, String> clickhouseTableSchema) {
        this.clickhouseTableSchema = clickhouseTableSchema;
        return this;
    }

    public JdbcBatchStatementExecutorBuilder setSupportUpsert(boolean supportUpsert) {
        this.supportUpsert = supportUpsert;
        return this;
    }

    public JdbcBatchStatementExecutorBuilder setAllowExperimentalLightweightDelete(boolean allowExperimentalLightweightDelete) {
        this.allowExperimentalLightweightDelete = allowExperimentalLightweightDelete;
        return this;
    }

    public JdbcBatchStatementExecutorBuilder setClickhouseServerEnableExperimentalLightweightDelete(boolean clickhouseServerEnableExperimentalLightweightDelete) {
        this.clickhouseServerEnableExperimentalLightweightDelete = clickhouseServerEnableExperimentalLightweightDelete;
        return this;
    }

    public JdbcBatchStatementExecutorBuilder setOrderByKeys(String[] orderByKeys) {
        this.orderByKeys = orderByKeys;
        return this;
    }
}

