/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.clickhouse.config;

import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.sink.DataSaveMode;
import org.apache.seatunnel.api.sink.SaveModePlaceHolder;
import org.apache.seatunnel.api.sink.SchemaSaveMode;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.ClickhouseFileCopyMethod;
import org.apache.seatunnel.connectors.seatunnel.clickhouse.config.NodePassConfig;

public class ClickhouseConfig {
    public static final Option<Integer> BULK_SIZE = Options.key((String)"bulk_size").intType().defaultValue((Object)20000).withDescription("Bulk size of clickhouse jdbc");
    public static final Option<String> SQL = Options.key((String)"sql").stringType().noDefaultValue().withDescription("Clickhouse sql used to query data");
    public static final Option<String> HOST = Options.key((String)"host").stringType().noDefaultValue().withDescription("Clickhouse server host");
    public static final Option<String> TABLE = Options.key((String)"table").stringType().noDefaultValue().withDescription("Clickhouse table name");
    public static final Option<String> DATABASE = Options.key((String)"database").stringType().noDefaultValue().withDescription("Clickhouse database name");
    public static final Option<String> USERNAME = Options.key((String)"username").stringType().noDefaultValue().withDescription("Clickhouse server username");
    public static final Option<String> PASSWORD = Options.key((String)"password").stringType().noDefaultValue().withDescription("Clickhouse server password");
    public static final Option<String> SERVER_TIME_ZONE = Options.key((String)"server_time_zone").stringType().defaultValue((Object)ZoneId.systemDefault().getId()).withDescription("The session time zone in database server.If not set, then ZoneId.systemDefault() is used to determine the server time zone");
    public static final Option<Boolean> SPLIT_MODE = Options.key((String)"split_mode").booleanType().defaultValue((Object)false).withDescription("Split mode when table is distributed engine");
    public static final Option<String> SHARDING_KEY = Options.key((String)"sharding_key").stringType().noDefaultValue().withDescription("When split_mode is true, the sharding_key use for split");
    public static final Option<String> PRIMARY_KEY = Options.key((String)"primary_key").stringType().noDefaultValue().withDescription("Mark the primary key column from clickhouse table, and based on primary key execute INSERT/UPDATE/DELETE to clickhouse table");
    public static final Option<Boolean> SUPPORT_UPSERT = Options.key((String)"support_upsert").booleanType().defaultValue((Object)false).withDescription("Support upsert row by query primary key");
    public static final Option<Boolean> ALLOW_EXPERIMENTAL_LIGHTWEIGHT_DELETE = Options.key((String)"allow_experimental_lightweight_delete").booleanType().defaultValue((Object)false).withDescription("Allow experimental lightweight delete based on `*MergeTree` table engine");
    public static final Option<String> CLICKHOUSE_LOCAL_PATH = Options.key((String)"clickhouse_local_path").stringType().noDefaultValue().withDescription("ClickhouseFile sink connector used clickhouse-local program's path");
    public static final Option<ClickhouseFileCopyMethod> COPY_METHOD = Options.key((String)"copy_method").enumType(ClickhouseFileCopyMethod.class).defaultValue((Object)ClickhouseFileCopyMethod.SCP).withDescription("The method of copy Clickhouse file");
    public static final Option<Boolean> COMPATIBLE_MODE = Options.key((String)"compatible_mode").booleanType().defaultValue((Object)false).withDescription("In the lower version of Clickhouse, the ClickhouseLocal program does not support the `--path` parameter, you need to use this mode to take other ways to realize the --path parameter function");
    public static final String NODE_ADDRESS = "node_address";
    public static final Option<Boolean> NODE_FREE_PASSWORD = Options.key((String)"node_free_password").booleanType().defaultValue((Object)false).withDescription("Because seatunnel need to use scp or rsync for file transfer, seatunnel need clickhouse server-side access. If each spark node and clickhouse server are configured with password-free login, you can configure this option to true, otherwise you need to configure the corresponding node password in the node_pass configuration");
    public static final Option<List<NodePassConfig>> NODE_PASS = Options.key((String)"node_pass").listType(NodePassConfig.class).noDefaultValue().withDescription("The password of Clickhouse server node");
    public static final Option<Map<String, String>> CLICKHOUSE_CONFIG = Options.key((String)"clickhouse.config").mapType().defaultValue(Collections.emptyMap()).withDescription("Clickhouse custom config");
    public static final Option<String> KEY_PATH = Options.key((String)"key_path").stringType().noDefaultValue().withDescription("The path of rsync/ssh key file");
    public static final Option<String> FILE_FIELDS_DELIMITER = Options.key((String)"file_fields_delimiter").stringType().defaultValue((Object)"\t").withDescription("ClickhouseFile uses csv format to temporarily save data. If the data in the row contains the delimiter value of csv, it may cause program exceptions. Avoid this with this configuration. Value string has to be an exactly one character long");
    public static final Option<String> FILE_TEMP_PATH = Options.key((String)"file_temp_path").stringType().defaultValue((Object)"/tmp/seatunnel/clickhouse-local/file").withDescription("The directory where ClickhouseFile stores temporary files locally.");
    public static final Option<SchemaSaveMode> SCHEMA_SAVE_MODE = Options.key((String)"schema_save_mode").enumType(SchemaSaveMode.class).defaultValue((Object)SchemaSaveMode.CREATE_SCHEMA_WHEN_NOT_EXIST).withDescription("different treatment schemes are selected for the existing surface structure of the target side");
    public static final Option<DataSaveMode> DATA_SAVE_MODE = Options.key((String)"data_save_mode").enumType(DataSaveMode.class).defaultValue((Object)DataSaveMode.APPEND_DATA).withDescription("different processing schemes are selected for data existing data on the target side");
    public static final Option<String> CUSTOM_SQL = Options.key((String)"custom_sql").stringType().noDefaultValue().withDescription("when schema_save_mode selects CUSTOM_PROCESSING custom SQL");
    public static final Option<String> SAVE_MODE_CREATE_TEMPLATE = Options.key((String)"save_mode_create_template").stringType().defaultValue((Object)("CREATE TABLE IF NOT EXISTS `" + SaveModePlaceHolder.DATABASE.getPlaceHolder() + "`.`" + SaveModePlaceHolder.TABLE.getPlaceHolder() + "` (\n" + SaveModePlaceHolder.ROWTYPE_PRIMARY_KEY.getPlaceHolder() + ",\n" + SaveModePlaceHolder.ROWTYPE_FIELDS.getPlaceHolder() + "\n) ENGINE = MergeTree()\nORDER BY (" + SaveModePlaceHolder.ROWTYPE_PRIMARY_KEY.getPlaceHolder() + ")\nPRIMARY KEY (" + SaveModePlaceHolder.ROWTYPE_PRIMARY_KEY.getPlaceHolder() + ")\nSETTINGS\n    index_granularity = 8192;")).withDescription("Create table statement template, used to create Clickhouse table");
}

