/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.executor;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import lombok.NonNull;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.executor.JdbcBatchStatementExecutor;

public class BufferedBatchStatementExecutor
implements JdbcBatchStatementExecutor<SeaTunnelRow> {
    @NonNull
    private final JdbcBatchStatementExecutor<SeaTunnelRow> statementExecutor;
    @NonNull
    private final Function<SeaTunnelRow, SeaTunnelRow> valueTransform;
    @NonNull
    private final List<SeaTunnelRow> buffer = new ArrayList<SeaTunnelRow>();

    @Override
    public void prepareStatements(Connection connection) throws SQLException {
        this.statementExecutor.prepareStatements(connection);
    }

    @Override
    public void addToBatch(SeaTunnelRow record) throws SQLException {
        this.buffer.add(this.valueTransform.apply(record));
    }

    @Override
    public void executeBatch() throws SQLException {
        if (!this.buffer.isEmpty()) {
            for (SeaTunnelRow row : this.buffer) {
                this.statementExecutor.addToBatch(row);
            }
            this.statementExecutor.executeBatch();
            this.buffer.clear();
        }
    }

    @Override
    public void closeStatements() throws SQLException {
        try {
            if (!this.buffer.isEmpty()) {
                this.executeBatch();
            }
        }
        finally {
            if (!this.buffer.isEmpty()) {
                this.buffer.clear();
            }
            this.statementExecutor.closeStatements();
        }
    }

    public BufferedBatchStatementExecutor(@NonNull JdbcBatchStatementExecutor<SeaTunnelRow> statementExecutor, @NonNull Function<SeaTunnelRow, SeaTunnelRow> valueTransform) {
        if (statementExecutor == null) {
            throw new NullPointerException("statementExecutor is marked non-null but is null");
        }
        if (valueTransform == null) {
            throw new NullPointerException("valueTransform is marked non-null but is null");
        }
        this.statementExecutor = statementExecutor;
        this.valueTransform = valueTransform;
    }
}

