/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mysql.utils;

import io.debezium.relational.TableId;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.utils.MySqlUtils;

public class MySqlDdlBuilder {
    private final TableId tableId;
    private final List<Column> columns;
    private List<String> primaryKeys;

    public MySqlDdlBuilder(TableId tableId) {
        this.tableId = tableId;
        this.columns = new ArrayList<Column>();
        this.primaryKeys = new ArrayList<String>();
    }

    public MySqlDdlBuilder addColumn(Column column) {
        this.columns.add(column);
        if (column.isPrimaryKey()) {
            this.primaryKeys.add(column.getColumnName());
        }
        return this;
    }

    public String generateDdl() {
        String columnDefinitions = this.columns.stream().map(Column::generateDdl).collect(Collectors.joining(", "));
        String keyDefinitions = this.primaryKeys.stream().map(MySqlUtils::quote).collect(Collectors.joining(", ", "PRIMARY KEY (", ")"));
        return String.format("CREATE TABLE %s (%s, %s)", this.tableId.table(), columnDefinitions, keyDefinitions);
    }

    public static class Column {
        private String columnName;
        private String columnType;
        private boolean nullable;
        private boolean primaryKey;
        private boolean uniqueKey;
        private String defaultValue;
        private String extra;

        public String generateDdl() {
            return MySqlUtils.quote(this.columnName) + " " + this.columnType + " " + (this.nullable ? "" : "NOT NULL");
        }

        Column(String columnName, String columnType, boolean nullable, boolean primaryKey, boolean uniqueKey, String defaultValue, String extra) {
            this.columnName = columnName;
            this.columnType = columnType;
            this.nullable = nullable;
            this.primaryKey = primaryKey;
            this.uniqueKey = uniqueKey;
            this.defaultValue = defaultValue;
            this.extra = extra;
        }

        public static ColumnBuilder builder() {
            return new ColumnBuilder();
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getColumnType() {
            return this.columnType;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public boolean isPrimaryKey() {
            return this.primaryKey;
        }

        public boolean isUniqueKey() {
            return this.uniqueKey;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getExtra() {
            return this.extra;
        }

        public static class ColumnBuilder {
            private String columnName;
            private String columnType;
            private boolean nullable;
            private boolean primaryKey;
            private boolean uniqueKey;
            private String defaultValue;
            private String extra;

            ColumnBuilder() {
            }

            public ColumnBuilder columnName(String columnName) {
                this.columnName = columnName;
                return this;
            }

            public ColumnBuilder columnType(String columnType) {
                this.columnType = columnType;
                return this;
            }

            public ColumnBuilder nullable(boolean nullable) {
                this.nullable = nullable;
                return this;
            }

            public ColumnBuilder primaryKey(boolean primaryKey) {
                this.primaryKey = primaryKey;
                return this;
            }

            public ColumnBuilder uniqueKey(boolean uniqueKey) {
                this.uniqueKey = uniqueKey;
                return this;
            }

            public ColumnBuilder defaultValue(String defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            public ColumnBuilder extra(String extra) {
                this.extra = extra;
                return this;
            }

            public Column build() {
                return new Column(this.columnName, this.columnType, this.nullable, this.primaryKey, this.uniqueKey, this.defaultValue, this.extra);
            }

            public String toString() {
                return "MySqlDdlBuilder.Column.ColumnBuilder(columnName=" + this.columnName + ", columnType=" + this.columnType + ", nullable=" + this.nullable + ", primaryKey=" + this.primaryKey + ", uniqueKey=" + this.uniqueKey + ", defaultValue=" + this.defaultValue + ", extra=" + this.extra + ")";
            }
        }
    }
}

