/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.debezium.row;

import io.debezium.relational.TableId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.cdc.debezium.AbstractDebeziumDeserializationSchema;
import org.apache.seatunnel.format.compatible.debezium.json.CompatibleDebeziumJsonDeserializationSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebeziumJsonDeserializeSchema
extends AbstractDebeziumDeserializationSchema<SeaTunnelRow> {
    private static final Logger log = LoggerFactory.getLogger(DebeziumJsonDeserializeSchema.class);
    private static final String KEY_SCHEMA_ENABLE = "key.converter.schemas.enable";
    private static final String VALUE_SCHEMA_ENABLE = "value.converter.schemas.enable";
    private final CompatibleDebeziumJsonDeserializationSchema deserializationSchema;

    public DebeziumJsonDeserializeSchema(Map<String, String> debeziumConfig) {
        this(debeziumConfig, new HashMap<TableId, Struct>());
    }

    public DebeziumJsonDeserializeSchema(Map<String, String> debeziumConfig, Map<TableId, Struct> tableIdTableChangeMap) {
        super(tableIdTableChangeMap);
        boolean keySchemaEnable = Boolean.valueOf(debeziumConfig.getOrDefault(KEY_SCHEMA_ENABLE, "true"));
        boolean valueSchemaEnable = Boolean.valueOf(debeziumConfig.getOrDefault(VALUE_SCHEMA_ENABLE, "true"));
        this.deserializationSchema = new CompatibleDebeziumJsonDeserializationSchema(keySchemaEnable, valueSchemaEnable);
    }

    @Override
    public void deserialize(SourceRecord record, Collector<SeaTunnelRow> out) throws Exception {
        super.deserialize(record, out);
        SeaTunnelRow row = this.deserializationSchema.deserialize(record);
        out.collect((Object)row);
    }

    @Override
    public List<CatalogTable> getProducedType() {
        return CatalogTableUtil.convertDataTypeToCatalogTables(this.deserializationSchema.getProducedType(), (String)"default.default");
    }
}

