/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.checkpoint.storage.hdfs.common;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.seatunnel.engine.checkpoint.storage.exception.CheckpointStorageException;
import org.apache.seatunnel.engine.checkpoint.storage.hdfs.common.AbstractConfiguration;

public class HdfsConfiguration
extends AbstractConfiguration {
    private static final String HDFS_DEF_FS_NAME = "fs.defaultFS";
    private static final String KERBEROS_PRINCIPAL = "kerberosPrincipal";
    private static final String KERBEROS_KEYTAB_FILE_PATH = "kerberosKeytabFilePath";
    private static final String HADOOP_SECURITY_AUTHENTICATION_KEY = "hadoop.security.authentication";
    private static final String KERBEROS_KEY = "kerberos";
    private static final String HDFS_IMPL = "org.apache.hadoop.hdfs.DistributedFileSystem";
    private static final String HDFS_IMPL_KEY = "fs.hdfs.impl";
    private static final String SEATUNNEL_HADOOP_PREFIX = "seatunnel.hadoop.";

    @Override
    public Configuration buildConfiguration(Map<String, String> config) throws CheckpointStorageException {
        this.checkConfiguration(config, HDFS_DEF_FS_NAME);
        Configuration hadoopConf = new Configuration();
        if (config.containsKey(HDFS_DEF_FS_NAME)) {
            hadoopConf.set(HDFS_DEF_FS_NAME, config.get(HDFS_DEF_FS_NAME));
        }
        hadoopConf.set(HDFS_IMPL_KEY, HDFS_IMPL);
        hadoopConf.set(HDFS_DEF_FS_NAME, config.get(HDFS_DEF_FS_NAME));
        if (config.containsKey(KERBEROS_PRINCIPAL) && config.containsKey(KERBEROS_KEYTAB_FILE_PATH)) {
            String kerberosPrincipal = config.get(KERBEROS_PRINCIPAL);
            String kerberosKeytabFilePath = config.get(KERBEROS_KEYTAB_FILE_PATH);
            if (StringUtils.isNotBlank((CharSequence)kerberosPrincipal) && StringUtils.isNotBlank((CharSequence)kerberosKeytabFilePath)) {
                hadoopConf.set(HADOOP_SECURITY_AUTHENTICATION_KEY, KERBEROS_KEY);
                this.authenticateKerberos(kerberosPrincipal, kerberosKeytabFilePath, hadoopConf);
            }
        }
        config.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(SEATUNNEL_HADOOP_PREFIX)).forEach(entry -> {
            String key = ((String)entry.getKey()).replace(SEATUNNEL_HADOOP_PREFIX, "");
            String value = (String)entry.getValue();
            hadoopConf.set(key, value);
        });
        return hadoopConf;
    }

    private void authenticateKerberos(String kerberosPrincipal, String kerberosKeytabFilePath, Configuration hdfsConf) throws CheckpointStorageException {
        UserGroupInformation.setConfiguration((Configuration)hdfsConf);
        try {
            UserGroupInformation.loginUserFromKeytab((String)kerberosPrincipal, (String)kerberosKeytabFilePath);
        }
        catch (IOException e) {
            throw new CheckpointStorageException("Failed to login user from keytab : " + kerberosKeytabFilePath + " and kerberos principal : " + kerberosPrincipal, (Throwable)e);
        }
    }
}

