/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.serializer.seata.protocol.transaction;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import org.apache.seata.core.protocol.transaction.GlobalBeginRequest;
import org.apache.seata.serializer.seata.protocol.transaction.AbstractTransactionRequestToTCCodec;

public class GlobalBeginRequestCodec
extends AbstractTransactionRequestToTCCodec {
    @Override
    public Class<?> getMessageClassType() {
        return GlobalBeginRequest.class;
    }

    @Override
    public <T> void encode(T t, ByteBuf out) {
        GlobalBeginRequest globalBeginRequest = (GlobalBeginRequest)t;
        int timeout = globalBeginRequest.getTimeout();
        String transactionName = globalBeginRequest.getTransactionName();
        out.writeInt(timeout);
        if (transactionName != null) {
            byte[] bs = transactionName.getBytes(UTF8);
            out.writeShort((int)((short)bs.length));
            if (bs.length > 0) {
                out.writeBytes(bs);
            }
        } else {
            out.writeShort(0);
        }
    }

    @Override
    public <T> void decode(T t, ByteBuffer in) {
        GlobalBeginRequest globalBeginRequest = (GlobalBeginRequest)t;
        globalBeginRequest.setTimeout(in.getInt());
        short len = in.getShort();
        if (len > 0) {
            byte[] bs = new byte[len];
            in.get(bs);
            globalBeginRequest.setTransactionName(new String(bs, UTF8));
        }
    }
}

