/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.serializer.seata;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.seata.core.protocol.AbstractMessage;
import org.apache.seata.core.protocol.BatchResultMessage;
import org.apache.seata.core.protocol.MergeResultMessage;
import org.apache.seata.core.protocol.MergedWarpMessage;
import org.apache.seata.core.protocol.RegisterRMRequest;
import org.apache.seata.core.protocol.RegisterRMResponse;
import org.apache.seata.core.protocol.RegisterTMRequest;
import org.apache.seata.core.protocol.RegisterTMResponse;
import org.apache.seata.core.protocol.transaction.BranchCommitRequest;
import org.apache.seata.core.protocol.transaction.BranchCommitResponse;
import org.apache.seata.core.protocol.transaction.BranchRegisterRequest;
import org.apache.seata.core.protocol.transaction.BranchRegisterResponse;
import org.apache.seata.core.protocol.transaction.BranchReportRequest;
import org.apache.seata.core.protocol.transaction.BranchReportResponse;
import org.apache.seata.core.protocol.transaction.BranchRollbackRequest;
import org.apache.seata.core.protocol.transaction.BranchRollbackResponse;
import org.apache.seata.core.protocol.transaction.GlobalBeginRequest;
import org.apache.seata.core.protocol.transaction.GlobalBeginResponse;
import org.apache.seata.core.protocol.transaction.GlobalCommitRequest;
import org.apache.seata.core.protocol.transaction.GlobalCommitResponse;
import org.apache.seata.core.protocol.transaction.GlobalLockQueryRequest;
import org.apache.seata.core.protocol.transaction.GlobalLockQueryResponse;
import org.apache.seata.core.protocol.transaction.GlobalReportRequest;
import org.apache.seata.core.protocol.transaction.GlobalReportResponse;
import org.apache.seata.core.protocol.transaction.GlobalRollbackRequest;
import org.apache.seata.core.protocol.transaction.GlobalRollbackResponse;
import org.apache.seata.core.protocol.transaction.GlobalStatusRequest;
import org.apache.seata.core.protocol.transaction.GlobalStatusResponse;
import org.apache.seata.core.protocol.transaction.UndoLogDeleteRequest;
import org.apache.seata.serializer.seata.MessageSeataCodec;
import org.apache.seata.serializer.seata.protocol.AbstractMessageCodec;
import org.apache.seata.serializer.seata.protocol.BatchResultMessageCodec;
import org.apache.seata.serializer.seata.protocol.MergeResultMessageCodec;
import org.apache.seata.serializer.seata.protocol.MergedWarpMessageCodec;
import org.apache.seata.serializer.seata.protocol.RegisterRMRequestCodec;
import org.apache.seata.serializer.seata.protocol.RegisterRMResponseCodec;
import org.apache.seata.serializer.seata.protocol.RegisterTMRequestCodec;
import org.apache.seata.serializer.seata.protocol.RegisterTMResponseCodec;
import org.apache.seata.serializer.seata.protocol.transaction.BranchCommitRequestCodec;
import org.apache.seata.serializer.seata.protocol.transaction.BranchCommitResponseCodec;
import org.apache.seata.serializer.seata.protocol.transaction.BranchRegisterRequestCodec;
import org.apache.seata.serializer.seata.protocol.transaction.BranchRegisterResponseCodec;
import org.apache.seata.serializer.seata.protocol.transaction.BranchReportRequestCodec;
import org.apache.seata.serializer.seata.protocol.transaction.BranchReportResponseCodec;
import org.apache.seata.serializer.seata.protocol.transaction.BranchRollbackRequestCodec;
import org.apache.seata.serializer.seata.protocol.transaction.BranchRollbackResponseCodec;
import org.apache.seata.serializer.seata.protocol.transaction.GlobalBeginRequestCodec;
import org.apache.seata.serializer.seata.protocol.transaction.GlobalBeginResponseCodec;
import org.apache.seata.serializer.seata.protocol.transaction.GlobalCommitRequestCodec;
import org.apache.seata.serializer.seata.protocol.transaction.GlobalCommitResponseCodec;
import org.apache.seata.serializer.seata.protocol.transaction.GlobalLockQueryRequestCodec;
import org.apache.seata.serializer.seata.protocol.transaction.GlobalLockQueryResponseCodec;
import org.apache.seata.serializer.seata.protocol.transaction.GlobalReportRequestCodec;
import org.apache.seata.serializer.seata.protocol.transaction.GlobalReportResponseCodec;
import org.apache.seata.serializer.seata.protocol.transaction.GlobalRollbackRequestCodec;
import org.apache.seata.serializer.seata.protocol.transaction.GlobalRollbackResponseCodec;
import org.apache.seata.serializer.seata.protocol.transaction.GlobalStatusRequestCodec;
import org.apache.seata.serializer.seata.protocol.transaction.GlobalStatusResponseCodec;
import org.apache.seata.serializer.seata.protocol.transaction.UndoLogDeleteRequestCodec;

public class MessageCodecFactory {
    protected static final Charset UTF8 = StandardCharsets.UTF_8;

    public static MessageSeataCodec getMessageCodec(AbstractMessage abstractMessage, byte version) {
        return MessageCodecFactory.getMessageCodec(abstractMessage.getTypeCode(), version);
    }

    public static MessageSeataCodec getMessageCodec(short typeCode, byte version) {
        AbstractMessageCodec msgCodec = null;
        switch (typeCode) {
            case 59: {
                msgCodec = new MergedWarpMessageCodec(version);
                break;
            }
            case 60: {
                msgCodec = new MergeResultMessageCodec(version);
                break;
            }
            case 101: {
                msgCodec = new RegisterTMRequestCodec();
                break;
            }
            case 102: {
                msgCodec = new RegisterTMResponseCodec();
                break;
            }
            case 103: {
                msgCodec = new RegisterRMRequestCodec();
                break;
            }
            case 104: {
                msgCodec = new RegisterRMResponseCodec();
                break;
            }
            case 3: {
                msgCodec = new BranchCommitRequestCodec();
                break;
            }
            case 5: {
                msgCodec = new BranchRollbackRequestCodec();
                break;
            }
            case 17: {
                msgCodec = new GlobalReportRequestCodec();
                break;
            }
            case 121: {
                msgCodec = new BatchResultMessageCodec(version);
                break;
            }
            case 1: {
                msgCodec = new GlobalBeginRequestCodec();
                break;
            }
            case 7: {
                msgCodec = new GlobalCommitRequestCodec();
                break;
            }
            case 9: {
                msgCodec = new GlobalRollbackRequestCodec();
                break;
            }
            case 15: {
                msgCodec = new GlobalStatusRequestCodec();
                break;
            }
            case 21: {
                msgCodec = new GlobalLockQueryRequestCodec();
                break;
            }
            case 11: {
                msgCodec = new BranchRegisterRequestCodec();
                break;
            }
            case 13: {
                msgCodec = new BranchReportRequestCodec();
                break;
            }
            case 2: {
                msgCodec = new GlobalBeginResponseCodec();
                break;
            }
            case 8: {
                msgCodec = new GlobalCommitResponseCodec();
                break;
            }
            case 10: {
                msgCodec = new GlobalRollbackResponseCodec();
                break;
            }
            case 16: {
                msgCodec = new GlobalStatusResponseCodec();
                break;
            }
            case 22: {
                msgCodec = new GlobalLockQueryResponseCodec();
                break;
            }
            case 12: {
                msgCodec = new BranchRegisterResponseCodec();
                break;
            }
            case 14: {
                msgCodec = new BranchReportResponseCodec();
                break;
            }
            case 4: {
                msgCodec = new BranchCommitResponseCodec();
                break;
            }
            case 6: {
                msgCodec = new BranchRollbackResponseCodec();
                break;
            }
            case 111: {
                msgCodec = new UndoLogDeleteRequestCodec();
                break;
            }
            case 18: {
                msgCodec = new GlobalReportResponseCodec();
                break;
            }
        }
        if (msgCodec != null) {
            return msgCodec;
        }
        throw new IllegalArgumentException("not support typeCode," + typeCode);
    }

    public static AbstractMessage getMessage(short typeCode) {
        AbstractMessage abstractMessage = null;
        switch (typeCode) {
            case 59: {
                abstractMessage = new MergedWarpMessage();
                break;
            }
            case 60: {
                abstractMessage = new MergeResultMessage();
                break;
            }
            case 101: {
                abstractMessage = new RegisterTMRequest();
                break;
            }
            case 102: {
                abstractMessage = new RegisterTMResponse();
                break;
            }
            case 103: {
                abstractMessage = new RegisterRMRequest();
                break;
            }
            case 104: {
                abstractMessage = new RegisterRMResponse();
                break;
            }
            case 3: {
                abstractMessage = new BranchCommitRequest();
                break;
            }
            case 5: {
                abstractMessage = new BranchRollbackRequest();
                break;
            }
            case 111: {
                abstractMessage = new UndoLogDeleteRequest();
                break;
            }
            case 17: {
                abstractMessage = new GlobalReportRequest();
                break;
            }
            case 18: {
                abstractMessage = new GlobalReportResponse();
                break;
            }
            case 121: {
                abstractMessage = new BatchResultMessage();
                break;
            }
            case 1: {
                abstractMessage = new GlobalBeginRequest();
                break;
            }
            case 7: {
                abstractMessage = new GlobalCommitRequest();
                break;
            }
            case 9: {
                abstractMessage = new GlobalRollbackRequest();
                break;
            }
            case 15: {
                abstractMessage = new GlobalStatusRequest();
                break;
            }
            case 21: {
                abstractMessage = new GlobalLockQueryRequest();
                break;
            }
            case 11: {
                abstractMessage = new BranchRegisterRequest();
                break;
            }
            case 13: {
                abstractMessage = new BranchReportRequest();
                break;
            }
            case 2: {
                abstractMessage = new GlobalBeginResponse();
                break;
            }
            case 8: {
                abstractMessage = new GlobalCommitResponse();
                break;
            }
            case 10: {
                abstractMessage = new GlobalRollbackResponse();
                break;
            }
            case 16: {
                abstractMessage = new GlobalStatusResponse();
                break;
            }
            case 22: {
                abstractMessage = new GlobalLockQueryResponse();
                break;
            }
            case 12: {
                abstractMessage = new BranchRegisterResponse();
                break;
            }
            case 14: {
                abstractMessage = new BranchReportResponse();
                break;
            }
            case 4: {
                abstractMessage = new BranchCommitResponse();
                break;
            }
            case 6: {
                abstractMessage = new BranchRollbackResponse();
                break;
            }
        }
        if (abstractMessage != null) {
            return abstractMessage;
        }
        throw new IllegalArgumentException("not support typeCode," + typeCode);
    }
}

