/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.engine.store.db;

public class StateLangStoreSqls {
    private static final String STATE_MACHINE_FIELDS = "id, tenant_id, app_name, name, status, gmt_create, ver, type, content, recover_strategy, comment_";
    private static final String GET_STATE_MACHINE_BY_ID_SQL = "SELECT id, tenant_id, app_name, name, status, gmt_create, ver, type, content, recover_strategy, comment_ FROM ${TABLE_PREFIX}state_machine_def WHERE id = ?";
    private static final String QUERY_STATE_MACHINES_BY_NAME_AND_TENANT_SQL = "SELECT id, tenant_id, app_name, name, status, gmt_create, ver, type, content, recover_strategy, comment_ FROM ${TABLE_PREFIX}state_machine_def WHERE name = ? AND tenant_id = ? ORDER BY gmt_create DESC";
    private static final String INSERT_STATE_MACHINE_SQL = "INSERT INTO ${TABLE_PREFIX}state_machine_def (id, tenant_id, app_name, name, status, gmt_create, ver, type, content, recover_strategy, comment_) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String TABLE_PREFIX_REGEX = "\\$\\{TABLE_PREFIX}";
    private String tablePrefix;
    private String getGetStateMachineByIdSql;
    private String queryStateMachinesByNameAndTenantSql;
    private String insertStateMachineSql;

    public StateLangStoreSqls(String tablePrefix) {
        this.tablePrefix = tablePrefix;
        this.init();
    }

    private void init() {
        this.getGetStateMachineByIdSql = GET_STATE_MACHINE_BY_ID_SQL.replaceAll(TABLE_PREFIX_REGEX, this.tablePrefix);
        this.queryStateMachinesByNameAndTenantSql = QUERY_STATE_MACHINES_BY_NAME_AND_TENANT_SQL.replaceAll(TABLE_PREFIX_REGEX, this.tablePrefix);
        this.insertStateMachineSql = INSERT_STATE_MACHINE_SQL.replaceAll(TABLE_PREFIX_REGEX, this.tablePrefix);
    }

    public String getGetStateMachineByIdSql(String dbType) {
        return this.getGetStateMachineByIdSql;
    }

    public String getQueryStateMachinesByNameAndTenantSql(String dbType) {
        return this.queryStateMachinesByNameAndTenantSql;
    }

    public String getInsertStateMachineSql(String dbType) {
        return this.insertStateMachineSql;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }
}

