/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.protocol.detector;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.util.CharsetUtil;
import org.apache.seata.core.protocol.detector.ProtocolDetector;
import org.apache.seata.core.rpc.netty.grpc.GrpcDecoder;
import org.apache.seata.core.rpc.netty.grpc.GrpcEncoder;
import org.apache.seata.core.rpc.netty.http.Http2HttpHandler;

public class Http2Detector
implements ProtocolDetector {
    private static final byte[] HTTP2_PREFIX_BYTES = "PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n".getBytes(CharsetUtil.UTF_8);
    private final ChannelHandler[] serverHandlers;

    public Http2Detector(ChannelHandler[] serverHandlers) {
        this.serverHandlers = serverHandlers;
    }

    @Override
    public boolean detect(ByteBuf in) {
        if (in.readableBytes() < HTTP2_PREFIX_BYTES.length) {
            return false;
        }
        for (int i = 0; i < HTTP2_PREFIX_BYTES.length; ++i) {
            if (in.getByte(i) == HTTP2_PREFIX_BYTES[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public ChannelHandler[] getHandlers() {
        return new ChannelHandler[]{Http2FrameCodecBuilder.forServer().build(), new Http2MultiplexHandler((ChannelHandler)new ChannelInitializer<Http2StreamChannel>(){

            protected void initChannel(Http2StreamChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new Http2SelectorHandler()});
            }
        })};
    }

    private class Http2SelectorHandler
    extends ChannelInboundHandlerAdapter {
        private Http2SelectorHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (msg instanceof Http2HeadersFrame) {
                Http2HeadersFrame headersFrame = (Http2HeadersFrame)msg;
                CharSequence contentType = (CharSequence)headersFrame.headers().get((Object)HttpHeaderNames.CONTENT_TYPE);
                ChannelPipeline p = ctx.pipeline();
                if (contentType != null && contentType.toString().endsWith("grpc")) {
                    p.addLast(new ChannelHandler[]{new GrpcDecoder()});
                    p.addLast(new ChannelHandler[]{new GrpcEncoder()});
                    p.addLast(Http2Detector.this.serverHandlers);
                } else {
                    p.addLast(new ChannelHandler[]{new Http2HttpHandler()});
                }
                p.remove((ChannelHandler)this);
            }
            ctx.fireChannelRead(msg);
        }
    }
}

