/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.sql.handler.kingbase;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.sqlparser.EscapeHandler;
import org.apache.seata.sqlparser.struct.ColumnMeta;
import org.apache.seata.sqlparser.struct.TableMeta;

@LoadLevel(name="kingbase")
public class KingbaseEscapeHandler
implements EscapeHandler {
    private Set<String> keywordSet = Arrays.stream(KingbaseKeyword.values()).map(Enum::name).collect(Collectors.toSet());

    @Override
    public boolean checkIfKeyWords(String fieldOrTableName) {
        if (this.keywordSet.contains(fieldOrTableName)) {
            return true;
        }
        if (fieldOrTableName != null) {
            fieldOrTableName = fieldOrTableName.toUpperCase();
        }
        return this.keywordSet.contains(fieldOrTableName);
    }

    @Override
    public boolean checkIfNeedEscape(String columnName, TableMeta tableMeta) {
        if (StringUtils.isBlank(columnName)) {
            return false;
        }
        if (this.containsEscape(columnName = columnName.trim())) {
            return false;
        }
        boolean isKeyWord = this.checkIfKeyWords(columnName);
        if (isKeyWord) {
            return true;
        }
        if (null != tableMeta) {
            ColumnMeta columnMeta = tableMeta.getColumnMeta(columnName);
            if (null != columnMeta) {
                return columnMeta.isCaseSensitive();
            }
        } else if (KingbaseEscapeHandler.isUppercase(columnName)) {
            return false;
        }
        return true;
    }

    private static boolean isUppercase(String fieldOrTableName) {
        char[] chars;
        if (fieldOrTableName == null) {
            return false;
        }
        for (char ch : chars = fieldOrTableName.toCharArray()) {
            if (ch < 'a' || ch > 'z') continue;
            return false;
        }
        return true;
    }

    private static enum KingbaseKeyword {
        ACCESS("ACCESS"),
        ADD("ADD"),
        ALL("ALL"),
        ALTER("ALTER"),
        AND("AND"),
        ANY("ANY"),
        AS("AS"),
        ASC("ASC"),
        AUDIT("AUDIT"),
        BETWEEN("BETWEEN"),
        BY("BY"),
        CHAR("CHAR"),
        CHECK("CHECK"),
        CLUSTER("CLUSTER"),
        COLUMN("COLUMN"),
        COLUMN_VALUE("COLUMN_VALUE"),
        COMMENT("COMMENT"),
        COMPRESS("COMPRESS"),
        CONNECT("CONNECT"),
        CREATE("CREATE"),
        CURRENT("CURRENT"),
        DATE("DATE"),
        DECIMAL("DECIMAL"),
        DEFAULT("DEFAULT"),
        DELETE("DELETE"),
        DESC("DESC"),
        DISTINCT("DISTINCT"),
        DROP("DROP"),
        ELSE("ELSE"),
        EXCLUSIVE("EXCLUSIVE"),
        EXISTS("EXISTS"),
        FILE("FILE"),
        FLOAT("FLOAT"),
        FOR("FOR"),
        FROM("FROM"),
        GRANT("GRANT"),
        GROUP("GROUP"),
        HAVING("HAVING"),
        IDENTIFIED("IDENTIFIED"),
        IMMEDIATE("IMMEDIATE"),
        IN("IN"),
        INCREMENT("INCREMENT"),
        INDEX("INDEX"),
        INITIAL("INITIAL"),
        INSERT("INSERT"),
        INTEGER("INTEGER"),
        INTERSECT("INTERSECT"),
        INTO("INTO"),
        IS("IS"),
        LEVEL("LEVEL"),
        LIKE("LIKE"),
        LOCK("LOCK"),
        LONG("LONG"),
        MAXEXTENTS("MAXEXTENTS"),
        MINUS("MINUS"),
        MLSLABEL("MLSLABEL"),
        MODE("MODE"),
        MODIFY("MODIFY"),
        NESTED_TABLE_ID("NESTED_TABLE_ID"),
        NOAUDIT("NOAUDIT"),
        NOCOMPRESS("NOCOMPRESS"),
        NOT("NOT"),
        NOWAIT("NOWAIT"),
        NULL("NULL"),
        NUMBER("NUMBER"),
        OF("OF"),
        OFFLINE("OFFLINE"),
        ON("ON"),
        ONLINE("ONLINE"),
        OPTION("OPTION"),
        OR("OR"),
        ORDER("ORDER"),
        PCTFREE("PCTFREE"),
        PRIOR("PRIOR"),
        PUBLIC("PUBLIC"),
        RAW("RAW"),
        RENAME("RENAME"),
        RESOURCE("RESOURCE"),
        REVOKE("REVOKE"),
        ROW("ROW"),
        ROWID("ROWID"),
        ROWNUM("ROWNUM"),
        ROWS("ROWS"),
        SELECT("SELECT"),
        SESSION("SESSION"),
        SET("SET"),
        SHARE("SHARE"),
        SIZE("SIZE"),
        SMALLINT("SMALLINT"),
        START("START"),
        SUCCESSFUL("SUCCESSFUL"),
        SYNONYM("SYNONYM"),
        SYSDATE("SYSDATE"),
        TABLE("TABLE"),
        THEN("THEN"),
        TO("TO"),
        TRIGGER("TRIGGER"),
        UID("UID"),
        UNION("UNION"),
        UNIQUE("UNIQUE"),
        UPDATE("UPDATE"),
        USER("USER"),
        VALIDATE("VALIDATE"),
        VALUES("VALUES"),
        VARCHAR("VARCHAR"),
        VARCHAR2("VARCHAR2"),
        VIEW("VIEW"),
        WHENEVER("WHENEVER"),
        WHERE("WHERE"),
        WITH("WITH");

        public final String name;

        private KingbaseKeyword(String name) {
            this.name = name;
        }
    }
}

