/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.rpc.core;

import java.util.HashMap;
import java.util.Map;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.context.RootContext;
import org.apache.seata.core.model.BranchType;
import org.apache.seata.integration.rpc.core.BaseRpcFilter;

public interface ProviderRpcFilter<T>
extends BaseRpcFilter<T> {
    public static final String[] TRX_CONTEXT_KEYS = new String[]{"TX_XID", "TX_XID".toLowerCase(), "TX_BRANCH_TYPE"};
    public static final String LOW_KEY_XID = "tx_xid";

    default public Map<String, String> getRpcContexts(T rpcRequest) {
        HashMap<String, String> contextMap = new HashMap<String, String>();
        for (int i = 0; i < TRX_CONTEXT_KEYS.length; ++i) {
            String contextValue = this.getRpcContext(rpcRequest, TRX_CONTEXT_KEYS[i]);
            if (!StringUtils.isNotBlank(contextValue)) continue;
            contextMap.put(TRX_CONTEXT_KEYS[i], contextValue);
        }
        return contextMap;
    }

    public String getRpcContext(T var1, String var2);

    default public String getXidFromContexts(Map<String, String> rpcContextMap) {
        String xid = this.getValueFromMap(rpcContextMap, "TX_XID");
        if (StringUtils.isBlank(xid)) {
            return this.getValueFromMap(rpcContextMap, "TX_XID".toLowerCase());
        }
        return xid;
    }

    default public void bindRequestToContexts(Map<String, String> contextMap) {
        block9: for (int i = 0; i < TRX_CONTEXT_KEYS.length; ++i) {
            String contextValue = contextMap.get(TRX_CONTEXT_KEYS[i]);
            if (!StringUtils.isNotBlank(contextValue)) continue;
            switch (TRX_CONTEXT_KEYS[i]) {
                case "TX_XID": 
                case "tx_xid": {
                    RootContext.bind(contextValue);
                    continue block9;
                }
                case "TX_BRANCH_TYPE": {
                    if (!BranchType.TCC.name().equalsIgnoreCase(contextValue)) continue block9;
                    RootContext.bindBranchType(BranchType.TCC);
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("wrong context:" + TRX_CONTEXT_KEYS[i]);
                }
            }
        }
    }

    default public Map<String, String> cleanRootContexts() {
        HashMap<String, String> contextMap = new HashMap<String, String>();
        block10: for (int i = 0; i < TRX_CONTEXT_KEYS.length; ++i) {
            switch (TRX_CONTEXT_KEYS[i]) {
                case "TX_XID": {
                    String xid = RootContext.unbind();
                    contextMap.put("TX_XID", xid);
                    continue block10;
                }
                case "tx_xid": {
                    continue block10;
                }
                case "TX_BRANCH_TYPE": {
                    BranchType contextValue = RootContext.getBranchType();
                    if (BranchType.TCC == contextValue) {
                        RootContext.unbindBranchType();
                    }
                    if (null == contextValue) continue block10;
                    contextMap.put("TX_BRANCH_TYPE", contextValue.name());
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("wrong context:" + TRX_CONTEXT_KEYS[i]);
                }
            }
        }
        return contextMap;
    }

    default public void resetRootContexts(Map<String, String> contextMap) {
        this.bindRequestToContexts(contextMap);
    }
}

