/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty;

import io.netty.channel.Channel;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.seata.common.thread.NamedThreadFactory;
import org.apache.seata.core.rpc.ShutdownHook;
import org.apache.seata.core.rpc.TransactionMessageHandler;
import org.apache.seata.core.rpc.netty.AbstractNettyRemotingServer;
import org.apache.seata.core.rpc.netty.NettyServerConfig;
import org.apache.seata.core.rpc.processor.server.RegRmProcessor;
import org.apache.seata.core.rpc.processor.server.RegTmProcessor;
import org.apache.seata.core.rpc.processor.server.ServerHeartbeatProcessor;
import org.apache.seata.core.rpc.processor.server.ServerOnRequestProcessor;
import org.apache.seata.core.rpc.processor.server.ServerOnResponseProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyRemotingServer
extends AbstractNettyRemotingServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyRemotingServer.class);
    private TransactionMessageHandler transactionMessageHandler;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final ThreadPoolExecutor branchResultMessageExecutor = new ThreadPoolExecutor(NettyServerConfig.getMinBranchResultPoolSize(), NettyServerConfig.getMaxBranchResultPoolSize(), NettyServerConfig.getKeepAliveTime(), TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(NettyServerConfig.getMaxTaskQueueSize()), new NamedThreadFactory("BranchResultHandlerThread", NettyServerConfig.getMaxBranchResultPoolSize()), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    public void init() {
        this.registerProcessor();
        if (this.initialized.compareAndSet(false, true)) {
            super.init();
        }
    }

    public NettyRemotingServer(ThreadPoolExecutor messageExecutor) {
        super(messageExecutor, new NettyServerConfig());
    }

    public NettyRemotingServer(ThreadPoolExecutor messageExecutor, NettyServerConfig nettyServerConfig) {
        super(messageExecutor, nettyServerConfig);
    }

    public void setHandler(TransactionMessageHandler transactionMessageHandler) {
        this.transactionMessageHandler = transactionMessageHandler;
    }

    public TransactionMessageHandler getHandler() {
        return this.transactionMessageHandler;
    }

    @Override
    public void destroyChannel(String serverAddress, Channel channel) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("will destroy channel:{},address:{}", (Object)channel, (Object)serverAddress);
        }
        channel.disconnect();
        channel.close();
    }

    private void registerProcessor() {
        ServerOnRequestProcessor onRequestProcessor = new ServerOnRequestProcessor(this, this.getHandler());
        ShutdownHook.getInstance().addDisposable(onRequestProcessor);
        super.registerProcessor(11, onRequestProcessor, this.messageExecutor);
        super.registerProcessor(13, onRequestProcessor, this.messageExecutor);
        super.registerProcessor(1, onRequestProcessor, this.messageExecutor);
        super.registerProcessor(7, onRequestProcessor, this.messageExecutor);
        super.registerProcessor(21, onRequestProcessor, this.messageExecutor);
        super.registerProcessor(17, onRequestProcessor, this.messageExecutor);
        super.registerProcessor(9, onRequestProcessor, this.messageExecutor);
        super.registerProcessor(15, onRequestProcessor, this.messageExecutor);
        super.registerProcessor(59, onRequestProcessor, this.messageExecutor);
        ServerOnResponseProcessor onResponseProcessor = new ServerOnResponseProcessor(this.getHandler(), this.getFutures());
        super.registerProcessor(4, onResponseProcessor, this.branchResultMessageExecutor);
        super.registerProcessor(6, onResponseProcessor, this.branchResultMessageExecutor);
        RegRmProcessor regRmProcessor = new RegRmProcessor(this);
        super.registerProcessor(103, regRmProcessor, this.messageExecutor);
        RegTmProcessor regTmProcessor = new RegTmProcessor(this);
        super.registerProcessor(101, regTmProcessor, null);
        ServerHeartbeatProcessor heartbeatMessageProcessor = new ServerHeartbeatProcessor(this);
        super.registerProcessor(120, heartbeatMessageProcessor, null);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.branchResultMessageExecutor.shutdown();
    }
}

