/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.message;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.store.ConsumeQueue;
import org.apache.rocketmq.store.MappedFile;
import org.apache.rocketmq.store.MappedFileQueue;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.config.StorePathConfigHelper;

public class Store {
    public static final int MESSAGE_MAGIC_CODE = -626843481;
    private static final int BLANK_MAGIC_CODE = -875286124;
    private MappedFileQueue mapedFileQueue;
    private ConcurrentHashMap<String, ConcurrentHashMap<Integer, ConsumeQueue>> consumeQueueTable;
    private String cStorePath;
    private int cSize;
    private String lStorePath;
    private int lSize;

    public Store(String cStorePath, int cSize, String lStorePath, int lSize) {
        this.cStorePath = cStorePath;
        this.cSize = cSize;
        this.lStorePath = lStorePath;
        this.lSize = lSize;
        this.mapedFileQueue = new MappedFileQueue(cStorePath, cSize, null);
        this.consumeQueueTable = new ConcurrentHashMap();
    }

    public boolean load() {
        boolean result = this.mapedFileQueue.load();
        System.out.printf("load commit log " + (result ? "OK" : "Failed"), new Object[0]);
        if (result) {
            result = this.loadConsumeQueue();
        }
        System.out.printf("load logics log " + (result ? "OK" : "Failed"), new Object[0]);
        return result;
    }

    private boolean loadConsumeQueue() {
        File dirLogic = new File(StorePathConfigHelper.getStorePathConsumeQueue((String)this.lStorePath));
        File[] fileTopicList = dirLogic.listFiles();
        if (fileTopicList != null) {
            for (File fileTopic : fileTopicList) {
                String topic = fileTopic.getName();
                File[] fileQueueIdList = fileTopic.listFiles();
                if (fileQueueIdList == null) continue;
                for (File fileQueueId : fileQueueIdList) {
                    int queueId = Integer.parseInt(fileQueueId.getName());
                    ConsumeQueue logic = new ConsumeQueue(topic, queueId, StorePathConfigHelper.getStorePathConsumeQueue((String)this.lStorePath), this.lSize, null);
                    this.putConsumeQueue(topic, queueId, logic);
                    if (logic.load()) continue;
                    return false;
                }
            }
        }
        System.out.printf("load logics queue all over, OK", new Object[0]);
        return true;
    }

    private void putConsumeQueue(String topic, int queueId, ConsumeQueue consumeQueue) {
        ConcurrentHashMap<Integer, Object> map = this.consumeQueueTable.get(topic);
        if (null == map) {
            map = new ConcurrentHashMap();
            map.put(queueId, consumeQueue);
            this.consumeQueueTable.put(topic, map);
        } else {
            map.put(queueId, consumeQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traval(boolean openAll) {
        boolean success = true;
        byte[] bytesContent = new byte[1024];
        List mapedFiles = this.mapedFileQueue.getMappedFiles();
        block6: for (MappedFile mapedFile : mapedFiles) {
            long startOffset = mapedFile.getFileFromOffset();
            int position = 0;
            int msgCount = 0;
            int errorCount = 0;
            System.out.printf("start travel " + mapedFile.getFileName(), new Object[0]);
            long startTime = System.currentTimeMillis();
            ByteBuffer byteBuffer = mapedFile.sliceByteBuffer();
            while (byteBuffer.hasRemaining()) {
                int totalSize = byteBuffer.getInt();
                int magicCode = byteBuffer.getInt();
                if (-875286124 == magicCode) {
                    position = byteBuffer.limit();
                    break;
                }
                int bodyCRC = byteBuffer.getInt();
                int queueId = byteBuffer.getInt();
                int flag = byteBuffer.getInt();
                long queueOffset = byteBuffer.getLong();
                long physicOffset = byteBuffer.getLong();
                int sysFlag = byteBuffer.getInt();
                long bornTimeStamp = byteBuffer.getLong();
                byteBuffer.position(byteBuffer.position() + 8);
                long storeTimestamp = byteBuffer.getLong();
                byteBuffer.position(byteBuffer.position() + 8);
                int reconsumeTimes = byteBuffer.getInt();
                long preparedTransactionOffset = byteBuffer.getLong();
                int bodyLen = byteBuffer.getInt();
                if (bodyLen > 0) {
                    byteBuffer.position(byteBuffer.position() + bodyLen);
                }
                byte topicLen = byteBuffer.get();
                byteBuffer.get(bytesContent, 0, topicLen);
                String topic = null;
                try {
                    topic = new String(bytesContent, 0, (int)topicLen, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                Date storeTime = new Date(storeTimestamp);
                long currentPhyOffset = startOffset + (long)position;
                if (physicOffset != currentPhyOffset) {
                    System.out.printf(storeTime + " [fetal error] physicOffset != currentPhyOffset. position=" + position + ", msgCount=" + msgCount + ", physicOffset=" + physicOffset + ", currentPhyOffset=" + currentPhyOffset, new Object[0]);
                    ++errorCount;
                    if (!openAll) {
                        success = false;
                        break block6;
                    }
                }
                ConsumeQueue consumeQueue = this.findConsumeQueue(topic, queueId);
                SelectMappedBufferResult smb = consumeQueue.getIndexBuffer(queueOffset);
                try {
                    long offsetPy = smb.getByteBuffer().getLong();
                    int sizePy = smb.getByteBuffer().getInt();
                    if (physicOffset != offsetPy) {
                        System.out.printf(storeTime + " [fetal error] physicOffset != offsetPy. position=" + position + ", msgCount=" + msgCount + ", physicOffset=" + physicOffset + ", offsetPy=" + offsetPy, new Object[0]);
                        ++errorCount;
                        if (!openAll) {
                            success = false;
                            break block6;
                        }
                    }
                    if (totalSize != sizePy) {
                        System.out.printf(storeTime + " [fetal error] totalSize != sizePy. position=" + position + ", msgCount=" + msgCount + ", totalSize=" + totalSize + ", sizePy=" + sizePy, new Object[0]);
                        ++errorCount;
                        if (!openAll) {
                            success = false;
                            break block6;
                        }
                    }
                }
                finally {
                    smb.release();
                }
                ++msgCount;
                byteBuffer.position(position += totalSize);
            }
            System.out.printf("end travel " + mapedFile.getFileName() + ", total msg=" + msgCount + ", error count=" + errorCount + ", cost:" + (System.currentTimeMillis() - startTime), new Object[0]);
        }
        System.out.printf("travel " + (success ? "ok" : "fail"), new Object[0]);
    }

    public ConsumeQueue findConsumeQueue(String topic, int queueId) {
        ConsumeQueue logic;
        ConcurrentHashMap<Integer, Object> map = this.consumeQueueTable.get(topic);
        if (null == map) {
            ConcurrentHashMap newMap = new ConcurrentHashMap(128);
            ConcurrentHashMap oldMap = this.consumeQueueTable.putIfAbsent(topic, newMap);
            map = oldMap != null ? oldMap : newMap;
        }
        if (null == (logic = map.get(queueId))) {
            ConsumeQueue newLogic = new ConsumeQueue(topic, queueId, StorePathConfigHelper.getStorePathConsumeQueue((String)this.lStorePath), this.lSize, null);
            ConsumeQueue oldLogic = map.putIfAbsent(queueId, newLogic);
            logic = oldLogic != null ? oldLogic : newLogic;
        }
        return logic;
    }
}

