/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.config.validation;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.apache.pulsar.config.validation.ConfigValidationUtils;
import org.apache.pulsar.config.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorImpls {
    private static final Logger log = LoggerFactory.getLogger(ValidatorImpls.class);

    private static Class<?> loadClass(String className) throws ClassNotFoundException {
        Class<?> objectClass;
        try {
            objectClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            ClassLoader clsLoader = Thread.currentThread().getContextClassLoader();
            if (clsLoader != null) {
                objectClass = clsLoader.loadClass(className);
            }
            throw e;
        }
        return objectClass;
    }

    public static class SimpleTypeValidator
    extends Validator {
        private Class<?> type;

        public SimpleTypeValidator(Map<String, Object> params) {
            this.type = (Class)params.get("type");
        }

        public static void validateField(String name, Class<?> type, Object o) {
            if (o == null) {
                return;
            }
            if (type.isInstance(o)) {
                return;
            }
            throw new IllegalArgumentException("Field " + name + " must be of type " + type + ". Object: " + o + " actual type: " + o.getClass());
        }

        @Override
        public void validateField(String name, Object o) {
            SimpleTypeValidator.validateField(name, this.type, o);
        }
    }

    public static class ListEntryCustomValidator
    extends Validator {
        private Class<?>[] entryValidators;

        public ListEntryCustomValidator(Map<String, Object> params) {
            this.entryValidators = (Class[])params.get("entryValidatorClasses");
        }

        public static void validateField(String name, Class<?>[] validators, Object o) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
            if (o == null) {
                return;
            }
            SimpleTypeValidator.validateField(name, Iterable.class, o);
            for (Object entry : (Iterable)o) {
                for (Class<?> validator : validators) {
                    Object v = validator.getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (v instanceof Validator) {
                        ((Validator)v).validateField(name + " list entry", entry);
                        continue;
                    }
                    log.warn("validator: {} cannot be used in ListEntryCustomValidator. Individual entry validators must a instance of Validator class", (Object)validator.getName());
                }
            }
        }

        @Override
        public void validateField(String name, Object o) {
            try {
                ListEntryCustomValidator.validateField(name, this.entryValidators, o);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class StringValidator
    extends Validator {
        private HashSet<String> acceptedValues = null;

        public StringValidator() {
        }

        public StringValidator(Map<String, Object> params) {
            this.acceptedValues = new HashSet<String>(Arrays.asList((String[])params.get("acceptedValues")));
            if (this.acceptedValues.isEmpty() || this.acceptedValues.size() == 1 && this.acceptedValues.contains("")) {
                this.acceptedValues = null;
            }
        }

        @Override
        public void validateField(String name, Object o) {
            SimpleTypeValidator.validateField(name, String.class, o);
            if (this.acceptedValues != null && !this.acceptedValues.contains((String)o)) {
                throw new IllegalArgumentException("Field " + name + " is not an accepted value. Value: " + o + " Accepted values: " + this.acceptedValues);
            }
        }
    }

    public static class MapEntryCustomValidator
    extends Validator {
        private Class<?>[] keyValidators;
        private Class<?>[] valueValidators;

        public MapEntryCustomValidator(Map<String, Object> params) {
            this.keyValidators = (Class[])params.get("keyValidatorClasses");
            this.valueValidators = (Class[])params.get("valueValidatorClasses");
        }

        public static void validateField(String name, Class<?>[] keyValidators, Class<?>[] valueValidators, Object o) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
            if (o == null) {
                return;
            }
            SimpleTypeValidator.validateField(name, Map.class, o);
            for (Map.Entry entry : ((Map)o).entrySet()) {
                for (Class<?> kv : keyValidators) {
                    Object keyValidator = kv.getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (keyValidator instanceof Validator) {
                        ((Validator)keyValidator).validateField(name + " Map key", entry.getKey());
                        continue;
                    }
                    log.warn("validator: {} cannot be used in MapEntryCustomValidator to validate keys.  Individual entry validators must be a instance of Validator class", (Object)kv.getName());
                }
                for (Class<?> vv : valueValidators) {
                    Object valueValidator = vv.getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (valueValidator instanceof Validator) {
                        ((Validator)valueValidator).validateField(name + " Map value", entry.getValue());
                        continue;
                    }
                    log.warn("validator: {} cannot be used in MapEntryCustomValidator to validate values.  Individual entry validators must a instance of Validator class", (Object)vv.getName());
                }
            }
        }

        @Override
        public void validateField(String name, Object o) {
            try {
                MapEntryCustomValidator.validateField(name, this.keyValidators, this.valueValidators, o);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class ImplementsClassesValidator
    extends Validator {
        Class<?>[] classesImplements;

        public ImplementsClassesValidator(Map<String, Object> params) {
            this.classesImplements = (Class[])params.get("implementsClasses");
        }

        @Override
        public void validateField(String name, Object o) {
            if (o == null) {
                return;
            }
            SimpleTypeValidator.validateField(name, String.class, o);
            String className = (String)o;
            int count = 0;
            for (Class<?> classImplements : this.classesImplements) {
                Class<?> objectClass = null;
                try {
                    objectClass = ValidatorImpls.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Cannot find/load class " + className);
                }
                if (!classImplements.isAssignableFrom(objectClass)) continue;
                ++count;
            }
            if (count == 0) {
                throw new IllegalArgumentException(String.format("Field '%s' with value '%s' does not implement any of these classes %s", name, o, Arrays.toString(this.classesImplements)));
            }
        }
    }

    public static class ImplementsClassValidator
    extends Validator {
        Class<?> classImplements;

        public ImplementsClassValidator(Map<String, Object> params) {
            this.classImplements = (Class)params.get("implementsClass");
        }

        public ImplementsClassValidator(Class<?> classImplements) {
            this.classImplements = classImplements;
        }

        @Override
        public void validateField(String name, Object o) {
            if (o == null) {
                return;
            }
            SimpleTypeValidator.validateField(name, String.class, o);
            String className = (String)o;
            try {
                ClassLoader clsLoader = Thread.currentThread().getContextClassLoader();
                Class<?> objectClass = clsLoader.loadClass(className);
                if (!this.classImplements.isAssignableFrom(objectClass)) {
                    throw new IllegalArgumentException(String.format("Field '%s' with value '%s' does not implement %s ", name, o, this.classImplements.getName()));
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class MapEntryTypeValidator
    extends Validator {
        private Class<?> keyType;
        private Class<?> valueType;

        public MapEntryTypeValidator(Map<String, Object> params) {
            this.keyType = (Class)params.get("keyType");
            this.valueType = (Class)params.get("valueType");
        }

        public static void validateField(String name, Class<?> keyType, Class<?> valueType, Object o) {
            ConfigValidationUtils.NestableFieldValidator validator = ConfigValidationUtils.mapFv(keyType, valueType, false);
            validator.validateField(name, o);
        }

        @Override
        public void validateField(String name, Object o) {
            MapEntryTypeValidator.validateField(name, this.keyType, this.valueType, o);
        }
    }

    public static class ListEntryTypeValidator
    extends Validator {
        private Class<?> type;

        public ListEntryTypeValidator(Map<String, Object> params) {
            this.type = (Class)params.get("type");
        }

        public static void validateField(String name, Class<?> type, Object o) {
            ConfigValidationUtils.NestableFieldValidator validator = ConfigValidationUtils.listFv(type, false);
            validator.validateField(name, o);
        }

        @Override
        public void validateField(String name, Object o) {
            ListEntryTypeValidator.validateField(name, this.type, o);
        }
    }

    public static class NotNullValidator
    extends Validator {
        @Override
        public void validateField(String name, Object o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Field '%s' cannot be null!", name));
            }
        }
    }

    public static class PositiveNumberValidator
    extends Validator {
        private boolean includeZero;

        public PositiveNumberValidator() {
            this.includeZero = false;
        }

        public PositiveNumberValidator(Map<String, Object> params) {
            this.includeZero = (Boolean)params.get("includeZero");
        }

        public static void validateField(String name, boolean includeZero, Object o) {
            if (o == null) {
                return;
            }
            if (o instanceof Number && (includeZero ? ((Number)o).doubleValue() >= 0.0 : ((Number)o).doubleValue() > 0.0)) {
                return;
            }
            throw new IllegalArgumentException(String.format("Field '%s' must be a Positive Number", name));
        }

        @Override
        public void validateField(String name, Object o) {
            PositiveNumberValidator.validateField(name, this.includeZero, o);
        }
    }
}

