/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.util.Map;
import org.apache.avro.Conversion;
import org.apache.avro.Conversions;
import org.apache.avro.data.JodaTimeConversions;
import org.apache.avro.data.TimeConversions;
import org.apache.avro.reflect.ReflectData;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.client.api.schema.SchemaWriter;
import org.apache.pulsar.client.impl.schema.AvroBaseStructSchema;
import org.apache.pulsar.client.impl.schema.reader.MultiVersionAvroReader;
import org.apache.pulsar.client.impl.schema.util.SchemaUtil;
import org.apache.pulsar.client.impl.schema.writer.AvroWriter;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSchema<T>
extends AvroBaseStructSchema<T> {
    private static final Logger log = LoggerFactory.getLogger(AvroSchema.class);
    private static final Logger LOG = LoggerFactory.getLogger(AvroSchema.class);
    private boolean isCustomReaderAndWriter;
    private ClassLoader pojoClassLoader;

    private AvroSchema(SchemaInfo schemaInfo, ClassLoader pojoClassLoader) {
        super(schemaInfo);
        this.pojoClassLoader = pojoClassLoader;
        boolean jsr310ConversionEnabled = SchemaUtil.getJsr310ConversionEnabledFromSchemaInfo(schemaInfo);
        this.setReader(new MultiVersionAvroReader(this.schema, pojoClassLoader, SchemaUtil.getJsr310ConversionEnabledFromSchemaInfo(schemaInfo)));
        this.setWriter(new AvroWriter(this.schema, jsr310ConversionEnabled));
    }

    private AvroSchema(SchemaReader<T> reader, SchemaWriter<T> writer, SchemaInfo schemaInfo) {
        super(schemaInfo);
        this.setReader(reader);
        this.setWriter(writer);
        this.isCustomReaderAndWriter = true;
    }

    @Override
    public boolean supportSchemaVersioning() {
        return true;
    }

    @Override
    public Schema<T> clone() {
        if (this.isCustomReaderAndWriter) {
            return new AvroSchema<T>(this.reader, this.writer, this.schemaInfo);
        }
        AvroSchema<T> schema = new AvroSchema<T>(this.schemaInfo, this.pojoClassLoader);
        if (this.schemaInfoProvider != null) {
            schema.setSchemaInfoProvider(this.schemaInfoProvider);
        }
        return schema;
    }

    public static <T> AvroSchema<T> of(SchemaDefinition<T> schemaDefinition) {
        if (schemaDefinition.getSchemaReaderOpt().isPresent() && schemaDefinition.getSchemaWriterOpt().isPresent()) {
            return new AvroSchema<T>(schemaDefinition.getSchemaReaderOpt().get(), schemaDefinition.getSchemaWriterOpt().get(), SchemaUtil.parseSchemaInfo(schemaDefinition, SchemaType.AVRO));
        }
        ClassLoader pojoClassLoader = null;
        if (schemaDefinition.getPojo() != null) {
            pojoClassLoader = schemaDefinition.getPojo().getClassLoader();
        }
        return new AvroSchema<T>(SchemaUtil.parseSchemaInfo(schemaDefinition, SchemaType.AVRO), pojoClassLoader);
    }

    public static <T> AvroSchema<T> of(Class<T> pojo) {
        return AvroSchema.of(SchemaDefinition.builder().withPojo(pojo).build());
    }

    public static <T> AvroSchema<T> of(Class<T> pojo, Map<String, String> properties) {
        ClassLoader pojoClassLoader = null;
        if (pojo != null) {
            pojoClassLoader = pojo.getClassLoader();
        }
        SchemaDefinition schemaDefinition = SchemaDefinition.builder().withPojo(pojo).withProperties(properties).build();
        return new AvroSchema<T>(SchemaUtil.parseSchemaInfo(schemaDefinition, SchemaType.AVRO), pojoClassLoader);
    }

    public static void addLogicalTypeConversions(ReflectData reflectData, boolean jsr310ConversionEnabled) {
        reflectData.addLogicalTypeConversion((Conversion)new Conversions.DecimalConversion());
        reflectData.addLogicalTypeConversion((Conversion)new TimeConversions.DateConversion());
        reflectData.addLogicalTypeConversion((Conversion)new TimeConversions.TimeMillisConversion());
        reflectData.addLogicalTypeConversion((Conversion)new TimeConversions.TimeMicrosConversion());
        reflectData.addLogicalTypeConversion((Conversion)new TimeConversions.TimestampMicrosConversion());
        if (jsr310ConversionEnabled) {
            reflectData.addLogicalTypeConversion((Conversion)new TimeConversions.TimestampMillisConversion());
        } else {
            try {
                Class.forName("org.joda.time.DateTime");
                reflectData.addLogicalTypeConversion((Conversion)new JodaTimeConversions.TimestampConversion());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

