/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.maven.plugins;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.jetspeed.maven.plugins.CompositeMap;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.invoker.CommandLineConfigurationException;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.InvokerLogger;
import org.apache.maven.shared.invoker.MavenCommandLineBuilder;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.invoker.SystemOutLogger;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.interpolation.MapBasedValueSource;
import org.codehaus.plexus.util.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.util.interpolation.ValueSource;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

public class MvnMojo
extends AbstractMojo {
    private static final Comparator<List<Target>> targetListComparator = new Comparator<List<Target>>(){

        @Override
        public int compare(List<Target> o1, List<Target> o2) {
            for (Target t1 : o1) {
                for (Target t2 : o2) {
                    if (t1.id != t2.id) continue;
                    return -1;
                }
            }
            for (Target t2 : o2) {
                for (Target t1 : o1) {
                    if (t1.id != t2.id) continue;
                    return 1;
                }
            }
            if (o1.size() == o2.size()) {
                return 0;
            }
            if (o1.size() < o2.size()) {
                return -1;
            }
            return 1;
        }
    };
    protected String defaultTarget;
    protected boolean useSettings;
    protected String mavenOpts;
    protected String target;
    protected String list;
    protected Target[] targets;
    protected Map properties;
    protected String rootdir;
    protected Invoker invoker;
    protected Settings settings;
    protected MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!StringUtils.isEmpty((String)this.rootdir)) {
            File dir = new File(this.rootdir);
            if (!dir.exists() || !dir.isDirectory()) {
                throw new MojoFailureException("Project property rootdir doesn't resolve to an existing directory");
            }
            this.rootdir = dir.getAbsolutePath();
        } else {
            MavenProject prj = this.project;
            while (prj.hasParent() && prj.getParent().getBasedir() != null) {
                prj = prj.getParent();
            }
            this.rootdir = prj.getBasedir().getAbsolutePath();
        }
        HashMap<String, Target> targetsMap = new HashMap<String, Target>();
        if (this.targets != null) {
            int i = 0;
            for (Target t : this.targets) {
                t.init();
                if (t.id == null) {
                    throw new MojoFailureException("Target element[" + i + "] encountered without id");
                }
                if (t.name == null && t.depends == null && t.dir == null) {
                    throw new MojoFailureException("Target [" + t.id + "] requires at least a name, a dir or depends definition");
                }
                if (targetsMap.containsKey(t.id)) {
                    throw new MojoFailureException("Duplicate target id (or derived from its name): " + t.id + "(" + targetsMap + ")");
                }
                if (t.dir != null) {
                    t.dir = this.interpolateRootDir(t.dir);
                }
                if (t.settingsFile != null) {
                    t.settingsFile = this.interpolateRootDir(t.settingsFile);
                }
                if (t.properties != null) {
                    Iterator<String> iterator = t.properties.keySet().iterator();
                    while (iterator.hasNext()) {
                        if (t.properties.get(iterator.next()) != null) continue;
                        iterator.remove();
                    }
                }
                targetsMap.put(t.id, t);
                ++i;
            }
        }
        if (this.list != null) {
            ArrayList<List<Target>> lists = new ArrayList<List<Target>>();
            int maxLength = 0;
            for (Target target : this.targets) {
                if (target.id.length() > maxLength) {
                    maxLength = target.id.length();
                }
                lists.add(this.resolveTargets(targetsMap, null, target.id));
            }
            Collections.sort(lists, targetListComparator);
            StringBuffer buffer = new StringBuffer();
            System.out.println();
            System.out.println("Available jetspeed:mvn targets:");
            for (List list : lists) {
                int i;
                Target t = (Target)list.get(list.size() - 1);
                buffer.setLength(0);
                buffer.append("  " + t.id);
                for (i = t.id.length(); i < maxLength; ++i) {
                    buffer.append(" ");
                }
                buffer.append(" [");
                int size = list.size();
                for (i = 0; i < size; ++i) {
                    buffer.append(((Target)list.get((int)i)).id);
                    if (i >= size - 1) continue;
                    buffer.append(", ");
                }
                buffer.append("]");
                System.out.println(buffer.toString());
            }
            System.out.println();
            return;
        }
        String targetId = this.target;
        if (StringUtils.isEmpty((String)targetId) || targetId.equals("true")) {
            String string = targetId = StringUtils.isEmpty((String)this.defaultTarget) ? null : this.defaultTarget;
        }
        if (targetId == null) {
            throw new MojoFailureException("Specify a target on the commandline using -Dtarget=<name> or define a defaultTarget in the plugin configuration.\nUse parameter -Dlist to show the list of available targets.");
        }
        List<Target> targetsList = this.resolveTargets(targetsMap, null, targetId);
        this.getLog().info((CharSequence)("Resolved target(s) order: " + targetsList));
        for (Target target : targetsList) {
            this.executeTarget(target);
        }
    }

    protected void executeTarget(Target target) throws MojoExecutionException, MojoFailureException {
        String mavenOpts;
        File targetDir;
        if (target.name == null && target.dir == null) {
            this.getLog().info((CharSequence)("Executing target: " + target.id + " dependent on [" + target.depends + "] ONLY: all done"));
            return;
        }
        if (target.depends == null) {
            this.getLog().info((CharSequence)("Executing target: " + target.id));
        } else {
            this.getLog().info((CharSequence)("Executing target: " + target.id + " dependent on [" + target.depends + "]"));
        }
        File file = targetDir = target.dir != null ? new File(target.dir) : this.project.getBasedir();
        if (!targetDir.exists() || !targetDir.isDirectory()) {
            throw new MojoFailureException("Invalid or non-existing target directory " + targetDir.getAbsolutePath());
        }
        String targetPomName = target.name == null ? "pom.xml" : "jetspeed-mvn-" + target.name + "-pom.xml";
        File targetPom = new File(targetDir, targetPomName);
        if (!targetPom.exists() || !targetPom.isFile()) {
            if (target.dir != null) {
                throw new MojoFailureException("Invalid or non-existing target pom " + targetPom.getAbsolutePath());
            }
            targetPom = this.getProjectFile(this.project, targetPomName);
        }
        if (targetPom == null) {
            throw new MojoFailureException("Target pom file " + targetPomName + " not found in current project directory or one of its parent projects");
        }
        StringBuffer targetCmdMessage = new StringBuffer();
        try {
            targetCmdMessage.append("Invoking target " + target.id + ": " + targetPom.getCanonicalPath());
        }
        catch (IOException ioe) {
            this.getLog().error((CharSequence)("Unexpected error: " + ioe.toString()));
            throw new MojoExecutionException("Unexpected error: ", (Exception)ioe);
        }
        Properties props = new Properties();
        if (this.properties != null) {
            props.putAll((Map<?, ?>)this.properties);
        }
        props.putAll(target.properties);
        CompositeMap filter = new CompositeMap(this.project, props);
        this.addFileProperties(filter, this.getLocalOrProjectFile(targetPom.getParentFile(), this.project, "jetspeed-mvn.properties"));
        if (target.name != null) {
            this.addFileProperties(filter, this.getLocalOrProjectFile(targetPom.getParentFile(), this.project, "jetspeed-mvn-" + target.name + ".properties"));
            if (!target.id.equals(target.name)) {
                this.addFileProperties(filter, this.getLocalOrProjectFile(targetPom.getParentFile(), this.project, "jetspeed-mvn-" + target.name + "-" + target.id + ".properties"));
            }
        }
        if (!props.containsKey("rootdir")) {
            props.put("rootdir", this.rootdir);
        }
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        if (!StringUtils.isEmpty((String)target.goals)) {
            List<String> goals = Arrays.asList(StringUtils.split((String)target.goals, (String)", "));
            targetCmdMessage.append(" " + StringUtils.join(goals.iterator(), (String)" "));
            request.setGoals(goals);
        }
        if (!StringUtils.isEmpty((String)target.profiles)) {
            List<String> profiles = Arrays.asList(StringUtils.split((String)target.profiles, (String)", "));
            targetCmdMessage.append(" " + StringUtils.join(profiles.iterator(), (String)" "));
            request.setProfiles(profiles);
        }
        request.setProperties(props);
        request.setInteractive(false);
        request.setShowErrors(this.getLog().isErrorEnabled());
        request.setDebug(this.getLog().isDebugEnabled());
        request.setOffline(this.settings.isOffline());
        if (this.settings.getLocalRepository() != null) {
            request.setLocalRepositoryDirectory(new File(this.settings.getLocalRepository()));
        }
        if (StringUtils.isEmpty((String)(mavenOpts = props.getProperty("jetspeed.mvn.mavenOpts", null))) && !StringUtils.isEmpty((String)target.mavenOpts)) {
            mavenOpts = target.mavenOpts;
        }
        if (StringUtils.isEmpty((String)mavenOpts) && !StringUtils.isEmpty((String)this.mavenOpts)) {
            mavenOpts = this.mavenOpts;
        }
        if (!StringUtils.isEmpty((String)mavenOpts)) {
            request.setMavenOpts(mavenOpts);
        }
        request.setBaseDirectory(targetPom.getParentFile());
        if (target.name != null) {
            targetPom = this.buildInterpolatedFile(targetPom, targetPom.getParentFile(), targetPomName + ".interpolated", filter);
        }
        request.setPomFile(targetPom);
        File settingsFile = null;
        String settingsFileName = (String)filter.get("jetspeed.mvn.settings.xml");
        if (settingsFileName == null) {
            settingsFileName = target.settingsFile;
        }
        if (!(settingsFileName == null || (settingsFile = new File(settingsFileName = this.interpolateRootDir(settingsFileName))).exists() && settingsFile.isFile())) {
            settingsFile = null;
        }
        if (settingsFile == null && this.useSettings) {
            settingsFile = this.getLocalOrProjectFile(targetPom.getParentFile(), this.project, "jetspeed-mvn-settings.xml");
        }
        if (settingsFile != null) {
            settingsFile = this.buildInterpolatedFile(settingsFile, settingsFile.getParentFile(), settingsFile.getName() + ".interpolated", filter);
            request.setUserSettingsFile(settingsFile);
        }
        try {
            this.getLog().debug((CharSequence)("Executing: " + new MavenCommandLineBuilder().build((InvocationRequest)request)));
        }
        catch (CommandLineConfigurationException e) {
            this.getLog().debug((CharSequence)("Failed to display command line: " + e.getMessage()));
        }
        InvocationResult result = null;
        try {
            this.getLog().info((CharSequence)targetCmdMessage.toString());
            if (this.invoker.getLogger() == null) {
                this.invoker.setLogger((InvokerLogger)new SystemOutLogger());
            }
            result = this.invoker.execute((InvocationRequest)request);
        }
        catch (MavenInvocationException e) {
            this.getLog().debug((CharSequence)("Error invoking Maven: " + e.getMessage()), (Throwable)e);
            throw new MojoFailureException("...FAILED[error invoking Maven]");
        }
        CommandLineException executionException = result.getExecutionException();
        if (executionException != null) {
            throw new MojoFailureException("...FAILED");
        }
        if (result.getExitCode() != 0) {
            throw new MojoFailureException("...FAILED[code=" + result.getExitCode() + "].");
        }
        this.getLog().info((CharSequence)"...SUCCESS.");
    }

    protected String interpolateRootDir(String str) {
        return StringUtils.replace((String)str, (String)"@rootdir@", (String)this.rootdir);
    }

    protected List<Target> resolveTargets(HashMap<String, Target> targetsMap, List<Target> resolving, String id) throws MojoFailureException {
        ArrayList<Target> targets = new ArrayList<Target>();
        Target t = targetsMap.get(id);
        if (t == null) {
            if (resolving == null) {
                t = new Target(id);
                t.init();
            } else {
                throw new MojoFailureException("Target with id " + id + " undefined");
            }
        }
        if (resolving == null) {
            resolving = new ArrayList<Target>();
        }
        if (resolving.contains(t)) {
            throw new MojoFailureException("Circular reference encountered for target " + t.id);
        }
        if (t.depends != null) {
            resolving.add(t);
            for (String depend : StringUtils.split((String)t.depends, (String)" ,")) {
                List<Target> depends = this.resolveTargets(targetsMap, resolving, depend);
                for (Target d : depends) {
                    if (targets.contains(d)) continue;
                    targets.add(d);
                }
            }
            targets.add(t);
            resolving.remove(t);
        } else {
            targets.add(t);
        }
        return targets;
    }

    protected File buildInterpolatedFile(File originalFile, File targetDirectory, String targetFileName, CompositeMap filter) throws MojoExecutionException, MojoFailureException {
        File interpolatedFile = new File(targetDirectory, targetFileName);
        if (interpolatedFile.exists()) {
            interpolatedFile.delete();
        }
        interpolatedFile.deleteOnExit();
        try {
            boolean created = interpolatedFile.createNewFile();
            if (!created) {
                throw new MojoFailureException("Failure creating file " + interpolatedFile.getPath());
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Failure creating file " + interpolatedFile.getPath());
        }
        BufferedReader reader = null;
        XmlStreamWriter writer = null;
        try {
            reader = new BufferedReader((Reader)new InterpolationFilterReader((Reader)ReaderFactory.newXmlReader((File)originalFile), (Map)filter, "@", "@"));
            writer = WriterFactory.newXmlWriter((File)interpolatedFile);
            String line = null;
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.write("\n");
            }
            writer.flush();
        }
        catch (IOException e) {
            try {
                String message = "Failure interpolating file: " + e.getMessage();
                this.getLog().error((CharSequence)message);
                throw new MojoExecutionException(message, (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        IOUtil.close((Writer)writer);
        if (interpolatedFile == null) {
            throw new MojoFailureException("File is null after interpolation");
        }
        return interpolatedFile;
    }

    protected void addFileProperties(CompositeMap filter, File propsFile) throws MojoExecutionException, MojoFailureException {
        if (propsFile != null) {
            FileInputStream fin = null;
            Properties props = new Properties();
            try {
                fin = new FileInputStream(propsFile);
                props.load(fin);
                RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
                interpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)filter));
                for (String string : props.keySet()) {
                    String value = props.getProperty(string);
                    value = interpolator.interpolate(value, "");
                    props.setProperty(string, value);
                }
                filter.getProperties().putAll((Map<?, ?>)props);
            }
            catch (IOException ioe) {
                try {
                    throw new MojoFailureException("Failed to read properties from " + propsFile.getAbsolutePath());
                }
                catch (Throwable throwable) {
                    IOUtil.close(fin);
                    throw throwable;
                }
            }
            IOUtil.close((InputStream)fin);
        }
    }

    protected File getLocalOrProjectFile(File localDir, MavenProject project, String name) {
        File file = new File(localDir, name);
        if (!file.exists() || !file.isFile()) {
            file = this.getProjectFile(project, name);
        }
        return file;
    }

    protected File getProjectFile(MavenProject project, String name) {
        File basedir = project.getBasedir();
        if (basedir == null) {
            return null;
        }
        File projectFile = new File(basedir, name);
        if (!projectFile.exists() || !projectFile.isFile()) {
            projectFile = project.getParent() != null ? this.getProjectFile(project.getParent(), name) : null;
        }
        return projectFile;
    }

    public static class Target {
        protected String id;
        protected String name;
        protected String dir;
        protected String settingsFile;
        protected String goals;
        protected String profiles;
        protected String depends;
        protected Map<String, String> properties;
        protected String mavenOpts;

        public Target() {
        }

        public Target(String name) {
            this.name = name;
            this.init();
        }

        public void init() {
            if (this.properties == null) {
                this.properties = new HashMap<String, String>();
            }
        }

        public String toString() {
            return this.id;
        }
    }
}

