/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.maven.utils;

import java.util.Map;
import java.util.Properties;
import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.maven.utils.MavenToolsLogger;
import org.apache.jetspeed.page.JetspeedPageSerializerApplication;
import org.apache.jetspeed.tools.ToolsLogger;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class PageSerializer {
    private static final String PAGE_SERIALIZER_APPLICATION_CLASS_NAME = "org.apache.jetspeed.tools.page.serializer.JetspeedPageSerializerApplicationImpl";
    private String filterPropertiesFileName;
    private String categories;
    private String applicationRootPath;
    private String psmlPagesPath;
    private String rootFolder = "/";
    private boolean importing = true;
    private Map initProperties;

    public boolean isConfigered() throws MojoExecutionException {
        boolean configured = false;
        if (this.applicationRootPath == null) {
            throw new MojoExecutionException("PageSerializer applicationRootPath is required");
        }
        configured = true;
        return configured;
    }

    public void execute(Log log) throws MojoExecutionException {
        JetspeedPageSerializerApplication app = null;
        try {
            Class<?> dfClass = Class.forName(PAGE_SERIALIZER_APPLICATION_CLASS_NAME, true, Thread.currentThread().getContextClassLoader());
            app = (JetspeedPageSerializerApplication)dfClass.newInstance();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Cannot find or load JetspeedPageSerializerApplication class org.apache.jetspeed.tools.page.serializer.JetspeedPageSerializerApplicationImpl", e);
        }
        MavenToolsLogger logger = new MavenToolsLogger(log);
        Properties props = new Properties();
        if (this.initProperties != null) {
            for (Map.Entry entry : this.initProperties.entrySet()) {
                if (entry.getValue() != null) continue;
                entry.setValue("");
            }
            props.putAll((Map<?, ?>)this.initProperties);
        }
        if (this.psmlPagesPath != null) {
            props.put("psml.pages.path", this.psmlPagesPath);
        }
        try {
            if (this.importing) {
                app.importPages((ToolsLogger)logger, this.applicationRootPath, this.categories, this.filterPropertiesFileName, props, this.rootFolder);
            } else {
                app.exportPages((ToolsLogger)logger, this.applicationRootPath, this.categories, this.filterPropertiesFileName, props, this.rootFolder);
            }
        }
        catch (JetspeedException je) {
            throw new MojoExecutionException("PageSerializer error: ", (Exception)((Object)je));
        }
    }
}

