/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.queryserver.client;

import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import sqlline.SqlLine;

public class SqllineWrapper {
    public static final String HBASE_AUTHENTICATION_ATTR = "hbase.security.authentication";
    public static final String QUERY_SERVER_SPNEGO_AUTH_DISABLED_ATTRIB = "phoenix.queryserver.spnego.auth.disabled";
    public static final boolean DEFAULT_QUERY_SERVER_SPNEGO_AUTH_DISABLED = false;

    static UserGroupInformation loginIfNecessary(Configuration conf) {
        if ("kerberos".equalsIgnoreCase(conf.get(HBASE_AUTHENTICATION_ATTR))) {
            String principal = System.getProperty("sun.security.krb5.principal", System.getProperty("user.name"));
            try {
                return UserGroupInformation.getUGIFromTicketCache(null, (String)principal);
            }
            catch (Exception e) {
                throw new RuntimeException("Kerberos login failed using ticket cache. Did you kinit?", e);
            }
        }
        return null;
    }

    private static String[] updateArgsForKerberos(String[] origArgs) {
        String[] newArgs = new String[origArgs.length];
        for (int i = 0; i < origArgs.length; ++i) {
            String arg;
            newArgs[i] = arg = origArgs[i];
            if (!arg.equals("-u")) continue;
            if (!(arg = origArgs[++i]).contains("authentication=")) {
                arg = arg + ";authentication=SPNEGO";
            }
            newArgs[i] = arg;
        }
        return newArgs;
    }

    public static void main(String[] args) throws Exception {
        UserGroupInformation ugi;
        Configuration conf = new Configuration(false);
        conf.addResource("hbase-site.xml");
        boolean disableSpnego = conf.getBoolean(QUERY_SERVER_SPNEGO_AUTH_DISABLED_ATTRIB, false);
        if (disableSpnego) {
            SqlLine.main((String[])args);
        }
        if (null != (ugi = SqllineWrapper.loginIfNecessary(conf))) {
            final String[] updatedArgs = SqllineWrapper.updateArgsForKerberos(args);
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    SqlLine.main((String[])updatedArgs);
                    return null;
                }
            });
        } else {
            SqlLine.main((String[])args);
        }
    }
}

