/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.streampane.tooltip;

import java.awt.Color;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.pdfbox.debugger.streampane.tooltip.ColorToolTip;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;

final class KToolTip
extends ColorToolTip {
    KToolTip(String rowText) {
        this.createMarkUp(rowText);
    }

    private void createMarkUp(String rowText) {
        float[] colorValues = this.extractColorValues(rowText);
        if (colorValues != null) {
            try {
                float[] rgbValues = this.getICCColorSpace().toRGB(colorValues);
                this.setToolTipText(this.getMarkUp(KToolTip.colorHexValue(new Color(rgbValues[0], rgbValues[1], rgbValues[2]))));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    ICC_ColorSpace getICCColorSpace() throws IOException {
        ICC_Profile iccProfile = this.getICCProfile();
        if (iccProfile == null) {
            throw new IOException("Default CMYK color profile could not be loaded");
        }
        return new ICC_ColorSpace(iccProfile);
    }

    ICC_Profile getICCProfile() throws IOException {
        String name = "org/apache/pdfbox/resources/icc/ISOcoated_v2_300_bas.icc";
        URL url = PDDeviceCMYK.class.getClassLoader().getResource(name);
        if (url == null) {
            throw new IOException("Error loading resource: " + name);
        }
        InputStream input = url.openStream();
        ICC_Profile iccProfile = ICC_Profile.getInstance(input);
        input.close();
        return iccProfile;
    }
}

