/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel.exps;

import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Objects;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.exps.Context;
import org.apache.openjpa.kernel.exps.Path;
import org.apache.openjpa.kernel.exps.Val;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.XMLMetaData;
import org.apache.openjpa.util.ImplHelper;

public class CandidatePath
extends Val
implements Path {
    protected LinkedList _actions = null;
    protected String _correlationVar = null;

    @Override
    public void get(FieldMetaData field, boolean nullTraversal) {
        if (this._actions == null) {
            this._actions = new LinkedList();
        }
        this._actions.add(new Traversal(field, nullTraversal));
    }

    @Override
    public Class getType() {
        if (this._actions == null) {
            return this.getCandidateType();
        }
        Object last = this._actions.getLast();
        if (last instanceof Class) {
            return (Class)last;
        }
        FieldMetaData fmd = ((Traversal)last).field;
        return fmd.getDeclaredType();
    }

    protected Class getCandidateType() {
        ClassMetaData meta = this.getMetaData();
        if (meta == null) {
            return Object.class;
        }
        return meta.getDescribedType();
    }

    @Override
    public void setImplicitType(Class type) {
    }

    @Override
    public FieldMetaData last() {
        if (this._actions == null) {
            return null;
        }
        ListIterator itr = this._actions.listIterator(this._actions.size());
        while (itr.hasPrevious()) {
            Object prev = itr.previous();
            if (!(prev instanceof Traversal)) continue;
            return ((Traversal)prev).field;
        }
        return null;
    }

    public void castTo(Class type) {
        if (this._actions == null) {
            this._actions = new LinkedList();
        }
        this._actions.add(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object eval(Object candidate, Object orig, StoreContext ctx, Object[] params) {
        if (this._actions == null) {
            return candidate;
        }
        Broker tmpBroker = null;
        for (Object action : this._actions) {
            if (candidate == null) {
                if (action instanceof Traversal && ((Traversal)action).nullTraversal) {
                    return null;
                }
                throw new NullPointerException();
            }
            if (action instanceof Class) {
                candidate = Filters.convert(candidate, (Class)action);
                continue;
            }
            OpenJPAStateManager sm = null;
            tmpBroker = null;
            if (ImplHelper.isManageable(candidate)) {
                sm = (OpenJPAStateManager)ImplHelper.toPersistenceCapable(candidate, ctx.getConfiguration()).pcGetStateManager();
            }
            if (sm == null) {
                tmpBroker = ctx.getBroker();
                tmpBroker.transactional(candidate, false, null);
                sm = tmpBroker.getStateManager(candidate);
            }
            try {
                Traversal traversal = (Traversal)action;
                candidate = sm.fetchField(traversal.field.getIndex(), true);
            }
            finally {
                if (tmpBroker == null) continue;
                tmpBroker.nontransactional(sm.getManagedInstance(), null);
            }
        }
        return candidate;
    }

    public int hashCode() {
        return this._actions == null ? 0 : this._actions.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CandidatePath)) {
            return false;
        }
        return Objects.equals(this._actions, ((CandidatePath)other)._actions);
    }

    @Override
    public void get(FieldMetaData fmd, XMLMetaData meta) {
    }

    @Override
    public void get(XMLMetaData meta, String name) {
    }

    @Override
    public XMLMetaData getXmlMapping() {
        return null;
    }

    @Override
    public void setSchemaAlias(String schemaAlias) {
    }

    @Override
    public String getSchemaAlias() {
        return null;
    }

    @Override
    public void setSubqueryContext(Context conext, String correlationVar) {
    }

    @Override
    public String getCorrelationVar() {
        return this._correlationVar;
    }

    public static class Traversal {
        public final FieldMetaData field;
        public final boolean nullTraversal;

        private Traversal(FieldMetaData field, boolean nullTraversal) {
            this.field = field;
            this.nullTraversal = nullTraversal;
        }

        public int hashCode() {
            return this.field.hashCode();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            return ((Traversal)other).field.equals(this.field);
        }
    }
}

