/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.schema;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.identifier.Normalizer;
import org.apache.openjpa.jdbc.identifier.QualifiedDBIdentifier;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.schema.Sequence;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;

public class SchemaGenerator {
    private static final Localizer _loc = Localizer.forPackage(SchemaGenerator.class);
    private final DataSource _ds;
    private final DBDictionary _dict;
    private final Log _log;
    private final Object[][] _allowed;
    private boolean _indexes = true;
    private boolean _fks = true;
    private boolean _pks = true;
    private boolean _seqs = true;
    private boolean _openjpaTables = true;
    private SchemaGroup _group = null;
    private List<Listener> _listeners = null;
    private int _schemaObjects = 0;
    private Connection _conn = null;

    public SchemaGenerator(JDBCConfiguration conf) {
        this._ds = conf.getDataSource2(null);
        this._log = conf.getLog("openjpa.jdbc.Schema");
        this._dict = conf.getDBDictionaryInstance();
        String[] schemaArray = conf.getSchemasList();
        DBIdentifier[] names = new DBIdentifier[schemaArray == null ? 0 : schemaArray.length];
        for (int i = 0; i < names.length; ++i) {
            String[] splitName = Normalizer.splitName(schemaArray[i]);
            if (splitName == null || splitName.length == 0) continue;
            names[i] = splitName.length == 1 ? DBIdentifier.newSchema(schemaArray[i]) : QualifiedDBIdentifier.newTable(schemaArray[i]);
        }
        this._allowed = SchemaGenerator.parseSchemasList(names);
    }

    private static Object[][] parseSchemasList(DBIdentifier[] args) {
        if (args == null || args.length == 0) {
            return null;
        }
        HashMap<DBIdentifier, LinkedList<DBIdentifier>> schemas = new HashMap<DBIdentifier, LinkedList<DBIdentifier>>();
        DBIdentifier schema = DBIdentifier.NULL;
        DBIdentifier table = DBIdentifier.NULL;
        LinkedList<DBIdentifier> tables = null;
        for (int i = 0; i < args.length; ++i) {
            QualifiedDBIdentifier path = QualifiedDBIdentifier.getPath(args[i]);
            schema = path.getSchemaName();
            table = path.getIdentifier();
            if (DBIdentifier.isNull(table) && !schemas.containsKey(schema)) {
                schemas.put(schema, null);
                continue;
            }
            if (DBIdentifier.isNull(table)) continue;
            tables = (LinkedList<DBIdentifier>)schemas.get(schema);
            if (tables == null) {
                tables = new LinkedList<DBIdentifier>();
                schemas.put(schema, tables);
            }
            tables.add(table);
        }
        Object[][] parsed = new Object[schemas.size()][2];
        int idx = 0;
        for (Map.Entry entry : schemas.entrySet()) {
            tables = (Collection)entry.getValue();
            parsed[idx][0] = entry.getKey();
            if (tables != null) {
                parsed[idx][1] = tables.toArray(new DBIdentifier[tables.size()]);
            }
            ++idx;
        }
        return parsed;
    }

    public boolean getIndexes() {
        return this._indexes;
    }

    public void setIndexes(boolean indexes) {
        this._indexes = indexes;
    }

    public boolean getForeignKeys() {
        return this._fks;
    }

    public void setForeignKeys(boolean fks) {
        this._fks = fks;
    }

    public boolean getPrimaryKeys() {
        return this._pks;
    }

    public void setPrimaryKeys(boolean pks) {
        this._pks = pks;
    }

    public boolean getSequences() {
        return this._seqs;
    }

    public void setSequences(boolean seqs) {
        this._seqs = seqs;
    }

    public boolean getOpenJPATables() {
        return this._openjpaTables;
    }

    public void setOpenJPATables(boolean openjpaTables) {
        this._openjpaTables = openjpaTables;
    }

    public SchemaGroup getSchemaGroup() {
        if (this._group == null) {
            this._group = new SchemaGroup();
        }
        return this._group;
    }

    public void setSchemaGroup(SchemaGroup group) {
        this._group = group;
    }

    public void generateSchemas() throws SQLException {
        this.fireGenerationEvent(_loc.get("generating-schemas"));
        this.generateSchemas((DBIdentifier[])null);
    }

    public void generateSchemas(String[] schemasAndTables) throws SQLException {
        this.generateSchemas(DBIdentifier.toArray(schemasAndTables, DBIdentifier.DBIdentifierType.TABLE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateSchemas(DBIdentifier[] schemasAndTables) throws SQLException {
        this.fireGenerationEvent(_loc.get("generating-schemas"));
        try {
            this.getConn();
            Object[][] schemaMap = schemasAndTables == null || schemasAndTables.length == 0 ? this._allowed : SchemaGenerator.parseSchemasList(schemasAndTables);
            if (schemaMap == null) {
                this.generateSchema(DBIdentifier.NULL, (DBIdentifier[])null);
                int numTables = this.getTables(null).size();
                this._schemaObjects += numTables + (this._pks ? numTables : 0) + (this._indexes ? numTables : 0) + (this._fks ? numTables : 0);
                if (this._pks) {
                    this.generatePrimaryKeys(DBIdentifier.NULL, null);
                }
                if (this._indexes) {
                    this.generateIndexes(DBIdentifier.NULL, null);
                }
                if (this._fks) {
                    this.generateForeignKeys(DBIdentifier.NULL, null);
                }
                return;
            }
            for (int i = 0; i < schemaMap.length; ++i) {
                this.generateSchema((DBIdentifier)schemaMap[i][0], (DBIdentifier[])schemaMap[i][1]);
            }
            DBIdentifier schemaName = DBIdentifier.NULL;
            for (int i = 0; i < schemaMap.length; ++i) {
                schemaName = (DBIdentifier)schemaMap[i][0];
                DBIdentifier[] tableNames = (DBIdentifier[])schemaMap[i][1];
                int numTables = tableNames != null ? tableNames.length : this.getTables(schemaName).size();
                this._schemaObjects += numTables + (this._pks ? numTables : 0) + (this._indexes ? numTables : 0) + (this._fks ? numTables : 0);
                if (this._pks) {
                    this.generatePrimaryKeys(schemaName, tableNames);
                }
                if (this._indexes) {
                    this.generateIndexes(schemaName, tableNames);
                }
                if (!this._fks) continue;
                this.generateForeignKeys(schemaName, tableNames);
            }
        }
        finally {
            this.closeConn();
        }
    }

    public void generateSchema(String name, String[] tableNames) throws SQLException {
        this.generateSchema(DBIdentifier.newSchema(name), DBIdentifier.toArray(tableNames, DBIdentifier.DBIdentifierType.TABLE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateSchema(DBIdentifier name, DBIdentifier[] tableNames) throws SQLException {
        this.fireGenerationEvent(_loc.get("generating-schema", (Object)name));
        DatabaseMetaData meta = this._conn.getMetaData();
        try {
            if (tableNames == null) {
                this.generateTables(name, DBIdentifier.NULL, this._conn, meta);
            } else {
                for (int i = 0; i < tableNames.length; ++i) {
                    this.generateTables(name, tableNames[i], this._conn, meta);
                }
            }
            if (this._seqs) {
                this.generateSequences(name, DBIdentifier.NULL, this._conn, meta);
            }
        }
        finally {
            try {
                this._conn.commit();
            }
            catch (SQLException se) {}
        }
    }

    public void generatePrimaryKeys(String schemaName, String[] tableNames) throws SQLException {
        this.generatePrimaryKeys(DBIdentifier.newSchema(schemaName), DBIdentifier.toArray(tableNames, DBIdentifier.DBIdentifierType.TABLE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generatePrimaryKeys(DBIdentifier schemaName, DBIdentifier[] tableNames) throws SQLException {
        this.fireGenerationEvent(_loc.get("generating-all-primaries", (Object)schemaName));
        DatabaseMetaData meta = this._conn.getMetaData();
        try {
            if (tableNames == null) {
                this.generatePrimaryKeys(schemaName, null, this._conn, meta);
            } else {
                for (int i = 0; i < tableNames.length; ++i) {
                    this.generatePrimaryKeys(schemaName, tableNames[i], this._conn, meta);
                }
            }
        }
        finally {
            try {
                this._conn.commit();
            }
            catch (SQLException se) {}
        }
    }

    public void generateIndexes(String schemaName, String[] tableNames) throws SQLException {
        this.generateIndexes(DBIdentifier.newSchema(schemaName), DBIdentifier.toArray(tableNames, DBIdentifier.DBIdentifierType.TABLE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateIndexes(DBIdentifier schemaName, DBIdentifier[] tableNames) throws SQLException {
        this.fireGenerationEvent(_loc.get("generating-all-indexes", (Object)schemaName));
        DatabaseMetaData meta = this._conn.getMetaData();
        try {
            if (tableNames == null) {
                this.generateIndexes(schemaName, null, this._conn, meta);
            } else {
                for (int i = 0; i < tableNames.length; ++i) {
                    this.generateIndexes(schemaName, tableNames[i], this._conn, meta);
                }
            }
        }
        finally {
            try {
                this._conn.commit();
            }
            catch (SQLException se) {}
        }
    }

    public void generateForeignKeys(String schemaName, String[] tableNames) throws SQLException {
        this.generateForeignKeys(DBIdentifier.newSchema(schemaName), DBIdentifier.toArray(tableNames, DBIdentifier.DBIdentifierType.TABLE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateForeignKeys(DBIdentifier schemaName, DBIdentifier[] tableNames) throws SQLException {
        this.fireGenerationEvent(_loc.get("generating-all-foreigns", (Object)schemaName));
        DatabaseMetaData meta = this._conn.getMetaData();
        try {
            if (tableNames == null) {
                this.generateForeignKeys(schemaName, null, this._conn, meta);
            } else {
                for (int i = 0; i < tableNames.length; ++i) {
                    this.generateForeignKeys(schemaName, tableNames[i], this._conn, meta);
                }
            }
        }
        finally {
            try {
                this._conn.commit();
            }
            catch (SQLException se) {}
        }
    }

    public void generateTables(String schemaName, String tableName, Connection conn, DatabaseMetaData meta) throws SQLException {
        this.generateTables(DBIdentifier.newSchema(schemaName), DBIdentifier.newTable(tableName), conn, meta);
    }

    public void generateTables(DBIdentifier schemaName, DBIdentifier tableName, Connection conn, DatabaseMetaData meta) throws SQLException {
        this.fireGenerationEvent(_loc.get("generating-columns", (Object)schemaName, (Object)tableName));
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)_loc.get("gen-tables", (Object)schemaName, (Object)tableName));
        }
        Column[] cols = this._dict.getColumns(meta, DBIdentifier.newCatalog(conn.getCatalog()), schemaName, tableName, null, conn);
        HashSet<DBIdentifier> tableNames = null;
        if (DBIdentifier.isNull(tableName) || "%".equals(tableName.getName())) {
            Table[] tables = this._dict.getTables(meta, DBIdentifier.newCatalog(conn.getCatalog()), schemaName, tableName, conn);
            tableNames = new HashSet<DBIdentifier>();
            for (int i = 0; tables != null && i < tables.length; ++i) {
                if (cols == null) {
                    tableNames.add(tables[i].getIdentifier());
                    continue;
                }
                DBIdentifier sName = DBIdentifier.toUpper(tables[i].getIdentifier());
                tableNames.add(sName);
            }
        }
        if (cols == null && DBIdentifier.isNull(tableName)) {
            Iterator itr = tableNames.iterator();
            while (itr.hasNext()) {
                this.generateTables(schemaName, (DBIdentifier)itr.next(), conn, meta);
            }
            return;
        }
        SchemaGroup group = this.getSchemaGroup();
        DBIdentifier tableSchema = DBIdentifier.NULL;
        DBIdentifier baseTableName = tableName == null ? DBIdentifier.NULL : tableName.clone();
        for (int i = 0; cols != null && i < cols.length; ++i) {
            Table table;
            tableName = DBIdentifier.isNull(baseTableName) || baseTableName.equals("%") ? cols[i].getTableIdentifier() : baseTableName;
            tableSchema = DBIdentifier.isNull(schemaName) ? DBIdentifier.trimToNull(cols[i].getSchemaIdentifier()) : schemaName;
            if (!this._openjpaTables && (tableName.getName().toUpperCase().startsWith("OPENJPA_") || tableName.getName().toUpperCase().startsWith("JDO_")) || this._dict.isSystemTable(tableName, tableSchema, !DBIdentifier.isNull(schemaName)) || tableNames != null && !tableNames.contains(DBIdentifier.toUpper(tableName)) || !this.isAllowedTable(tableSchema, tableName)) continue;
            Schema schema = group.getSchema(tableSchema);
            if (schema == null) {
                schema = group.addSchema(tableSchema);
            }
            if ((table = schema.getTable(tableName)) == null) {
                table = schema.addTable(tableName);
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)_loc.get("col-table", (Object)table));
                }
            }
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)_loc.get("gen-column", (Object)cols[i].getIdentifier(), (Object)table));
            }
            if (table.getColumn(cols[i].getIdentifier()) != null) continue;
            table.importColumn(cols[i]);
        }
    }

    private boolean isAllowedTable(DBIdentifier schema, DBIdentifier table) {
        int i;
        if (this._allowed == null) {
            return true;
        }
        DBIdentifier[] anySchemaTables = null;
        for (i = 0; i < this._allowed.length; ++i) {
            if (this._allowed[i][0] == null) {
                anySchemaTables = (DBIdentifier[])this._allowed[i][1];
                if (schema != null) continue;
                break;
            }
            if (!schema.equals((DBIdentifier)this._allowed[i][0])) continue;
            if (table == null) {
                return true;
            }
            DBIdentifier[] tables = (DBIdentifier[])this._allowed[i][1];
            if (tables == null) {
                return true;
            }
            for (int j = 0; j < tables.length; ++j) {
                if (!table.equals(tables[j])) continue;
                return true;
            }
        }
        if (anySchemaTables != null) {
            if (table == null) {
                return true;
            }
            for (i = 0; i < anySchemaTables.length; ++i) {
                if (!table.equals(anySchemaTables[i])) continue;
                return true;
            }
        }
        return false;
    }

    public void generatePrimaryKeys(String schemaName, String tableName, Connection conn, DatabaseMetaData meta) throws SQLException {
        this.generatePrimaryKeys(DBIdentifier.newSchema(schemaName), DBIdentifier.newTable(tableName), conn, meta);
    }

    public void generatePrimaryKeys(DBIdentifier schemaName, DBIdentifier tableName, Connection conn, DatabaseMetaData meta) throws SQLException {
        this.fireGenerationEvent(_loc.get("generating-primary", (Object)schemaName, (Object)tableName));
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)_loc.get("gen-pks", (Object)schemaName, (Object)tableName));
        }
        SchemaGroup group = this.getSchemaGroup();
        if (tableName != null && !tableName.isNull() && group.findTable(QualifiedDBIdentifier.getPath(tableName)) == null) {
            return;
        }
        PrimaryKey[] pks = this._dict.getPrimaryKeys(meta, DBIdentifier.newCatalog(conn.getCatalog()), schemaName, tableName, conn);
        if (pks == null && tableName == null) {
            Collection<Table> tables = this.getTables(schemaName);
            for (Table table : tables) {
                this.generatePrimaryKeys(table.getSchemaIdentifier(), table.getIdentifier(), conn, meta);
            }
            return;
        }
        DBIdentifier name = DBIdentifier.NULL;
        DBIdentifier colName = DBIdentifier.NULL;
        for (int i = 0; pks != null && i < pks.length; ++i) {
            PrimaryKey pk;
            Table table;
            schemaName = DBIdentifier.trimToNull(pks[i].getSchemaIdentifier());
            Schema schema = group.getSchema(schemaName);
            if (schema == null || (table = schema.getTable(pks[i].getTableIdentifier())) == null) continue;
            colName = pks[i].getColumnIdentifier();
            name = pks[i].getIdentifier();
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)_loc.get("gen-pk", (Object)name, (Object)table, (Object)colName));
            }
            if ((pk = table.getPrimaryKey()) == null) {
                pk = table.addPrimaryKey(name);
            }
            pk.addColumn(table.getColumn(colName));
        }
    }

    public void generateIndexes(String schemaName, String tableName, Connection conn, DatabaseMetaData meta) throws SQLException {
        this.generateIndexes(DBIdentifier.newSchema(schemaName), DBIdentifier.newTable(tableName), conn, meta);
    }

    public void generateIndexes(DBIdentifier schemaName, DBIdentifier tableName, Connection conn, DatabaseMetaData meta) throws SQLException {
        this.fireGenerationEvent(_loc.get("generating-indexes", (Object)schemaName, (Object)tableName));
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)_loc.get("gen-indexes", (Object)schemaName, (Object)tableName));
        }
        SchemaGroup group = this.getSchemaGroup();
        if (tableName != null && group.findTable(QualifiedDBIdentifier.getPath(tableName)) == null) {
            return;
        }
        Index[] idxs = this._dict.getIndexInfo(meta, DBIdentifier.newCatalog(conn.getCatalog()), schemaName, tableName, false, true, conn);
        if (idxs == null && tableName == null) {
            Collection<Table> tables = this.getTables(schemaName);
            for (Table table : tables) {
                this.generateIndexes(table.getSchemaIdentifier(), table.getIdentifier(), conn, meta);
            }
            return;
        }
        DBIdentifier name = DBIdentifier.NULL;
        DBIdentifier colName = DBIdentifier.NULL;
        DBIdentifier pkName = DBIdentifier.NULL;
        for (int i = 0; idxs != null && i < idxs.length; ++i) {
            Index idx;
            Table table;
            schemaName = DBIdentifier.trimToNull(idxs[i].getSchemaIdentifier());
            Schema schema = group.getSchema(schemaName);
            if (schema == null || (table = schema.getTable(idxs[i].getTableIdentifier())) == null) continue;
            pkName = table.getPrimaryKey() != null ? table.getPrimaryKey().getIdentifier() : null;
            name = idxs[i].getIdentifier();
            if (DBIdentifier.isEmpty(name) || pkName != null && name.equals(pkName) || this._dict.isSystemIndex(name, table) || table.getColumn(colName = idxs[i].getColumnIdentifier()) == null) continue;
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)_loc.get("gen-index", (Object)name, (Object)table, (Object)colName));
            }
            if ((idx = table.getIndex(name)) == null) {
                idx = table.addIndex(name);
                idx.setUnique(idxs[i].isUnique());
            }
            idx.addColumn(table.getColumn(colName));
        }
    }

    public void generateForeignKeys(String schemaName, String tableName, Connection conn, DatabaseMetaData meta) throws SQLException {
        this.generateForeignKeys(DBIdentifier.newSchema(schemaName), DBIdentifier.newTable(tableName), conn, meta);
    }

    public void generateForeignKeys(DBIdentifier schemaName, DBIdentifier tableName, Connection conn, DatabaseMetaData meta) throws SQLException {
        this.fireGenerationEvent(_loc.get("generating-foreign", (Object)schemaName, (Object)tableName));
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)_loc.get("gen-fks", (Object)schemaName, (Object)tableName));
        }
        SchemaGroup group = this.getSchemaGroup();
        if (!DBIdentifier.isNull(tableName) && group.findTable(QualifiedDBIdentifier.getPath(tableName)) == null) {
            return;
        }
        ForeignKey[] fks = this._dict.getImportedKeys(meta, DBIdentifier.newCatalog(conn.getCatalog()), schemaName, tableName, conn);
        if (fks == null && DBIdentifier.isNull(tableName)) {
            Collection<Table> tables = this.getTables(schemaName);
            for (Table table : tables) {
                this.generateForeignKeys(table.getSchemaIdentifier(), table.getIdentifier(), conn, meta);
            }
            return;
        }
        DBIdentifier name = DBIdentifier.NULL;
        DBIdentifier pkSchemaName = DBIdentifier.NULL;
        DBIdentifier pkTableName = DBIdentifier.NULL;
        DBIdentifier pkColName = DBIdentifier.NULL;
        DBIdentifier fkColName = DBIdentifier.NULL;
        boolean seqWas0 = false;
        HashSet<ForeignKey> invalids = null;
        for (int i = 0; fks != null && i < fks.length; ++i) {
            Table pkTable;
            Table table;
            schemaName = DBIdentifier.trimToNull(fks[i].getSchemaIdentifier());
            Schema schema = group.getSchema(schemaName);
            if (schema == null || (table = schema.getTable(fks[i].getTableIdentifier())) == null) continue;
            name = fks[i].getIdentifier();
            fkColName = fks[i].getColumnIdentifier();
            pkColName = fks[i].getPrimaryKeyColumnIdentifier();
            int seq = fks[i].getKeySequence();
            if (seq == 0) {
                seqWas0 = true;
            }
            if (seqWas0) {
                ++seq;
            }
            pkSchemaName = fks[i].getPrimaryKeySchemaIdentifier();
            if (this._dict.getTrimSchemaName()) {
                pkSchemaName = DBIdentifier.trimToNull(pkSchemaName);
            }
            pkTableName = fks[i].getPrimaryKeyTableIdentifier();
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)_loc.get("gen-fk", new Object[]{name, table, fkColName, pkTableName, pkColName, seq + ""}));
            }
            if ((pkTable = group.findTable(QualifiedDBIdentifier.newPath(pkSchemaName, pkTableName))) == null) {
                throw new SQLException(_loc.get("gen-nofktable", (Object)table, (Object)pkTableName).getMessage());
            }
            ForeignKey fk = table.getForeignKey(name);
            if (seq == 1 || fk == null) {
                fk = table.addForeignKey(name);
                fk.setDeferred(fks[i].isDeferred());
                fk.setDeleteAction(fks[i].getDeleteAction());
            }
            if (invalids != null && invalids.contains(fk)) continue;
            try {
                Column fkCol = table.getColumn(fkColName);
                if (fkCol == null) {
                    throw new IllegalArgumentException(_loc.get("no-column", (Object)fkColName, (Object)table.getIdentifier()).getMessage());
                }
                fk.join(fkCol, pkTable.getColumn(pkColName));
                continue;
            }
            catch (IllegalArgumentException iae) {
                if (this._log.isWarnEnabled()) {
                    this._log.warn((Object)_loc.get("bad-join", (Object)iae.toString()));
                }
                if (invalids == null) {
                    invalids = new HashSet<ForeignKey>();
                }
                invalids.add(fk);
            }
        }
        if (invalids != null) {
            for (ForeignKey fk : invalids) {
                fk.getTable().removeForeignKey(fk);
            }
        }
    }

    public void generateSequences(String schemaName, String sequenceName, Connection conn, DatabaseMetaData meta) throws SQLException {
        this.generateSequences(DBIdentifier.newSchema(schemaName), DBIdentifier.newSequence(sequenceName), conn, meta);
    }

    public void generateSequences(DBIdentifier schemaName, DBIdentifier sequenceName, Connection conn, DatabaseMetaData meta) throws SQLException {
        this.fireGenerationEvent(_loc.get("generating-sequences", (Object)schemaName));
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)_loc.get("gen-seqs", (Object)schemaName, (Object)sequenceName));
        }
        Sequence[] seqs = this._dict.getSequences(meta, DBIdentifier.newCatalog(conn.getCatalog()), DBIdentifier.NULL, sequenceName, conn);
        SchemaGroup group = this.getSchemaGroup();
        DBIdentifier sequenceSchema = DBIdentifier.NULL;
        for (int i = 0; seqs != null && i < seqs.length; ++i) {
            sequenceName = seqs[i].getIdentifier();
            sequenceSchema = DBIdentifier.trimToNull(seqs[i].getSchemaIdentifier());
            String seqUpper = DBIdentifier.toUpper(sequenceName).getName();
            if (!this._openjpaTables && (seqUpper.startsWith("OPENJPA_") || seqUpper.startsWith("JDO_")) || this._dict.isSystemSequence(sequenceName, sequenceSchema, schemaName != null, conn) || !this.isAllowedTable(sequenceSchema, null)) continue;
            Schema schema = group.getSchema(sequenceSchema);
            if (schema == null) {
                schema = group.addSchema(sequenceSchema);
            }
            if (schema.getSequence(sequenceName) != null) continue;
            schema.addSequence(sequenceName);
        }
    }

    private void fireGenerationEvent(Object schemaObject) throws SQLException {
        if (schemaObject == null) {
            return;
        }
        if (this._listeners == null || this._listeners.size() == 0) {
            return;
        }
        Event e = new Event(schemaObject, this._schemaObjects);
        for (Listener l : this._listeners) {
            if (l.schemaObjectGenerated(e)) continue;
            throw new SQLException(_loc.get("refresh-cancelled").getMessage());
        }
    }

    public void addListener(Listener l) {
        if (this._listeners == null) {
            this._listeners = new LinkedList<Listener>();
        }
        this._listeners.add(l);
    }

    public boolean removeListener(Listener l) {
        return this._listeners != null && this._listeners.remove(l);
    }

    private Collection<Table> getTables(DBIdentifier schemaName) {
        SchemaGroup group = this.getSchemaGroup();
        if (!DBIdentifier.isNull(schemaName)) {
            Schema schema = group.getSchema(schemaName);
            if (schema == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(schema.getTables());
        }
        Schema[] schemas = group.getSchemas();
        LinkedList<Table> tables = new LinkedList<Table>();
        for (int i = 0; i < schemas.length; ++i) {
            tables.addAll(Arrays.asList(schemas[i].getTables()));
        }
        return tables;
    }

    private void getConn() throws SQLException {
        if (this._conn == null) {
            this._conn = this._ds.getConnection();
        }
    }

    private void closeConn() throws SQLException {
        if (this._conn != null && !this._conn.isClosed()) {
            this._conn.close();
        }
    }

    public static class Event
    extends EventObject {
        private final int _total;

        public Event(Object ob, int total) {
            super(ob);
            this._total = total;
        }

        public int getTotal() {
            return this._total;
        }
    }

    public static interface Listener {
        public boolean schemaObjectGenerated(Event var1);
    }
}

