/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta;

import java.util.Comparator;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.JDBCOrder;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.MetaDataException;

class JDBCRelatedFieldOrder
implements JDBCOrder {
    private static final Localizer _loc = Localizer.forPackage(JDBCRelatedFieldOrder.class);
    private final FieldMapping _fm;
    private final boolean _asc;

    public JDBCRelatedFieldOrder(FieldMapping owner, FieldMapping rel, boolean asc) {
        if (!rel.isInDefaultFetchGroup() && !rel.isPrimaryKey()) {
            throw new MetaDataException(_loc.get("nondfg-field-orderable", (Object)owner, (Object)rel.getName()));
        }
        this._fm = rel;
        this._asc = asc;
    }

    public String getName() {
        return this._fm.getName();
    }

    @Override
    public DBIdentifier getIdentifier() {
        return DBIdentifier.newColumn(this._fm.getName());
    }

    public boolean isAscending() {
        return this._asc;
    }

    public Comparator<?> getComparator() {
        return null;
    }

    @Override
    public boolean isInRelation() {
        return true;
    }

    @Override
    public void order(Select sel, ClassMapping elem, Joins joins) {
        FieldMapping fm = this._fm;
        if (elem != null && (fm = this.getOrderByField(elem, fm)) == null) {
            fm = elem.getFieldMapping(this._fm.getIndex());
        }
        sel.orderBy(fm.getColumns(), this._asc, joins, false);
    }

    private FieldMapping getOrderByField(ClassMapping elem, FieldMapping fm) {
        ClassMapping owner = (ClassMapping)this._fm.getDefiningMetaData();
        if (owner.getDescribedType() == elem.getDescribedType()) {
            return elem.getFieldMapping(this._fm.getIndex());
        }
        FieldMapping[] fms = elem.getFieldMappings();
        for (int i = 0; i < fms.length; ++i) {
            ValueMapping vm = (ValueMapping)fms[i].getValue();
            ClassMapping clm = (ClassMapping)vm.getEmbeddedMetaData();
            if (clm == null) continue;
            if (clm.getDescribedType() == owner.getDescribedType()) {
                return owner.getFieldMapping(this._fm.getIndex());
            }
            FieldMapping fm1 = this.getOrderByField(clm, fm);
            if (fm1 == null) continue;
            return fm1;
        }
        return null;
    }
}

