/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.transaction;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParametersDelegate;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.omid.tools.hbase.HBaseLogin;
import org.apache.omid.tools.hbase.SecureHBaseConfig;

public class CompactorUtil {
    public static void setOmidCompaction(Connection conn, TableName table, byte[] columnFamily, String value) throws IOException {
        try (Admin admin = conn.getAdmin();){
            TableDescriptor desc = admin.getDescriptor(table);
            ColumnFamilyDescriptor cfDesc = desc.getColumnFamily(columnFamily);
            ColumnFamilyDescriptorBuilder cfBuilder = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)cfDesc);
            cfBuilder.setValue(Bytes.toBytes((String)"OMID_ENABLED"), Bytes.toBytes((String)value));
            admin.modifyColumnFamily(table, cfBuilder.build());
        }
    }

    public static void enableOmidCompaction(Connection conn, TableName table, byte[] columnFamily) throws IOException {
        CompactorUtil.setOmidCompaction(conn, table, columnFamily, Boolean.TRUE.toString());
    }

    public static void disableOmidCompaction(Connection conn, TableName table, byte[] columnFamily) throws IOException {
        CompactorUtil.setOmidCompaction(conn, table, columnFamily, Boolean.FALSE.toString());
    }

    public static void main(String[] args) throws IOException {
        Config cmdline = new Config();
        JCommander jcommander = new JCommander((Object)cmdline, args);
        if (cmdline.help) {
            jcommander.usage();
            System.exit(1);
        }
        HBaseLogin.loginIfNeeded(cmdline.loginFlags);
        Configuration conf = HBaseConfiguration.create();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
            if (cmdline.enable) {
                CompactorUtil.enableOmidCompaction(conn, TableName.valueOf((String)cmdline.table), Bytes.toBytes((String)cmdline.columnFamily));
            } else if (cmdline.disable) {
                CompactorUtil.disableOmidCompaction(conn, TableName.valueOf((String)cmdline.table), Bytes.toBytes((String)cmdline.columnFamily));
            } else {
                System.err.println("Must specify enable or disable");
            }
        }
    }

    static class Config {
        @Parameter(names={"-table"}, required=true)
        String table;
        @Parameter(names={"-columnFamily"}, required=false)
        String columnFamily;
        @Parameter(names={"-help"})
        boolean help = false;
        @Parameter(names={"-enable"})
        boolean enable = false;
        @Parameter(names={"-disable"})
        boolean disable = false;
        @ParametersDelegate
        private SecureHBaseConfig loginFlags = new SecureHBaseConfig();

        Config() {
        }
    }
}

