/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionConnectionFactory {
    public static final String COMMIT_TABLE_ACCESS_ON_COMPACTION_RETRIES_NUMBER = "omid.commit.table.access.on.compaction.retries";
    public static final String COMMIT_TABLE_ACCESS_ON_COMPACTION_RETRY_PAUSE = "omid.commit.table.access.on.compaction.retry.pause";
    public static final String COMMIT_TABLE_ACCESS_ON_READ_RETRIES_NUMBER = "omid.commit.table.access.on.read.retries";
    public static final String COMMIT_TABLE_ACCESS_ON_READ_RETRY_PAUSE = "omid.commit.table.access.on.read.retry.pause";
    private static final Logger LOG = LoggerFactory.getLogger(RegionConnectionFactory.class);
    private static final int DEFAULT_COMMIT_TABLE_ACCESS_ON_COMPACTION_RETRIES_NUMBER = 20;
    private static final int DEFAULT_COMMIT_TABLE_ACCESS_ON_COMPACTION_RETRY_PAUSE = 100;
    private static final int DEFAULT_COMMIT_TABLE_ACCESS_ON_READ_RETRIES_NUMBER = 2;
    private static final int DEFAULT_COMMIT_TABLE_ACCESS_ON_READ_RETRY_PAUSE = 100;
    private static Map<ConnectionType, Connection> connections = new HashMap<ConnectionType, Connection>();

    private RegionConnectionFactory() {
    }

    private static Configuration cloneConfig(Configuration toCopy) {
        Configuration clone = new Configuration();
        for (Map.Entry entry : toCopy) {
            clone.set((String)entry.getKey(), (String)entry.getValue());
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Class<RegionConnectionFactory> clazz = RegionConnectionFactory.class;
        synchronized (RegionConnectionFactory.class) {
            for (Connection connection : connections.values()) {
                try {
                    connection.close();
                }
                catch (IOException e) {
                    LOG.warn("Unable to close coprocessor connection", (Throwable)e);
                }
            }
            connections.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Connection getConnection(ConnectionType connectionType, RegionCoprocessorEnvironment env) throws IOException {
        Connection connection = null;
        connection = connections.get((Object)connectionType);
        if (connection != null) return connection;
        Class<RegionConnectionFactory> clazz = RegionConnectionFactory.class;
        synchronized (RegionConnectionFactory.class) {
            connection = connections.get((Object)connectionType);
            if (connection != null) return connection;
            connection = env.createConnection(RegionConnectionFactory.getTypeSpecificConfiguration(connectionType, env.getConfiguration()));
            connections.put(connectionType, connection);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return connection;
        }
    }

    private static Configuration getTypeSpecificConfiguration(ConnectionType connectionType, Configuration conf) {
        switch (connectionType) {
            case COMPACTION_CONNECTION: {
                return RegionConnectionFactory.getCompactionConfig(conf);
            }
            case DEFAULT_SERVER_CONNECTION: {
                return conf;
            }
            case READ_CONNECTION: {
                return RegionConnectionFactory.getReadConfig(conf);
            }
        }
        return conf;
    }

    private static Configuration getCompactionConfig(Configuration conf) {
        Configuration compactionConfig = RegionConnectionFactory.cloneConfig(conf);
        compactionConfig.setInt("hbase.client.retries.number", conf.getInt(COMMIT_TABLE_ACCESS_ON_COMPACTION_RETRIES_NUMBER, 20));
        compactionConfig.setInt("hbase.client.pause", conf.getInt(COMMIT_TABLE_ACCESS_ON_COMPACTION_RETRY_PAUSE, 100));
        return compactionConfig;
    }

    private static Configuration getReadConfig(Configuration conf) {
        Configuration compactionConfig = RegionConnectionFactory.cloneConfig(conf);
        compactionConfig.setInt("hbase.client.retries.number", conf.getInt(COMMIT_TABLE_ACCESS_ON_READ_RETRIES_NUMBER, 2));
        compactionConfig.setInt("hbase.client.pause", conf.getInt(COMMIT_TABLE_ACCESS_ON_READ_RETRY_PAUSE, 100));
        return compactionConfig;
    }

    public static enum ConnectionType {
        COMPACTION_CONNECTION,
        READ_CONNECTION,
        DEFAULT_SERVER_CONNECTION;

    }
}

