/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.dto.AffectedComponentDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.DtoFactory;
import org.apache.nifi.web.api.entity.AffectedComponentEntity;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.ProcessorEntity;
import org.apache.nifi.web.revision.RevisionManager;
import org.apache.nifi.web.util.AffectedComponentUtils;
import org.apache.nifi.web.util.ComponentLifecycle;
import org.apache.nifi.web.util.InvalidComponentAction;
import org.apache.nifi.web.util.LifecycleManagementException;
import org.apache.nifi.web.util.LocalComponentLifecycle;
import org.apache.nifi.web.util.Pause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class LocalComponentLifecycle
implements ComponentLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(LocalComponentLifecycle.class);
    private NiFiServiceFacade serviceFacade;
    private RevisionManager revisionManager;
    private DtoFactory dtoFactory;

    public Set<AffectedComponentEntity> scheduleComponents(URI exampleUri, String groupId, Set<AffectedComponentEntity> components, ScheduledState desiredState, Pause pause, InvalidComponentAction invalidComponentAction) throws LifecycleManagementException {
        Map<String, Revision> processorRevisions = components.stream().collect(Collectors.toMap(ComponentEntity::getId, entity -> this.revisionManager.getRevision(entity.getId())));
        Map affectedComponentMap = components.stream().collect(Collectors.toMap(ComponentEntity::getId, Function.identity()));
        if (desiredState == ScheduledState.RUNNING) {
            this.startComponents(groupId, processorRevisions, affectedComponentMap, pause, invalidComponentAction);
        } else {
            this.stopComponents(groupId, processorRevisions, affectedComponentMap, pause, invalidComponentAction);
        }
        Set<AffectedComponentEntity> updatedEntities = components.stream().map(component -> AffectedComponentUtils.updateEntity((AffectedComponentEntity)component, (NiFiServiceFacade)this.serviceFacade, (DtoFactory)this.dtoFactory)).collect(Collectors.toSet());
        return updatedEntities;
    }

    public Set<AffectedComponentEntity> activateControllerServices(URI exampleUri, String groupId, Set<AffectedComponentEntity> services, ControllerServiceState desiredState, Pause pause, InvalidComponentAction invalidComponentAction) throws LifecycleManagementException {
        Map<String, Revision> serviceRevisions = services.stream().collect(Collectors.toMap(ComponentEntity::getId, entity -> this.revisionManager.getRevision(entity.getId())));
        Map affectedServiceMap = services.stream().collect(Collectors.toMap(ComponentEntity::getId, Function.identity()));
        if (desiredState == ControllerServiceState.ENABLED) {
            this.enableControllerServices(groupId, serviceRevisions, affectedServiceMap, pause, invalidComponentAction);
        } else {
            this.disableControllerServices(groupId, serviceRevisions, affectedServiceMap, pause, invalidComponentAction);
        }
        return services.stream().map(componentEntity -> this.serviceFacade.getControllerService(componentEntity.getId())).map(arg_0 -> ((DtoFactory)this.dtoFactory).createAffectedComponentEntity(arg_0)).collect(Collectors.toSet());
    }

    private void startComponents(String processGroupId, Map<String, Revision> componentRevisions, Map<String, AffectedComponentEntity> affectedComponents, Pause pause, InvalidComponentAction invalidComponentAction) throws LifecycleManagementException {
        if (componentRevisions.isEmpty()) {
            return;
        }
        logger.debug("Starting components with ID's {} from Process Group {}", componentRevisions.keySet(), (Object)processGroupId);
        this.waitForProcessorValidation(processGroupId, affectedComponents, pause);
        this.serviceFacade.verifyScheduleComponents(processGroupId, ScheduledState.RUNNING, componentRevisions.keySet());
        this.serviceFacade.scheduleComponents(processGroupId, ScheduledState.RUNNING, componentRevisions);
        this.waitForProcessorState(processGroupId, affectedComponents, ScheduledState.RUNNING, pause, invalidComponentAction);
    }

    private void stopComponents(String processGroupId, Map<String, Revision> componentRevisions, Map<String, AffectedComponentEntity> affectedComponents, Pause pause, InvalidComponentAction invalidComponentAction) throws LifecycleManagementException {
        if (componentRevisions.isEmpty()) {
            return;
        }
        logger.debug("Stopping components with ID's {} from Process Group {}", componentRevisions.keySet(), (Object)processGroupId);
        this.serviceFacade.verifyScheduleComponents(processGroupId, ScheduledState.STOPPED, componentRevisions.keySet());
        this.serviceFacade.scheduleComponents(processGroupId, ScheduledState.STOPPED, componentRevisions);
        this.waitForProcessorState(processGroupId, affectedComponents, ScheduledState.STOPPED, pause, invalidComponentAction);
    }

    private boolean waitForProcessorValidation(String groupId, Map<String, AffectedComponentEntity> affectedComponents, Pause pause) {
        logger.debug("Waiting for {} processors to complete validation", (Object)affectedComponents.size());
        boolean continuePolling = true;
        while (continuePolling) {
            Set processorEntities = this.serviceFacade.getProcessors(groupId, true);
            if (this.isProcessorValidationComplete(processorEntities, affectedComponents)) {
                logger.debug("All {} processors of interest have completed validation", (Object)affectedComponents.size());
                return true;
            }
            continuePolling = pause.pause();
        }
        return false;
    }

    private boolean isProcessorValidationComplete(Set<ProcessorEntity> processorEntities, Map<String, AffectedComponentEntity> affectedComponents) {
        this.updateAffectedProcessors(processorEntities, affectedComponents);
        for (ProcessorEntity entity : processorEntities) {
            if (!affectedComponents.containsKey(entity.getId()) || !"VALIDATING".equals(entity.getComponent().getValidationStatus())) continue;
            return false;
        }
        return true;
    }

    private boolean waitForProcessorState(String groupId, Map<String, AffectedComponentEntity> affectedComponents, ScheduledState desiredState, Pause pause, InvalidComponentAction invalidComponentAction) throws LifecycleManagementException {
        logger.debug("Waiting for {} processors to transition their states to {}", (Object)affectedComponents.size(), (Object)desiredState);
        boolean continuePolling = true;
        while (continuePolling) {
            Set processorEntities = this.serviceFacade.getProcessors(groupId, true);
            if (this.isProcessorActionComplete(processorEntities, affectedComponents, desiredState, invalidComponentAction)) {
                logger.debug("All {} processors of interest now have the desired state of {}", (Object)affectedComponents.size(), (Object)desiredState);
                return true;
            }
            continuePolling = pause.pause();
        }
        return false;
    }

    private void updateAffectedProcessors(Set<ProcessorEntity> processorEntities, Map<String, AffectedComponentEntity> affectedComponents) {
        processorEntities.stream().filter(entity -> affectedComponents.containsKey(entity.getId())).forEach(entity -> {
            AffectedComponentEntity affectedComponentEntity = (AffectedComponentEntity)affectedComponents.get(entity.getId());
            affectedComponentEntity.setRevision(entity.getRevision());
            if (Boolean.TRUE.equals(affectedComponentEntity.getPermissions().getCanRead())) {
                AffectedComponentDTO affectedComponent = affectedComponentEntity.getComponent();
                affectedComponent.setState(entity.getStatus().getAggregateSnapshot().getRunStatus());
                affectedComponent.setActiveThreadCount(entity.getStatus().getAggregateSnapshot().getActiveThreadCount());
                if (Boolean.TRUE.equals(entity.getPermissions().getCanRead())) {
                    affectedComponent.setValidationErrors(entity.getComponent().getValidationErrors());
                }
            }
        });
    }

    private boolean isProcessorActionComplete(Set<ProcessorEntity> processorEntities, Map<String, AffectedComponentEntity> affectedComponents, ScheduledState desiredState, InvalidComponentAction invalidComponentAction) throws LifecycleManagementException {
        this.updateAffectedProcessors(processorEntities, affectedComponents);
        block5: for (ProcessorEntity entity : processorEntities) {
            if (!affectedComponents.containsKey(entity.getId())) continue;
            boolean desiredStateReached = this.isDesiredProcessorStateReached(entity, desiredState);
            logger.debug("Processor[id={}, name={}] now has a state of {} with {} Active Threads, Validation Errors: {}; desired state = {}; invalid component action: {}; desired state reached = {}", new Object[]{entity.getId(), entity.getComponent().getName(), entity.getStatus().getRunStatus(), entity.getStatus().getAggregateSnapshot().getActiveThreadCount(), entity.getComponent().getValidationErrors(), desiredState, invalidComponentAction, desiredStateReached});
            if (desiredStateReached) continue;
            if (desiredState == ScheduledState.STOPPED && entity.getStatus().getAggregateSnapshot().getActiveThreadCount() != 0) {
                return false;
            }
            if ("Invalid".equalsIgnoreCase(entity.getComponent().getValidationStatus())) {
                switch (1.$SwitchMap$org$apache$nifi$web$util$InvalidComponentAction[invalidComponentAction.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        logger.debug("Processor[id={}, name={}] is invalid. Skipping over this processor when looking for Desired State of {} because Invalid Component Action = SKIP", new Object[]{entity.getId(), entity.getComponent().getName(), desiredState});
                        continue block5;
                    }
                    case 3: {
                        String action = desiredState == ScheduledState.RUNNING ? "start" : "stop";
                        throw new LifecycleManagementException("Could not " + action + " " + entity.getComponent().getName() + " because it is invalid");
                    }
                }
            }
            return false;
        }
        return true;
    }

    private boolean isDesiredProcessorStateReached(ProcessorEntity processorEntity, ScheduledState desiredState) {
        String runStatus = processorEntity.getStatus().getRunStatus();
        boolean stateMatches = desiredState.name().equalsIgnoreCase(runStatus);
        if (!stateMatches) {
            return false;
        }
        Integer activeThreadCount = processorEntity.getStatus().getAggregateSnapshot().getActiveThreadCount();
        return desiredState != ScheduledState.STOPPED || activeThreadCount == 0;
    }

    private void enableControllerServices(String processGroupId, Map<String, Revision> serviceRevisions, Map<String, AffectedComponentEntity> affectedServices, Pause pause, InvalidComponentAction invalidComponentAction) throws LifecycleManagementException {
        if (serviceRevisions.isEmpty()) {
            return;
        }
        logger.debug("Enabling Controller Services with ID's {} from Process Group {}", serviceRevisions.keySet(), (Object)processGroupId);
        this.waitForControllerServiceValidation(processGroupId, affectedServices, pause);
        this.serviceFacade.verifyActivateControllerServices(processGroupId, ControllerServiceState.ENABLED, affectedServices.keySet());
        this.serviceFacade.activateControllerServices(processGroupId, ControllerServiceState.ENABLED, serviceRevisions);
        this.waitForControllerServiceState(processGroupId, affectedServices, ControllerServiceState.ENABLED, pause, invalidComponentAction);
    }

    private void disableControllerServices(String processGroupId, Map<String, Revision> serviceRevisions, Map<String, AffectedComponentEntity> affectedServices, Pause pause, InvalidComponentAction invalidComponentAction) throws LifecycleManagementException {
        if (serviceRevisions.isEmpty()) {
            return;
        }
        logger.debug("Disabling Controller Services with ID's {} from Process Group {}", serviceRevisions.keySet(), (Object)processGroupId);
        this.serviceFacade.verifyActivateControllerServices(processGroupId, ControllerServiceState.DISABLED, affectedServices.keySet());
        this.serviceFacade.activateControllerServices(processGroupId, ControllerServiceState.DISABLED, serviceRevisions);
        this.waitForControllerServiceState(processGroupId, affectedServices, ControllerServiceState.DISABLED, pause, invalidComponentAction);
    }

    static List<List<ControllerServiceNode>> determineEnablingOrder(Map<String, ControllerServiceNode> serviceNodeMap) {
        ArrayList<List<ControllerServiceNode>> orderedNodeLists = new ArrayList<List<ControllerServiceNode>>();
        for (ControllerServiceNode node : serviceNodeMap.values()) {
            ArrayList branch = new ArrayList();
            LocalComponentLifecycle.determineEnablingOrder(serviceNodeMap, (ControllerServiceNode)node, branch, new HashSet());
            orderedNodeLists.add(branch);
        }
        return orderedNodeLists;
    }

    private static void determineEnablingOrder(Map<String, ControllerServiceNode> serviceNodeMap, ControllerServiceNode contextNode, List<ControllerServiceNode> orderedNodes, Set<ControllerServiceNode> visited) {
        if (visited.contains(contextNode)) {
            return;
        }
        for (Map.Entry entry : contextNode.getEffectivePropertyValues().entrySet()) {
            ControllerServiceNode referencedNode;
            String referencedServiceId;
            if (((PropertyDescriptor)entry.getKey()).getControllerServiceDefinition() == null || (referencedServiceId = (String)entry.getValue()) == null || orderedNodes.contains(referencedNode = serviceNodeMap.get(referencedServiceId))) continue;
            visited.add(contextNode);
            LocalComponentLifecycle.determineEnablingOrder(serviceNodeMap, (ControllerServiceNode)referencedNode, orderedNodes, visited);
        }
        if (!orderedNodes.contains(contextNode)) {
            orderedNodes.add(contextNode);
        }
    }

    private boolean waitForControllerServiceValidation(String groupId, Map<String, AffectedComponentEntity> affectedComponents, Pause pause) {
        logger.debug("Waiting for {} controller services to complete validation", (Object)affectedComponents.size());
        boolean continuePolling = true;
        while (continuePolling) {
            Set serviceEntities = this.serviceFacade.getControllerServices(groupId, false, true);
            if (this.isControllerServiceValidationComplete(serviceEntities, affectedComponents)) {
                logger.debug("All {} controller services of interest have completed validation", (Object)affectedComponents.size());
                return true;
            }
            continuePolling = pause.pause();
        }
        return false;
    }

    private boolean isControllerServiceValidationComplete(Set<ControllerServiceEntity> controllerServiceEntities, Map<String, AffectedComponentEntity> affectedComponents) {
        this.updateAffectedControllerServices(controllerServiceEntities, affectedComponents);
        for (ControllerServiceEntity entity : controllerServiceEntities) {
            if (!affectedComponents.containsKey(entity.getId()) || !"VALIDATING".equals(entity.getComponent().getValidationStatus())) continue;
            return false;
        }
        return true;
    }

    private boolean waitForControllerServiceState(String groupId, Map<String, AffectedComponentEntity> affectedServices, ControllerServiceState desiredState, Pause pause, InvalidComponentAction invalidComponentAction) throws LifecycleManagementException {
        logger.debug("Waiting for {} Controller Services to transition their states to {}", (Object)affectedServices.size(), (Object)desiredState);
        boolean continuePolling = true;
        while (continuePolling) {
            Set serviceEntities = this.serviceFacade.getControllerServices(groupId, false, true);
            this.updateAffectedControllerServices(serviceEntities, affectedServices);
            String desiredStateName = desiredState.name();
            boolean allReachedDesiredState = true;
            block6: for (ControllerServiceEntity serviceEntity : serviceEntities) {
                if (!affectedServices.containsKey(serviceEntity.getId())) continue;
                ControllerServiceDTO serviceDto = serviceEntity.getComponent();
                boolean desiredStateReached = desiredStateName.equals(serviceDto.getState());
                String validationStatus = serviceDto.getValidationStatus();
                logger.debug("ControllerService[id={}, name={}] now has a state of {} with a Validation Status of {}; desired state = {}; invalid component action is {}; desired state reached = {}", new Object[]{serviceDto.getId(), serviceDto.getName(), serviceDto.getState(), validationStatus, desiredState, invalidComponentAction, desiredStateReached});
                if (desiredStateReached) continue;
                if ("INVALID".equalsIgnoreCase(validationStatus)) {
                    switch (1.$SwitchMap$org$apache$nifi$web$util$InvalidComponentAction[invalidComponentAction.ordinal()]) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            continue block6;
                        }
                        case 3: {
                            String action = desiredState == ControllerServiceState.ENABLED ? "enable" : "disable";
                            throw new LifecycleManagementException("Could not " + action + " " + serviceEntity.getComponent().getName() + " because it is invalid");
                        }
                    }
                }
                allReachedDesiredState = false;
            }
            if (allReachedDesiredState) {
                logger.debug("All {} controller services of interest now have the desired state of {}", (Object)affectedServices.size(), (Object)desiredState);
                return true;
            }
            continuePolling = pause.pause();
        }
        return false;
    }

    private void updateAffectedControllerServices(Set<ControllerServiceEntity> serviceEntities, Map<String, AffectedComponentEntity> affectedServices) {
        serviceEntities.stream().filter(entity -> affectedServices.containsKey(entity.getId())).forEach(entity -> {
            AffectedComponentEntity affectedComponentEntity = (AffectedComponentEntity)affectedServices.get(entity.getId());
            affectedComponentEntity.setRevision(entity.getRevision());
            if (Boolean.TRUE.equals(affectedComponentEntity.getPermissions().getCanRead())) {
                AffectedComponentDTO affectedComponent = affectedComponentEntity.getComponent();
                affectedComponent.setState(entity.getComponent().getState());
                if (Boolean.TRUE.equals(entity.getPermissions().getCanRead())) {
                    affectedComponent.setValidationErrors(entity.getComponent().getValidationErrors());
                }
            }
        });
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setRevisionManager(RevisionManager revisionManager) {
        this.revisionManager = revisionManager;
    }

    public void setDtoFactory(DtoFactory dtoFactory) {
        this.dtoFactory = dtoFactory;
    }
}

