/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.search.attributematchers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.web.search.attributematchers.AttributeMatcher;
import org.apache.nifi.web.search.query.SearchQuery;

public class ExpirationMatcher
implements AttributeMatcher<Connection> {
    private static final String MATCH_PREFIX = "FlowFile expiration: ";
    private static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("expires", "expiration"));

    public void match(Connection component, SearchQuery query, List<String> matches) {
        int expirationMillis;
        if (this.containsKeyword(query) && (expirationMillis = component.getFlowFileQueue().getFlowFileExpiration(TimeUnit.MILLISECONDS)) > 0) {
            matches.add(MATCH_PREFIX + component.getFlowFileQueue().getFlowFileExpiration());
        }
    }

    private boolean containsKeyword(SearchQuery query) {
        return KEYWORDS.stream().anyMatch(keyword -> StringUtils.containsIgnoreCase((CharSequence)keyword, (CharSequence)query.getTerm()));
    }
}

