/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.dao.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.PropertyConfiguration;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterDescriptor;
import org.apache.nifi.parameter.ParameterReference;
import org.apache.nifi.parameter.ParameterReferenceManager;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.dto.ParameterDTO;
import org.apache.nifi.web.api.entity.ParameterEntity;
import org.apache.nifi.web.dao.ParameterContextDAO;

public class StandardParameterContextDAO
implements ParameterContextDAO {
    private FlowManager flowManager;

    public boolean hasParameterContext(String parameterContextId) {
        return this.flowManager.getParameterContextManager().getParameterContext(parameterContextId) != null;
    }

    public void verifyCreate(ParameterContextDTO parameterContextDto) {
        this.verifyNoNamingConflict(parameterContextDto.getName());
    }

    public ParameterContext createParameterContext(ParameterContextDTO parameterContextDto) {
        Map parameters = this.getParameters(parameterContextDto, null);
        ParameterContext parameterContext = this.flowManager.createParameterContext(parameterContextDto.getId(), parameterContextDto.getName(), parameters);
        if (parameterContextDto.getDescription() != null) {
            parameterContext.setDescription(parameterContextDto.getDescription());
        }
        return parameterContext;
    }

    private Map<String, Parameter> getParameters(ParameterContextDTO parameterContextDto, ParameterContext context) {
        Set parameterEntities = parameterContextDto.getParameters();
        if (parameterEntities == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Parameter> parameterMap = new HashMap<String, Parameter>();
        for (ParameterEntity parameterEntity : parameterEntities) {
            boolean deletion;
            ParameterDTO parameterDto = parameterEntity.getParameter();
            if (parameterDto.getName() == null) {
                throw new IllegalArgumentException("Cannot specify a Parameter without a name");
            }
            boolean bl = deletion = parameterDto.getDescription() == null && parameterDto.getSensitive() == null && parameterDto.getValue() == null;
            if (deletion) {
                parameterMap.put(parameterDto.getName().trim(), null);
                continue;
            }
            Parameter parameter = this.createParameter(parameterDto, context);
            parameterMap.put(parameterDto.getName().trim(), parameter);
        }
        return parameterMap;
    }

    private Parameter createParameter(ParameterDTO dto, ParameterContext context) {
        String value;
        ParameterDescriptor descriptor = new ParameterDescriptor.Builder().name(dto.getName()).description(dto.getDescription()).sensitive(Boolean.TRUE.equals(dto.getSensitive())).build();
        if (dto.getValue() == null && Boolean.TRUE.equals(dto.getValueRemoved())) {
            value = null;
        } else if (dto.getValue() == null && context != null) {
            Optional optionalParameter = context.getParameter(dto.getName());
            value = optionalParameter.map(Parameter::getValue).orElse(dto.getValue());
        } else {
            value = dto.getValue();
        }
        return new Parameter(descriptor, value);
    }

    public ParameterContext getParameterContext(String parameterContextId) {
        ParameterContext context = this.flowManager.getParameterContextManager().getParameterContext(parameterContextId);
        if (context == null) {
            throw new ResourceNotFoundException(String.format("Unable to find Parameter Context with id '%s'.", parameterContextId));
        }
        return context;
    }

    public Set<ParameterContext> getParameterContexts() {
        return this.flowManager.getParameterContextManager().getParameterContexts();
    }

    public ParameterContext updateParameterContext(ParameterContextDTO parameterContextDto) {
        this.verifyUpdate(parameterContextDto, true);
        ParameterContext context = this.getParameterContext(parameterContextDto.getId());
        if (parameterContextDto.getName() != null) {
            this.verifyNoNamingConflict(parameterContextDto.getName(), parameterContextDto.getId());
            context.setName(parameterContextDto.getName());
        }
        if (parameterContextDto.getDescription() != null) {
            context.setDescription(parameterContextDto.getDescription());
        }
        if (parameterContextDto.getParameters() != null) {
            Map parameters = this.getParameters(parameterContextDto, context);
            context.setParameters(parameters);
        }
        return context;
    }

    public void verifyUpdate(ParameterContextDTO parameterContextDto, boolean verifyComponentStates) {
        this.verifyNoNamingConflict(parameterContextDto.getName(), parameterContextDto.getId());
        ParameterContext currentContext = this.getParameterContext(parameterContextDto.getId());
        for (ParameterEntity parameterEntity : parameterContextDto.getParameters()) {
            ParameterDTO parameterDto = parameterEntity.getParameter();
            String parameterName = parameterDto.getName();
            ParameterReferenceManager referenceManager = currentContext.getParameterReferenceManager();
            for (ProcessorNode processor : referenceManager.getProcessorsReferencing(currentContext, parameterName)) {
                this.verifyParameterUpdate(parameterDto, (ComponentNode)processor, currentContext.getName(), verifyComponentStates, processor.isRunning(), "Processor that is running");
            }
            for (ControllerServiceNode serviceNode : referenceManager.getControllerServicesReferencing(currentContext, parameterName)) {
                this.verifyParameterUpdate(parameterDto, (ComponentNode)serviceNode, currentContext.getName(), verifyComponentStates, serviceNode.getState() != ControllerServiceState.DISABLED, "Controller Service that is enabled");
            }
        }
    }

    private void verifyParameterUpdate(ParameterDTO parameterDto, ComponentNode component, String contextName, boolean verifyComponentStates, boolean active, String activeExplanation) {
        String parameterName = parameterDto.getName();
        Boolean parameterSensitive = parameterDto.getSensitive();
        boolean parameterDeletion = parameterDto.getDescription() == null && parameterDto.getSensitive() == null && parameterDto.getValue() == null;
        for (Map.Entry entry : component.getProperties().entrySet()) {
            PropertyConfiguration configuration = (PropertyConfiguration)entry.getValue();
            if (configuration == null) continue;
            for (ParameterReference reference : configuration.getParameterReferences()) {
                String referencedParameterName = reference.getParameterName();
                if (!referencedParameterName.equals(parameterName)) continue;
                if (((PropertyDescriptor)entry.getKey()).isSensitive() && !parameterDeletion && !Boolean.TRUE.equals(parameterSensitive)) {
                    throw new IllegalStateException("Cannot update Parameter Context " + contextName + " because the update would add a Non-Sensitive Parameter named '" + parameterName + "' but this Parameter already is referenced by a Sensitive Property.");
                }
                if (!((PropertyDescriptor)entry.getKey()).isSensitive() && !parameterDeletion && Boolean.TRUE.equals(parameterSensitive)) {
                    throw new IllegalStateException("Cannot update Parameter Context " + contextName + " because the update would add a Sensitive Parameter named '" + parameterName + "' but this Parameter already is referenced by a Non-Sensitive Property.");
                }
                if (!active || !verifyComponentStates && !parameterDeletion) continue;
                throw new IllegalStateException("Cannot update Parameter Context " + contextName + " because it has Parameters that are being referenced by a " + activeExplanation + ".");
            }
        }
    }

    private void verifyNoNamingConflict(String contextName) {
        this.verifyNoNamingConflict(contextName, null);
    }

    private void verifyNoNamingConflict(String contextName, String contextId) {
        if (contextName == null) {
            return;
        }
        for (ParameterContext parameterContext : this.flowManager.getParameterContextManager().getParameterContexts()) {
            if (!parameterContext.getName().equals(contextName) || contextId == null || contextId.equals(parameterContext.getIdentifier())) continue;
            throw new IllegalStateException("Cannot update Parameter Context name because another Parameter Context already exists with the name '" + contextName + "'");
        }
    }

    public void verifyDelete(String parameterContextId) {
        List groupsReferencingParameterContext = this.getBoundProcessGroups(parameterContextId);
        for (ProcessGroup group : groupsReferencingParameterContext) {
            for (ProcessorNode processor : group.getProcessors()) {
                if (!processor.isReferencingParameter() || !processor.isRunning()) continue;
                throw new IllegalStateException("Cannot delete Parameter Context with ID " + parameterContextId + " because it is in use by at least one Processor that is running");
            }
            for (ControllerServiceNode service : group.getControllerServices(false)) {
                if (!service.isReferencingParameter() || service.getState() == ControllerServiceState.DISABLED) continue;
                throw new IllegalStateException("Cannot delete Parameter Context with ID " + parameterContextId + " because it is in use by at least one Controller Service that is enabled");
            }
        }
    }

    public void deleteParameterContext(String parameterContextId) {
        this.verifyDelete(parameterContextId);
        this.flowManager.getParameterContextManager().removeParameterContext(parameterContextId);
        this.getBoundProcessGroups(parameterContextId).forEach(group -> group.setParameterContext(null));
    }

    public void setFlowController(FlowController flowController) {
        this.flowManager = flowController.getFlowManager();
    }

    private List<ProcessGroup> getBoundProcessGroups(String parameterContextId) {
        ProcessGroup rootGroup = this.flowManager.getRootGroup();
        return rootGroup.findAllProcessGroups(group -> group.getParameterContext() != null && group.getParameterContext().getIdentifier().equals(parameterContextId));
    }
}

