/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.controller;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.web.api.dto.search.ComponentSearchResultDTO;
import org.apache.nifi.web.api.dto.search.SearchResultsDTO;
import org.apache.nifi.web.search.ComponentMatcher;
import org.apache.nifi.web.search.query.SearchQuery;
import org.apache.nifi.web.search.resultenrichment.ComponentSearchResultEnricher;
import org.apache.nifi.web.search.resultenrichment.ComponentSearchResultEnricherFactory;

public class ControllerSearchService {
    private static final String FILTER_NAME_GROUP = "group";
    private static final String FILTER_NAME_SCOPE = "scope";
    private static final String FILTER_SCOPE_VALUE_HERE = "here";
    private FlowController flowController;
    private Authorizer authorizer;
    private ComponentSearchResultEnricherFactory resultEnricherFactory;
    private ComponentMatcher<ProcessorNode> matcherForProcessor;
    private ComponentMatcher<ProcessGroup> matcherForProcessGroup;
    private ComponentMatcher<Connection> matcherForConnection;
    private ComponentMatcher<RemoteProcessGroup> matcherForRemoteProcessGroup;
    private ComponentMatcher<Port> matcherForPort;
    private ComponentMatcher<Funnel> matcherForFunnel;
    private ComponentMatcher<ParameterContext> matcherForParameterContext;
    private ComponentMatcher<Parameter> matcherForParameter;
    private ComponentMatcher<Label> matcherForLabel;
    private ComponentMatcher<ControllerServiceNode> matcherForControllerServiceNode;

    public void search(SearchQuery searchQuery, SearchResultsDTO results) {
        if (searchQuery.hasFilter(FILTER_NAME_SCOPE) && FILTER_SCOPE_VALUE_HERE.equals(searchQuery.getFilter(FILTER_NAME_SCOPE))) {
            this.searchInProcessGroup(results, searchQuery, searchQuery.getActiveGroup());
        } else {
            this.searchInProcessGroup(results, searchQuery, searchQuery.getRootGroup());
        }
    }

    private void searchInProcessGroup(SearchResultsDTO results, SearchQuery searchQuery, ProcessGroup scope) {
        NiFiUser user = searchQuery.getUser();
        ComponentSearchResultEnricher resultEnricher = this.resultEnricherFactory.getComponentResultEnricher(scope, user);
        ComponentSearchResultEnricher groupResultEnricher = this.resultEnricherFactory.getProcessGroupResultEnricher(scope, user);
        if (this.appliesToGroupFilter(searchQuery, scope)) {
            this.searchComponentType(Collections.singletonList(scope), user, searchQuery, this.matcherForProcessGroup, groupResultEnricher, results.getProcessGroupResults());
            this.searchComponentType(scope.getProcessors(), user, searchQuery, this.matcherForProcessor, resultEnricher, results.getProcessorResults());
            this.searchComponentType((Collection)scope.getConnections(), user, searchQuery, this.matcherForConnection, resultEnricher, results.getConnectionResults());
            this.searchComponentType((Collection)scope.getRemoteProcessGroups(), user, searchQuery, this.matcherForRemoteProcessGroup, resultEnricher, results.getRemoteProcessGroupResults());
            this.searchComponentType((Collection)scope.getInputPorts(), user, searchQuery, this.matcherForPort, resultEnricher, results.getInputPortResults());
            this.searchComponentType((Collection)scope.getOutputPorts(), user, searchQuery, this.matcherForPort, resultEnricher, results.getOutputPortResults());
            this.searchComponentType((Collection)scope.getFunnels(), user, searchQuery, this.matcherForFunnel, resultEnricher, results.getFunnelResults());
            this.searchComponentType((Collection)scope.getLabels(), user, searchQuery, this.matcherForLabel, resultEnricher, results.getLabelResults());
            this.searchComponentType((Collection)scope.getControllerServices(false), user, searchQuery, this.matcherForControllerServiceNode, resultEnricher, results.getControllerServiceNodeResults());
        }
        scope.getProcessGroups().forEach(processGroup -> this.searchInProcessGroup(results, searchQuery, processGroup));
    }

    private boolean appliesToGroupFilter(SearchQuery searchQuery, ProcessGroup scope) {
        return !searchQuery.hasFilter(FILTER_NAME_GROUP) || this.eligibleForGroupFilter(scope, searchQuery.getFilter(FILTER_NAME_GROUP));
    }

    private boolean eligibleForGroupFilter(ProcessGroup scope, String filterValue) {
        List lineage = this.getLineage(scope);
        for (ProcessGroup group : lineage) {
            if (!StringUtils.containsIgnoreCase((CharSequence)group.getName(), (CharSequence)filterValue) && !StringUtils.containsIgnoreCase((CharSequence)group.getIdentifier(), (CharSequence)filterValue)) continue;
            return true;
        }
        return false;
    }

    private List<ProcessGroup> getLineage(ProcessGroup group) {
        LinkedList<ProcessGroup> result = new LinkedList<ProcessGroup>();
        for (ProcessGroup current = group; current != null; current = current.getParent()) {
            result.addLast(current);
        }
        return result;
    }

    private <T extends Authorizable> void searchComponentType(Collection<T> components, NiFiUser user, SearchQuery searchQuery, ComponentMatcher<T> matcher, ComponentSearchResultEnricher resultEnricher, List<ComponentSearchResultDTO> resultAccumulator) {
        components.stream().filter(component -> component.isAuthorized(this.authorizer, RequestAction.READ, user)).map(component -> matcher.match(component, searchQuery)).filter(Optional::isPresent).map(result -> resultEnricher.enrich((ComponentSearchResultDTO)result.get())).forEach(result -> resultAccumulator.add((ComponentSearchResultDTO)result));
    }

    public void searchParameters(SearchQuery searchQuery, SearchResultsDTO results) {
        this.flowController.getFlowManager().getParameterContextManager().getParameterContexts().stream().filter(component -> component.isAuthorized(this.authorizer, RequestAction.READ, searchQuery.getUser())).forEach(parameterContext -> {
            ComponentSearchResultEnricher resultEnricher = this.resultEnricherFactory.getParameterResultEnricher(parameterContext);
            this.matcherForParameterContext.match(parameterContext, searchQuery).ifPresent(match -> results.getParameterContextResults().add(match));
            parameterContext.getParameters().values().stream().map(component -> this.matcherForParameter.match(component, searchQuery)).filter(Optional::isPresent).map(result -> resultEnricher.enrich((ComponentSearchResultDTO)result.get())).forEach(result -> results.getParameterResults().add(result));
        });
    }

    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void setResultEnricherFactory(ComponentSearchResultEnricherFactory resultEnricherFactory) {
        this.resultEnricherFactory = resultEnricherFactory;
    }

    public void setMatcherForProcessor(ComponentMatcher<ProcessorNode> matcherForProcessor) {
        this.matcherForProcessor = matcherForProcessor;
    }

    public void setMatcherForProcessGroup(ComponentMatcher<ProcessGroup> matcherForProcessGroup) {
        this.matcherForProcessGroup = matcherForProcessGroup;
    }

    public void setMatcherForConnection(ComponentMatcher<Connection> matcherForConnection) {
        this.matcherForConnection = matcherForConnection;
    }

    public void setMatcherForRemoteProcessGroup(ComponentMatcher<RemoteProcessGroup> matcherForRemoteProcessGroup) {
        this.matcherForRemoteProcessGroup = matcherForRemoteProcessGroup;
    }

    public void setMatcherForPort(ComponentMatcher<Port> matcherForPort) {
        this.matcherForPort = matcherForPort;
    }

    public void setMatcherForFunnel(ComponentMatcher<Funnel> matcherForFunnel) {
        this.matcherForFunnel = matcherForFunnel;
    }

    public void setMatcherForParameterContext(ComponentMatcher<ParameterContext> matcherForParameterContext) {
        this.matcherForParameterContext = matcherForParameterContext;
    }

    public void setMatcherForParameter(ComponentMatcher<Parameter> matcherForParameter) {
        this.matcherForParameter = matcherForParameter;
    }

    public void setMatcherForLabel(ComponentMatcher<Label> matcherForLabel) {
        this.matcherForLabel = matcherForLabel;
    }

    public void setMatcherForControllerServiceNode(ComponentMatcher<ControllerServiceNode> matcherForControllerServiceNode) {
        this.matcherForControllerServiceNode = matcherForControllerServiceNode;
    }
}

