/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.admin.service.IdpUserGroupService;
import org.apache.nifi.authentication.exception.AuthenticationNotSupportedException;
import org.apache.nifi.authorization.util.IdentityMappingUtil;
import org.apache.nifi.idp.IdpType;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.api.AccessResource;
import org.apache.nifi.web.security.logout.LogoutRequest;
import org.apache.nifi.web.security.saml.SAMLCredentialStore;
import org.apache.nifi.web.security.saml.SAMLService;
import org.apache.nifi.web.security.saml.SAMLStateManager;
import org.apache.nifi.web.security.token.LoginAuthenticationToken;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.saml.SAMLCredential;
import org.springframework.web.util.WebUtils;

@Path(value="/access/saml")
@Api(value="/access/saml", description="Endpoints for authenticating, obtaining an access token or logging out of a configured SAML authentication provider.")
public class SAMLAccessResource
extends AccessResource {
    private static final Logger logger = LoggerFactory.getLogger(SAMLAccessResource.class);
    private static final String SAML_REQUEST_IDENTIFIER = "saml-request-identifier";
    private static final String SAML_METADATA_MEDIA_TYPE = "application/samlmetadata+xml";
    private static final String LOGOUT_REQUEST_IDENTIFIER_NOT_FOUND = "The logout request identifier was not found in the request. Unable to continue.";
    private static final String LOGOUT_REQUEST_NOT_FOUND_FOR_GIVEN_IDENTIFIER = "No logout request was found for the given identifier. Unable to continue.";
    private static final boolean LOGGING_IN = true;
    private SAMLService samlService;
    private SAMLStateManager samlStateManager;
    private SAMLCredentialStore samlCredentialStore;
    private IdpUserGroupService idpUserGroupService;

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/samlmetadata+xml"})
    @Path(value="/metadata")
    @ApiOperation(value="Retrieves the service provider metadata.", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.")
    public Response samlMetadata(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) throws Exception {
        if (!httpServletRequest.isSecure()) {
            throw new AuthenticationNotSupportedException("User authentication/authorization is only supported when running over HTTPS.");
        }
        if (!this.samlService.isSamlEnabled()) {
            logger.debug("SAML support is not configured");
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"SAML support is not configured").build();
        }
        this.initializeSamlServiceProvider();
        String metadataXml = this.samlService.getServiceProviderMetadata();
        return Response.ok((Object)metadataXml, (String)SAML_METADATA_MEDIA_TYPE).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="login/request")
    @ApiOperation(value="Initiates an SSO request to the configured SAML identity provider.", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.")
    public void samlLoginRequest(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) throws Exception {
        assert (this.isSamlEnabled(httpServletRequest, httpServletResponse, true));
        this.initializeSamlServiceProvider();
        String samlRequestIdentifier = UUID.randomUUID().toString();
        Cookie cookie = new Cookie(SAML_REQUEST_IDENTIFIER, samlRequestIdentifier);
        cookie.setPath("/");
        cookie.setHttpOnly(true);
        cookie.setMaxAge(60);
        cookie.setSecure(true);
        httpServletResponse.addCookie(cookie);
        String relayState = this.samlStateManager.createState(samlRequestIdentifier);
        try {
            this.samlService.initiateLogin(httpServletRequest, httpServletResponse, relayState);
        }
        catch (Exception e) {
            this.forwardToLoginMessagePage(httpServletRequest, httpServletResponse, e.getMessage());
            return;
        }
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"*/*"})
    @Path(value="/login/consumer")
    @ApiOperation(value="Processes the SSO response from the SAML identity provider for HTTP-POST binding.", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.")
    public void samlLoginHttpPostConsumer(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse, MultivaluedMap<String, String> formParams) throws Exception {
        assert (this.isSamlEnabled(httpServletRequest, httpServletResponse, true));
        Map parameters = this.getParameterMap(formParams);
        this.samlLoginConsumer(httpServletRequest, httpServletResponse, parameters);
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="/login/consumer")
    @ApiOperation(value="Processes the SSO response from the SAML identity provider for HTTP-REDIRECT binding.", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.")
    public void samlLoginHttpRedirectConsumer(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse, @Context UriInfo uriInfo) throws Exception {
        assert (this.isSamlEnabled(httpServletRequest, httpServletResponse, true));
        Map parameters = this.getParameterMap(uriInfo.getQueryParameters());
        this.samlLoginConsumer(httpServletRequest, httpServletResponse, parameters);
    }

    private void samlLoginConsumer(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map<String, String> parameters) throws Exception {
        SAMLCredential samlCredential;
        this.initializeSamlServiceProvider();
        String samlRequestIdentifier = WebUtils.getCookie((HttpServletRequest)httpServletRequest, (String)SAML_REQUEST_IDENTIFIER).getValue();
        if (samlRequestIdentifier == null) {
            this.forwardToLoginMessagePage(httpServletRequest, httpServletResponse, "The login request identifier was not found in the request. Unable to continue.");
            return;
        }
        String requestState = parameters.get("RelayState");
        if (requestState == null) {
            this.removeSamlRequestCookie(httpServletResponse);
            this.forwardToLoginMessagePage(httpServletRequest, httpServletResponse, "The RelayState parameter was not found in the request. Unable to continue.");
            return;
        }
        if (!this.samlStateManager.isStateValid(samlRequestIdentifier, requestState)) {
            logger.error("The RelayState value returned by the SAML IDP does not match the stored state. Unable to continue login process.");
            this.removeSamlRequestCookie(httpServletResponse);
            this.forwardToLoginMessagePage(httpServletRequest, httpServletResponse, "Purposed RelayState does not match the stored state. Unable to continue login process.");
            return;
        }
        try {
            samlCredential = this.samlService.processLogin(httpServletRequest, httpServletResponse, parameters);
        }
        catch (Exception e) {
            this.removeSamlRequestCookie(httpServletResponse);
            this.forwardToLoginMessagePage(httpServletRequest, httpServletResponse, e.getMessage());
            return;
        }
        String rawIdentity = this.samlService.getUserIdentity(samlCredential);
        String mappedIdentity = IdentityMappingUtil.mapIdentity((String)rawIdentity, (List)IdentityMappingUtil.getIdentityMappings((NiFiProperties)this.properties));
        long expiration = this.validateTokenExpiration(this.samlService.getAuthExpiration(), mappedIdentity);
        String issuer = samlCredential.getRemoteEntityID();
        LoginAuthenticationToken loginToken = new LoginAuthenticationToken(mappedIdentity, mappedIdentity, expiration, issuer);
        this.samlStateManager.createJwt(samlRequestIdentifier, loginToken);
        this.samlCredentialStore.save(mappedIdentity, samlCredential);
        Set userGroups = this.samlService.getUserGroups(samlCredential);
        if (logger.isDebugEnabled()) {
            logger.debug("SAML User '{}' belongs to the unmapped groups {}", (Object)mappedIdentity, (Object)StringUtils.join((Object[])new Set[]{userGroups}));
        }
        List groupIdentityMappings = IdentityMappingUtil.getGroupMappings((NiFiProperties)this.properties);
        Set mappedGroups = userGroups.stream().map(g -> IdentityMappingUtil.mapIdentity((String)g, (List)groupIdentityMappings)).collect(Collectors.toSet());
        logger.info("SAML User '{}' belongs to the mapped groups {}", (Object)mappedIdentity, (Object)StringUtils.join((Object[])new Set[]{mappedGroups}));
        this.idpUserGroupService.replaceUserGroups(mappedIdentity, IdpType.SAML, mappedGroups);
        httpServletResponse.sendRedirect(this.getNiFiUri());
    }

    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    @Path(value="/login/exchange")
    @ApiOperation(value="Retrieves a JWT following a successful login sequence using the configured SAML identity provider.", response=String.class, notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.")
    public Response samlLoginExchange(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) throws Exception {
        if (!httpServletRequest.isSecure()) {
            throw new AuthenticationNotSupportedException("User authentication/authorization is only supported when running over HTTPS.");
        }
        if (!this.samlService.isSamlEnabled()) {
            logger.debug("SAML support is not configured");
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"SAML support is not configured").build();
        }
        logger.info("Attempting to exchange SAML login request for a NiFi JWT...");
        this.initializeSamlServiceProvider();
        String samlRequestIdentifier = WebUtils.getCookie((HttpServletRequest)httpServletRequest, (String)SAML_REQUEST_IDENTIFIER).getValue();
        if (samlRequestIdentifier == null) {
            String message = "The login request identifier was not found in the request. Unable to continue.";
            logger.warn("The login request identifier was not found in the request. Unable to continue.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"The login request identifier was not found in the request. Unable to continue.").build();
        }
        this.removeSamlRequestCookie(httpServletResponse);
        String jwt = this.samlStateManager.getJwt(samlRequestIdentifier);
        if (jwt == null) {
            throw new IllegalArgumentException("A JWT for this login request identifier could not be found. Unable to continue.");
        }
        logger.info("SAML login exchange complete");
        return this.generateOkResponse((Object)jwt).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="/single-logout/request")
    @ApiOperation(value="Initiates a logout request using the SingleLogout service of the configured SAML identity provider.", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.")
    public void samlSingleLogoutRequest(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) throws Exception {
        assert (this.isSamlEnabled(httpServletRequest, httpServletResponse, false));
        String logoutRequestIdentifier = WebUtils.getCookie((HttpServletRequest)httpServletRequest, (String)"nifi-logout-request-identifier").getValue();
        if (StringUtils.isBlank((CharSequence)logoutRequestIdentifier)) {
            this.forwardToLogoutMessagePage(httpServletRequest, httpServletResponse, LOGOUT_REQUEST_IDENTIFIER_NOT_FOUND);
            return;
        }
        LogoutRequest logoutRequest = this.logoutRequestManager.get(logoutRequestIdentifier);
        if (logoutRequest == null) {
            this.forwardToLogoutMessagePage(httpServletRequest, httpServletResponse, LOGOUT_REQUEST_NOT_FOUND_FOR_GIVEN_IDENTIFIER);
            return;
        }
        this.initializeSamlServiceProvider();
        String userIdentity = logoutRequest.getMappedUserIdentity();
        logger.info("Attempting to performing SAML Single Logout for {}", (Object)userIdentity);
        SAMLCredential samlCredential = this.samlCredentialStore.get(userIdentity);
        if (samlCredential == null) {
            throw new IllegalStateException("Unable to find a stored SAML credential for " + userIdentity);
        }
        try {
            logger.info("Initiating SAML Single Logout with IDP...");
            this.samlService.initiateLogout(httpServletRequest, httpServletResponse, samlCredential);
        }
        catch (Exception e) {
            this.forwardToLogoutMessagePage(httpServletRequest, httpServletResponse, e.getMessage());
            return;
        }
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="/single-logout/consumer")
    @ApiOperation(value="Processes a SingleLogout message from the configured SAML identity provider using the HTTP-REDIRECT binding.", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.")
    public void samlSingleLogoutHttpRedirectConsumer(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse, @Context UriInfo uriInfo) throws Exception {
        assert (this.isSamlEnabled(httpServletRequest, httpServletResponse, false));
        Map parameters = this.getParameterMap(uriInfo.getQueryParameters());
        this.samlSingleLogoutConsumer(httpServletRequest, httpServletResponse, parameters);
    }

    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="/single-logout/consumer")
    @ApiOperation(value="Processes a SingleLogout message from the configured SAML identity provider using the HTTP-POST binding.", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.")
    public void samlSingleLogoutHttpPostConsumer(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse, MultivaluedMap<String, String> formParams) throws Exception {
        assert (this.isSamlEnabled(httpServletRequest, httpServletResponse, false));
        Map parameters = this.getParameterMap(formParams);
        this.samlSingleLogoutConsumer(httpServletRequest, httpServletResponse, parameters);
    }

    private void samlSingleLogoutConsumer(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map<String, String> parameters) throws Exception {
        this.initializeSamlServiceProvider();
        String logoutRequestIdentifier = WebUtils.getCookie((HttpServletRequest)httpServletRequest, (String)"nifi-logout-request-identifier").getValue();
        if (StringUtils.isBlank((CharSequence)logoutRequestIdentifier)) {
            this.forwardToLogoutMessagePage(httpServletRequest, httpServletResponse, LOGOUT_REQUEST_IDENTIFIER_NOT_FOUND);
            return;
        }
        LogoutRequest logoutRequest = this.logoutRequestManager.get(logoutRequestIdentifier);
        if (logoutRequest == null) {
            this.forwardToLogoutMessagePage(httpServletRequest, httpServletResponse, LOGOUT_REQUEST_NOT_FOUND_FOR_GIVEN_IDENTIFIER);
            return;
        }
        this.logoutRequestManager.complete(logoutRequestIdentifier);
        this.removeLogoutRequestCookie(httpServletResponse);
        String identity = logoutRequest.getMappedUserIdentity();
        logger.info("Consuming SAML Single Logout for {}", (Object)identity);
        this.samlCredentialStore.delete(identity);
        this.idpUserGroupService.deleteUserGroups(identity);
        try {
            this.samlService.processLogout(httpServletRequest, httpServletResponse, parameters);
            logger.info("Completed SAML Single Logout for {}", (Object)identity);
        }
        catch (Exception e) {
            this.forwardToLogoutMessagePage(httpServletRequest, httpServletResponse, e.getMessage());
            return;
        }
        httpServletResponse.sendRedirect(this.getNiFiLogoutCompleteUri());
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="/local-logout")
    @ApiOperation(value="Local logout when SAML is enabled, does not communicate with the IDP.", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.")
    public void samlLocalLogout(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) throws Exception {
        assert (this.isSamlEnabled(httpServletRequest, httpServletResponse, false));
        LogoutRequest completedLogoutRequest = this.completeLogoutRequest(httpServletResponse);
        if (completedLogoutRequest != null) {
            String userIdentity = completedLogoutRequest.getMappedUserIdentity();
            logger.info("Removing cached SAML information for " + userIdentity);
            this.samlCredentialStore.delete(userIdentity);
            logger.info("Removing cached SAML Groups for " + userIdentity);
            this.idpUserGroupService.deleteUserGroups(userIdentity);
        }
        httpServletResponse.sendRedirect(this.getNiFiLogoutCompleteUri());
    }

    private void initializeSamlServiceProvider() throws MetadataProviderException {
        if (!this.samlService.isServiceProviderInitialized()) {
            String samlMetadataUri = this.generateResourceUri(new String[]{"saml", "metadata"});
            String baseUri = samlMetadataUri.replace("/saml/metadata", "");
            this.samlService.initializeServiceProvider(baseUri);
        }
    }

    private Map<String, String> getParameterMap(MultivaluedMap<String, String> formParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (String paramKey : formParams.keySet()) {
            params.put(paramKey, (String)formParams.getFirst((Object)paramKey));
        }
        return params;
    }

    private void removeSamlRequestCookie(HttpServletResponse httpServletResponse) {
        this.removeCookie(httpServletResponse, SAML_REQUEST_IDENTIFIER);
    }

    private boolean isSamlEnabled(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean isLogin) throws Exception {
        String pageTitle = this.getForwardPageTitle(isLogin);
        if (!httpServletRequest.isSecure()) {
            this.forwardToMessagePage(httpServletRequest, httpServletResponse, pageTitle, "User authentication/authorization is only supported when running over HTTPS.");
            return false;
        }
        if (!this.samlService.isSamlEnabled()) {
            this.forwardToMessagePage(httpServletRequest, httpServletResponse, pageTitle, "SAML support is not configured");
            return false;
        }
        return true;
    }

    private String getForwardPageTitle(boolean isLogin) {
        return isLogin ? "Unable to continue login sequence" : "Unable to continue logout sequence";
    }

    public void setSamlService(SAMLService samlService) {
        this.samlService = samlService;
    }

    public void setSamlStateManager(SAMLStateManager samlStateManager) {
        this.samlStateManager = samlStateManager;
    }

    public void setSamlCredentialStore(SAMLCredentialStore samlCredentialStore) {
        this.samlCredentialStore = samlCredentialStore;
    }

    public void setIdpUserGroupService(IdpUserGroupService idpUserGroupService) {
        this.idpUserGroupService = idpUserGroupService;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    protected NiFiProperties getProperties() {
        return this.properties;
    }
}

