/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.ResumeFlowException;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.ParameterContextResource;
import org.apache.nifi.web.api.concurrent.AsyncRequestManager;
import org.apache.nifi.web.api.concurrent.AsynchronousWebRequest;
import org.apache.nifi.web.api.concurrent.RequestManager;
import org.apache.nifi.web.api.concurrent.StandardAsynchronousWebRequest;
import org.apache.nifi.web.api.concurrent.StandardUpdateStep;
import org.apache.nifi.web.api.concurrent.UpdateStep;
import org.apache.nifi.web.api.dto.AffectedComponentDTO;
import org.apache.nifi.web.api.dto.DtoFactory;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.dto.ParameterContextUpdateRequestDTO;
import org.apache.nifi.web.api.dto.ParameterContextUpdateStepDTO;
import org.apache.nifi.web.api.dto.ParameterContextValidationRequestDTO;
import org.apache.nifi.web.api.dto.ParameterDTO;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.entity.AffectedComponentEntity;
import org.apache.nifi.web.api.entity.ComponentValidationResultsEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.ParameterContextEntity;
import org.apache.nifi.web.api.entity.ParameterContextUpdateRequestEntity;
import org.apache.nifi.web.api.entity.ParameterContextValidationRequestEntity;
import org.apache.nifi.web.api.entity.ParameterEntity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.LongParameter;
import org.apache.nifi.web.util.AffectedComponentUtils;
import org.apache.nifi.web.util.CancellableTimedPause;
import org.apache.nifi.web.util.ComponentLifecycle;
import org.apache.nifi.web.util.InvalidComponentAction;
import org.apache.nifi.web.util.LifecycleManagementException;
import org.apache.nifi.web.util.Pause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/parameter-contexts")
@Api(value="/parameter-contexts", description="Endpoint for managing version control for a flow")
public class ParameterContextResource
extends ApplicationResource {
    private static final Logger logger = LoggerFactory.getLogger(ParameterContextResource.class);
    private static final Pattern VALID_PARAMETER_NAME_PATTERN = Pattern.compile("[A-Za-z0-9 ._\\-]+");
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;
    private DtoFactory dtoFactory;
    private ComponentLifecycle clusterComponentLifecycle;
    private ComponentLifecycle localComponentLifecycle;
    private RequestManager<ParameterContextEntity, ParameterContextEntity> updateRequestManager = new AsyncRequestManager(100, TimeUnit.MINUTES.toMillis(1L), "Parameter Context Update Thread");
    private RequestManager<ParameterContextValidationRequestEntity, ComponentValidationResultsEntity> validationRequestManager = new AsyncRequestManager(100, TimeUnit.MINUTES.toMillis(1L), "Parameter Context Validation Thread");

    private void authorizeReadParameterContext(String parameterContextId) {
        if (parameterContextId == null) {
            throw new IllegalArgumentException("Parameter Context ID must be specified");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable parameterContext = lookup.getParameterContext(parameterContextId);
            parameterContext.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Returns the Parameter Context with the given ID", response=ParameterContextEntity.class, notes="Returns the Parameter Context with the given ID.", authorizations={@Authorization(value="Read - /parameter-contexts/{id}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getParameterContext(@ApiParam(value="The ID of the Parameter Context") @PathParam(value="id") String parameterContextId) {
        this.authorizeReadParameterContext(parameterContextId);
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ParameterContextEntity entity = this.serviceFacade.getParameterContext(parameterContextId, NiFiUserUtils.getNiFiUser());
        entity.setUri(this.generateResourceUri(new String[]{"parameter-contexts", entity.getId()}));
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a Parameter Context", response=ParameterContextEntity.class, authorizations={@Authorization(value="Write - /parameter-contexts")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createParameterContext(@ApiParam(value="The Parameter Context.", required=true) ParameterContextEntity requestEntity) {
        if (requestEntity == null || requestEntity.getComponent() == null) {
            throw new IllegalArgumentException("Parameter Context must be specified");
        }
        if (requestEntity.getRevision() == null || requestEntity.getRevision().getVersion() == null || requestEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Parameter Context.");
        }
        ParameterContextDTO context = requestEntity.getComponent();
        if (context.getName() == null) {
            throw new IllegalArgumentException("Parameter Context's Name must be specified");
        }
        this.validateParameterNames(requestEntity.getComponent());
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestEntity, lookup -> {
            Authorizable parameterContexts = lookup.getParameterContexts();
            parameterContexts.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyCreateParameterContext(requestEntity.getComponent()), entity -> {
            String contextId = this.generateUuid();
            entity.getComponent().setId(contextId);
            Revision revision = this.getRevision(entity.getRevision(), contextId);
            ParameterContextEntity contextEntity = this.serviceFacade.createParameterContext(revision, entity.getComponent());
            String uri = this.generateResourceUri(new String[]{"parameter-contexts", contextEntity.getId()});
            contextEntity.setUri(uri);
            return this.generateCreatedResponse(URI.create(uri), (Object)contextEntity).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Modifies a Parameter Context", response=ParameterContextEntity.class, notes="This endpoint will update a Parameter Context to match the provided entity. However, this request will fail if any component is running and is referencing a Parameter in the Parameter Context. Generally, this endpoint is not called directly. Instead, an update request should be submitted by making a POST to the /parameter-contexts/update-requests endpoint. That endpoint will, in turn, call this endpoint.", authorizations={@Authorization(value="Read - /parameter-contexts/{id}"), @Authorization(value="Write - /parameter-contexts/{id}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateParameterContext(@PathParam(value="id") String contextId, @ApiParam(value="The updated Parameter Context", required=true) ParameterContextEntity requestEntity) {
        if (requestEntity.getId() == null) {
            throw new IllegalArgumentException("The ID of the Parameter Context must be specified");
        }
        if (!requestEntity.getId().equals(contextId)) {
            throw new IllegalArgumentException("The ID of the Parameter Context must match the ID specified in the URL's path");
        }
        ParameterContextDTO updateDto = requestEntity.getComponent();
        if (updateDto == null) {
            throw new IllegalArgumentException("The Parameter Context must be supplied");
        }
        RevisionDTO revisionDto = requestEntity.getRevision();
        if (revisionDto == null) {
            throw new IllegalArgumentException("The Revision of the Parameter Context must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision(requestEntity.getRevision(), updateDto.getId());
        return this.withWriteLock(this.serviceFacade, (Entity)requestEntity, requestRevision, lookup -> {
            Authorizable parameterContext = lookup.getParameterContext(contextId);
            parameterContext.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
            parameterContext.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyUpdateParameterContext(updateDto, true), (rev, entity) -> {
            ParameterContextEntity updatedEntity = this.serviceFacade.updateParameterContext(rev, entity.getComponent());
            updatedEntity.setUri(this.generateResourceUri(new String[]{"parameter-contexts", entity.getId()}));
            return this.generateOkResponse((Object)updatedEntity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{contextId}/update-requests")
    @ApiOperation(value="Initiate the Update Request of a Parameter Context", response=ParameterContextUpdateRequestEntity.class, notes="This will initiate the process of updating a Parameter Context. Changing the value of a Parameter may require that one or more components be stopped and restarted, so this acttion may take significantly more time than many other REST API actions. As a result, this endpoint will immediately return a ParameterContextUpdateRequestEntity, and the process of updating the necessary components will occur asynchronously in the background. The client may then periodically poll the status of the request by issuing a GET request to /parameter-contexts/update-requests/{requestId}. Once the request is completed, the client is expected to issue a DELETE request to /parameter-contexts/update-requests/{requestId}.", authorizations={@Authorization(value="Read - /parameter-contexts/{parameterContextId}"), @Authorization(value="Write - /parameter-contexts/{parameterContextId}"), @Authorization(value="Read - for every component that is affected by the update"), @Authorization(value="Write - for every component that is affected by the update")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response submitParameterContextUpdate(@PathParam(value="contextId") String contextId, @ApiParam(value="The updated version of the parameter context.", required=true) ParameterContextEntity requestEntity) {
        if (requestEntity == null) {
            throw new IllegalArgumentException("Parameter Context must be specified.");
        }
        RevisionDTO revisionDto = requestEntity.getRevision();
        if (revisionDto == null) {
            throw new IllegalArgumentException("Parameter Context Revision must be specified");
        }
        ParameterContextDTO contextDto = requestEntity.getComponent();
        if (contextDto == null) {
            throw new IllegalArgumentException("Parameter Context must be specified");
        }
        if (contextDto.getId() == null) {
            throw new IllegalArgumentException("Parameter Context's ID must be specified");
        }
        if (!contextDto.getId().equals(contextId)) {
            throw new IllegalArgumentException("ID of Parameter Context in message body does not match Parameter Context ID supplied in URI");
        }
        this.validateParameterNames(contextDto);
        boolean replicateRequest = this.isReplicateRequest();
        ComponentLifecycle componentLifecycle = replicateRequest ? this.clusterComponentLifecycle : this.localComponentLifecycle;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        Set affectedComponents = this.serviceFacade.getComponentsAffectedByParameterContextUpdate(contextDto);
        logger.debug("Received Update Request for Parameter Context: {}; the following {} components will be affected: {}", new Object[]{requestEntity, affectedComponents.size(), affectedComponents});
        InitiateChangeParameterContextRequestWrapper requestWrapper = new InitiateChangeParameterContextRequestWrapper(requestEntity, componentLifecycle, this.getAbsolutePath(), affectedComponents, replicateRequest, user);
        Revision requestRevision = this.getRevision(requestEntity.getRevision(), contextDto.getId());
        return this.withWriteLock(this.serviceFacade, (Entity)requestWrapper, requestRevision, lookup -> {
            Authorizable parameterContext = lookup.getParameterContext(contextId);
            parameterContext.authorize(this.authorizer, RequestAction.READ, user);
            parameterContext.authorize(this.authorizer, RequestAction.WRITE, user);
            affectedComponents.forEach(component -> this.authorizeAffectedComponent(component, lookup, user, true, true));
        }, () -> this.serviceFacade.verifyUpdateParameterContext(contextDto, false), (arg_0, arg_1) -> this.submitUpdateRequest(arg_0, arg_1));
    }

    private void validateParameterNames(ParameterContextDTO parameterContextDto) {
        for (ParameterEntity entity : parameterContextDto.getParameters()) {
            String parameterName = entity.getParameter().getName();
            if (this.isLegalParameterName(parameterName)) continue;
            throw new IllegalArgumentException("Request contains an illegal Parameter Name (" + parameterName + "). Parameter names may only include letters, numbers, spaces, and the special characters .-_");
        }
    }

    private boolean isLegalParameterName(String parameterName) {
        return VALID_PARAMETER_NAME_PATTERN.matcher(parameterName).matches();
    }

    private void authorizeAffectedComponent(AffectedComponentEntity entity, AuthorizableLookup lookup, NiFiUser user, boolean requireRead, boolean requireWrite) {
        AffectedComponentDTO dto = entity.getComponent();
        if (dto == null) {
            Authorizable authorizable;
            try {
                authorizable = lookup.getProcessor(entity.getId()).getAuthorizable();
            }
            catch (ResourceNotFoundException rnfe) {
                authorizable = lookup.getControllerService(entity.getId()).getAuthorizable();
            }
            if (requireRead) {
                authorizable.authorize(this.authorizer, RequestAction.READ, user);
            }
            if (requireWrite) {
                authorizable.authorize(this.authorizer, RequestAction.WRITE, user);
            }
        } else if ("PROCESSOR".equals(dto.getReferenceType())) {
            Authorizable processor = lookup.getProcessor(dto.getId()).getAuthorizable();
            if (requireRead) {
                processor.authorize(this.authorizer, RequestAction.READ, user);
            }
            if (requireWrite) {
                processor.authorize(this.authorizer, RequestAction.WRITE, user);
            }
        } else if ("CONTROLLER_SERVICE".equals(dto.getReferenceType())) {
            Authorizable service = lookup.getControllerService(dto.getId()).getAuthorizable();
            if (requireRead) {
                service.authorize(this.authorizer, RequestAction.READ, user);
            }
            if (requireWrite) {
                service.authorize(this.authorizer, RequestAction.WRITE, user);
            }
        }
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{contextId}/update-requests/{requestId}")
    @ApiOperation(value="Returns the Update Request with the given ID", response=ParameterContextUpdateRequestEntity.class, notes="Returns the Update Request with the given ID. Once an Update Request has been created by performing a POST to /nifi-api/parameter-contexts, that request can subsequently be retrieved via this endpoint, and the request that is fetched will contain the updated state, such as percent complete, the current state of the request, and any failures. ", authorizations={@Authorization(value="Only the user that submitted the request can get it")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getParameterContextUpdate(@ApiParam(value="The ID of the Parameter Context") @PathParam(value="contextId") String contextId, @ApiParam(value="The ID of the Update Request") @PathParam(value="requestId") String updateRequestId) {
        this.authorizeReadParameterContext(contextId);
        return this.retrieveUpdateRequest("update-requests", contextId, updateRequestId);
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{contextId}/update-requests/{requestId}")
    @ApiOperation(value="Deletes the Update Request with the given ID", response=ParameterContextUpdateRequestEntity.class, notes="Deletes the Update Request with the given ID. After a request is created via a POST to /nifi-api/parameter-contexts/update-requests, it is expected that the client will properly clean up the request by DELETE'ing it, once the Update process has completed. If the request is deleted before the request completes, then the Update request will finish the step that it is currently performing and then will cancel any subsequent steps.", authorizations={@Authorization(value="Only the user that submitted the request can remove it")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response deleteUpdateRequest(@ApiParam(value="Acknowledges that this node is disconnected to allow for mutable requests to proceed.", required=false) @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @ApiParam(value="The ID of the ParameterContext") @PathParam(value="contextId") String contextId, @ApiParam(value="The ID of the Update Request") @PathParam(value="requestId") String updateRequestId) {
        this.authorizeReadParameterContext(contextId);
        return this.deleteUpdateRequest("update-requests", contextId, updateRequestId, disconnectedNodeAcknowledged.booleanValue());
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Deletes the Parameter Context with the given ID", response=ParameterContextEntity.class, notes="Deletes the Parameter Context with the given ID.", authorizations={@Authorization(value="Read - /parameter-contexts/{uuid}"), @Authorization(value="Write - /parameter-contexts/{uuid}"), @Authorization(value="Read - /process-groups/{uuid}, for any Process Group that is currently bound to the Parameter Context"), @Authorization(value="Write - /process-groups/{uuid}, for any Process Group that is currently bound to the Parameter Context")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response deleteParameterContext(@ApiParam(value="The version is used to verify the client is working with the latest version of the flow.", required=false) @QueryParam(value="version") LongParameter version, @ApiParam(value="If the client id is not specified, a new one will be generated. This value (whether specified or generated) is included in the response.", required=false) @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @ApiParam(value="Acknowledges that this node is disconnected to allow for mutable requests to proceed.", required=false) @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @ApiParam(value="The Parameter Context ID.") @PathParam(value="id") String parameterContextId) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), parameterContextId);
        return this.withWriteLock(this.serviceFacade, null, requestRevision, lookup -> {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            Authorizable parameterContext = lookup.getParameterContext(parameterContextId);
            parameterContext.authorize(this.authorizer, RequestAction.READ, user);
            parameterContext.authorize(this.authorizer, RequestAction.WRITE, user);
            ParameterContextEntity contextEntity = this.serviceFacade.getParameterContext(parameterContextId, user);
            for (ProcessGroupEntity boundGroupEntity : contextEntity.getComponent().getBoundProcessGroups()) {
                String groupId = boundGroupEntity.getId();
                Authorizable groupAuthorizable = lookup.getProcessGroup(groupId).getAuthorizable();
                groupAuthorizable.authorize(this.authorizer, RequestAction.READ, user);
                groupAuthorizable.authorize(this.authorizer, RequestAction.WRITE, user);
            }
        }, () -> this.serviceFacade.verifyDeleteParameterContext(parameterContextId), (revision, groupEntity) -> {
            ParameterContextEntity entity = this.serviceFacade.deleteParameterContext(revision, parameterContextId);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{contextId}/validation-requests")
    @ApiOperation(value="Initiate a Validation Request to determine how the validity of components will change if a Parameter Context were to be updated", response=ParameterContextValidationRequestEntity.class, notes="This will initiate the process of validating all components whose Process Group is bound to the specified Parameter Context. Performing validation against an arbitrary number of components may be expect and take significantly more time than many other REST API actions. As a result, this endpoint will immediately return a ParameterContextValidationRequestEntity, and the process of validating the necessary components will occur asynchronously in the background. The client may then periodically poll the status of the request by issuing a GET request to /parameter-contexts/validation-requests/{requestId}. Once the request is completed, the client is expected to issue a DELETE request to /parameter-contexts/validation-requests/{requestId}.", authorizations={@Authorization(value="Read - /parameter-contexts/{parameterContextId}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response submitValidationRequest(@PathParam(value="contextId") String contextId, @ApiParam(value="The validation request", required=true) ParameterContextValidationRequestEntity requestEntity) {
        if (requestEntity == null) {
            throw new IllegalArgumentException("Parameter Context must be specified.");
        }
        ParameterContextValidationRequestDTO requestDto = requestEntity.getRequest();
        if (requestDto == null) {
            throw new IllegalArgumentException("Parameter Context must be specified");
        }
        if (requestDto.getParameterContext() == null) {
            throw new IllegalArgumentException("Parameter Context must be specified");
        }
        if (requestDto.getParameterContext().getId() == null) {
            throw new IllegalArgumentException("Parameter Context's ID must be specified");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestEntity, lookup -> {
            Authorizable parameterContext = lookup.getParameterContext(contextId);
            parameterContext.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
            this.authorizeReferencingComponents(requestEntity.getRequest().getParameterContext().getId(), lookup, NiFiUserUtils.getNiFiUser());
        }, () -> {}, entity -> this.performAsyncValidation(entity, NiFiUserUtils.getNiFiUser()));
    }

    private void authorizeReferencingComponents(String parameterContextId, AuthorizableLookup lookup, NiFiUser user) {
        ParameterContextEntity context = this.serviceFacade.getParameterContext(parameterContextId, NiFiUserUtils.getNiFiUser());
        for (ParameterEntity parameterEntity : context.getComponent().getParameters()) {
            ParameterDTO dto = parameterEntity.getParameter();
            if (dto == null) continue;
            for (AffectedComponentEntity affectedComponent : dto.getReferencingComponents()) {
                this.authorizeAffectedComponent(affectedComponent, lookup, user, true, false);
            }
        }
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{contextId}/validation-requests/{id}")
    @ApiOperation(value="Returns the Validation Request with the given ID", response=ParameterContextValidationRequestEntity.class, notes="Returns the Validation Request with the given ID. Once a Validation Request has been created by performing a POST to /nifi-api/validation-contexts, that request can subsequently be retrieved via this endpoint, and the request that is fetched will contain the updated state, such as percent complete, the current state of the request, and any failures. ", authorizations={@Authorization(value="Only the user that submitted the request can get it")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getValidationRequest(@ApiParam(value="The ID of the Parameter Context") @PathParam(value="contextId") String contextId, @ApiParam(value="The ID of the Validation Request") @PathParam(value="id") String validationRequestId) {
        this.authorizeReadParameterContext(contextId);
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        return this.retrieveValidationRequest("validation-requests", contextId, validationRequestId);
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{contextId}/validation-requests/{id}")
    @ApiOperation(value="Deletes the Validation Request with the given ID", response=ParameterContextValidationRequestEntity.class, notes="Deletes the Validation Request with the given ID. After a request is created via a POST to /nifi-api/validation-contexts, it is expected that the client will properly clean up the request by DELETE'ing it, once the validation process has completed. If the request is deleted before the request completes, then the Validation request will finish the step that it is currently performing and then will cancel any subsequent steps.", authorizations={@Authorization(value="Only the user that submitted the request can remove it")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response deleteValidationRequest(@ApiParam(value="Acknowledges that this node is disconnected to allow for mutable requests to proceed.", required=false) @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @ApiParam(value="The ID of the Parameter Context") @PathParam(value="contextId") String contextId, @ApiParam(value="The ID of the Update Request") @PathParam(value="id") String validationRequestId) {
        this.authorizeReadParameterContext(contextId);
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        return this.deleteValidationRequest("validation-requests", contextId, validationRequestId, disconnectedNodeAcknowledged.booleanValue());
    }

    private Response performAsyncValidation(ParameterContextValidationRequestEntity requestEntity, NiFiUser user) {
        String requestId = this.generateUuid();
        StandardAsynchronousWebRequest request = new StandardAsynchronousWebRequest(requestId, (Object)requestEntity, null, user, this.getValidationSteps());
        Consumer<AsynchronousWebRequest> validationTask = asyncRequest -> {
            try {
                ComponentValidationResultsEntity resultEntity = this.validateComponents(requestEntity, user);
                asyncRequest.markStepComplete((Object)resultEntity);
            }
            catch (Exception e) {
                logger.error("Failed to validate components", (Throwable)e);
                asyncRequest.fail("Failed to validation components due to " + e);
            }
        };
        this.validationRequestManager.submitRequest("validation-requests", requestId, (AsynchronousWebRequest)request, validationTask);
        ParameterContextValidationRequestDTO validationRequestDto = new ParameterContextValidationRequestDTO();
        validationRequestDto.setComplete(request.isComplete());
        validationRequestDto.setFailureReason(request.getFailureReason());
        validationRequestDto.setLastUpdated(request.getLastUpdated());
        validationRequestDto.setRequestId(requestId);
        validationRequestDto.setUri(this.generateResourceUri(new String[]{"parameter-contexts", "validation-requests", requestId}));
        validationRequestDto.setPercentCompleted(request.getPercentComplete());
        validationRequestDto.setState(request.getState());
        validationRequestDto.setComponentValidationResults((ComponentValidationResultsEntity)request.getResults());
        ParameterContextValidationRequestEntity validationRequestEntity = new ParameterContextValidationRequestEntity();
        validationRequestEntity.setRequest(validationRequestDto);
        return this.generateOkResponse((Object)validationRequestEntity).build();
    }

    private List<UpdateStep> getValidationSteps() {
        return Collections.singletonList(new StandardUpdateStep("Validating Components"));
    }

    private ComponentValidationResultsEntity validateComponents(ParameterContextValidationRequestEntity requestEntity, NiFiUser user) {
        List resultEntities = this.serviceFacade.validateComponents(requestEntity.getRequest().getParameterContext(), user);
        ComponentValidationResultsEntity resultsEntity = new ComponentValidationResultsEntity();
        resultsEntity.setValidationResults(resultEntities);
        return resultsEntity;
    }

    private Response submitUpdateRequest(Revision requestRevision, InitiateChangeParameterContextRequestWrapper requestWrapper) {
        String requestId = UUID.randomUUID().toString();
        String contextId = requestWrapper.getParameterContextEntity().getComponent().getId();
        StandardAsynchronousWebRequest request = new StandardAsynchronousWebRequest(requestId, (Object)requestWrapper.getParameterContextEntity(), contextId, requestWrapper.getUser(), this.getUpdateSteps());
        Consumer<AsynchronousWebRequest> updateTask = asyncRequest -> {
            try {
                ParameterContextEntity updatedParameterContextEntity = this.updateParameterContext(asyncRequest, requestWrapper.getComponentLifecycle(), requestWrapper.getExampleUri(), requestWrapper.getReferencingComponents(), requestWrapper.isReplicateRequest(), requestRevision, requestWrapper.getParameterContextEntity());
                asyncRequest.markStepComplete((Object)updatedParameterContextEntity);
            }
            catch (ResumeFlowException rfe) {
                logger.error(rfe.getMessage(), (Throwable)rfe);
                asyncRequest.fail(rfe.getMessage());
            }
            catch (Exception e) {
                logger.error("Failed to update Parameter Context", (Throwable)e);
                asyncRequest.fail("Failed to update Parameter Context due to " + e);
            }
        };
        this.updateRequestManager.submitRequest("update-requests", requestId, (AsynchronousWebRequest)request, updateTask);
        ParameterContextUpdateRequestEntity updateRequestEntity = this.createUpdateRequestEntity((AsynchronousWebRequest)request, "update-requests", contextId, requestId);
        return this.generateOkResponse((Object)updateRequestEntity).build();
    }

    private List<UpdateStep> getUpdateSteps() {
        return Arrays.asList(new StandardUpdateStep("Stopping Affected Processors"), new StandardUpdateStep("Disabling Affected Controller Services"), new StandardUpdateStep("Updating Parameter Context"), new StandardUpdateStep("Re-Enabling Affected Controller Services"), new StandardUpdateStep("Restarting Affected Processors"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParameterContextEntity updateParameterContext(AsynchronousWebRequest<ParameterContextEntity, ParameterContextEntity> asyncRequest, ComponentLifecycle componentLifecycle, URI uri, Set<AffectedComponentEntity> affectedComponents, boolean replicateRequest, Revision revision, ParameterContextEntity updatedContextEntity) throws LifecycleManagementException, ResumeFlowException {
        ParameterContextEntity updatedEntity;
        Set runningProcessors = affectedComponents.stream().filter(entity -> entity.getComponent() != null).filter(entity -> "PROCESSOR".equals(entity.getComponent().getReferenceType())).filter(component -> "Running".equalsIgnoreCase(component.getComponent().getState())).collect(Collectors.toSet());
        Set enabledControllerServices = affectedComponents.stream().filter(entity -> entity.getComponent() != null).filter(dto -> "CONTROLLER_SERVICE".equals(dto.getComponent().getReferenceType())).filter(dto -> "Enabling".equalsIgnoreCase(dto.getComponent().getState()) || "Enabled".equalsIgnoreCase(dto.getComponent().getState())).collect(Collectors.toSet());
        this.stopProcessors(runningProcessors, asyncRequest, componentLifecycle, uri);
        if (asyncRequest.isCancelled()) {
            return null;
        }
        this.disableControllerServices(enabledControllerServices, asyncRequest, componentLifecycle, uri);
        if (asyncRequest.isCancelled()) {
            return null;
        }
        asyncRequest.markStepComplete();
        logger.info("Updating Parameter Context with ID {}", (Object)updatedContextEntity.getId());
        try {
            updatedEntity = this.performParameterContextUpdate(asyncRequest, uri, replicateRequest, revision, updatedContextEntity);
            asyncRequest.markStepComplete();
            logger.info("Successfully updated Parameter Context with ID {}", (Object)updatedContextEntity.getId());
        }
        finally {
            if (!asyncRequest.isCancelled()) {
                this.enableControllerServices(enabledControllerServices, asyncRequest, componentLifecycle, uri);
            }
            if (!asyncRequest.isCancelled()) {
                this.restartProcessors(runningProcessors, asyncRequest, componentLifecycle, uri);
            }
        }
        asyncRequest.setCancelCallback(null);
        if (asyncRequest.isCancelled()) {
            return null;
        }
        return updatedEntity;
    }

    private ParameterContextEntity performParameterContextUpdate(AsynchronousWebRequest<?, ?> asyncRequest, URI exampleUri, boolean replicateRequest, Revision revision, ParameterContextEntity updatedContext) throws LifecycleManagementException {
        if (replicateRequest) {
            NodeResponse clusterResponse;
            URI updateUri;
            try {
                updateUri = new URI(exampleUri.getScheme(), exampleUri.getUserInfo(), exampleUri.getHost(), exampleUri.getPort(), "/nifi-api/parameter-contexts/" + updatedContext.getId(), null, exampleUri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("content-type", "application/json");
            NiFiUser user = asyncRequest.getUser();
            try {
                logger.debug("Replicating PUT request to {} for user {}", (Object)updateUri, (Object)user);
                clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate(user, "PUT", updateUri, (Object)updatedContext, headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), user, "PUT", updateUri, (Object)updatedContext, headers).awaitMergedResponse();
            }
            catch (InterruptedException ie) {
                logger.warn("Interrupted while replicating PUT request to {} for user {}", (Object)updateUri, (Object)user);
                Thread.currentThread().interrupt();
                throw new LifecycleManagementException("Interrupted while updating flows across cluster", (Throwable)ie);
            }
            int updateFlowStatus = clusterResponse.getStatus();
            if (updateFlowStatus != Response.Status.OK.getStatusCode()) {
                String explanation = (String)this.getResponseEntity(clusterResponse, String.class);
                logger.error("Failed to update flow across cluster when replicating PUT request to {} for user {}. Received {} response with explanation: {}", new Object[]{updateUri, user, updateFlowStatus, explanation});
                throw new LifecycleManagementException("Failed to update Flow on all nodes in cluster due to " + explanation);
            }
            return this.serviceFacade.getParameterContext(updatedContext.getId(), user);
        }
        this.serviceFacade.verifyUpdateParameterContext(updatedContext.getComponent(), true);
        return this.serviceFacade.updateParameterContext(revision, updatedContext.getComponent());
    }

    private <T> T getResponseEntity(NodeResponse nodeResponse, Class<T> clazz) {
        Object entity = nodeResponse.getUpdatedEntity();
        if (entity == null) {
            entity = nodeResponse.getClientResponse().readEntity(clazz);
        }
        return (T)entity;
    }

    private void stopProcessors(Set<AffectedComponentEntity> processors, AsynchronousWebRequest<?, ?> asyncRequest, ComponentLifecycle componentLifecycle, URI uri) throws LifecycleManagementException {
        logger.info("Stopping {} Processors in order to update Parameter Context", (Object)processors.size());
        CancellableTimedPause stopComponentsPause = new CancellableTimedPause(250L, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        asyncRequest.setCancelCallback(() -> ((CancellableTimedPause)stopComponentsPause).cancel());
        componentLifecycle.scheduleComponents(uri, "root", processors, ScheduledState.STOPPED, (Pause)stopComponentsPause, InvalidComponentAction.SKIP);
    }

    private void restartProcessors(Set<AffectedComponentEntity> processors, AsynchronousWebRequest<?, ?> asyncRequest, ComponentLifecycle componentLifecycle, URI uri) throws ResumeFlowException, LifecycleManagementException {
        if (logger.isDebugEnabled()) {
            logger.debug("Restarting {} Processors after having updated Parameter Context: {}", (Object)processors.size(), processors);
        } else {
            logger.info("Restarting {} Processors after having updated Parameter Context", (Object)processors.size());
        }
        Set componentsToStart = this.getUpdatedEntities(processors);
        CancellableTimedPause startComponentsPause = new CancellableTimedPause(250L, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        asyncRequest.setCancelCallback(() -> ((CancellableTimedPause)startComponentsPause).cancel());
        try {
            componentLifecycle.scheduleComponents(uri, "root", componentsToStart, ScheduledState.RUNNING, (Pause)startComponentsPause, InvalidComponentAction.SKIP);
            asyncRequest.markStepComplete();
        }
        catch (IllegalStateException ise) {
            throw new ResumeFlowException("Failed to restart components because " + ise.getMessage(), (Throwable)ise);
        }
    }

    private void disableControllerServices(Set<AffectedComponentEntity> controllerServices, AsynchronousWebRequest<?, ?> asyncRequest, ComponentLifecycle componentLifecycle, URI uri) throws LifecycleManagementException {
        asyncRequest.markStepComplete();
        logger.info("Disabling {} Controller Services in order to update Parameter Context", (Object)controllerServices.size());
        CancellableTimedPause disableServicesPause = new CancellableTimedPause(250L, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        asyncRequest.setCancelCallback(() -> ((CancellableTimedPause)disableServicesPause).cancel());
        componentLifecycle.activateControllerServices(uri, "root", controllerServices, ControllerServiceState.DISABLED, (Pause)disableServicesPause, InvalidComponentAction.WAIT);
    }

    private void enableControllerServices(Set<AffectedComponentEntity> controllerServices, AsynchronousWebRequest<?, ?> asyncRequest, ComponentLifecycle componentLifecycle, URI uri) throws LifecycleManagementException, ResumeFlowException {
        if (logger.isDebugEnabled()) {
            logger.debug("Re-Enabling {} Controller Services: {}", (Object)controllerServices.size(), controllerServices);
        } else {
            logger.info("Re-Enabling {} Controller Services after having updated Parameter Context", (Object)controllerServices.size());
        }
        CancellableTimedPause enableServicesPause = new CancellableTimedPause(250L, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        asyncRequest.setCancelCallback(() -> ((CancellableTimedPause)enableServicesPause).cancel());
        Set servicesToEnable = this.getUpdatedEntities(controllerServices);
        try {
            componentLifecycle.activateControllerServices(uri, "root", servicesToEnable, ControllerServiceState.ENABLED, (Pause)enableServicesPause, InvalidComponentAction.SKIP);
            asyncRequest.markStepComplete();
        }
        catch (IllegalStateException ise) {
            throw new ResumeFlowException("Failed to re-enable Controller Services because " + ise.getMessage(), (Throwable)ise);
        }
    }

    private Set<AffectedComponentEntity> getUpdatedEntities(Set<AffectedComponentEntity> originalEntities) {
        LinkedHashSet<AffectedComponentEntity> entities = new LinkedHashSet<AffectedComponentEntity>();
        for (AffectedComponentEntity original : originalEntities) {
            try {
                AffectedComponentEntity updatedEntity = AffectedComponentUtils.updateEntity((AffectedComponentEntity)original, (NiFiServiceFacade)this.serviceFacade, (DtoFactory)this.dtoFactory);
                if (updatedEntity == null) continue;
                entities.add(updatedEntity);
            }
            catch (ResourceNotFoundException resourceNotFoundException) {}
        }
        return entities;
    }

    private Response retrieveValidationRequest(String requestType, String contextId, String requestId) {
        if (requestId == null) {
            throw new IllegalArgumentException("Request ID must be specified.");
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        AsynchronousWebRequest asyncRequest = this.validationRequestManager.getRequest(requestType, requestId, user);
        ParameterContextValidationRequestEntity requestEntity = this.createValidationRequestEntity(asyncRequest, contextId, requestType, requestId);
        return this.generateOkResponse((Object)requestEntity).build();
    }

    private Response deleteValidationRequest(String requestType, String contextId, String requestId, boolean disconnectedNodeAcknowledged) {
        NiFiUser user;
        AsynchronousWebRequest asyncRequest;
        if (requestId == null) {
            throw new IllegalArgumentException("Request ID must be specified.");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(Boolean.valueOf(disconnectedNodeAcknowledged));
        }
        if ((asyncRequest = this.validationRequestManager.removeRequest(requestType, requestId, user = NiFiUserUtils.getNiFiUser())) == null) {
            throw new ResourceNotFoundException("Could not find request of type " + requestType + " with ID " + requestId);
        }
        if (!asyncRequest.isComplete()) {
            asyncRequest.cancel();
        }
        ParameterContextValidationRequestEntity requestEntity = this.createValidationRequestEntity(asyncRequest, contextId, requestType, requestId);
        return this.generateOkResponse((Object)requestEntity).build();
    }

    private ParameterContextValidationRequestEntity createValidationRequestEntity(AsynchronousWebRequest<?, ComponentValidationResultsEntity> asyncRequest, String requestType, String contextId, String requestId) {
        ParameterContextValidationRequestDTO requestDto = new ParameterContextValidationRequestDTO();
        requestDto.setComplete(asyncRequest.isComplete());
        requestDto.setFailureReason(asyncRequest.getFailureReason());
        requestDto.setLastUpdated(asyncRequest.getLastUpdated());
        requestDto.setRequestId(requestId);
        requestDto.setUri(this.generateResourceUri(new String[]{"parameter-contexts", contextId, requestType, requestId}));
        requestDto.setState(asyncRequest.getState());
        requestDto.setPercentCompleted(asyncRequest.getPercentComplete());
        requestDto.setComponentValidationResults((ComponentValidationResultsEntity)asyncRequest.getResults());
        ParameterContextValidationRequestEntity entity = new ParameterContextValidationRequestEntity();
        entity.setRequest(requestDto);
        return entity;
    }

    private Response retrieveUpdateRequest(String requestType, String contextId, String requestId) {
        if (requestId == null) {
            throw new IllegalArgumentException("Request ID must be specified.");
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        AsynchronousWebRequest asyncRequest = this.updateRequestManager.getRequest(requestType, requestId, user);
        ParameterContextUpdateRequestEntity updateRequestEntity = this.createUpdateRequestEntity(asyncRequest, requestType, contextId, requestId);
        return this.generateOkResponse((Object)updateRequestEntity).build();
    }

    private Response deleteUpdateRequest(String requestType, String contextId, String requestId, boolean disconnectedNodeAcknowledged) {
        NiFiUser user;
        AsynchronousWebRequest asyncRequest;
        if (requestId == null) {
            throw new IllegalArgumentException("Request ID must be specified.");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(Boolean.valueOf(disconnectedNodeAcknowledged));
        }
        if ((asyncRequest = this.updateRequestManager.removeRequest(requestType, requestId, user = NiFiUserUtils.getNiFiUser())) == null) {
            throw new ResourceNotFoundException("Could not find request of type " + requestType + " with ID " + requestId);
        }
        if (!asyncRequest.isComplete()) {
            asyncRequest.cancel();
        }
        ParameterContextUpdateRequestEntity updateRequestEntity = this.createUpdateRequestEntity(asyncRequest, requestType, contextId, requestId);
        return this.generateOkResponse((Object)updateRequestEntity).build();
    }

    private ParameterContextUpdateRequestEntity createUpdateRequestEntity(AsynchronousWebRequest<ParameterContextEntity, ParameterContextEntity> asyncRequest, String requestType, String contextId, String requestId) {
        ParameterContextUpdateRequestDTO updateRequestDto = new ParameterContextUpdateRequestDTO();
        updateRequestDto.setComplete(asyncRequest.isComplete());
        updateRequestDto.setFailureReason(asyncRequest.getFailureReason());
        updateRequestDto.setLastUpdated(asyncRequest.getLastUpdated());
        updateRequestDto.setRequestId(requestId);
        updateRequestDto.setUri(this.generateResourceUri(new String[]{"parameter-contexts", contextId, requestType, requestId}));
        updateRequestDto.setState(asyncRequest.getState());
        updateRequestDto.setPercentCompleted(asyncRequest.getPercentComplete());
        ArrayList<Object> updateSteps = new ArrayList<Object>();
        for (UpdateStep updateStep : asyncRequest.getUpdateSteps()) {
            ParameterContextUpdateStepDTO stepDto = new ParameterContextUpdateStepDTO();
            stepDto.setDescription(updateStep.getDescription());
            stepDto.setComplete(updateStep.isComplete());
            stepDto.setFailureReason(updateStep.getFailureReason());
            updateSteps.add(stepDto);
        }
        updateRequestDto.setUpdateSteps(updateSteps);
        ParameterContextEntity initialRequest = (ParameterContextEntity)asyncRequest.getRequest();
        HashMap<String, AffectedComponentEntity> affectedComponents = new HashMap<String, AffectedComponentEntity>();
        for (ParameterEntity entity : initialRequest.getComponent().getParameters()) {
            for (AffectedComponentEntity affectedComponentEntity : entity.getParameter().getReferencingComponents()) {
                affectedComponents.put(affectedComponentEntity.getId(), this.serviceFacade.getUpdatedAffectedComponentEntity(affectedComponentEntity));
            }
        }
        updateRequestDto.setReferencingComponents(new HashSet(affectedComponents.values()));
        ParameterContextEntity contextEntity = this.serviceFacade.getParameterContext(asyncRequest.getComponentId(), NiFiUserUtils.getNiFiUser());
        ParameterContextUpdateRequestEntity updateRequestEntity = new ParameterContextUpdateRequestEntity();
        if (updateRequestDto.isComplete()) {
            updateRequestDto.setParameterContext(contextEntity == null ? null : contextEntity.getComponent());
            updateRequestEntity.setParameterContextRevision(contextEntity == null ? null : contextEntity.getRevision());
        }
        updateRequestEntity.setRequest(updateRequestDto);
        return updateRequestEntity;
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void setClusterComponentLifecycle(ComponentLifecycle componentLifecycle) {
        this.clusterComponentLifecycle = componentLifecycle;
    }

    public void setLocalComponentLifecycle(ComponentLifecycle componentLifecycle) {
        this.localComponentLifecycle = componentLifecycle;
    }

    public void setDtoFactory(DtoFactory dtoFactory) {
        this.dtoFactory = dtoFactory;
    }
}

