/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponseParser;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PreDestroy;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.nifi.authentication.exception.AuthenticationNotSupportedException;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.api.AccessResource;
import org.apache.nifi.web.security.jwt.JwtService;
import org.apache.nifi.web.security.oidc.OidcService;
import org.apache.nifi.web.security.token.LoginAuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.WebUtils;

@Path(value="/access/oidc")
@Api(value="/access/oidc", description="Endpoints for obtaining an access token or checking access status.")
public class OIDCAccessResource
extends AccessResource {
    private static final Logger logger = LoggerFactory.getLogger(OIDCAccessResource.class);
    private static final String OIDC_REQUEST_IDENTIFIER = "oidc-request-identifier";
    private static final String OIDC_ID_TOKEN_AUTHN_ERROR = "Unable to exchange authorization for ID token: ";
    private static final String OPEN_ID_CONNECT_SUPPORT_IS_NOT_CONFIGURED_MSG = "OpenId Connect support is not configured";
    private static final String REVOKE_ACCESS_TOKEN_LOGOUT = "oidc_access_token_logout";
    private static final String ID_TOKEN_LOGOUT = "oidc_id_token_logout";
    private static final String STANDARD_LOGOUT = "oidc_standard_logout";
    private static final Pattern REVOKE_ACCESS_TOKEN_LOGOUT_FORMAT = Pattern.compile("(\\.google\\.com)");
    private static final Pattern ID_TOKEN_LOGOUT_FORMAT = Pattern.compile("(\\.okta)");
    private static final int msTimeout = 30000;
    private static final boolean LOGGING_IN = true;
    private OidcService oidcService;
    private JwtService jwtService;
    private CloseableHttpClient httpClient;

    public OIDCAccessResource() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="/request")
    @ApiOperation(value="Initiates a request to authenticate through the configured OpenId Connect provider.", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.")
    public void oidcRequest(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) throws Exception {
        if (!httpServletRequest.isSecure()) {
            this.forwardToLoginMessagePage(httpServletRequest, httpServletResponse, "User authentication/authorization is only supported when running over HTTPS.");
            return;
        }
        if (!this.oidcService.isOidcEnabled()) {
            this.forwardToLoginMessagePage(httpServletRequest, httpServletResponse, OPEN_ID_CONNECT_SUPPORT_IS_NOT_CONFIGURED_MSG);
            return;
        }
        URI authorizationURI = this.oidcRequestAuthorizationCode(httpServletResponse, this.getOidcCallback());
        httpServletResponse.sendRedirect(authorizationURI.toString());
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="/callback")
    @ApiOperation(value="Redirect/callback URI for processing the result of the OpenId Connect login sequence.", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.")
    public void oidcCallback(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) throws Exception {
        AuthenticationResponse oidcResponse = this.parseOidcResponse(httpServletRequest, httpServletResponse, true);
        String oidcRequestIdentifier = WebUtils.getCookie((HttpServletRequest)httpServletRequest, (String)OIDC_REQUEST_IDENTIFIER).getValue();
        if (oidcResponse != null && oidcResponse.indicatesSuccess()) {
            AuthenticationSuccessResponse successfulOidcResponse = (AuthenticationSuccessResponse)oidcResponse;
            this.checkOidcState(httpServletResponse, oidcRequestIdentifier, successfulOidcResponse, true);
            try {
                AuthorizationCode authorizationCode = successfulOidcResponse.getAuthorizationCode();
                AuthorizationCodeGrant authorizationGrant = new AuthorizationCodeGrant(authorizationCode, URI.create(this.getOidcCallback()));
                LoginAuthenticationToken oidcToken = this.oidcService.exchangeAuthorizationCodeForLoginAuthenticationToken((AuthorizationGrant)authorizationGrant);
                String nifiJwt = this.jwtService.generateSignedToken(oidcToken);
                this.oidcService.storeJwt(oidcRequestIdentifier, nifiJwt);
            }
            catch (Exception e) {
                logger.error(OIDC_ID_TOKEN_AUTHN_ERROR + e.getMessage(), (Throwable)e);
                this.removeOidcRequestCookie(httpServletResponse);
                this.forwardToLoginMessagePage(httpServletRequest, httpServletResponse, OIDC_ID_TOKEN_AUTHN_ERROR + e.getMessage());
                return;
            }
            httpServletResponse.sendRedirect(this.getNiFiUri());
        } else {
            this.removeOidcRequestCookie(httpServletResponse);
            AuthenticationErrorResponse errorOidcResponse = (AuthenticationErrorResponse)oidcResponse;
            this.forwardToLoginMessagePage(httpServletRequest, httpServletResponse, "Unsuccessful login attempt: " + errorOidcResponse.getErrorObject().getDescription());
        }
    }

    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    @Path(value="/exchange")
    @ApiOperation(value="Retrieves a JWT following a successful login sequence using the configured OpenId Connect provider.", response=String.class, notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.")
    public Response oidcExchange(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) {
        if (!httpServletRequest.isSecure()) {
            throw new AuthenticationNotSupportedException("User authentication/authorization is only supported when running over HTTPS.");
        }
        if (!this.oidcService.isOidcEnabled()) {
            logger.debug(OPEN_ID_CONNECT_SUPPORT_IS_NOT_CONFIGURED_MSG);
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)OPEN_ID_CONNECT_SUPPORT_IS_NOT_CONFIGURED_MSG).build();
        }
        String oidcRequestIdentifier = WebUtils.getCookie((HttpServletRequest)httpServletRequest, (String)OIDC_REQUEST_IDENTIFIER).getValue();
        if (oidcRequestIdentifier == null) {
            String message = "The login request identifier was not found in the request. Unable to continue.";
            logger.warn("The login request identifier was not found in the request. Unable to continue.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"The login request identifier was not found in the request. Unable to continue.").build();
        }
        this.removeOidcRequestCookie(httpServletResponse);
        String jwt = this.oidcService.getJwt(oidcRequestIdentifier);
        if (jwt == null) {
            throw new IllegalArgumentException("A JWT for this login request identifier could not be found. Unable to continue.");
        }
        return this.generateTokenResponse(this.generateOkResponse((Object)jwt), jwt);
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="/logout")
    @ApiOperation(value="Performs a logout in the OpenId Provider.", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.")
    public void oidcLogout(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) throws Exception {
        String logoutMethod;
        if (!httpServletRequest.isSecure()) {
            throw new IllegalStateException("User authentication/authorization is only supported when running over HTTPS.");
        }
        if (!this.oidcService.isOidcEnabled()) {
            throw new IllegalStateException(OPEN_ID_CONNECT_SUPPORT_IS_NOT_CONFIGURED_MSG);
        }
        String mappedUserIdentity = NiFiUserUtils.getNiFiUserIdentity();
        this.removeCookie(httpServletResponse, "__Host-Authorization-Bearer");
        logger.debug("Invalidated JWT for user [{}]", (Object)mappedUserIdentity);
        String oidcDiscoveryUrl = this.properties.getOidcDiscoveryUrl();
        switch (logoutMethod = this.determineLogoutMethod(oidcDiscoveryUrl)) {
            case "oidc_access_token_logout": 
            case "oidc_id_token_logout": {
                URI authorizationURI = this.oidcRequestAuthorizationCode(httpServletResponse, this.getOidcLogoutCallback());
                httpServletResponse.sendRedirect(authorizationURI.toString());
                break;
            }
            default: {
                URI endSessionEndpoint = this.oidcService.getEndSessionEndpoint();
                String postLogoutRedirectUri = this.generateResourceUri(new String[]{"..", "nifi", "logout-complete"});
                if (endSessionEndpoint == null) {
                    httpServletResponse.sendRedirect(postLogoutRedirectUri);
                    break;
                }
                URI logoutUri = UriBuilder.fromUri((URI)endSessionEndpoint).queryParam("post_logout_redirect_uri", new Object[]{postLogoutRedirectUri}).build(new Object[0]);
                httpServletResponse.sendRedirect(logoutUri.toString());
            }
        }
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="/logoutCallback")
    @ApiOperation(value="Redirect/callback URI for processing the result of the OpenId Connect logout sequence.", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.")
    public void oidcLogoutCallback(@Context HttpServletRequest httpServletRequest, @Context HttpServletResponse httpServletResponse) throws Exception {
        AuthenticationResponse oidcResponse = this.parseOidcResponse(httpServletRequest, httpServletResponse, false);
        String oidcRequestIdentifier = WebUtils.getCookie((HttpServletRequest)httpServletRequest, (String)OIDC_REQUEST_IDENTIFIER).getValue();
        if (oidcResponse != null && oidcResponse.indicatesSuccess()) {
            AuthenticationSuccessResponse successfulOidcResponse = (AuthenticationSuccessResponse)oidcResponse;
            this.checkOidcState(httpServletResponse, oidcRequestIdentifier, successfulOidcResponse, false);
            String oidcDiscoveryUrl = this.properties.getOidcDiscoveryUrl();
            String logoutMethod = this.determineLogoutMethod(oidcDiscoveryUrl);
            AuthorizationCode authorizationCode = successfulOidcResponse.getAuthorizationCode();
            AuthorizationCodeGrant authorizationGrant = new AuthorizationCodeGrant(authorizationCode, URI.create(this.getOidcLogoutCallback()));
            switch (logoutMethod) {
                case "oidc_access_token_logout": {
                    String accessToken;
                    try {
                        accessToken = this.oidcService.exchangeAuthorizationCodeForAccessToken((AuthorizationGrant)authorizationGrant);
                    }
                    catch (Exception e) {
                        logger.error("Unable to exchange authorization for the Access token: " + e.getMessage(), (Throwable)e);
                        this.removeOidcRequestCookie(httpServletResponse);
                        this.forwardToLogoutMessagePage(httpServletRequest, httpServletResponse, OIDC_ID_TOKEN_AUTHN_ERROR + e.getMessage());
                        return;
                    }
                    URI revokeEndpoint = this.getRevokeEndpoint();
                    if (revokeEndpoint == null) break;
                    try {
                        this.revokeEndpointRequest(httpServletResponse, accessToken, revokeEndpoint);
                    }
                    catch (IOException e) {
                        logger.error("There was an error logging out of the OpenId Connect Provider: " + e.getMessage(), (Throwable)e);
                        this.removeOidcRequestCookie(httpServletResponse);
                        this.forwardToLogoutMessagePage(httpServletRequest, httpServletResponse, "There was an error logging out of the OpenId Connect Provider: " + e.getMessage());
                    }
                    break;
                }
                case "oidc_id_token_logout": {
                    String idToken;
                    try {
                        idToken = this.oidcService.exchangeAuthorizationCodeForIdToken((AuthorizationGrant)authorizationGrant);
                    }
                    catch (Exception e) {
                        logger.error(OIDC_ID_TOKEN_AUTHN_ERROR + e.getMessage(), (Throwable)e);
                        this.removeOidcRequestCookie(httpServletResponse);
                        this.forwardToLogoutMessagePage(httpServletRequest, httpServletResponse, OIDC_ID_TOKEN_AUTHN_ERROR + e.getMessage());
                        return;
                    }
                    URI endSessionEndpoint = this.oidcService.getEndSessionEndpoint();
                    String postLogoutRedirectUri = this.generateResourceUri(new String[]{"..", "nifi", "logout-complete"});
                    if (endSessionEndpoint == null) {
                        logger.debug("Unable to log out of the OpenId Connect Provider. The end session endpoint is: null. Redirecting to the logout page.");
                        httpServletResponse.sendRedirect(postLogoutRedirectUri);
                        break;
                    }
                    URI logoutUri = UriBuilder.fromUri((URI)endSessionEndpoint).queryParam("id_token_hint", new Object[]{idToken}).queryParam("post_logout_redirect_uri", new Object[]{postLogoutRedirectUri}).build(new Object[0]);
                    httpServletResponse.sendRedirect(logoutUri.toString());
                }
            }
        } else {
            this.removeOidcRequestCookie(httpServletResponse);
            AuthenticationErrorResponse errorOidcResponse = (AuthenticationErrorResponse)oidcResponse;
            this.forwardToLogoutMessagePage(httpServletRequest, httpServletResponse, "Unsuccessful logout attempt: " + errorOidcResponse.getErrorObject().getDescription());
        }
    }

    private URI oidcRequestAuthorizationCode(@Context HttpServletResponse httpServletResponse, String callback) {
        String oidcRequestIdentifier = UUID.randomUUID().toString();
        Cookie cookie = new Cookie(OIDC_REQUEST_IDENTIFIER, oidcRequestIdentifier);
        cookie.setPath("/");
        cookie.setHttpOnly(true);
        cookie.setMaxAge(60);
        cookie.setSecure(true);
        httpServletResponse.addCookie(cookie);
        State state = this.oidcService.createState(oidcRequestIdentifier);
        URI authorizationUri = UriBuilder.fromUri((URI)this.oidcService.getAuthorizationEndpoint()).queryParam("client_id", new Object[]{this.oidcService.getClientId()}).queryParam("response_type", new Object[]{"code"}).queryParam("scope", new Object[]{this.oidcService.getScope().toString()}).queryParam("state", new Object[]{state.getValue()}).queryParam("redirect_uri", new Object[]{callback}).build(new Object[0]);
        return authorizationUri;
    }

    private String determineLogoutMethod(String oidcDiscoveryUrl) {
        Matcher accessTokenMatcher = REVOKE_ACCESS_TOKEN_LOGOUT_FORMAT.matcher(oidcDiscoveryUrl);
        Matcher idTokenMatcher = ID_TOKEN_LOGOUT_FORMAT.matcher(oidcDiscoveryUrl);
        if (accessTokenMatcher.find()) {
            return REVOKE_ACCESS_TOKEN_LOGOUT;
        }
        if (idTokenMatcher.find()) {
            return ID_TOKEN_LOGOUT;
        }
        return STANDARD_LOGOUT;
    }

    private void revokeEndpointRequest(@Context HttpServletResponse httpServletResponse, String accessToken, URI revokeEndpoint) throws IOException {
        HttpPost httpPost = new HttpPost(revokeEndpoint);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("token", accessToken));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            if (response.getStatusLine().getStatusCode() == 200) {
                logger.debug("You are logged out of the OpenId Connect Provider.");
                String postLogoutRedirectUri = this.generateResourceUri(new String[]{"..", "nifi", "logout-complete"});
                httpServletResponse.sendRedirect(postLogoutRedirectUri);
            } else {
                logger.error("There was an error logging out of the OpenId Connect Provider. Response status: " + response.getStatusLine().getStatusCode());
            }
        }
    }

    @PreDestroy
    private final void closeClient() throws IOException {
        this.httpClient.close();
    }

    private AuthenticationResponse parseOidcResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean isLogin) throws Exception {
        String pageTitle = this.getForwardPageTitle(isLogin);
        if (!httpServletRequest.isSecure()) {
            this.forwardToMessagePage(httpServletRequest, httpServletResponse, pageTitle, "User authentication/authorization is only supported when running over HTTPS.");
            return null;
        }
        if (!this.oidcService.isOidcEnabled()) {
            this.forwardToMessagePage(httpServletRequest, httpServletResponse, pageTitle, OPEN_ID_CONNECT_SUPPORT_IS_NOT_CONFIGURED_MSG);
            return null;
        }
        String oidcRequestIdentifier = WebUtils.getCookie((HttpServletRequest)httpServletRequest, (String)OIDC_REQUEST_IDENTIFIER).getValue();
        if (oidcRequestIdentifier == null) {
            this.forwardToMessagePage(httpServletRequest, httpServletResponse, pageTitle, "The request identifier was not found in the request. Unable to continue.");
            return null;
        }
        try {
            AuthenticationResponse oidcResponse = AuthenticationResponseParser.parse((URI)this.getRequestUri());
            return oidcResponse;
        }
        catch (ParseException e) {
            logger.error("Unable to parse the redirect URI from the OpenId Connect Provider. Unable to continue login/logout process.");
            this.removeOidcRequestCookie(httpServletResponse);
            this.forwardToMessagePage(httpServletRequest, httpServletResponse, pageTitle, "Unable to parse the redirect URI from the OpenId Connect Provider. Unable to continue login/logout process.");
            return null;
        }
    }

    private void checkOidcState(HttpServletResponse httpServletResponse, String oidcRequestIdentifier, AuthenticationSuccessResponse successfulOidcResponse, boolean isLogin) throws Exception {
        State state = successfulOidcResponse.getState();
        if (state == null || !this.oidcService.isStateValid(oidcRequestIdentifier, state)) {
            logger.error("The state value returned by the OpenId Connect Provider does not match the stored state. Unable to continue login/logout process.");
            this.removeOidcRequestCookie(httpServletResponse);
            this.forwardToMessagePage(this.httpServletRequest, httpServletResponse, this.getForwardPageTitle(isLogin), "Purposed state does not match the stored state. Unable to continue login/logout process.");
            return;
        }
    }

    private String getForwardPageTitle(boolean isLogin) {
        return isLogin ? "Unable to continue login sequence" : "Unable to continue logout sequence";
    }

    private String getOidcCallback() {
        return this.generateResourceUri(new String[]{"access", "oidc", "callback"});
    }

    private String getOidcLogoutCallback() {
        return this.generateResourceUri(new String[]{"access", "oidc", "logoutCallback"});
    }

    private URI getRevokeEndpoint() {
        return this.oidcService.getRevocationEndpoint();
    }

    private void removeOidcRequestCookie(HttpServletResponse httpServletResponse) {
        this.removeCookie(httpServletResponse, OIDC_REQUEST_IDENTIFIER);
    }

    public void setOidcService(OidcService oidcService) {
        this.oidcService = oidcService;
    }

    public void setJwtService(JwtService jwtService) {
        this.jwtService = jwtService;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    protected NiFiProperties getProperties() {
        return this.properties;
    }
}

