/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.AuthorizeParameterReference;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ComponentAuthorizable;
import org.apache.nifi.authorization.ProcessGroupAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.registry.flow.FlowRegistryUtils;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.registry.flow.VersionedParameterContext;
import org.apache.nifi.registry.flow.VersionedProcessGroup;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.ResumeFlowException;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.FlowUpdateResource;
import org.apache.nifi.web.api.concurrent.AsyncRequestManager;
import org.apache.nifi.web.api.concurrent.AsynchronousWebRequest;
import org.apache.nifi.web.api.concurrent.RequestManager;
import org.apache.nifi.web.api.concurrent.StandardAsynchronousWebRequest;
import org.apache.nifi.web.api.concurrent.StandardUpdateStep;
import org.apache.nifi.web.api.concurrent.UpdateStep;
import org.apache.nifi.web.api.dto.AffectedComponentDTO;
import org.apache.nifi.web.api.dto.DtoFactory;
import org.apache.nifi.web.api.dto.FlowUpdateRequestDTO;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.entity.AffectedComponentEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.FlowUpdateRequestEntity;
import org.apache.nifi.web.api.entity.ProcessGroupDescriptorEntity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.util.AffectedComponentUtils;
import org.apache.nifi.web.util.CancellableTimedPause;
import org.apache.nifi.web.util.ComponentLifecycle;
import org.apache.nifi.web.util.InvalidComponentAction;
import org.apache.nifi.web.util.LifecycleManagementException;
import org.apache.nifi.web.util.Pause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class FlowUpdateResource<T extends ProcessGroupDescriptorEntity, U extends FlowUpdateRequestEntity>
extends ApplicationResource {
    private static final Logger logger = LoggerFactory.getLogger(FlowUpdateResource.class);
    protected NiFiServiceFacade serviceFacade;
    protected Authorizer authorizer;
    protected DtoFactory dtoFactory;
    protected ComponentLifecycle clusterComponentLifecycle;
    protected ComponentLifecycle localComponentLifecycle;
    protected RequestManager<T, T> requestManager = new AsyncRequestManager(100, TimeUnit.MINUTES.toMillis(1L), "Process Group Update Thread");

    protected abstract ProcessGroupEntity performUpdateFlow(String var1, Revision var2, T var3, VersionedFlowSnapshot var4, String var5, boolean var6, boolean var7);

    protected abstract Entity createReplicateUpdateFlowEntity(Revision var1, T var2, VersionedFlowSnapshot var3);

    protected abstract U createUpdateRequestEntity();

    protected abstract void finalizeCompletedUpdateRequest(U var1);

    protected Response initiateFlowUpdate(String groupId, T requestEntity, boolean allowDirtyFlowUpdate, String requestType, String replicateUriPath, Supplier<VersionedFlowSnapshot> flowSnapshotSupplier) {
        boolean replicateRequest;
        RevisionDTO revisionDto = requestEntity.getProcessGroupRevision();
        if (revisionDto == null) {
            throw new IllegalArgumentException("Process Group Revision must be specified");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestEntity.isDisconnectedNodeAcknowledged());
        }
        ComponentLifecycle componentLifecycle = (replicateRequest = this.isReplicateRequest()) ? this.clusterComponentLifecycle : this.localComponentLifecycle;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        VersionedFlowSnapshot flowSnapshot = flowSnapshotSupplier.get();
        this.serviceFacade.discoverCompatibleBundles(flowSnapshot.getFlowContents());
        this.serviceFacade.resolveInheritedControllerServices(flowSnapshot, groupId, user);
        Set affectedComponents = this.serviceFacade.getComponentsAffectedByFlowUpdate(groupId, flowSnapshot);
        InitiateUpdateFlowRequestWrapper requestWrapper = new InitiateUpdateFlowRequestWrapper(this, requestEntity, componentLifecycle, requestType, this.getAbsolutePath(), replicateUriPath, affectedComponents, replicateRequest, flowSnapshot);
        Revision requestRevision = this.getRevision(revisionDto, groupId);
        return this.withWriteLock(this.serviceFacade, (Entity)requestWrapper, requestRevision, lookup -> this.authorizeFlowUpdate(lookup, user, groupId, flowSnapshot), () -> this.serviceFacade.verifyCanUpdate(groupId, flowSnapshot, false, !allowDirtyFlowUpdate), (revision, wrapper) -> this.submitFlowUpdateRequest(user, groupId, revision, wrapper, allowDirtyFlowUpdate));
    }

    protected void authorizeFlowUpdate(AuthorizableLookup lookup, NiFiUser user, String groupId, VersionedFlowSnapshot flowSnapshot) {
        ProcessGroupAuthorizable groupAuthorizable = lookup.getProcessGroup(groupId);
        this.authorizeProcessGroup(groupAuthorizable, this.authorizer, lookup, RequestAction.READ, true, false, true, true, true);
        this.authorizeProcessGroup(groupAuthorizable, this.authorizer, lookup, RequestAction.WRITE, true, false, true, true, false);
        VersionedProcessGroup groupContents = flowSnapshot.getFlowContents();
        Set restrictedComponents = FlowRegistryUtils.getRestrictedComponents((VersionedProcessGroup)groupContents, (NiFiServiceFacade)this.serviceFacade);
        restrictedComponents.forEach(restrictedComponent -> {
            ComponentAuthorizable restrictedComponentAuthorizable = lookup.getConfigurableComponent(restrictedComponent);
            this.authorizeRestrictions(this.authorizer, restrictedComponentAuthorizable);
        });
        Map parameterContexts = flowSnapshot.getParameterContexts();
        if (parameterContexts != null) {
            parameterContexts.values().forEach(context -> AuthorizeParameterReference.authorizeParameterContextAddition((VersionedParameterContext)context, (NiFiServiceFacade)this.serviceFacade, (Authorizer)this.authorizer, (AuthorizableLookup)lookup, (NiFiUser)user));
        }
    }

    protected Response submitFlowUpdateRequest(NiFiUser user, String groupId, Revision revision, InitiateUpdateFlowRequestWrapper wrapper, boolean allowDirtyFlowUpdate) {
        String requestType = wrapper.getRequestType();
        String idGenerationSeed = this.getIdGenerationSeed().orElse(null);
        String requestId = UUID.randomUUID().toString();
        StandardAsynchronousWebRequest request = new StandardAsynchronousWebRequest(requestId, (Object)wrapper.getRequestEntity(), groupId, user, FlowUpdateResource.getUpdateFlowSteps());
        Consumer<AsynchronousWebRequest> updateTask = arg_0 -> this.lambda$submitFlowUpdateRequest$5(groupId, wrapper, revision, (AsynchronousWebRequest)request, idGenerationSeed, allowDirtyFlowUpdate, arg_0);
        this.requestManager.submitRequest(requestType, requestId, (AsynchronousWebRequest)request, updateTask);
        return this.createUpdateRequestResponse(requestType, requestId, (AsynchronousWebRequest)request, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFlow(String groupId, ComponentLifecycle componentLifecycle, URI requestUri, Set<AffectedComponentEntity> affectedComponents, boolean replicateRequest, String replicateUriPath, Revision revision, T requestEntity, VersionedFlowSnapshot flowSnapshot, AsynchronousWebRequest<T, T> asyncRequest, String idGenerationSeed, boolean allowDirtyFlowUpdate) throws LifecycleManagementException, ResumeFlowException {
        block28: {
            HashSet<String> stoppableReferenceTypes = new HashSet<String>();
            stoppableReferenceTypes.add("PROCESSOR");
            stoppableReferenceTypes.add("REMOTE_INPUT_PORT");
            stoppableReferenceTypes.add("REMOTE_OUTPUT_PORT");
            stoppableReferenceTypes.add("INPUT_PORT");
            stoppableReferenceTypes.add("OUTPUT_PORT");
            Set runningComponents = affectedComponents.stream().filter(dto -> stoppableReferenceTypes.contains(dto.getComponent().getReferenceType())).filter(dto -> "Running".equalsIgnoreCase(dto.getComponent().getState())).collect(Collectors.toSet());
            logger.info("Stopping {} Processors", (Object)runningComponents.size());
            CancellableTimedPause stopComponentsPause = new CancellableTimedPause(250L, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            asyncRequest.setCancelCallback(() -> ((CancellableTimedPause)stopComponentsPause).cancel());
            componentLifecycle.scheduleComponents(requestUri, groupId, runningComponents, ScheduledState.STOPPED, (Pause)stopComponentsPause, InvalidComponentAction.SKIP);
            if (asyncRequest.isCancelled()) {
                return;
            }
            asyncRequest.markStepComplete();
            Set enabledServices = affectedComponents.stream().filter(dto -> "CONTROLLER_SERVICE".equals(dto.getComponent().getReferenceType())).filter(dto -> "Enabled".equalsIgnoreCase(dto.getComponent().getState())).collect(Collectors.toSet());
            logger.info("Disabling {} Controller Services", (Object)enabledServices.size());
            CancellableTimedPause disableServicesPause = new CancellableTimedPause(250L, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            asyncRequest.setCancelCallback(() -> ((CancellableTimedPause)disableServicesPause).cancel());
            componentLifecycle.activateControllerServices(requestUri, groupId, enabledServices, ControllerServiceState.DISABLED, (Pause)disableServicesPause, InvalidComponentAction.SKIP);
            if (asyncRequest.isCancelled()) {
                return;
            }
            asyncRequest.markStepComplete();
            try {
                if (replicateRequest) {
                    NodeResponse clusterResponse;
                    NiFiUser user = NiFiUserUtils.getNiFiUser();
                    URI replicateUri = null;
                    try {
                        replicateUri = new URI(requestUri.getScheme(), requestUri.getUserInfo(), requestUri.getHost(), requestUri.getPort(), replicateUriPath, null, requestUri.getFragment());
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                    HashMap<String, String> headers = new HashMap<String, String>();
                    headers.put("content-type", "application/json");
                    Entity replicateEntity = this.createReplicateUpdateFlowEntity(revision, requestEntity, flowSnapshot);
                    try {
                        logger.debug("Replicating PUT request to {} for user {}", (Object)replicateUri, (Object)user);
                        clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate(user, "PUT", replicateUri, (Object)replicateEntity, headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), user, "PUT", replicateUri, (Object)replicateEntity, headers).awaitMergedResponse();
                    }
                    catch (InterruptedException ie) {
                        logger.warn("Interrupted while replicating PUT request to {} for user {}", (Object)replicateUri, (Object)user);
                        Thread.currentThread().interrupt();
                        throw new LifecycleManagementException("Interrupted while updating flows across cluster", (Throwable)ie);
                    }
                    int updateFlowStatus = clusterResponse.getStatus();
                    if (updateFlowStatus != Response.Status.OK.getStatusCode()) {
                        String explanation = (String)this.getResponseEntity(clusterResponse, String.class);
                        logger.error("Failed to update flow across cluster when replicating PUT request to {} for user {}. Received {} response with explanation: {}", new Object[]{replicateUri, user, updateFlowStatus, explanation});
                        throw new LifecycleManagementException("Failed to update Flow on all nodes in cluster due to " + explanation);
                    }
                    break block28;
                }
                this.serviceFacade.verifyCanUpdate(groupId, flowSnapshot, true, !allowDirtyFlowUpdate);
                this.performUpdateFlow(groupId, revision, requestEntity, flowSnapshot, idGenerationSeed, !allowDirtyFlowUpdate, true);
            }
            finally {
                if (!asyncRequest.isCancelled()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Re-Enabling {} Controller Services: {}", (Object)enabledServices.size(), enabledServices);
                    }
                    asyncRequest.markStepComplete();
                    CancellableTimedPause enableServicesPause = new CancellableTimedPause(250L, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                    asyncRequest.setCancelCallback(() -> ((CancellableTimedPause)enableServicesPause).cancel());
                    Set servicesToEnable = this.getUpdatedEntities(enabledServices);
                    logger.info("Successfully updated flow; re-enabling {} Controller Services", (Object)servicesToEnable.size());
                    try {
                        componentLifecycle.activateControllerServices(requestUri, groupId, servicesToEnable, ControllerServiceState.ENABLED, (Pause)enableServicesPause, InvalidComponentAction.SKIP);
                    }
                    catch (IllegalStateException ise) {
                        throw new ResumeFlowException("Successfully updated flow but could not re-enable all Controller Services because " + ise.getMessage(), (Throwable)ise);
                    }
                }
                if (!asyncRequest.isCancelled()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Restart {} Processors: {}", (Object)runningComponents.size(), runningComponents);
                    }
                    asyncRequest.markStepComplete();
                    Set componentsToStart = this.getUpdatedEntities(runningComponents);
                    HashSet<AffectedComponentEntity> avoidStarting = new HashSet<AffectedComponentEntity>();
                    for (AffectedComponentEntity componentEntity : componentsToStart) {
                        boolean startComponent;
                        AffectedComponentDTO componentDto = componentEntity.getComponent();
                        String referenceType = componentDto.getReferenceType();
                        if (!"REMOTE_INPUT_PORT".equals(referenceType) && !"REMOTE_OUTPUT_PORT".equals(referenceType)) continue;
                        try {
                            startComponent = this.serviceFacade.isRemoteGroupPortConnected(componentDto.getProcessGroupId(), componentDto.getId());
                        }
                        catch (ResourceNotFoundException rnfe) {
                            startComponent = false;
                        }
                        if (startComponent) continue;
                        avoidStarting.add(componentEntity);
                    }
                    componentsToStart.removeAll(avoidStarting);
                    CancellableTimedPause startComponentsPause = new CancellableTimedPause(250L, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                    asyncRequest.setCancelCallback(() -> ((CancellableTimedPause)startComponentsPause).cancel());
                    logger.info("Restarting {} Processors", (Object)componentsToStart.size());
                    try {
                        componentLifecycle.scheduleComponents(requestUri, groupId, componentsToStart, ScheduledState.RUNNING, (Pause)startComponentsPause, InvalidComponentAction.SKIP);
                    }
                    catch (IllegalStateException ise) {
                        throw new ResumeFlowException("Successfully updated flow but could not restart all Processors because " + ise.getMessage(), (Throwable)ise);
                    }
                }
            }
        }
        asyncRequest.setCancelCallback(null);
    }

    private static List<UpdateStep> getUpdateFlowSteps() {
        ArrayList<UpdateStep> updateSteps = new ArrayList<UpdateStep>();
        updateSteps.add((UpdateStep)new StandardUpdateStep("Stopping Affected Processors"));
        updateSteps.add((UpdateStep)new StandardUpdateStep("Disabling Affected Controller Services"));
        updateSteps.add((UpdateStep)new StandardUpdateStep("Updating Flow"));
        updateSteps.add((UpdateStep)new StandardUpdateStep("Re-Enabling Controller Services"));
        updateSteps.add((UpdateStep)new StandardUpdateStep("Restarting Affected Processors"));
        return updateSteps;
    }

    protected <T> T getResponseEntity(NodeResponse nodeResponse, Class<T> clazz) {
        Object entity = nodeResponse.getUpdatedEntity();
        if (entity == null) {
            entity = nodeResponse.getClientResponse().readEntity(clazz);
        }
        return (T)entity;
    }

    protected Set<AffectedComponentEntity> getUpdatedEntities(Set<AffectedComponentEntity> originalEntities) {
        LinkedHashSet<AffectedComponentEntity> entities = new LinkedHashSet<AffectedComponentEntity>();
        for (AffectedComponentEntity original : originalEntities) {
            try {
                AffectedComponentEntity updatedEntity = AffectedComponentUtils.updateEntity((AffectedComponentEntity)original, (NiFiServiceFacade)this.serviceFacade, (DtoFactory)this.dtoFactory);
                if (updatedEntity == null) continue;
                entities.add(updatedEntity);
            }
            catch (ResourceNotFoundException resourceNotFoundException) {}
        }
        return entities;
    }

    protected Response retrieveFlowUpdateRequest(String requestType, String requestId) {
        if (requestId == null) {
            throw new IllegalArgumentException("Request ID must be specified.");
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        AsynchronousWebRequest asyncRequest = this.requestManager.getRequest(requestType, requestId, user);
        return this.createUpdateRequestResponse(requestType, requestId, asyncRequest, true);
    }

    protected Response deleteFlowUpdateRequest(String requestType, String requestId, boolean disconnectedNodeAcknowledged) {
        NiFiUser user;
        AsynchronousWebRequest asyncRequest;
        if (requestId == null) {
            throw new IllegalArgumentException("Request ID must be specified.");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(Boolean.valueOf(disconnectedNodeAcknowledged));
        }
        if (!(asyncRequest = this.requestManager.removeRequest(requestType, requestId, user = NiFiUserUtils.getNiFiUser())).isComplete()) {
            asyncRequest.cancel();
        }
        return this.createUpdateRequestResponse(requestType, requestId, asyncRequest, true);
    }

    protected Response createUpdateRequestResponse(String requestType, String requestId, AsynchronousWebRequest<T, T> asyncRequest, boolean finalizeCompletedRequest) {
        String groupId = asyncRequest.getComponentId();
        FlowUpdateRequestEntity updateRequestEntity = this.createUpdateRequestEntity();
        RevisionDTO groupRevision = this.serviceFacade.getProcessGroup(groupId).getRevision();
        updateRequestEntity.setProcessGroupRevision(groupRevision);
        FlowUpdateRequestDTO updateRequestDto = updateRequestEntity.getRequest();
        updateRequestDto.setComplete(asyncRequest.isComplete());
        updateRequestDto.setFailureReason(asyncRequest.getFailureReason());
        updateRequestDto.setLastUpdated(asyncRequest.getLastUpdated());
        updateRequestDto.setProcessGroupId(groupId);
        updateRequestDto.setRequestId(requestId);
        updateRequestDto.setUri(this.generateResourceUri(new String[]{this.getRequestPathFirstSegment(), requestType, requestId}));
        updateRequestDto.setPercentCompleted(asyncRequest.getPercentComplete());
        updateRequestDto.setState(asyncRequest.getState());
        if (finalizeCompletedRequest) {
            this.finalizeCompletedUpdateRequest(updateRequestEntity);
        }
        return this.generateOkResponse((Object)updateRequestEntity).build();
    }

    protected String getRequestPathFirstSegment() {
        return ((PathSegment)this.uriInfo.getPathSegments().get(0)).getPath();
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void setDtoFactory(DtoFactory dtoFactory) {
        this.dtoFactory = dtoFactory;
    }

    public void setClusterComponentLifecycle(ComponentLifecycle componentLifecycle) {
        this.clusterComponentLifecycle = componentLifecycle;
    }

    public void setLocalComponentLifecycle(ComponentLifecycle componentLifecycle) {
        this.localComponentLifecycle = componentLifecycle;
    }

    private /* synthetic */ void lambda$submitFlowUpdateRequest$5(String groupId, InitiateUpdateFlowRequestWrapper wrapper, Revision revision, AsynchronousWebRequest request, String idGenerationSeed, boolean allowDirtyFlowUpdate, AsynchronousWebRequest vcur) {
        try {
            this.updateFlow(groupId, wrapper.getComponentLifecycle(), wrapper.getRequestUri(), wrapper.getAffectedComponents(), wrapper.isReplicateRequest(), wrapper.getReplicateUriPath(), revision, wrapper.getRequestEntity(), wrapper.getFlowSnapshot(), request, idGenerationSeed, allowDirtyFlowUpdate);
            vcur.markStepComplete();
        }
        catch (ResumeFlowException rfe) {
            logger.warn(rfe.getMessage(), (Throwable)rfe);
            vcur.fail(rfe.getMessage());
        }
        catch (Exception e) {
            logger.error("Failed to perform update flow request ", (Throwable)e);
            vcur.fail("Failed to perform update flow request due to " + e.getMessage());
        }
    }
}

