/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.AuthorizeControllerServiceReference;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ComponentAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.web.IllegalClusterResourceRequestException;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.ControllerResource;
import org.apache.nifi.web.api.ControllerServiceResource;
import org.apache.nifi.web.api.ReportingTaskResource;
import org.apache.nifi.web.api.dto.BulletinDTO;
import org.apache.nifi.web.api.dto.ClusterDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.NodeDTO;
import org.apache.nifi.web.api.dto.RegistryDTO;
import org.apache.nifi.web.api.dto.ReportingTaskDTO;
import org.apache.nifi.web.api.entity.BulletinEntity;
import org.apache.nifi.web.api.entity.ClusterEntity;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.ComponentHistoryEntity;
import org.apache.nifi.web.api.entity.ControllerConfigurationEntity;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.HistoryEntity;
import org.apache.nifi.web.api.entity.NodeEntity;
import org.apache.nifi.web.api.entity.RegistryClientEntity;
import org.apache.nifi.web.api.entity.RegistryClientsEntity;
import org.apache.nifi.web.api.entity.ReportingTaskEntity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.DateTimeParameter;
import org.apache.nifi.web.api.request.LongParameter;

@Path(value="/controller")
@Api(value="/controller", description="Provides realtime command and control of this NiFi instance")
public class ControllerResource
extends ApplicationResource {
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;
    private ReportingTaskResource reportingTaskResource;
    private ControllerServiceResource controllerServiceResource;

    public RegistryClientEntity populateRemainingRegistryEntityContent(RegistryClientEntity registryClientEntity) {
        registryClientEntity.setUri(this.generateResourceUri(new String[]{"controller", "registry-clients", registryClientEntity.getId()}));
        return registryClientEntity;
    }

    private void authorizeController(RequestAction action) {
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable controller = lookup.getController();
            controller.authorize(this.authorizer, action, NiFiUserUtils.getNiFiUser());
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="config")
    @ApiOperation(value="Retrieves the configuration for this NiFi Controller", response=ControllerConfigurationEntity.class, authorizations={@Authorization(value="Read - /controller")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getControllerConfig() {
        this.authorizeController(RequestAction.READ);
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ControllerConfigurationEntity entity = this.serviceFacade.getControllerConfiguration();
        return this.generateOkResponse((Object)entity).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="config")
    @ApiOperation(value="Retrieves the configuration for this NiFi", response=ControllerConfigurationEntity.class, authorizations={@Authorization(value="Write - /controller")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateControllerConfig(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The controller configuration.", required=true) ControllerConfigurationEntity requestConfigEntity) {
        if (requestConfigEntity == null || requestConfigEntity.getComponent() == null) {
            throw new IllegalArgumentException("Controller configuration must be specified");
        }
        if (requestConfigEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestConfigEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestConfigEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision(requestConfigEntity.getRevision(), FlowController.class.getSimpleName());
        return this.withWriteLock(this.serviceFacade, (Entity)requestConfigEntity, requestRevision, lookup -> this.authorizeController(RequestAction.WRITE), null, (revision, configEntity) -> {
            ControllerConfigurationEntity entity = this.serviceFacade.updateControllerConfiguration(revision, configEntity.getComponent());
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="reporting-tasks")
    @ApiOperation(value="Creates a new reporting task", response=ReportingTaskEntity.class, authorizations={@Authorization(value="Write - /controller"), @Authorization(value="Read - any referenced Controller Services - /controller-services/{uuid}"), @Authorization(value="Write - if the Reporting Task is restricted - /restricted-components")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createReportingTask(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The reporting task configuration details.", required=true) ReportingTaskEntity requestReportingTaskEntity) {
        if (requestReportingTaskEntity == null || requestReportingTaskEntity.getComponent() == null) {
            throw new IllegalArgumentException("Reporting task details must be specified.");
        }
        if (requestReportingTaskEntity.getRevision() == null || requestReportingTaskEntity.getRevision().getVersion() == null || requestReportingTaskEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Reporting task.");
        }
        ReportingTaskDTO requestReportingTask = requestReportingTaskEntity.getComponent();
        if (requestReportingTask.getId() != null) {
            throw new IllegalArgumentException("Reporting task ID cannot be specified.");
        }
        if (StringUtils.isBlank((CharSequence)requestReportingTask.getType())) {
            throw new IllegalArgumentException("The type of reporting task to create must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestReportingTaskEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestReportingTaskEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestReportingTaskEntity, lookup -> {
            this.authorizeController(RequestAction.WRITE);
            ComponentAuthorizable authorizable = null;
            try {
                authorizable = lookup.getConfigurableComponent(requestReportingTask.getType(), requestReportingTask.getBundle());
                if (authorizable.isRestricted()) {
                    this.authorizeRestrictions(this.authorizer, authorizable);
                }
                if (requestReportingTask.getProperties() != null) {
                    AuthorizeControllerServiceReference.authorizeControllerServiceReferences((Map)requestReportingTask.getProperties(), (ComponentAuthorizable)authorizable, (Authorizer)this.authorizer, (AuthorizableLookup)lookup);
                }
            }
            finally {
                if (authorizable != null) {
                    authorizable.cleanUpResources();
                }
            }
        }, () -> this.serviceFacade.verifyCreateReportingTask(requestReportingTask), reportingTaskEntity -> {
            ReportingTaskDTO reportingTask = reportingTaskEntity.getComponent();
            reportingTask.setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)reportingTaskEntity, reportingTask.getId());
            ReportingTaskEntity entity = this.serviceFacade.createReportingTask(revision, reportingTask);
            this.reportingTaskResource.populateRemainingReportingTaskEntityContent(entity);
            return this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="registry-clients")
    @ApiOperation(value="Gets the listing of available registry clients", response=RegistryClientsEntity.class, authorizations={@Authorization(value="Read - /flow")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getRegistryClients() {
        this.authorizeController(RequestAction.READ);
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        Set registries = this.serviceFacade.getRegistryClients();
        registries.forEach(registry -> this.populateRemainingRegistryEntityContent(registry));
        RegistryClientsEntity registryEntities = new RegistryClientsEntity();
        registryEntities.setRegistries(registries);
        return this.generateOkResponse((Object)registryEntities).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="registry-clients")
    @ApiOperation(value="Creates a new registry client", response=RegistryClientEntity.class, authorizations={@Authorization(value="Write - /controller")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createRegistryClient(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The registry configuration details.", required=true) RegistryClientEntity requestRegistryClientEntity) {
        if (requestRegistryClientEntity == null || requestRegistryClientEntity.getComponent() == null) {
            throw new IllegalArgumentException("Registry details must be specified.");
        }
        if (requestRegistryClientEntity.getRevision() == null || requestRegistryClientEntity.getRevision().getVersion() == null || requestRegistryClientEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Registry.");
        }
        RegistryDTO requestRegistryClient = requestRegistryClientEntity.getComponent();
        if (requestRegistryClient.getId() != null) {
            throw new IllegalArgumentException("Registry ID cannot be specified.");
        }
        if (StringUtils.isBlank((CharSequence)requestRegistryClient.getName())) {
            throw new IllegalArgumentException("Registry name must be specified.");
        }
        if (StringUtils.isBlank((CharSequence)requestRegistryClient.getUri())) {
            throw new IllegalArgumentException("Registry URL must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestRegistryClientEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestRegistryClientEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestRegistryClientEntity, lookup -> this.authorizeController(RequestAction.WRITE), null, registryEntity -> {
            RegistryDTO registry = registryEntity.getComponent();
            registry.setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)registryEntity, registry.getId());
            RegistryClientEntity entity = this.serviceFacade.createRegistryClient(revision, registry);
            this.populateRemainingRegistryEntityContent(entity);
            return this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/registry-clients/{id}")
    @ApiOperation(value="Gets a registry client", response=RegistryClientEntity.class, authorizations={@Authorization(value="Read - /controller")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getRegistryClient(@ApiParam(value="The registry id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.authorizeController(RequestAction.READ);
        RegistryClientEntity entity = this.serviceFacade.getRegistryClient(id);
        this.populateRemainingRegistryEntityContent(entity);
        return this.generateOkResponse((Object)entity).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/registry-clients/{id}")
    @ApiOperation(value="Updates a registry client", response=RegistryClientEntity.class, authorizations={@Authorization(value="Write - /controller")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateRegistryClient(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The registry id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The registry configuration details.", required=true) RegistryClientEntity requestRegistryEntity) {
        if (requestRegistryEntity == null || requestRegistryEntity.getComponent() == null) {
            throw new IllegalArgumentException("Registry details must be specified.");
        }
        if (requestRegistryEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        RegistryDTO requestRegistryClient = requestRegistryEntity.getComponent();
        if (!id.equals(requestRegistryClient.getId())) {
            throw new IllegalArgumentException(String.format("The registry id (%s) in the request body does not equal the registry id of the requested resource (%s).", requestRegistryClient.getId(), id));
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestRegistryEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestRegistryEntity.isDisconnectedNodeAcknowledged());
        }
        if (requestRegistryClient.getName() != null && StringUtils.isBlank((CharSequence)requestRegistryClient.getName())) {
            throw new IllegalArgumentException("Registry name must be specified.");
        }
        if (requestRegistryClient.getUri() != null && StringUtils.isBlank((CharSequence)requestRegistryClient.getUri())) {
            throw new IllegalArgumentException("Registry URL must be specified.");
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestRegistryEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestRegistryEntity, requestRevision, lookup -> this.authorizeController(RequestAction.WRITE), null, (revision, registryEntity) -> {
            RegistryDTO registry = registryEntity.getComponent();
            RegistryClientEntity entity = this.serviceFacade.updateRegistryClient(revision, registry);
            this.populateRemainingRegistryEntityContent(entity);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/registry-clients/{id}")
    @ApiOperation(value="Deletes a registry client", response=RegistryClientEntity.class, authorizations={@Authorization(value="Write - /controller")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response deleteRegistryClient(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The revision is used to verify the client is working with the latest version of the flow.", required=false) @QueryParam(value="version") LongParameter version, @ApiParam(value="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.", required=false) @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @ApiParam(value="Acknowledges that this node is disconnected to allow for mutable requests to proceed.", required=false) @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @ApiParam(value="The registry id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        RegistryClientEntity requestRegistryClientEntity = new RegistryClientEntity();
        requestRegistryClientEntity.setId(id);
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestRegistryClientEntity, requestRevision, lookup -> this.authorizeController(RequestAction.WRITE), () -> this.serviceFacade.verifyDeleteRegistry(id), (revision, registryEntity) -> {
            RegistryClientEntity entity = this.serviceFacade.deleteRegistryClient(revision, registryEntity.getId());
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="bulletin")
    @ApiOperation(value="Creates a new bulletin", response=BulletinEntity.class, authorizations={@Authorization(value="Write - /controller")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createBulletin(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The reporting task configuration details.", required=true) BulletinEntity requestBulletinEntity) {
        if (requestBulletinEntity == null || requestBulletinEntity.getBulletin() == null) {
            throw new IllegalArgumentException("Bulletin details must be specified.");
        }
        BulletinDTO requestBulletin = requestBulletinEntity.getBulletin();
        if (requestBulletin.getId() != null) {
            throw new IllegalArgumentException("A bulletin ID cannot be specified.");
        }
        if (StringUtils.isBlank((CharSequence)requestBulletin.getMessage())) {
            throw new IllegalArgumentException("The bulletin message must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestBulletinEntity);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestBulletinEntity, lookup -> this.authorizeController(RequestAction.WRITE), null, bulletinEntity -> {
            BulletinDTO bulletin = bulletinEntity.getBulletin();
            BulletinEntity entity = this.serviceFacade.createBulletin(bulletin, Boolean.valueOf(true));
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="controller-services")
    @ApiOperation(value="Creates a new controller service", response=ControllerServiceEntity.class, authorizations={@Authorization(value="Write - /controller"), @Authorization(value="Read - any referenced Controller Services - /controller-services/{uuid}"), @Authorization(value="Write - if the Controller Service is restricted - /restricted-components")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createControllerService(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The controller service configuration details.", required=true) ControllerServiceEntity requestControllerServiceEntity) {
        if (requestControllerServiceEntity == null || requestControllerServiceEntity.getComponent() == null) {
            throw new IllegalArgumentException("Controller service details must be specified.");
        }
        if (requestControllerServiceEntity.getRevision() == null || requestControllerServiceEntity.getRevision().getVersion() == null || requestControllerServiceEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Controller service.");
        }
        ControllerServiceDTO requestControllerService = requestControllerServiceEntity.getComponent();
        if (requestControllerService.getId() != null) {
            throw new IllegalArgumentException("Controller service ID cannot be specified.");
        }
        if (requestControllerService.getParentGroupId() != null) {
            throw new IllegalArgumentException("Parent process group ID cannot be specified.");
        }
        if (StringUtils.isBlank((CharSequence)requestControllerService.getType())) {
            throw new IllegalArgumentException("The type of controller service to create must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestControllerServiceEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestControllerServiceEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestControllerServiceEntity, lookup -> {
            this.authorizeController(RequestAction.WRITE);
            ComponentAuthorizable authorizable = null;
            try {
                authorizable = lookup.getConfigurableComponent(requestControllerService.getType(), requestControllerService.getBundle());
                if (authorizable.isRestricted()) {
                    this.authorizeRestrictions(this.authorizer, authorizable);
                }
                if (requestControllerService.getProperties() != null) {
                    AuthorizeControllerServiceReference.authorizeControllerServiceReferences((Map)requestControllerService.getProperties(), (ComponentAuthorizable)authorizable, (Authorizer)this.authorizer, (AuthorizableLookup)lookup);
                }
            }
            finally {
                if (authorizable != null) {
                    authorizable.cleanUpResources();
                }
            }
        }, () -> this.serviceFacade.verifyCreateControllerService(requestControllerService), controllerServiceEntity -> {
            ControllerServiceDTO controllerService = controllerServiceEntity.getComponent();
            controllerService.setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)controllerServiceEntity, controllerService.getId());
            ControllerServiceEntity entity = this.serviceFacade.createControllerService(revision, null, controllerService);
            this.controllerServiceResource.populateRemainingControllerServiceEntityContent(entity);
            return this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="cluster")
    @ApiOperation(value="Gets the contents of the cluster", notes="Returns the contents of the cluster including all nodes and their status.", response=ClusterEntity.class, authorizations={@Authorization(value="Read - /controller")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getCluster() {
        this.authorizeController(RequestAction.READ);
        if (!this.isConnectedToCluster()) {
            throw new IllegalClusterResourceRequestException("Only a node connected to a cluster can process the request.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("GET", this.getClusterCoordinatorNode());
        }
        ClusterDTO dto = this.serviceFacade.getCluster();
        ClusterEntity entity = new ClusterEntity();
        entity.setCluster(dto);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="cluster/nodes/{id}")
    @ApiOperation(value="Gets a node in the cluster", response=NodeEntity.class, authorizations={@Authorization(value="Read - /controller")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getNode(@ApiParam(value="The node id.", required=true) @PathParam(value="id") String id) {
        this.authorizeController(RequestAction.READ);
        if (!this.isConnectedToCluster()) {
            throw new IllegalClusterResourceRequestException("Only a node connected to a cluster can process the request.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("GET", this.getClusterCoordinatorNode());
        }
        NodeDTO dto = this.serviceFacade.getNode(id);
        NodeEntity entity = new NodeEntity();
        entity.setNode(dto);
        return this.generateOkResponse((Object)entity).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="cluster/nodes/{id}")
    @ApiOperation(value="Updates a node in the cluster", response=NodeEntity.class, authorizations={@Authorization(value="Write - /controller")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateNode(@ApiParam(value="The node id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The node configuration. The only configuration that will be honored at this endpoint is the status.", required=true) NodeEntity nodeEntity) {
        this.authorizeController(RequestAction.WRITE);
        if (!this.isConnectedToCluster()) {
            throw new IllegalClusterResourceRequestException("Only a node connected to a cluster can process the request.");
        }
        if (nodeEntity == null || nodeEntity.getNode() == null) {
            throw new IllegalArgumentException("Node details must be specified.");
        }
        NodeDTO requestNodeDTO = nodeEntity.getNode();
        if (!id.equals(requestNodeDTO.getNodeId())) {
            throw new IllegalArgumentException(String.format("The node id (%s) in the request body does not equal the node id of the requested resource (%s).", requestNodeDTO.getNodeId(), id));
        }
        if (this.isReplicateRequest()) {
            return this.replicateToCoordinator("PUT", (Object)nodeEntity);
        }
        NodeDTO node = this.serviceFacade.updateNode(requestNodeDTO);
        NodeEntity entity = new NodeEntity();
        entity.setNode(node);
        return this.generateOkResponse((Object)entity).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="cluster/nodes/{id}")
    @ApiOperation(value="Removes a node from the cluster", response=NodeEntity.class, authorizations={@Authorization(value="Write - /controller")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response deleteNode(@ApiParam(value="The node id.", required=true) @PathParam(value="id") String id) {
        this.authorizeController(RequestAction.WRITE);
        if (!this.isConnectedToCluster()) {
            throw new IllegalClusterResourceRequestException("Only a node connected to a cluster can process the request.");
        }
        if (this.isReplicateRequest()) {
            return this.replicateToCoordinator("DELETE", (Object)this.getRequestParameters());
        }
        this.serviceFacade.deleteNode(id);
        NodeEntity entity = new NodeEntity();
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="status/history")
    @ApiOperation(value="Gets status history for the node", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=ComponentHistoryEntity.class, authorizations={@Authorization(value="Read - /controller")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getNodeStatusHistory() {
        this.authorizeController(RequestAction.READ);
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        return this.generateOkResponse((Object)this.serviceFacade.getNodeStatusHistory()).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="history")
    @ApiOperation(value="Purges history", response=HistoryEntity.class, authorizations={@Authorization(value="Write - /controller")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response deleteHistory(@Context HttpServletRequest httpServletRequest, @ApiParam(value="Purge actions before this date/time.", required=true) @QueryParam(value="endDate") DateTimeParameter endDate) {
        if (endDate == null) {
            throw new IllegalArgumentException("The end date must be specified.");
        }
        return this.withWriteLock(this.serviceFacade, (Entity)new EndDateEntity(this, endDate.getDateTime()), lookup -> this.authorizeController(RequestAction.WRITE), null, endDateEntity -> {
            this.serviceFacade.deleteActions(endDateEntity.getEndDate());
            return this.generateOkResponse((Object)new HistoryEntity()).build();
        });
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setReportingTaskResource(ReportingTaskResource reportingTaskResource) {
        this.reportingTaskResource = reportingTaskResource;
    }

    public void setControllerServiceResource(ControllerServiceResource controllerServiceResource) {
        this.controllerServiceResource = controllerServiceResource;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

