/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web;

import com.google.common.collect.Sets;
import io.prometheus.client.CollectorRegistry;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.Component;
import org.apache.nifi.action.FlowChangeAction;
import org.apache.nifi.action.Operation;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.action.details.FlowChangePurgeDetails;
import org.apache.nifi.admin.service.AuditService;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.AccessPolicy;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.AuthorizationRequest;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.AuthorizeAccess;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.User;
import org.apache.nifi.authorization.UserContextKeys;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.EnforcePolicyPermissionsThroughBaseResource;
import org.apache.nifi.authorization.resource.OperationAuthorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.heartbeat.HeartbeatMonitor;
import org.apache.nifi.cluster.coordination.heartbeat.NodeHeartbeat;
import org.apache.nifi.cluster.coordination.node.ClusterRoles;
import org.apache.nifi.cluster.coordination.node.DisconnectionCode;
import org.apache.nifi.cluster.coordination.node.NodeConnectionState;
import org.apache.nifi.cluster.coordination.node.NodeConnectionStatus;
import org.apache.nifi.cluster.coordination.node.OffloadCode;
import org.apache.nifi.cluster.manager.exception.IllegalNodeDeletionException;
import org.apache.nifi.cluster.manager.exception.UnknownNodeException;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.components.validation.ValidationState;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.Counter;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.Snippet;
import org.apache.nifi.controller.Template;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.leader.election.LeaderElectionManager;
import org.apache.nifi.controller.repository.FlowFileEvent;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.repository.claim.ContentDirection;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceReference;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.analytics.StatusAnalytics;
import org.apache.nifi.diagnostics.SystemDiagnostics;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.ProcessGroupCounts;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.history.History;
import org.apache.nifi.history.HistoryQuery;
import org.apache.nifi.history.PreviousValue;
import org.apache.nifi.metrics.jvm.JmxJvmMetrics;
import org.apache.nifi.metrics.jvm.JvmMetrics;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterDescriptor;
import org.apache.nifi.parameter.ParameterReferenceManager;
import org.apache.nifi.parameter.StandardParameterContext;
import org.apache.nifi.prometheus.util.BulletinMetricsRegistry;
import org.apache.nifi.prometheus.util.ConnectionAnalyticsMetricsRegistry;
import org.apache.nifi.prometheus.util.JvmMetricsRegistry;
import org.apache.nifi.prometheus.util.NiFiMetricsRegistry;
import org.apache.nifi.prometheus.util.PrometheusMetricsUtil;
import org.apache.nifi.registry.ComponentVariableRegistry;
import org.apache.nifi.registry.authorization.Permissions;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.flow.Bundle;
import org.apache.nifi.registry.flow.ComponentType;
import org.apache.nifi.registry.flow.ExternalControllerServiceReference;
import org.apache.nifi.registry.flow.FlowRegistry;
import org.apache.nifi.registry.flow.FlowRegistryClient;
import org.apache.nifi.registry.flow.VersionControlInformation;
import org.apache.nifi.registry.flow.VersionedComponent;
import org.apache.nifi.registry.flow.VersionedConfigurableComponent;
import org.apache.nifi.registry.flow.VersionedConnection;
import org.apache.nifi.registry.flow.VersionedControllerService;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowCoordinates;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.registry.flow.VersionedFlowSnapshotMetadata;
import org.apache.nifi.registry.flow.VersionedFlowState;
import org.apache.nifi.registry.flow.VersionedParameterContext;
import org.apache.nifi.registry.flow.VersionedProcessGroup;
import org.apache.nifi.registry.flow.VersionedProcessor;
import org.apache.nifi.registry.flow.VersionedPropertyDescriptor;
import org.apache.nifi.registry.flow.diff.ComparableDataFlow;
import org.apache.nifi.registry.flow.diff.ConciseEvolvingDifferenceDescriptor;
import org.apache.nifi.registry.flow.diff.DifferenceDescriptor;
import org.apache.nifi.registry.flow.diff.DifferenceType;
import org.apache.nifi.registry.flow.diff.FlowComparison;
import org.apache.nifi.registry.flow.diff.FlowDifference;
import org.apache.nifi.registry.flow.diff.StandardComparableDataFlow;
import org.apache.nifi.registry.flow.diff.StandardFlowComparator;
import org.apache.nifi.registry.flow.diff.StaticDifferenceDescriptor;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedComponent;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedControllerService;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedPort;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedProcessGroup;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedProcessor;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedRemoteGroupPort;
import org.apache.nifi.registry.flow.mapping.NiFiRegistryFlowMapper;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinQuery;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.util.BundleUtils;
import org.apache.nifi.util.FlowDifferenceFilters;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.StringUtils;
import org.apache.nifi.web.DownloadableContent;
import org.apache.nifi.web.FlowModification;
import org.apache.nifi.web.InvalidRevisionException;
import org.apache.nifi.web.NiFiCoreException;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.StandardNiFiServiceFacade;
import org.apache.nifi.web.api.dto.AccessPolicyDTO;
import org.apache.nifi.web.api.dto.AccessPolicySummaryDTO;
import org.apache.nifi.web.api.dto.AffectedComponentDTO;
import org.apache.nifi.web.api.dto.BucketDTO;
import org.apache.nifi.web.api.dto.BulletinBoardDTO;
import org.apache.nifi.web.api.dto.BulletinDTO;
import org.apache.nifi.web.api.dto.BulletinQueryDTO;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ClusterDTO;
import org.apache.nifi.web.api.dto.ComponentDTO;
import org.apache.nifi.web.api.dto.ComponentHistoryDTO;
import org.apache.nifi.web.api.dto.ComponentReferenceDTO;
import org.apache.nifi.web.api.dto.ComponentRestrictionPermissionDTO;
import org.apache.nifi.web.api.dto.ComponentStateDTO;
import org.apache.nifi.web.api.dto.ComponentValidationResultDTO;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.ControllerConfigurationDTO;
import org.apache.nifi.web.api.dto.ControllerDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.ControllerServiceReferencingComponentDTO;
import org.apache.nifi.web.api.dto.CounterDTO;
import org.apache.nifi.web.api.dto.CountersDTO;
import org.apache.nifi.web.api.dto.CountersSnapshotDTO;
import org.apache.nifi.web.api.dto.DocumentedTypeDTO;
import org.apache.nifi.web.api.dto.DropRequestDTO;
import org.apache.nifi.web.api.dto.DtoFactory;
import org.apache.nifi.web.api.dto.EntityFactory;
import org.apache.nifi.web.api.dto.FlowConfigurationDTO;
import org.apache.nifi.web.api.dto.FlowFileDTO;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.FunnelDTO;
import org.apache.nifi.web.api.dto.LabelDTO;
import org.apache.nifi.web.api.dto.ListingRequestDTO;
import org.apache.nifi.web.api.dto.NodeDTO;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.dto.ParameterDTO;
import org.apache.nifi.web.api.dto.PermissionsDTO;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.api.dto.PreviousValueDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.ProcessorRunStatusDetailsDTO;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;
import org.apache.nifi.web.api.dto.PropertyHistoryDTO;
import org.apache.nifi.web.api.dto.RegistryDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupPortDTO;
import org.apache.nifi.web.api.dto.ReportingTaskDTO;
import org.apache.nifi.web.api.dto.RequiredPermissionDTO;
import org.apache.nifi.web.api.dto.ResourceDTO;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.dto.SnippetDTO;
import org.apache.nifi.web.api.dto.SystemDiagnosticsDTO;
import org.apache.nifi.web.api.dto.TemplateDTO;
import org.apache.nifi.web.api.dto.UserDTO;
import org.apache.nifi.web.api.dto.UserGroupDTO;
import org.apache.nifi.web.api.dto.VariableRegistryDTO;
import org.apache.nifi.web.api.dto.VersionControlInformationDTO;
import org.apache.nifi.web.api.dto.VersionedFlowDTO;
import org.apache.nifi.web.api.dto.action.HistoryDTO;
import org.apache.nifi.web.api.dto.action.HistoryQueryDTO;
import org.apache.nifi.web.api.dto.diagnostics.ConnectionDiagnosticsDTO;
import org.apache.nifi.web.api.dto.diagnostics.JVMDiagnosticsDTO;
import org.apache.nifi.web.api.dto.diagnostics.JVMDiagnosticsSnapshotDTO;
import org.apache.nifi.web.api.dto.diagnostics.ProcessorDiagnosticsDTO;
import org.apache.nifi.web.api.dto.flow.FlowDTO;
import org.apache.nifi.web.api.dto.provenance.ProvenanceDTO;
import org.apache.nifi.web.api.dto.provenance.ProvenanceEventDTO;
import org.apache.nifi.web.api.dto.provenance.ProvenanceOptionsDTO;
import org.apache.nifi.web.api.dto.provenance.lineage.LineageDTO;
import org.apache.nifi.web.api.dto.search.SearchResultsDTO;
import org.apache.nifi.web.api.dto.status.ConnectionStatisticsDTO;
import org.apache.nifi.web.api.dto.status.ConnectionStatusDTO;
import org.apache.nifi.web.api.dto.status.ControllerStatusDTO;
import org.apache.nifi.web.api.dto.status.NodeProcessGroupStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.PortStatusDTO;
import org.apache.nifi.web.api.dto.status.ProcessGroupStatusDTO;
import org.apache.nifi.web.api.dto.status.ProcessGroupStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.ProcessorStatusDTO;
import org.apache.nifi.web.api.dto.status.RemoteProcessGroupStatusDTO;
import org.apache.nifi.web.api.dto.status.StatusHistoryDTO;
import org.apache.nifi.web.api.entity.AccessPolicyEntity;
import org.apache.nifi.web.api.entity.AccessPolicySummaryEntity;
import org.apache.nifi.web.api.entity.ActionEntity;
import org.apache.nifi.web.api.entity.ActivateControllerServicesEntity;
import org.apache.nifi.web.api.entity.AffectedComponentEntity;
import org.apache.nifi.web.api.entity.BucketEntity;
import org.apache.nifi.web.api.entity.BulletinEntity;
import org.apache.nifi.web.api.entity.ComponentReferenceEntity;
import org.apache.nifi.web.api.entity.ComponentValidationResultEntity;
import org.apache.nifi.web.api.entity.ConnectionEntity;
import org.apache.nifi.web.api.entity.ConnectionStatisticsEntity;
import org.apache.nifi.web.api.entity.ConnectionStatusEntity;
import org.apache.nifi.web.api.entity.ControllerBulletinsEntity;
import org.apache.nifi.web.api.entity.ControllerConfigurationEntity;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.ControllerServiceReferencingComponentEntity;
import org.apache.nifi.web.api.entity.ControllerServiceReferencingComponentsEntity;
import org.apache.nifi.web.api.entity.CurrentUserEntity;
import org.apache.nifi.web.api.entity.FlowComparisonEntity;
import org.apache.nifi.web.api.entity.FlowConfigurationEntity;
import org.apache.nifi.web.api.entity.FlowEntity;
import org.apache.nifi.web.api.entity.FunnelEntity;
import org.apache.nifi.web.api.entity.LabelEntity;
import org.apache.nifi.web.api.entity.ParameterContextEntity;
import org.apache.nifi.web.api.entity.ParameterEntity;
import org.apache.nifi.web.api.entity.PortEntity;
import org.apache.nifi.web.api.entity.PortStatusEntity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.entity.ProcessGroupFlowEntity;
import org.apache.nifi.web.api.entity.ProcessGroupStatusEntity;
import org.apache.nifi.web.api.entity.ProcessGroupStatusSnapshotEntity;
import org.apache.nifi.web.api.entity.ProcessorDiagnosticsEntity;
import org.apache.nifi.web.api.entity.ProcessorEntity;
import org.apache.nifi.web.api.entity.ProcessorRunStatusDetailsEntity;
import org.apache.nifi.web.api.entity.ProcessorStatusEntity;
import org.apache.nifi.web.api.entity.ProcessorsRunStatusDetailsEntity;
import org.apache.nifi.web.api.entity.RegistryClientEntity;
import org.apache.nifi.web.api.entity.RegistryEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupPortEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupStatusEntity;
import org.apache.nifi.web.api.entity.ReportingTaskEntity;
import org.apache.nifi.web.api.entity.ScheduleComponentsEntity;
import org.apache.nifi.web.api.entity.SnippetEntity;
import org.apache.nifi.web.api.entity.StartVersionControlRequestEntity;
import org.apache.nifi.web.api.entity.StatusHistoryEntity;
import org.apache.nifi.web.api.entity.TemplateEntity;
import org.apache.nifi.web.api.entity.TenantEntity;
import org.apache.nifi.web.api.entity.UserEntity;
import org.apache.nifi.web.api.entity.UserGroupEntity;
import org.apache.nifi.web.api.entity.VariableEntity;
import org.apache.nifi.web.api.entity.VariableRegistryEntity;
import org.apache.nifi.web.api.entity.VersionControlComponentMappingEntity;
import org.apache.nifi.web.api.entity.VersionControlInformationEntity;
import org.apache.nifi.web.api.entity.VersionedFlowEntity;
import org.apache.nifi.web.api.entity.VersionedFlowSnapshotMetadataEntity;
import org.apache.nifi.web.controller.ControllerFacade;
import org.apache.nifi.web.dao.AccessPolicyDAO;
import org.apache.nifi.web.dao.ConnectionDAO;
import org.apache.nifi.web.dao.ControllerServiceDAO;
import org.apache.nifi.web.dao.FunnelDAO;
import org.apache.nifi.web.dao.LabelDAO;
import org.apache.nifi.web.dao.ParameterContextDAO;
import org.apache.nifi.web.dao.PortDAO;
import org.apache.nifi.web.dao.ProcessGroupDAO;
import org.apache.nifi.web.dao.ProcessorDAO;
import org.apache.nifi.web.dao.RegistryDAO;
import org.apache.nifi.web.dao.RemoteProcessGroupDAO;
import org.apache.nifi.web.dao.ReportingTaskDAO;
import org.apache.nifi.web.dao.SnippetDAO;
import org.apache.nifi.web.dao.TemplateDAO;
import org.apache.nifi.web.dao.UserDAO;
import org.apache.nifi.web.dao.UserGroupDAO;
import org.apache.nifi.web.revision.DeleteRevisionTask;
import org.apache.nifi.web.revision.ExpiredRevisionClaimException;
import org.apache.nifi.web.revision.RevisionClaim;
import org.apache.nifi.web.revision.RevisionManager;
import org.apache.nifi.web.revision.RevisionUpdate;
import org.apache.nifi.web.revision.StandardRevisionClaim;
import org.apache.nifi.web.revision.StandardRevisionUpdate;
import org.apache.nifi.web.revision.UpdateRevisionTask;
import org.apache.nifi.web.util.SnippetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardNiFiServiceFacade
implements NiFiServiceFacade {
    private static final Logger logger = LoggerFactory.getLogger(StandardNiFiServiceFacade.class);
    private static final int VALIDATION_WAIT_MILLIS = 50;
    private ControllerFacade controllerFacade;
    private SnippetUtils snippetUtils;
    private RevisionManager revisionManager;
    private BulletinRepository bulletinRepository;
    private ProcessorDAO processorDAO;
    private ProcessGroupDAO processGroupDAO;
    private RemoteProcessGroupDAO remoteProcessGroupDAO;
    private LabelDAO labelDAO;
    private FunnelDAO funnelDAO;
    private SnippetDAO snippetDAO;
    private PortDAO inputPortDAO;
    private PortDAO outputPortDAO;
    private ConnectionDAO connectionDAO;
    private ControllerServiceDAO controllerServiceDAO;
    private ReportingTaskDAO reportingTaskDAO;
    private TemplateDAO templateDAO;
    private UserDAO userDAO;
    private UserGroupDAO userGroupDAO;
    private AccessPolicyDAO accessPolicyDAO;
    private RegistryDAO registryDAO;
    private ParameterContextDAO parameterContextDAO;
    private ClusterCoordinator clusterCoordinator;
    private HeartbeatMonitor heartbeatMonitor;
    private LeaderElectionManager leaderElectionManager;
    private AuditService auditService;
    private FlowRegistryClient flowRegistryClient;
    private NiFiProperties properties;
    private DtoFactory dtoFactory;
    private EntityFactory entityFactory;
    private Authorizer authorizer;
    private AuthorizableLookup authorizableLookup;
    private NiFiMetricsRegistry nifiMetricsRegistry = new NiFiMetricsRegistry();
    private JvmMetricsRegistry jvmMetricsRegistry = new JvmMetricsRegistry();
    private ConnectionAnalyticsMetricsRegistry connectionAnalyticsMetricsRegistry = new ConnectionAnalyticsMetricsRegistry();
    private BulletinMetricsRegistry bulletinMetricsRegistry = new BulletinMetricsRegistry();
    public final Collection<CollectorRegistry> ALL_REGISTRIES = Arrays.asList(this.nifiMetricsRegistry.getRegistry(), this.jvmMetricsRegistry.getRegistry(), this.connectionAnalyticsMetricsRegistry.getRegistry(), this.bulletinMetricsRegistry.getRegistry());

    public void authorizeAccess(AuthorizeAccess authorizeAccess) {
        authorizeAccess.authorize(this.authorizableLookup);
    }

    public void verifyRevision(Revision revision, NiFiUser user) {
        Revision curRevision = this.revisionManager.getRevision(revision.getComponentId());
        if (revision.equals((Object)curRevision)) {
            return;
        }
        throw new InvalidRevisionException(revision + " is not the most up-to-date revision. This component appears to have been modified");
    }

    public void verifyRevisions(Set<Revision> revisions, NiFiUser user) {
        for (Revision revision : revisions) {
            this.verifyRevision(revision, user);
        }
    }

    public Set<Revision> getRevisionsFromGroup(String groupId, Function<ProcessGroup, Set<String>> getComponents) {
        ProcessGroup group = this.processGroupDAO.getProcessGroup(groupId);
        Set<String> componentIds = getComponents.apply(group);
        return componentIds.stream().map(id -> this.revisionManager.getRevision(id)).collect(Collectors.toSet());
    }

    public Set<Revision> getRevisionsFromSnippet(String snippetId) {
        Snippet snippet = this.snippetDAO.getSnippet(snippetId);
        HashSet componentIds = new HashSet();
        componentIds.addAll(snippet.getProcessors().keySet());
        componentIds.addAll(snippet.getFunnels().keySet());
        componentIds.addAll(snippet.getLabels().keySet());
        componentIds.addAll(snippet.getConnections().keySet());
        componentIds.addAll(snippet.getInputPorts().keySet());
        componentIds.addAll(snippet.getOutputPorts().keySet());
        componentIds.addAll(snippet.getProcessGroups().keySet());
        componentIds.addAll(snippet.getRemoteProcessGroups().keySet());
        return componentIds.stream().map(id -> this.revisionManager.getRevision(id)).collect(Collectors.toSet());
    }

    public void verifyListQueue(String connectionId) {
        this.connectionDAO.verifyList(connectionId);
    }

    public void verifyCreateConnection(String groupId, ConnectionDTO connectionDTO) {
        this.connectionDAO.verifyCreate(groupId, connectionDTO);
    }

    public void verifyUpdateConnection(ConnectionDTO connectionDTO) {
        if (this.connectionDAO.hasConnection(connectionDTO.getId())) {
            this.connectionDAO.verifyUpdate(connectionDTO);
        } else {
            this.connectionDAO.verifyCreate(connectionDTO.getParentGroupId(), connectionDTO);
        }
    }

    public void verifyDeleteConnection(String connectionId) {
        this.connectionDAO.verifyDelete(connectionId);
    }

    public void verifyDeleteFunnel(String funnelId) {
        this.funnelDAO.verifyDelete(funnelId);
    }

    public void verifyUpdateInputPort(PortDTO inputPortDTO) {
        if (this.inputPortDAO.hasPort(inputPortDTO.getId())) {
            this.inputPortDAO.verifyUpdate(inputPortDTO);
        }
    }

    public void verifyDeleteInputPort(String inputPortId) {
        this.inputPortDAO.verifyDelete(inputPortId);
    }

    public void verifyUpdateOutputPort(PortDTO outputPortDTO) {
        if (this.outputPortDAO.hasPort(outputPortDTO.getId())) {
            this.outputPortDAO.verifyUpdate(outputPortDTO);
        }
    }

    public void verifyDeleteOutputPort(String outputPortId) {
        this.outputPortDAO.verifyDelete(outputPortId);
    }

    public void verifyCreateProcessor(ProcessorDTO processorDTO) {
        this.processorDAO.verifyCreate(processorDTO);
    }

    public void verifyUpdateProcessor(ProcessorDTO processorDTO) {
        if (this.processorDAO.hasProcessor(processorDTO.getId())) {
            this.processorDAO.verifyUpdate(processorDTO);
        } else {
            this.verifyCreateProcessor(processorDTO);
        }
    }

    public void verifyDeleteProcessor(String processorId) {
        this.processorDAO.verifyDelete(processorId);
    }

    public void verifyScheduleComponents(String groupId, ScheduledState state, Set<String> componentIds) {
        this.processGroupDAO.verifyScheduleComponents(groupId, state, componentIds);
    }

    public void verifyEnableComponents(String processGroupId, ScheduledState state, Set<String> componentIds) {
        this.processGroupDAO.verifyEnableComponents(processGroupId, state, componentIds);
    }

    public void verifyActivateControllerServices(String groupId, ControllerServiceState state, Collection<String> serviceIds) {
        this.processGroupDAO.verifyActivateControllerServices(state, serviceIds);
    }

    public void verifyDeleteProcessGroup(String groupId) {
        this.processGroupDAO.verifyDelete(groupId);
    }

    public void verifyUpdateRemoteProcessGroups(String processGroupId, boolean shouldTransmit) {
        List allRemoteProcessGroups = this.processGroupDAO.getProcessGroup(processGroupId).findAllRemoteProcessGroups();
        allRemoteProcessGroups.stream().map(remoteProcessGroup -> {
            RemoteProcessGroupDTO dto = new RemoteProcessGroupDTO();
            dto.setId(remoteProcessGroup.getIdentifier());
            dto.setTransmitting(Boolean.valueOf(shouldTransmit));
            return dto;
        }).forEach(arg_0 -> this.verifyUpdateRemoteProcessGroup(arg_0));
    }

    public void verifyUpdateRemoteProcessGroup(RemoteProcessGroupDTO remoteProcessGroupDTO) {
        if (this.remoteProcessGroupDAO.hasRemoteProcessGroup(remoteProcessGroupDTO.getId())) {
            this.remoteProcessGroupDAO.verifyUpdate(remoteProcessGroupDTO);
        }
    }

    public void verifyUpdateRemoteProcessGroupInputPort(String remoteProcessGroupId, RemoteProcessGroupPortDTO remoteProcessGroupPortDTO) {
        this.remoteProcessGroupDAO.verifyUpdateInputPort(remoteProcessGroupId, remoteProcessGroupPortDTO);
    }

    public void verifyUpdateRemoteProcessGroupOutputPort(String remoteProcessGroupId, RemoteProcessGroupPortDTO remoteProcessGroupPortDTO) {
        this.remoteProcessGroupDAO.verifyUpdateOutputPort(remoteProcessGroupId, remoteProcessGroupPortDTO);
    }

    public void verifyDeleteRemoteProcessGroup(String remoteProcessGroupId) {
        this.remoteProcessGroupDAO.verifyDelete(remoteProcessGroupId);
    }

    public void verifyCreateControllerService(ControllerServiceDTO controllerServiceDTO) {
        this.controllerServiceDAO.verifyCreate(controllerServiceDTO);
    }

    public void verifyUpdateControllerService(ControllerServiceDTO controllerServiceDTO) {
        if (this.controllerServiceDAO.hasControllerService(controllerServiceDTO.getId())) {
            this.controllerServiceDAO.verifyUpdate(controllerServiceDTO);
        } else {
            this.verifyCreateControllerService(controllerServiceDTO);
        }
    }

    public void verifyUpdateControllerServiceReferencingComponents(String controllerServiceId, ScheduledState scheduledState, ControllerServiceState controllerServiceState) {
        this.controllerServiceDAO.verifyUpdateReferencingComponents(controllerServiceId, scheduledState, controllerServiceState);
    }

    public void verifyDeleteControllerService(String controllerServiceId) {
        this.controllerServiceDAO.verifyDelete(controllerServiceId);
    }

    public void verifyCreateReportingTask(ReportingTaskDTO reportingTaskDTO) {
        this.reportingTaskDAO.verifyCreate(reportingTaskDTO);
    }

    public void verifyUpdateReportingTask(ReportingTaskDTO reportingTaskDTO) {
        if (this.reportingTaskDAO.hasReportingTask(reportingTaskDTO.getId())) {
            this.reportingTaskDAO.verifyUpdate(reportingTaskDTO);
        } else {
            this.verifyCreateReportingTask(reportingTaskDTO);
        }
    }

    public void verifyDeleteReportingTask(String reportingTaskId) {
        this.reportingTaskDAO.verifyDelete(reportingTaskId);
    }

    public AccessPolicyEntity updateAccessPolicy(Revision revision, AccessPolicyDTO accessPolicyDTO) {
        Authorizable authorizable = this.authorizableLookup.getAccessPolicyById(accessPolicyDTO.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, authorizable, () -> this.accessPolicyDAO.updateAccessPolicy(accessPolicyDTO), accessPolicy -> {
            Set users = accessPolicy.getUsers().stream().map(this.mapUserIdToTenantEntity(false)).collect(Collectors.toSet());
            Set userGroups = accessPolicy.getGroups().stream().map(this.mapUserGroupIdToTenantEntity(false)).collect(Collectors.toSet());
            ComponentReferenceEntity componentReference = this.createComponentReferenceEntity(accessPolicy.getResource());
            return this.dtoFactory.createAccessPolicyDto(accessPolicy, userGroups, users, componentReference);
        });
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto(authorizable);
        return this.entityFactory.createAccessPolicyEntity((AccessPolicyDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions);
    }

    public UserEntity updateUser(Revision revision, UserDTO userDTO) {
        Authorizable usersAuthorizable = this.authorizableLookup.getTenant();
        Set groups = this.userGroupDAO.getUserGroupsForUser(userDTO.getId());
        Set policies = this.userGroupDAO.getAccessPoliciesForUser(userDTO.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, usersAuthorizable, () -> this.userDAO.updateUser(userDTO), user -> {
            Set tenantEntities = groups.stream().map(g -> g.getIdentifier()).map(this.mapUserGroupIdToTenantEntity(false)).collect(Collectors.toSet());
            Set policyEntities = policies.stream().map(ap -> this.createAccessPolicySummaryEntity(ap)).collect(Collectors.toSet());
            return this.dtoFactory.createUserDto(user, tenantEntities, policyEntities);
        });
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto(usersAuthorizable);
        return this.entityFactory.createUserEntity((UserDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions);
    }

    public UserGroupEntity updateUserGroup(Revision revision, UserGroupDTO userGroupDTO) {
        Authorizable userGroupsAuthorizable = this.authorizableLookup.getTenant();
        Set policies = this.userGroupDAO.getAccessPoliciesForUserGroup(userGroupDTO.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, userGroupsAuthorizable, () -> this.userGroupDAO.updateUserGroup(userGroupDTO), userGroup -> {
            Set tenantEntities = userGroup.getUsers().stream().map(this.mapUserIdToTenantEntity(false)).collect(Collectors.toSet());
            Set policyEntities = policies.stream().map(ap -> this.createAccessPolicySummaryEntity(ap)).collect(Collectors.toSet());
            return this.dtoFactory.createUserGroupDto(userGroup, tenantEntities, policyEntities);
        });
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto(userGroupsAuthorizable);
        return this.entityFactory.createUserGroupEntity((UserGroupDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions);
    }

    public ConnectionEntity updateConnection(Revision revision, ConnectionDTO connectionDTO) {
        Connection connectionNode = this.connectionDAO.getConnection(connectionDTO.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)connectionNode, () -> this.connectionDAO.updateConnection(connectionDTO), connection -> this.dtoFactory.createConnectionDto(connection));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)connectionNode);
        ConnectionStatusDTO status = this.dtoFactory.createConnectionStatusDto(this.controllerFacade.getConnectionStatus(connectionNode.getIdentifier()));
        return this.entityFactory.createConnectionEntity((ConnectionDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, status);
    }

    public ProcessorEntity updateProcessor(Revision revision, ProcessorDTO processorDTO) {
        ProcessorNode processorNode = this.processorDAO.getProcessor(processorDTO.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)processorNode, () -> this.processorDAO.updateProcessor(processorDTO), proc -> {
            this.awaitValidationCompletion((ComponentNode)proc);
            return this.dtoFactory.createProcessorDto(proc);
        });
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processorNode);
        PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)processorNode));
        ProcessorStatusDTO status = this.dtoFactory.createProcessorStatusDto(this.controllerFacade.getProcessorStatus(processorNode.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(processorNode.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createProcessorEntity((ProcessorDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, operatePermissions, status, bulletinEntities);
    }

    private void awaitValidationCompletion(ComponentNode component) {
        component.getValidationStatus(50L, TimeUnit.MILLISECONDS);
    }

    public LabelEntity updateLabel(Revision revision, LabelDTO labelDTO) {
        Label labelNode = this.labelDAO.getLabel(labelDTO.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)labelNode, () -> this.labelDAO.updateLabel(labelDTO), label -> this.dtoFactory.createLabelDto(label));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)labelNode);
        return this.entityFactory.createLabelEntity((LabelDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions);
    }

    public FunnelEntity updateFunnel(Revision revision, FunnelDTO funnelDTO) {
        Funnel funnelNode = this.funnelDAO.getFunnel(funnelDTO.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)funnelNode, () -> this.funnelDAO.updateFunnel(funnelDTO), funnel -> this.dtoFactory.createFunnelDto(funnel));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)funnelNode);
        return this.entityFactory.createFunnelEntity((FunnelDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions);
    }

    private <D, C> RevisionUpdate<D> updateComponent(Revision revision, Authorizable authorizable, Supplier<C> daoUpdate, Function<C, D> dtoCreation) {
        try {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            RevisionUpdate updatedComponent = this.revisionManager.updateRevision((RevisionClaim)new StandardRevisionClaim(new Revision[]{revision}), user, (UpdateRevisionTask)new /* Unavailable Anonymous Inner Class!! */);
            return updatedComponent;
        }
        catch (ExpiredRevisionClaimException erce) {
            throw new InvalidRevisionException("Failed to update component " + authorizable, (Throwable)erce);
        }
    }

    public void verifyUpdateSnippet(SnippetDTO snippetDto, Set<String> affectedComponentIds) {
        if (this.snippetDAO.hasSnippet(snippetDto.getId())) {
            this.snippetDAO.verifyUpdateSnippetComponent(snippetDto);
        }
    }

    public SnippetEntity updateSnippet(Set<Revision> revisions, SnippetDTO snippetDto) {
        RevisionUpdate snapshot;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        StandardRevisionClaim revisionClaim = new StandardRevisionClaim(revisions);
        try {
            snapshot = this.revisionManager.updateRevision((RevisionClaim)revisionClaim, user, (UpdateRevisionTask)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (ExpiredRevisionClaimException e) {
            throw new InvalidRevisionException("Failed to update Snippet", (Throwable)e);
        }
        return this.entityFactory.createSnippetEntity((SnippetDTO)snapshot.getComponent());
    }

    public PortEntity updateInputPort(Revision revision, PortDTO inputPortDTO) {
        Port inputPortNode = this.inputPortDAO.getPort(inputPortDTO.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)inputPortNode, () -> this.inputPortDAO.updatePort(inputPortDTO), port -> this.dtoFactory.createPortDto(port));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)inputPortNode);
        PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)inputPortNode));
        PortStatusDTO status = this.dtoFactory.createPortStatusDto(this.controllerFacade.getInputPortStatus(inputPortNode.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(inputPortNode.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createPortEntity((PortDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, operatePermissions, status, bulletinEntities);
    }

    public PortEntity updateOutputPort(Revision revision, PortDTO outputPortDTO) {
        Port outputPortNode = this.outputPortDAO.getPort(outputPortDTO.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)outputPortNode, () -> this.outputPortDAO.updatePort(outputPortDTO), port -> this.dtoFactory.createPortDto(port));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)outputPortNode);
        PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)outputPortNode), NiFiUserUtils.getNiFiUser());
        PortStatusDTO status = this.dtoFactory.createPortStatusDto(this.controllerFacade.getOutputPortStatus(outputPortNode.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(outputPortNode.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createPortEntity((PortDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, operatePermissions, status, bulletinEntities);
    }

    public RemoteProcessGroupEntity updateRemoteProcessGroup(Revision revision, RemoteProcessGroupDTO remoteProcessGroupDTO) {
        RemoteProcessGroup remoteProcessGroupNode = this.remoteProcessGroupDAO.getRemoteProcessGroup(remoteProcessGroupDTO.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)remoteProcessGroupNode, () -> this.remoteProcessGroupDAO.updateRemoteProcessGroup(remoteProcessGroupDTO), remoteProcessGroup -> this.dtoFactory.createRemoteProcessGroupDto(remoteProcessGroup));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)remoteProcessGroupNode);
        PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)remoteProcessGroupNode));
        RevisionDTO updateRevision = this.dtoFactory.createRevisionDTO(snapshot.getLastModification());
        RemoteProcessGroupStatusDTO status = this.dtoFactory.createRemoteProcessGroupStatusDto(remoteProcessGroupNode, this.controllerFacade.getRemoteProcessGroupStatus(remoteProcessGroupNode.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(remoteProcessGroupNode.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createRemoteProcessGroupEntity((RemoteProcessGroupDTO)snapshot.getComponent(), updateRevision, permissions, operatePermissions, status, bulletinEntities);
    }

    public RemoteProcessGroupPortEntity updateRemoteProcessGroupInputPort(Revision revision, String remoteProcessGroupId, RemoteProcessGroupPortDTO remoteProcessGroupPortDTO) {
        RemoteProcessGroup remoteProcessGroupNode = this.remoteProcessGroupDAO.getRemoteProcessGroup(remoteProcessGroupPortDTO.getGroupId());
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)remoteProcessGroupNode, () -> this.remoteProcessGroupDAO.updateRemoteProcessGroupInputPort(remoteProcessGroupId, remoteProcessGroupPortDTO), remoteGroupPort -> this.dtoFactory.createRemoteProcessGroupPortDto(remoteGroupPort));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)remoteProcessGroupNode);
        PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)remoteProcessGroupNode));
        RevisionDTO updatedRevision = this.dtoFactory.createRevisionDTO(snapshot.getLastModification());
        return this.entityFactory.createRemoteProcessGroupPortEntity((RemoteProcessGroupPortDTO)snapshot.getComponent(), updatedRevision, permissions, operatePermissions);
    }

    public RemoteProcessGroupPortEntity updateRemoteProcessGroupOutputPort(Revision revision, String remoteProcessGroupId, RemoteProcessGroupPortDTO remoteProcessGroupPortDTO) {
        RemoteProcessGroup remoteProcessGroupNode = this.remoteProcessGroupDAO.getRemoteProcessGroup(remoteProcessGroupPortDTO.getGroupId());
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)remoteProcessGroupNode, () -> this.remoteProcessGroupDAO.updateRemoteProcessGroupOutputPort(remoteProcessGroupId, remoteProcessGroupPortDTO), remoteGroupPort -> this.dtoFactory.createRemoteProcessGroupPortDto(remoteGroupPort));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)remoteProcessGroupNode);
        PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)remoteProcessGroupNode));
        RevisionDTO updatedRevision = this.dtoFactory.createRevisionDTO(snapshot.getLastModification());
        return this.entityFactory.createRemoteProcessGroupPortEntity((RemoteProcessGroupPortDTO)snapshot.getComponent(), updatedRevision, permissions, operatePermissions);
    }

    public Set<AffectedComponentDTO> getActiveComponentsAffectedByVariableRegistryUpdate(VariableRegistryDTO variableRegistryDto) {
        ProcessGroup group = this.processGroupDAO.getProcessGroup(variableRegistryDto.getProcessGroupId());
        if (group == null) {
            throw new ResourceNotFoundException("Could not find Process Group with ID " + variableRegistryDto.getProcessGroupId());
        }
        HashMap variableMap = new HashMap();
        variableRegistryDto.getVariables().stream().map(VariableEntity::getVariable).forEach(var -> variableMap.put(var.getName(), var.getValue()));
        HashSet<AffectedComponentDTO> affectedComponentDtos = new HashSet<AffectedComponentDTO>();
        Set updatedVariableNames = this.getUpdatedVariables(group, variableMap);
        for (String variableName : updatedVariableNames) {
            Set affectedComponents = group.getComponentsAffectedByVariable(variableName);
            for (ComponentNode component : affectedComponents) {
                if (component instanceof ProcessorNode) {
                    ProcessorNode procNode = (ProcessorNode)component;
                    if (!procNode.isRunning()) continue;
                    affectedComponentDtos.add(this.dtoFactory.createAffectedComponentDto((ComponentNode)procNode));
                    continue;
                }
                if (component instanceof ControllerServiceNode) {
                    ControllerServiceNode serviceNode = (ControllerServiceNode)component;
                    if (!serviceNode.isActive()) continue;
                    affectedComponentDtos.add(this.dtoFactory.createAffectedComponentDto((ComponentNode)serviceNode));
                    continue;
                }
                throw new RuntimeException("Found unexpected type of Component [" + component.getCanonicalClassName() + "] dependending on variable");
            }
        }
        return affectedComponentDtos;
    }

    public Set<AffectedComponentEntity> getComponentsAffectedByVariableRegistryUpdate(VariableRegistryDTO variableRegistryDto) {
        ProcessGroup group = this.processGroupDAO.getProcessGroup(variableRegistryDto.getProcessGroupId());
        if (group == null) {
            throw new ResourceNotFoundException("Could not find Process Group with ID " + variableRegistryDto.getProcessGroupId());
        }
        HashMap variableMap = new HashMap();
        variableRegistryDto.getVariables().stream().map(VariableEntity::getVariable).forEach(var -> variableMap.put(var.getName(), var.getValue()));
        HashSet<AffectedComponentEntity> affectedComponentEntities = new HashSet<AffectedComponentEntity>();
        Set updatedVariableNames = this.getUpdatedVariables(group, variableMap);
        for (String variableName : updatedVariableNames) {
            Set affectedComponents = group.getComponentsAffectedByVariable(variableName);
            affectedComponentEntities.addAll(this.dtoFactory.createAffectedComponentEntities(affectedComponents, this.revisionManager));
        }
        return affectedComponentEntities;
    }

    private Set<String> getUpdatedVariables(ProcessGroup group, Map<String, String> newVariableValues) {
        HashSet<String> updatedVariableNames = new HashSet<String>();
        ComponentVariableRegistry registry = group.getVariableRegistry();
        for (Map.Entry<String, String> entry : newVariableValues.entrySet()) {
            String curValue;
            String varName = entry.getKey();
            String newValue = entry.getValue();
            if (Objects.equals(newValue, curValue = registry.getVariableValue(varName))) continue;
            updatedVariableNames.add(varName);
        }
        return updatedVariableNames;
    }

    public VariableRegistryEntity updateVariableRegistry(Revision revision, VariableRegistryDTO variableRegistryDto) {
        ProcessGroup processGroupNode = this.processGroupDAO.getProcessGroup(variableRegistryDto.getProcessGroupId());
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)processGroupNode, () -> this.processGroupDAO.updateVariableRegistry(variableRegistryDto), processGroup -> this.dtoFactory.createVariableRegistryDto(processGroup, this.revisionManager));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processGroupNode);
        RevisionDTO updatedRevision = this.dtoFactory.createRevisionDTO(snapshot.getLastModification());
        return this.entityFactory.createVariableRegistryEntity((VariableRegistryDTO)snapshot.getComponent(), updatedRevision, permissions);
    }

    public void verifyCreateParameterContext(ParameterContextDTO parameterContextDto) {
        this.parameterContextDAO.verifyCreate(parameterContextDto);
    }

    public void verifyUpdateParameterContext(ParameterContextDTO parameterContext, boolean verifyComponentStates) {
        this.parameterContextDAO.verifyUpdate(parameterContext, verifyComponentStates);
    }

    public ParameterContextEntity updateParameterContext(Revision revision, ParameterContextDTO parameterContextDto) {
        ParameterContext parameterContext = this.parameterContextDAO.getParameterContext(parameterContextDto.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)parameterContext, () -> this.parameterContextDAO.updateParameterContext(parameterContextDto), context -> this.dtoFactory.createParameterContextDto(context, this.revisionManager));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)parameterContext);
        RevisionDTO revisionDto = this.dtoFactory.createRevisionDTO(snapshot.getLastModification());
        return this.entityFactory.createParameterContextEntity((ParameterContextDTO)snapshot.getComponent(), revisionDto, permissions);
    }

    public ParameterContextEntity getParameterContext(String parameterContextId, NiFiUser user) {
        ParameterContext parameterContext = this.parameterContextDAO.getParameterContext(parameterContextId);
        return this.createParameterContextEntity(parameterContext, user);
    }

    public Set<ParameterContextEntity> getParameterContexts() {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        Set<ParameterContextEntity> entities = this.parameterContextDAO.getParameterContexts().stream().map(context -> this.createParameterContextEntity(context, user)).collect(Collectors.toSet());
        return entities;
    }

    public ParameterContext getParameterContextByName(String parameterContextName, NiFiUser user) {
        ParameterContext parameterContext = this.parameterContextDAO.getParameterContexts().stream().filter(context -> context.getName().equals(parameterContextName)).findAny().orElse(null);
        if (parameterContext == null) {
            return null;
        }
        boolean authorized = parameterContext.isAuthorized(this.authorizer, RequestAction.READ, user);
        if (!authorized) {
            throw new AccessDeniedException("Unable to read Parameter Context with name '" + parameterContextName + "'.");
        }
        return parameterContext;
    }

    private ParameterContextEntity createParameterContextEntity(ParameterContext parameterContext, NiFiUser user) {
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)parameterContext, user);
        RevisionDTO revisionDto = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(parameterContext.getIdentifier()));
        ParameterContextDTO parameterContextDto = this.dtoFactory.createParameterContextDto(parameterContext, this.revisionManager);
        ParameterContextEntity entity = this.entityFactory.createParameterContextEntity(parameterContextDto, revisionDto, permissions);
        return entity;
    }

    public List<ComponentValidationResultEntity> validateComponents(ParameterContextDTO parameterContextDto, NiFiUser nifiUser) {
        ParameterContext parameterContext = this.parameterContextDAO.getParameterContext(parameterContextDto.getId());
        Set boundProcessGroups = parameterContext.getParameterReferenceManager().getProcessGroupsBound(parameterContext);
        StandardParameterContext updatedParameterContext = new StandardParameterContext(parameterContext.getIdentifier(), parameterContext.getName(), ParameterReferenceManager.EMPTY, null);
        HashMap parameters = new HashMap();
        parameterContextDto.getParameters().stream().map(ParameterEntity::getParameter).map(arg_0 -> this.createParameter(arg_0)).forEach(param -> parameters.put(param.getDescriptor().getName(), param));
        updatedParameterContext.setParameters(parameters);
        ArrayList<ComponentValidationResultEntity> validationResults = new ArrayList<ComponentValidationResultEntity>();
        for (ProcessGroup processGroup : boundProcessGroups) {
            ComponentValidationResultEntity componentValidationResultEntity;
            for (ProcessorNode processorNode : processGroup.getProcessors()) {
                if (!processorNode.isReferencingParameter()) continue;
                componentValidationResultEntity = this.validateComponent((ComponentNode)processorNode, (ParameterContext)updatedParameterContext, nifiUser);
                validationResults.add(componentValidationResultEntity);
            }
            for (ControllerServiceNode serviceNode : processGroup.getControllerServices(false)) {
                if (!serviceNode.isReferencingParameter()) continue;
                componentValidationResultEntity = this.validateComponent((ComponentNode)serviceNode, (ParameterContext)updatedParameterContext, nifiUser);
                validationResults.add(componentValidationResultEntity);
            }
        }
        return validationResults;
    }

    private ComponentValidationResultEntity validateComponent(ComponentNode componentNode, ParameterContext parameterContext, NiFiUser user) {
        ValidationState newState = componentNode.performValidation(componentNode.getProperties(), componentNode.getAnnotationData(), parameterContext);
        ComponentValidationResultDTO resultDto = this.dtoFactory.createComponentValidationResultDto(componentNode, newState);
        Revision revision = this.revisionManager.getRevision(componentNode.getIdentifier());
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)componentNode, user);
        RevisionDTO revisionDto = this.dtoFactory.createRevisionDTO(revision);
        ComponentValidationResultEntity componentValidationResultEntity = this.entityFactory.createComponentValidationResultEntity(resultDto, revisionDto, permissions);
        return componentValidationResultEntity;
    }

    private Parameter createParameter(ParameterDTO dto) {
        if (dto.getDescription() == null && dto.getSensitive() == null && dto.getValue() == null) {
            return null;
        }
        ParameterDescriptor descriptor = new ParameterDescriptor.Builder().name(dto.getName()).description(dto.getDescription()).sensitive(Boolean.TRUE.equals(dto.getSensitive())).build();
        return new Parameter(descriptor, dto.getValue());
    }

    public ParameterContextEntity createParameterContext(Revision revision, ParameterContextDTO parameterContextDto) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        StandardRevisionClaim claim = new StandardRevisionClaim(new Revision[]{revision});
        RevisionUpdate snapshot = this.revisionManager.updateRevision((RevisionClaim)claim, user, () -> {
            ParameterContext parameterContext = this.parameterContextDAO.createParameterContext(parameterContextDto);
            this.controllerFacade.save();
            ParameterContextDTO dto = this.dtoFactory.createParameterContextDto(parameterContext, this.revisionManager);
            FlowModification lastMod = new FlowModification(revision.incrementRevision(revision.getClientId()), user.getIdentity());
            return new StandardRevisionUpdate((Object)dto, lastMod);
        });
        ParameterContext parameterContext = this.parameterContextDAO.getParameterContext(parameterContextDto.getId());
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)parameterContext);
        return this.entityFactory.createParameterContextEntity((ParameterContextDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions);
    }

    public void verifyDeleteParameterContext(String parameterContextId) {
        this.parameterContextDAO.verifyDelete(parameterContextId);
    }

    public ParameterContextEntity deleteParameterContext(Revision revision, String parameterContextId) {
        ParameterContext parameterContext = this.parameterContextDAO.getParameterContext(parameterContextId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)parameterContext);
        ParameterContextDTO snapshot = (ParameterContextDTO)this.deleteComponent(revision, parameterContext.getResource(), () -> this.parameterContextDAO.deleteParameterContext(parameterContextId), true, (Object)this.dtoFactory.createParameterContextDto(parameterContext, this.revisionManager));
        return this.entityFactory.createParameterContextEntity(snapshot, null, permissions);
    }

    public Set<AffectedComponentEntity> getProcessorsReferencingParameter(String groupId) {
        return this.getComponentsReferencingParameter(groupId, ProcessGroup::getProcessors);
    }

    public Set<AffectedComponentEntity> getControllerServicesReferencingParameter(String groupId) {
        return this.getComponentsReferencingParameter(groupId, group -> group.getControllerServices(false));
    }

    private Set<AffectedComponentEntity> getComponentsReferencingParameter(String groupId, Function<ProcessGroup, Collection<? extends ComponentNode>> componentFunction) {
        ProcessGroup group = this.processGroupDAO.getProcessGroup(groupId);
        HashSet affectedComponents = new HashSet();
        componentFunction.apply(group).stream().filter(ComponentNode::isReferencingParameter).forEach(affectedComponents::add);
        return this.dtoFactory.createAffectedComponentEntities(affectedComponents, this.revisionManager);
    }

    public AffectedComponentEntity getUpdatedAffectedComponentEntity(AffectedComponentEntity affectedComponent) {
        AffectedComponentDTO dto = affectedComponent.getComponent();
        if (dto == null) {
            return affectedComponent;
        }
        String groupId = affectedComponent.getProcessGroup().getId();
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(groupId);
        String componentType = dto.getReferenceType();
        if ("CONTROLLER_SERVICE".equals(componentType)) {
            ControllerServiceNode serviceNode = processGroup.getControllerService(dto.getId());
            return this.dtoFactory.createAffectedComponentEntity((ComponentNode)serviceNode, this.revisionManager);
        }
        if ("PROCESSOR".equals(componentType)) {
            ProcessorNode processorNode = processGroup.getProcessor(dto.getId());
            return this.dtoFactory.createAffectedComponentEntity((ComponentNode)processorNode, this.revisionManager);
        }
        if ("INPUT_PORT".equals(componentType)) {
            Port inputPort = processGroup.getInputPort(dto.getId());
            PortEntity portEntity = this.createInputPortEntity(inputPort);
            return this.dtoFactory.createAffectedComponentEntity(portEntity, "INPUT_PORT");
        }
        if ("OUTPUT_PORT".equals(componentType)) {
            Port outputPort = processGroup.getOutputPort(dto.getId());
            PortEntity portEntity = this.createOutputPortEntity(outputPort);
            return this.dtoFactory.createAffectedComponentEntity(portEntity, "OUTPUT_PORT");
        }
        if ("REMOTE_INPUT_PORT".equals(componentType)) {
            RemoteGroupPort remoteGroupPort = processGroup.findRemoteGroupPort(dto.getId());
            RemoteProcessGroupEntity rpgEntity = this.createRemoteGroupEntity(remoteGroupPort.getRemoteProcessGroup(), NiFiUserUtils.getNiFiUser());
            RemoteProcessGroupPortDTO remotePortDto = this.dtoFactory.createRemoteProcessGroupPortDto(remoteGroupPort);
            return this.dtoFactory.createAffectedComponentEntity(remotePortDto, "REMOTE_INPUT_PORT", rpgEntity);
        }
        if ("REMOTE_OUTPUT_PORT".equals(componentType)) {
            RemoteGroupPort remoteGroupPort = processGroup.findRemoteGroupPort(dto.getId());
            RemoteProcessGroupEntity rpgEntity = this.createRemoteGroupEntity(remoteGroupPort.getRemoteProcessGroup(), NiFiUserUtils.getNiFiUser());
            RemoteProcessGroupPortDTO remotePortDto = this.dtoFactory.createRemoteProcessGroupPortDto(remoteGroupPort);
            return this.dtoFactory.createAffectedComponentEntity(remotePortDto, "REMOTE_OUTPUT_PORT", rpgEntity);
        }
        return affectedComponent;
    }

    public Set<AffectedComponentEntity> getComponentsAffectedByParameterContextUpdate(ParameterContextDTO parameterContextDto) {
        return this.getComponentsAffectedByParameterContextUpdate(parameterContextDto, true);
    }

    private Set<AffectedComponentEntity> getComponentsAffectedByParameterContextUpdate(ParameterContextDTO parameterContextDto, boolean includeInactive) {
        ProcessGroup rootGroup = this.processGroupDAO.getProcessGroup("root");
        List groupsReferencingParameterContext = rootGroup.findAllProcessGroups(group -> group.getParameterContext() != null && group.getParameterContext().getIdentifier().equals(parameterContextDto.getId()));
        Set updatedParameterNames = this.getUpdatedParameterNames(parameterContextDto);
        for (ParameterEntity parameterEntity : parameterContextDto.getParameters()) {
            parameterEntity.getParameter().setReferencingComponents(new HashSet());
        }
        HashSet<ProcessorNode> affectedComponents = new HashSet<ProcessorNode>();
        for (ProcessGroup group2 : groupsReferencingParameterContext) {
            ParameterDTO paramDto;
            Set referencedParams;
            for (ProcessorNode processor : group2.getProcessors()) {
                if (!includeInactive && !processor.isRunning()) continue;
                referencedParams = processor.getReferencedParameterNames();
                boolean referencesUpdatedParam = referencedParams.stream().anyMatch(updatedParameterNames::contains);
                if (!referencesUpdatedParam) continue;
                affectedComponents.add(processor);
                AffectedComponentEntity affectedComponentEntity = this.dtoFactory.createAffectedComponentEntity((ComponentNode)processor, this.revisionManager);
                for (String referencedParam : referencedParams) {
                    for (ParameterEntity paramEntity : parameterContextDto.getParameters()) {
                        paramDto = paramEntity.getParameter();
                        if (!referencedParam.equals(paramDto.getName())) continue;
                        paramDto.getReferencingComponents().add(affectedComponentEntity);
                    }
                }
            }
            for (ControllerServiceNode service : group2.getControllerServices(false)) {
                if (!includeInactive && !service.isActive()) continue;
                referencedParams = service.getReferencedParameterNames();
                Set updatedReferencedParams = referencedParams.stream().filter(updatedParameterNames::contains).collect(Collectors.toSet());
                ArrayList<ParameterDTO> affectedParameterDtos = new ArrayList<ParameterDTO>();
                for (String referencedParam : referencedParams) {
                    for (ParameterEntity paramEntity : parameterContextDto.getParameters()) {
                        paramDto = paramEntity.getParameter();
                        if (!referencedParam.equals(paramDto.getName())) continue;
                        affectedParameterDtos.add(paramDto);
                    }
                }
                if (updatedReferencedParams.isEmpty()) continue;
                this.addReferencingComponents(service, affectedComponents, affectedParameterDtos, includeInactive);
            }
        }
        return this.dtoFactory.createAffectedComponentEntities(affectedComponents, this.revisionManager);
    }

    private void addReferencingComponents(ControllerServiceNode service, Set<ComponentNode> affectedComponents, List<ParameterDTO> affectedParameterDtos, boolean includeInactive) {
        affectedComponents.add((ComponentNode)service);
        AffectedComponentEntity affectedComponentEntity = this.dtoFactory.createAffectedComponentEntity((ComponentNode)service, this.revisionManager);
        affectedParameterDtos.forEach(dto -> dto.getReferencingComponents().add(affectedComponentEntity));
        for (ComponentNode referencingComponent : service.getReferences().getReferencingComponents()) {
            if (!includeInactive && !this.isActive(referencingComponent)) continue;
            affectedComponents.add(referencingComponent);
            AffectedComponentEntity referencingComponentEntity = this.dtoFactory.createAffectedComponentEntity(referencingComponent, this.revisionManager);
            affectedParameterDtos.forEach(dto -> dto.getReferencingComponents().add(referencingComponentEntity));
            if (!(referencingComponent instanceof ControllerServiceNode)) continue;
            this.addReferencingComponents((ControllerServiceNode)referencingComponent, affectedComponents, affectedParameterDtos, includeInactive);
        }
    }

    private boolean isActive(ComponentNode componentNode) {
        if (componentNode instanceof ControllerServiceNode) {
            return ((ControllerServiceNode)componentNode).isActive();
        }
        if (componentNode instanceof ProcessorNode) {
            return ((ProcessorNode)componentNode).isRunning();
        }
        return false;
    }

    private Set<String> getUpdatedParameterNames(ParameterContextDTO parameterContextDto) {
        ParameterContext parameterContext = this.parameterContextDAO.getParameterContext(parameterContextDto.getId());
        HashSet<String> updatedParameters = new HashSet<String>();
        for (ParameterEntity parameterEntity : parameterContextDto.getParameters()) {
            ParameterDTO parameterDto = parameterEntity.getParameter();
            String updatedValue = parameterDto.getValue();
            String parameterName = parameterDto.getName();
            Optional parameterOption = parameterContext.getParameter(parameterName);
            if (!parameterOption.isPresent()) {
                updatedParameters.add(parameterName);
                continue;
            }
            Parameter parameter = (Parameter)parameterOption.get();
            boolean valueUpdated = !Objects.equals(updatedValue, parameter.getValue());
            boolean descriptionUpdated = parameterDto.getDescription() != null && !parameterDto.getDescription().equals(parameter.getDescriptor().getDescription());
            boolean updated = valueUpdated || descriptionUpdated;
            if (!updated) continue;
            updatedParameters.add(parameterName);
        }
        return updatedParameters;
    }

    public ProcessGroupEntity updateProcessGroup(Revision revision, ProcessGroupDTO processGroupDTO) {
        ProcessGroup processGroupNode = this.processGroupDAO.getProcessGroup(processGroupDTO.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)processGroupNode, () -> this.processGroupDAO.updateProcessGroup(processGroupDTO), processGroup -> this.dtoFactory.createProcessGroupDto(processGroup));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processGroupNode);
        RevisionDTO updatedRevision = this.dtoFactory.createRevisionDTO(snapshot.getLastModification());
        ProcessGroupStatusDTO status = this.dtoFactory.createConciseProcessGroupStatusDto(this.controllerFacade.getProcessGroupStatus(processGroupNode.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(processGroupNode.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createProcessGroupEntity((ProcessGroupDTO)snapshot.getComponent(), updatedRevision, permissions, status, bulletinEntities);
    }

    public void verifyUpdateProcessGroup(ProcessGroupDTO processGroupDTO) {
        if (this.processGroupDAO.hasProcessGroup(processGroupDTO.getId())) {
            this.processGroupDAO.verifyUpdate(processGroupDTO);
        }
    }

    public ScheduleComponentsEntity enableComponents(String processGroupId, ScheduledState state, Map<String, Revision> componentRevisions) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        RevisionUpdate updatedComponent = this.revisionManager.updateRevision((RevisionClaim)new StandardRevisionClaim(componentRevisions.values()), user, (UpdateRevisionTask)new /* Unavailable Anonymous Inner Class!! */);
        return (ScheduleComponentsEntity)updatedComponent.getComponent();
    }

    public ScheduleComponentsEntity scheduleComponents(String processGroupId, ScheduledState state, Map<String, Revision> componentRevisions) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        RevisionUpdate updatedComponent = this.revisionManager.updateRevision((RevisionClaim)new StandardRevisionClaim(componentRevisions.values()), user, (UpdateRevisionTask)new /* Unavailable Anonymous Inner Class!! */);
        return (ScheduleComponentsEntity)updatedComponent.getComponent();
    }

    public ActivateControllerServicesEntity activateControllerServices(String processGroupId, ControllerServiceState state, Map<String, Revision> serviceRevisions) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        RevisionUpdate updatedComponent = this.revisionManager.updateRevision((RevisionClaim)new StandardRevisionClaim(serviceRevisions.values()), user, (UpdateRevisionTask)new /* Unavailable Anonymous Inner Class!! */);
        return (ActivateControllerServicesEntity)updatedComponent.getComponent();
    }

    public ControllerConfigurationEntity updateControllerConfiguration(Revision revision, ControllerConfigurationDTO controllerConfigurationDTO) {
        RevisionUpdate updatedComponent = this.updateComponent(revision, (Authorizable)this.controllerFacade, () -> {
            if (controllerConfigurationDTO.getMaxTimerDrivenThreadCount() != null) {
                this.controllerFacade.setMaxTimerDrivenThreadCount(controllerConfigurationDTO.getMaxTimerDrivenThreadCount().intValue());
            }
            if (controllerConfigurationDTO.getMaxEventDrivenThreadCount() != null) {
                this.controllerFacade.setMaxEventDrivenThreadCount(controllerConfigurationDTO.getMaxEventDrivenThreadCount().intValue());
            }
            return controllerConfigurationDTO;
        }, controller -> this.dtoFactory.createControllerConfigurationDto(this.controllerFacade));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)this.controllerFacade);
        RevisionDTO updateRevision = this.dtoFactory.createRevisionDTO(updatedComponent.getLastModification());
        return this.entityFactory.createControllerConfigurationEntity((ControllerConfigurationDTO)updatedComponent.getComponent(), updateRevision, permissions);
    }

    public NodeDTO updateNode(NodeDTO nodeDTO) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user == null) {
            throw new WebApplicationException(new Throwable("Unable to access details for current user."));
        }
        String userDn = user.getIdentity();
        NodeIdentifier nodeId = this.clusterCoordinator.getNodeIdentifier(nodeDTO.getNodeId());
        if (nodeId == null) {
            throw new UnknownNodeException("No node exists with ID " + nodeDTO.getNodeId());
        }
        if (NodeConnectionState.CONNECTING.name().equalsIgnoreCase(nodeDTO.getStatus())) {
            this.clusterCoordinator.requestNodeConnect(nodeId, userDn);
        } else if (NodeConnectionState.OFFLOADING.name().equalsIgnoreCase(nodeDTO.getStatus())) {
            this.clusterCoordinator.requestNodeOffload(nodeId, OffloadCode.OFFLOADED, "User " + userDn + " requested that node be offloaded");
        } else if (NodeConnectionState.DISCONNECTING.name().equalsIgnoreCase(nodeDTO.getStatus())) {
            this.clusterCoordinator.requestNodeDisconnect(nodeId, DisconnectionCode.USER_DISCONNECTED, "User " + userDn + " requested that node be disconnected from cluster");
        }
        return this.getNode(nodeId);
    }

    public CounterDTO updateCounter(String counterId) {
        return this.dtoFactory.createCounterDto(this.controllerFacade.resetCounter(counterId));
    }

    public void verifyCanClearProcessorState(String processorId) {
        this.processorDAO.verifyClearState(processorId);
    }

    public void clearProcessorState(String processorId) {
        this.processorDAO.clearState(processorId);
    }

    public void verifyCanClearControllerServiceState(String controllerServiceId) {
        this.controllerServiceDAO.verifyClearState(controllerServiceId);
    }

    public void clearControllerServiceState(String controllerServiceId) {
        this.controllerServiceDAO.clearState(controllerServiceId);
    }

    public void verifyCanClearReportingTaskState(String reportingTaskId) {
        this.reportingTaskDAO.verifyClearState(reportingTaskId);
    }

    public void clearReportingTaskState(String reportingTaskId) {
        this.reportingTaskDAO.clearState(reportingTaskId);
    }

    public ComponentStateDTO getRemoteProcessGroupState(String remoteProcessGroupId) {
        StateMap clusterState = this.isClustered() ? this.remoteProcessGroupDAO.getState(remoteProcessGroupId, Scope.CLUSTER) : null;
        StateMap localState = this.remoteProcessGroupDAO.getState(remoteProcessGroupId, Scope.LOCAL);
        RemoteProcessGroup remoteProcessGroup = this.remoteProcessGroupDAO.getRemoteProcessGroup(remoteProcessGroupId);
        return this.dtoFactory.createComponentStateDTO(remoteProcessGroupId, remoteProcessGroup.getClass(), localState, clusterState);
    }

    public ConnectionEntity deleteConnection(Revision revision, String connectionId) {
        Connection connection = this.connectionDAO.getConnection(connectionId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)connection);
        ConnectionDTO snapshot = (ConnectionDTO)this.deleteComponent(revision, connection.getResource(), () -> this.connectionDAO.deleteConnection(connectionId), false, (Object)this.dtoFactory.createConnectionDto(connection));
        return this.entityFactory.createConnectionEntity(snapshot, null, permissions, null);
    }

    public DropRequestDTO deleteFlowFileDropRequest(String connectionId, String dropRequestId) {
        return this.dtoFactory.createDropRequestDTO(this.connectionDAO.deleteFlowFileDropRequest(connectionId, dropRequestId));
    }

    public ListingRequestDTO deleteFlowFileListingRequest(String connectionId, String listingRequestId) {
        Connection connection = this.connectionDAO.getConnection(connectionId);
        ListingRequestDTO listRequest = this.dtoFactory.createListingRequestDTO(this.connectionDAO.deleteFlowFileListingRequest(connectionId, listingRequestId));
        if (connection.getSource() != null) {
            listRequest.setSourceRunning(Boolean.valueOf(connection.getSource().isRunning()));
        }
        if (connection.getDestination() != null) {
            listRequest.setDestinationRunning(Boolean.valueOf(connection.getDestination().isRunning()));
        }
        return listRequest;
    }

    public ProcessorEntity deleteProcessor(Revision revision, String processorId) {
        ProcessorNode processor = this.processorDAO.getProcessor(processorId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processor);
        PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)processor));
        ProcessorDTO snapshot = (ProcessorDTO)this.deleteComponent(revision, processor.getResource(), () -> this.processorDAO.deleteProcessor(processorId), true, (Object)this.dtoFactory.createProcessorDto(processor));
        return this.entityFactory.createProcessorEntity(snapshot, null, permissions, operatePermissions, null, null);
    }

    public ProcessorEntity terminateProcessor(String processorId) {
        this.processorDAO.terminate(processorId);
        return this.getProcessor(processorId);
    }

    public void verifyTerminateProcessor(String processorId) {
        this.processorDAO.verifyTerminate(processorId);
    }

    public LabelEntity deleteLabel(Revision revision, String labelId) {
        Label label = this.labelDAO.getLabel(labelId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)label);
        LabelDTO snapshot = (LabelDTO)this.deleteComponent(revision, label.getResource(), () -> this.labelDAO.deleteLabel(labelId), true, (Object)this.dtoFactory.createLabelDto(label));
        return this.entityFactory.createLabelEntity(snapshot, null, permissions);
    }

    public UserEntity deleteUser(Revision revision, String userId) {
        User user = this.userDAO.getUser(userId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto(this.authorizableLookup.getTenant());
        Set userGroups = user != null ? this.userGroupDAO.getUserGroupsForUser(userId).stream().map(g -> g.getIdentifier()).map(this.mapUserGroupIdToTenantEntity(false)).collect(Collectors.toSet()) : null;
        Set policyEntities = user != null ? this.userGroupDAO.getAccessPoliciesForUser(userId).stream().map(ap -> this.createAccessPolicySummaryEntity(ap)).collect(Collectors.toSet()) : null;
        String resourceIdentifier = ResourceFactory.getTenantResource().getIdentifier() + "/" + userId;
        UserDTO snapshot = (UserDTO)this.deleteComponent(revision, (Resource)new /* Unavailable Anonymous Inner Class!! */, () -> this.userDAO.deleteUser(userId), false, (Object)this.dtoFactory.createUserDto(user, userGroups, policyEntities));
        return this.entityFactory.createUserEntity(snapshot, null, permissions);
    }

    public UserGroupEntity deleteUserGroup(Revision revision, String userGroupId) {
        Group userGroup = this.userGroupDAO.getUserGroup(userGroupId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto(this.authorizableLookup.getTenant());
        Set users = userGroup != null ? userGroup.getUsers().stream().map(this.mapUserIdToTenantEntity(false)).collect(Collectors.toSet()) : null;
        Set policyEntities = this.userGroupDAO.getAccessPoliciesForUserGroup(userGroup.getIdentifier()).stream().map(ap -> this.createAccessPolicySummaryEntity(ap)).collect(Collectors.toSet());
        String resourceIdentifier = ResourceFactory.getTenantResource().getIdentifier() + "/" + userGroupId;
        UserGroupDTO snapshot = (UserGroupDTO)this.deleteComponent(revision, (Resource)new /* Unavailable Anonymous Inner Class!! */, () -> this.userGroupDAO.deleteUserGroup(userGroupId), false, (Object)this.dtoFactory.createUserGroupDto(userGroup, users, policyEntities));
        return this.entityFactory.createUserGroupEntity(snapshot, null, permissions);
    }

    public AccessPolicyEntity deleteAccessPolicy(Revision revision, String accessPolicyId) {
        AccessPolicy accessPolicy = this.accessPolicyDAO.getAccessPolicy(accessPolicyId);
        ComponentReferenceEntity componentReference = this.createComponentReferenceEntity(accessPolicy.getResource());
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto(this.authorizableLookup.getAccessPolicyById(accessPolicyId));
        Set userGroups = accessPolicy != null ? accessPolicy.getGroups().stream().map(this.mapUserGroupIdToTenantEntity(false)).collect(Collectors.toSet()) : null;
        Set users = accessPolicy != null ? accessPolicy.getUsers().stream().map(this.mapUserIdToTenantEntity(false)).collect(Collectors.toSet()) : null;
        AccessPolicyDTO snapshot = (AccessPolicyDTO)this.deleteComponent(revision, (Resource)new /* Unavailable Anonymous Inner Class!! */, () -> this.accessPolicyDAO.deleteAccessPolicy(accessPolicyId), false, (Object)this.dtoFactory.createAccessPolicyDto(accessPolicy, userGroups, users, componentReference));
        return this.entityFactory.createAccessPolicyEntity(snapshot, null, permissions);
    }

    public FunnelEntity deleteFunnel(Revision revision, String funnelId) {
        Funnel funnel = this.funnelDAO.getFunnel(funnelId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)funnel);
        FunnelDTO snapshot = (FunnelDTO)this.deleteComponent(revision, funnel.getResource(), () -> this.funnelDAO.deleteFunnel(funnelId), true, (Object)this.dtoFactory.createFunnelDto(funnel));
        return this.entityFactory.createFunnelEntity(snapshot, null, permissions);
    }

    private <D, C> D deleteComponent(Revision revision, Resource resource, Runnable deleteAction, boolean cleanUpPolicies, D dto) {
        StandardRevisionClaim claim = new StandardRevisionClaim(new Revision[]{revision});
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        return (D)this.revisionManager.deleteRevision((RevisionClaim)claim, user, (DeleteRevisionTask)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void cleanUpPolicies(Resource componentResource) {
        if (this.accessPolicyDAO.supportsConfigurableAuthorizer()) {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            resources.add(componentResource);
            resources.add(ResourceFactory.getDataResource((Resource)componentResource));
            resources.add(ResourceFactory.getProvenanceDataResource((Resource)componentResource));
            resources.add(ResourceFactory.getDataTransferResource((Resource)componentResource));
            resources.add(ResourceFactory.getPolicyResource((Resource)componentResource));
            resources.add(ResourceFactory.getOperationResource((Resource)componentResource));
            for (Resource resource : resources) {
                for (RequestAction action : RequestAction.values()) {
                    try {
                        AccessPolicy readPolicy = this.accessPolicyDAO.getAccessPolicy(action, resource.getIdentifier());
                        if (readPolicy == null) continue;
                        this.accessPolicyDAO.deleteAccessPolicy(readPolicy.getIdentifier());
                    }
                    catch (Exception e) {
                        logger.warn(String.format("Unable to remove access policy for %s %s after component removal.", action, resource.getIdentifier()), (Throwable)e);
                    }
                }
            }
        }
    }

    public void verifyDeleteSnippet(String snippetId, Set<String> affectedComponentIds) {
        this.snippetDAO.verifyDeleteSnippetComponents(snippetId);
    }

    public SnippetEntity deleteSnippet(Set<Revision> revisions, String snippetId) {
        Snippet snippet = this.snippetDAO.getSnippet(snippetId);
        HashSet snippetResources = new HashSet();
        snippet.getProcessors().keySet().forEach(id -> snippetResources.add(this.processorDAO.getProcessor(id).getResource()));
        snippet.getInputPorts().keySet().forEach(id -> snippetResources.add(this.inputPortDAO.getPort(id).getResource()));
        snippet.getOutputPorts().keySet().forEach(id -> snippetResources.add(this.outputPortDAO.getPort(id).getResource()));
        snippet.getFunnels().keySet().forEach(id -> snippetResources.add(this.funnelDAO.getFunnel(id).getResource()));
        snippet.getLabels().keySet().forEach(id -> snippetResources.add(this.labelDAO.getLabel(id).getResource()));
        snippet.getRemoteProcessGroups().keySet().forEach(id -> snippetResources.add(this.remoteProcessGroupDAO.getRemoteProcessGroup(id).getResource()));
        snippet.getProcessGroups().keySet().forEach(id -> {
            ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(id);
            snippetResources.add(processGroup.getResource());
            processGroup.findAllProcessors().forEach(processor -> snippetResources.add(processor.getResource()));
            processGroup.findAllInputPorts().forEach(inputPort -> snippetResources.add(inputPort.getResource()));
            processGroup.findAllOutputPorts().forEach(outputPort -> snippetResources.add(outputPort.getResource()));
            processGroup.findAllFunnels().forEach(funnel -> snippetResources.add(funnel.getResource()));
            processGroup.findAllLabels().forEach(label -> snippetResources.add(label.getResource()));
            processGroup.findAllProcessGroups().forEach(childGroup -> snippetResources.add(childGroup.getResource()));
            processGroup.findAllRemoteProcessGroups().forEach(remoteProcessGroup -> snippetResources.add(remoteProcessGroup.getResource()));
            processGroup.findAllTemplates().forEach(template -> snippetResources.add(template.getResource()));
            processGroup.findAllControllerServices().forEach(controllerService -> snippetResources.add(controllerService.getResource()));
        });
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        StandardRevisionClaim claim = new StandardRevisionClaim(revisions);
        SnippetDTO dto = (SnippetDTO)this.revisionManager.deleteRevision((RevisionClaim)claim, user, (DeleteRevisionTask)new /* Unavailable Anonymous Inner Class!! */);
        snippetResources.forEach(resource -> this.cleanUpPolicies(resource));
        return this.entityFactory.createSnippetEntity(dto);
    }

    public PortEntity deleteInputPort(Revision revision, String inputPortId) {
        Port port = this.inputPortDAO.getPort(inputPortId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)port);
        PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)port));
        PortDTO snapshot = (PortDTO)this.deleteComponent(revision, port.getResource(), () -> this.inputPortDAO.deletePort(inputPortId), true, (Object)this.dtoFactory.createPortDto(port));
        return this.entityFactory.createPortEntity(snapshot, null, permissions, operatePermissions, null, null);
    }

    public PortEntity deleteOutputPort(Revision revision, String outputPortId) {
        Port port = this.outputPortDAO.getPort(outputPortId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)port);
        PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)port));
        PortDTO snapshot = (PortDTO)this.deleteComponent(revision, port.getResource(), () -> this.outputPortDAO.deletePort(outputPortId), true, (Object)this.dtoFactory.createPortDto(port));
        return this.entityFactory.createPortEntity(snapshot, null, permissions, operatePermissions, null, null);
    }

    public DropRequestDTO createDropAllFlowFilesInProcessGroup(String processGroupId, String dropRequestId) {
        return this.dtoFactory.createDropRequestDTO(this.processGroupDAO.createDropAllFlowFilesRequest(processGroupId, dropRequestId));
    }

    public DropRequestDTO getDropAllFlowFilesRequest(String processGroupId, String dropRequestId) {
        return this.dtoFactory.createDropRequestDTO(this.processGroupDAO.getDropAllFlowFilesRequest(processGroupId, dropRequestId));
    }

    public DropRequestDTO deleteDropAllFlowFilesRequest(String processGroupId, String dropRequestId) {
        return this.dtoFactory.createDropRequestDTO(this.processGroupDAO.deleteDropAllFlowFilesRequest(processGroupId, dropRequestId));
    }

    public ProcessGroupEntity deleteProcessGroup(Revision revision, String groupId) {
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(groupId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processGroup);
        HashSet groupResources = new HashSet();
        processGroup.findAllProcessors().forEach(processor -> groupResources.add(processor.getResource()));
        processGroup.findAllInputPorts().forEach(inputPort -> groupResources.add(inputPort.getResource()));
        processGroup.findAllOutputPorts().forEach(outputPort -> groupResources.add(outputPort.getResource()));
        processGroup.findAllFunnels().forEach(funnel -> groupResources.add(funnel.getResource()));
        processGroup.findAllLabels().forEach(label -> groupResources.add(label.getResource()));
        processGroup.findAllProcessGroups().forEach(childGroup -> groupResources.add(childGroup.getResource()));
        processGroup.findAllRemoteProcessGroups().forEach(remoteProcessGroup -> groupResources.add(remoteProcessGroup.getResource()));
        processGroup.findAllTemplates().forEach(template -> groupResources.add(template.getResource()));
        processGroup.findAllControllerServices().forEach(controllerService -> groupResources.add(controllerService.getResource()));
        ProcessGroupDTO snapshot = (ProcessGroupDTO)this.deleteComponent(revision, processGroup.getResource(), () -> this.processGroupDAO.deleteProcessGroup(groupId), true, (Object)this.dtoFactory.createProcessGroupDto(processGroup));
        groupResources.forEach(groupResource -> this.cleanUpPolicies(groupResource));
        return this.entityFactory.createProcessGroupEntity(snapshot, null, permissions, null, null);
    }

    public RemoteProcessGroupEntity deleteRemoteProcessGroup(Revision revision, String remoteProcessGroupId) {
        RemoteProcessGroup remoteProcessGroup = this.remoteProcessGroupDAO.getRemoteProcessGroup(remoteProcessGroupId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)remoteProcessGroup);
        PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)remoteProcessGroup));
        RemoteProcessGroupDTO snapshot = (RemoteProcessGroupDTO)this.deleteComponent(revision, remoteProcessGroup.getResource(), () -> this.remoteProcessGroupDAO.deleteRemoteProcessGroup(remoteProcessGroupId), true, (Object)this.dtoFactory.createRemoteProcessGroupDto(remoteProcessGroup));
        return this.entityFactory.createRemoteProcessGroupEntity(snapshot, null, permissions, operatePermissions, null, null);
    }

    public void deleteTemplate(String id) {
        this.templateDAO.deleteTemplate(id);
        this.controllerFacade.save();
    }

    public ConnectionEntity createConnection(Revision revision, String groupId, ConnectionDTO connectionDTO) {
        RevisionUpdate snapshot = this.createComponent(revision, (ComponentDTO)connectionDTO, () -> this.connectionDAO.createConnection(groupId, connectionDTO), connection -> this.dtoFactory.createConnectionDto(connection));
        Connection connection2 = this.connectionDAO.getConnection(connectionDTO.getId());
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)connection2);
        ConnectionStatusDTO status = this.dtoFactory.createConnectionStatusDto(this.controllerFacade.getConnectionStatus(connectionDTO.getId()));
        return this.entityFactory.createConnectionEntity((ConnectionDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, status);
    }

    public DropRequestDTO createFlowFileDropRequest(String connectionId, String dropRequestId) {
        return this.dtoFactory.createDropRequestDTO(this.connectionDAO.createFlowFileDropRequest(connectionId, dropRequestId));
    }

    public ListingRequestDTO createFlowFileListingRequest(String connectionId, String listingRequestId) {
        Connection connection = this.connectionDAO.getConnection(connectionId);
        ListingRequestDTO listRequest = this.dtoFactory.createListingRequestDTO(this.connectionDAO.createFlowFileListingRequest(connectionId, listingRequestId));
        if (connection.getSource() != null) {
            listRequest.setSourceRunning(Boolean.valueOf(connection.getSource().isRunning()));
        }
        if (connection.getDestination() != null) {
            listRequest.setDestinationRunning(Boolean.valueOf(connection.getDestination().isRunning()));
        }
        return listRequest;
    }

    public ProcessorEntity createProcessor(Revision revision, String groupId, ProcessorDTO processorDTO) {
        RevisionUpdate snapshot = this.createComponent(revision, (ComponentDTO)processorDTO, () -> this.processorDAO.createProcessor(groupId, processorDTO), processor -> {
            this.awaitValidationCompletion((ComponentNode)processor);
            return this.dtoFactory.createProcessorDto(processor);
        });
        ProcessorNode processor2 = this.processorDAO.getProcessor(processorDTO.getId());
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processor2);
        PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)processor2));
        ProcessorStatusDTO status = this.dtoFactory.createProcessorStatusDto(this.controllerFacade.getProcessorStatus(processorDTO.getId()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(processorDTO.getId()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createProcessorEntity((ProcessorDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, operatePermissions, status, bulletinEntities);
    }

    public LabelEntity createLabel(Revision revision, String groupId, LabelDTO labelDTO) {
        RevisionUpdate snapshot = this.createComponent(revision, (ComponentDTO)labelDTO, () -> this.labelDAO.createLabel(groupId, labelDTO), label -> this.dtoFactory.createLabelDto(label));
        Label label2 = this.labelDAO.getLabel(labelDTO.getId());
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)label2);
        return this.entityFactory.createLabelEntity((LabelDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions);
    }

    private <D, C> RevisionUpdate<D> createComponent(Revision revision, ComponentDTO componentDto, Supplier<C> daoCreation, Function<C, D> dtoCreation) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        StandardRevisionClaim claim = new StandardRevisionClaim(new Revision[]{revision});
        return this.revisionManager.updateRevision((RevisionClaim)claim, user, () -> {
            Object component = daoCreation.get();
            this.controllerFacade.save();
            Object dto = dtoCreation.apply(component);
            FlowModification lastMod = new FlowModification(revision.incrementRevision(revision.getClientId()), user.getIdentity());
            return new StandardRevisionUpdate(dto, lastMod);
        });
    }

    public BulletinEntity createBulletin(BulletinDTO bulletinDTO, Boolean canRead) {
        Bulletin bulletin = BulletinFactory.createBulletin((String)bulletinDTO.getCategory(), (String)bulletinDTO.getLevel(), (String)bulletinDTO.getMessage());
        this.bulletinRepository.addBulletin(bulletin);
        return this.entityFactory.createBulletinEntity(this.dtoFactory.createBulletinDto(bulletin), canRead.booleanValue());
    }

    public FunnelEntity createFunnel(Revision revision, String groupId, FunnelDTO funnelDTO) {
        RevisionUpdate snapshot = this.createComponent(revision, (ComponentDTO)funnelDTO, () -> this.funnelDAO.createFunnel(groupId, funnelDTO), funnel -> this.dtoFactory.createFunnelDto(funnel));
        Funnel funnel2 = this.funnelDAO.getFunnel(funnelDTO.getId());
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)funnel2);
        return this.entityFactory.createFunnelEntity((FunnelDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions);
    }

    public AccessPolicyEntity createAccessPolicy(Revision revision, AccessPolicyDTO accessPolicyDTO) {
        Authorizable tenantAuthorizable = this.authorizableLookup.getTenant();
        String creator = NiFiUserUtils.getNiFiUserIdentity();
        AccessPolicy newAccessPolicy = this.accessPolicyDAO.createAccessPolicy(accessPolicyDTO);
        ComponentReferenceEntity componentReference = this.createComponentReferenceEntity(newAccessPolicy.getResource());
        AccessPolicyDTO newAccessPolicyDto = this.dtoFactory.createAccessPolicyDto(newAccessPolicy, newAccessPolicy.getGroups().stream().map(this.mapUserGroupIdToTenantEntity(false)).collect(Collectors.toSet()), newAccessPolicy.getUsers().stream().map(userId -> {
            RevisionDTO userRevision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(userId));
            return this.entityFactory.createTenantEntity(this.dtoFactory.createTenantDTO(this.userDAO.getUser(userId)), userRevision, this.dtoFactory.createPermissionsDto(tenantAuthorizable));
        }).collect(Collectors.toSet()), componentReference);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto(this.authorizableLookup.getAccessPolicyById(accessPolicyDTO.getId()));
        return this.entityFactory.createAccessPolicyEntity(newAccessPolicyDto, this.dtoFactory.createRevisionDTO(new FlowModification(revision, creator)), permissions);
    }

    public UserEntity createUser(Revision revision, UserDTO userDTO) {
        String creator = NiFiUserUtils.getNiFiUserIdentity();
        User newUser = this.userDAO.createUser(userDTO);
        Set tenantEntities = this.userGroupDAO.getUserGroupsForUser(newUser.getIdentifier()).stream().map(g -> g.getIdentifier()).map(this.mapUserGroupIdToTenantEntity(false)).collect(Collectors.toSet());
        Set policyEntities = this.userGroupDAO.getAccessPoliciesForUser(newUser.getIdentifier()).stream().map(ap -> this.createAccessPolicySummaryEntity(ap)).collect(Collectors.toSet());
        UserDTO newUserDto = this.dtoFactory.createUserDto(newUser, tenantEntities, policyEntities);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto(this.authorizableLookup.getTenant());
        return this.entityFactory.createUserEntity(newUserDto, this.dtoFactory.createRevisionDTO(new FlowModification(revision, creator)), permissions);
    }

    private ComponentReferenceEntity createComponentReferenceEntity(String resource) {
        ComponentReferenceEntity componentReferenceEntity = null;
        try {
            ComponentReferenceDTO componentReference;
            Authorizable componentAuthorizable = this.authorizableLookup.getAuthorizableFromResource(resource);
            if (componentAuthorizable instanceof EnforcePolicyPermissionsThroughBaseResource) {
                componentAuthorizable = ((EnforcePolicyPermissionsThroughBaseResource)componentAuthorizable).getBaseAuthorizable();
            }
            if ((componentReference = this.dtoFactory.createComponentReferenceDto(componentAuthorizable)) != null) {
                PermissionsDTO componentReferencePermissions = this.dtoFactory.createPermissionsDto(componentAuthorizable);
                RevisionDTO componentReferenceRevision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(componentReference.getId()));
                componentReferenceEntity = this.entityFactory.createComponentReferenceEntity(componentReference, componentReferenceRevision, componentReferencePermissions);
            }
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
        return componentReferenceEntity;
    }

    private AccessPolicySummaryEntity createAccessPolicySummaryEntity(AccessPolicy ap) {
        ComponentReferenceEntity componentReference = this.createComponentReferenceEntity(ap.getResource());
        AccessPolicySummaryDTO apSummary = this.dtoFactory.createAccessPolicySummaryDto(ap, componentReference);
        PermissionsDTO apPermissions = this.dtoFactory.createPermissionsDto(this.authorizableLookup.getAccessPolicyById(ap.getIdentifier()));
        RevisionDTO apRevision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(ap.getIdentifier()));
        return this.entityFactory.createAccessPolicySummaryEntity(apSummary, apRevision, apPermissions);
    }

    public UserGroupEntity createUserGroup(Revision revision, UserGroupDTO userGroupDTO) {
        String creator = NiFiUserUtils.getNiFiUserIdentity();
        Group newUserGroup = this.userGroupDAO.createUserGroup(userGroupDTO);
        Set tenantEntities = newUserGroup.getUsers().stream().map(this.mapUserIdToTenantEntity(false)).collect(Collectors.toSet());
        Set policyEntities = this.userGroupDAO.getAccessPoliciesForUserGroup(newUserGroup.getIdentifier()).stream().map(ap -> this.createAccessPolicySummaryEntity(ap)).collect(Collectors.toSet());
        UserGroupDTO newUserGroupDto = this.dtoFactory.createUserGroupDto(newUserGroup, tenantEntities, policyEntities);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto(this.authorizableLookup.getTenant());
        return this.entityFactory.createUserGroupEntity(newUserGroupDto, this.dtoFactory.createRevisionDTO(new FlowModification(revision, creator)), permissions);
    }

    private void validateSnippetContents(FlowSnippetDTO flow) {
        Port port;
        ArrayList<String> errors;
        Collection validationErrors;
        if (flow.getProcessors() != null) {
            for (ProcessorDTO processorDTO : flow.getProcessors()) {
                ProcessorNode processorNode = this.processorDAO.getProcessor(processorDTO.getId());
                processorDTO.setValidationStatus(processorNode.getValidationStatus().name());
                validationErrors = processorNode.getValidationErrors();
                if (validationErrors == null || validationErrors.isEmpty()) continue;
                errors = new ArrayList();
                for (ValidationResult validationResult : validationErrors) {
                    errors.add(validationResult.toString());
                }
                processorDTO.setValidationErrors(errors);
            }
        }
        if (flow.getInputPorts() != null) {
            for (PortDTO portDTO : flow.getInputPorts()) {
                port = this.inputPortDAO.getPort(portDTO.getId());
                validationErrors = port.getValidationErrors();
                if (validationErrors == null || validationErrors.isEmpty()) continue;
                errors = new ArrayList<String>();
                for (ValidationResult validationResult : validationErrors) {
                    errors.add(validationResult.toString());
                }
                portDTO.setValidationErrors(errors);
            }
        }
        if (flow.getOutputPorts() != null) {
            for (PortDTO portDTO : flow.getOutputPorts()) {
                port = this.outputPortDAO.getPort(portDTO.getId());
                validationErrors = port.getValidationErrors();
                if (validationErrors == null || validationErrors.isEmpty()) continue;
                errors = new ArrayList();
                for (ValidationResult validationResult : validationErrors) {
                    errors.add(validationResult.toString());
                }
                portDTO.setValidationErrors(errors);
            }
        }
        if (flow.getRemoteProcessGroups() != null) {
            for (RemoteProcessGroupDTO remoteProcessGroupDTO : flow.getRemoteProcessGroups()) {
                RemoteProcessGroup remoteProcessGroup = this.remoteProcessGroupDAO.getRemoteProcessGroup(remoteProcessGroupDTO.getId());
                if (remoteProcessGroup.getAuthorizationIssue() == null) continue;
                remoteProcessGroupDTO.setAuthorizationIssues(Arrays.asList(remoteProcessGroup.getAuthorizationIssue()));
            }
        }
    }

    public FlowEntity copySnippet(String groupId, String snippetId, Double originX, Double originY, String idGenerationSeed) {
        FlowSnippetDTO snippet = this.snippetDAO.copySnippet(groupId, snippetId, originX, originY, idGenerationSeed);
        this.controllerFacade.save();
        this.snippetDAO.dropSnippet(snippetId);
        FlowDTO flowDto = this.postProcessNewFlowSnippet(groupId, snippet);
        FlowEntity flowEntity = new FlowEntity();
        flowEntity.setFlow(flowDto);
        return flowEntity;
    }

    public SnippetEntity createSnippet(SnippetDTO snippetDTO) {
        Snippet snippet = this.snippetDAO.createSnippet(snippetDTO);
        this.controllerFacade.save();
        SnippetDTO dto = this.dtoFactory.createSnippetDto(snippet);
        StandardRevisionUpdate snapshot = new StandardRevisionUpdate((Object)dto, null);
        return this.entityFactory.createSnippetEntity((SnippetDTO)snapshot.getComponent());
    }

    public PortEntity createInputPort(Revision revision, String groupId, PortDTO inputPortDTO) {
        RevisionUpdate snapshot = this.createComponent(revision, (ComponentDTO)inputPortDTO, () -> this.inputPortDAO.createPort(groupId, inputPortDTO), port -> this.dtoFactory.createPortDto(port));
        Port port2 = this.inputPortDAO.getPort(inputPortDTO.getId());
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)port2);
        PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)port2));
        PortStatusDTO status = this.dtoFactory.createPortStatusDto(this.controllerFacade.getInputPortStatus(port2.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(port2.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createPortEntity((PortDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, operatePermissions, status, bulletinEntities);
    }

    public PortEntity createOutputPort(Revision revision, String groupId, PortDTO outputPortDTO) {
        RevisionUpdate snapshot = this.createComponent(revision, (ComponentDTO)outputPortDTO, () -> this.outputPortDAO.createPort(groupId, outputPortDTO), port -> this.dtoFactory.createPortDto(port));
        Port port2 = this.outputPortDAO.getPort(outputPortDTO.getId());
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)port2);
        PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)port2));
        PortStatusDTO status = this.dtoFactory.createPortStatusDto(this.controllerFacade.getOutputPortStatus(port2.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(port2.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createPortEntity((PortDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, operatePermissions, status, bulletinEntities);
    }

    public ProcessGroupEntity createProcessGroup(Revision revision, String parentGroupId, ProcessGroupDTO processGroupDTO) {
        RevisionUpdate snapshot = this.createComponent(revision, (ComponentDTO)processGroupDTO, () -> this.processGroupDAO.createProcessGroup(parentGroupId, processGroupDTO), processGroup -> this.dtoFactory.createProcessGroupDto(processGroup));
        ProcessGroup processGroup2 = this.processGroupDAO.getProcessGroup(processGroupDTO.getId());
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processGroup2);
        ProcessGroupStatusDTO status = this.dtoFactory.createConciseProcessGroupStatusDto(this.controllerFacade.getProcessGroupStatus(processGroup2.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(processGroup2.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createProcessGroupEntity((ProcessGroupDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, status, bulletinEntities);
    }

    public RemoteProcessGroupEntity createRemoteProcessGroup(Revision revision, String groupId, RemoteProcessGroupDTO remoteProcessGroupDTO) {
        RevisionUpdate snapshot = this.createComponent(revision, (ComponentDTO)remoteProcessGroupDTO, () -> this.remoteProcessGroupDAO.createRemoteProcessGroup(groupId, remoteProcessGroupDTO), remoteProcessGroup -> this.dtoFactory.createRemoteProcessGroupDto(remoteProcessGroup));
        RemoteProcessGroup remoteProcessGroup2 = this.remoteProcessGroupDAO.getRemoteProcessGroup(remoteProcessGroupDTO.getId());
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)remoteProcessGroup2);
        PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)remoteProcessGroup2));
        RemoteProcessGroupStatusDTO status = this.dtoFactory.createRemoteProcessGroupStatusDto(remoteProcessGroup2, this.controllerFacade.getRemoteProcessGroupStatus(remoteProcessGroup2.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(remoteProcessGroup2.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createRemoteProcessGroupEntity((RemoteProcessGroupDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, operatePermissions, status, bulletinEntities);
    }

    public boolean isRemoteGroupPortConnected(String remoteProcessGroupId, String remotePortId) {
        RemoteProcessGroup rpg = this.remoteProcessGroupDAO.getRemoteProcessGroup(remoteProcessGroupId);
        RemoteGroupPort port = rpg.getInputPort(remotePortId);
        if (port != null) {
            return port.hasIncomingConnection();
        }
        port = rpg.getOutputPort(remotePortId);
        if (port != null) {
            return !port.getConnections().isEmpty();
        }
        throw new ResourceNotFoundException("Could not find Port with ID " + remotePortId + " as a child of RemoteProcessGroup with ID " + remoteProcessGroupId);
    }

    public void verifyCanAddTemplate(String groupId, String name) {
        this.templateDAO.verifyCanAddTemplate(name, groupId);
    }

    public void verifyCanInstantiate(String groupId, FlowSnippetDTO snippetDTO) {
        this.templateDAO.verifyCanInstantiate(groupId, snippetDTO);
    }

    public void verifyComponentTypes(VersionedProcessGroup versionedGroup) {
        this.controllerFacade.verifyComponentTypes(versionedGroup);
    }

    public void verifyImportProcessGroup(VersionControlInformationDTO versionControlInfo, VersionedProcessGroup contents, String groupId) {
        ProcessGroup group = this.processGroupDAO.getProcessGroup(groupId);
        this.verifyImportProcessGroup(versionControlInfo, contents, group);
    }

    private void verifyImportProcessGroup(VersionControlInformationDTO vciDto, VersionedProcessGroup contents, ProcessGroup group) {
        if (group == null) {
            return;
        }
        VersionControlInformation vci = group.getVersionControlInformation();
        if (vci != null && Objects.equals(vciDto.getBucketId(), vci.getBucketIdentifier()) && Objects.equals(vciDto.getFlowId(), vci.getFlowIdentifier())) {
            throw new IllegalStateException("Cannot import the specified Versioned Flow into the Process Group because doing so would cause a recursive dataflow. If Process Group A contains Process Group B, then Process Group B is not allowed to contain the flow identified by Process Group A.");
        }
        Set childGroups = contents.getProcessGroups();
        if (childGroups != null) {
            for (VersionedProcessGroup childGroup : childGroups) {
                VersionedFlowCoordinates childCoordinates = childGroup.getVersionedFlowCoordinates();
                if (childCoordinates == null) continue;
                VersionControlInformationDTO childVci = new VersionControlInformationDTO();
                childVci.setBucketId(childCoordinates.getBucketId());
                childVci.setFlowId(childCoordinates.getFlowId());
                this.verifyImportProcessGroup(childVci, childGroup, group);
            }
        }
        this.verifyImportProcessGroup(vciDto, contents, group.getParent());
    }

    public TemplateDTO createTemplate(String name, String description, String snippetId, String groupId, Optional<String> idGenerationSeed) {
        Snippet snippet = this.snippetDAO.getSnippet(snippetId);
        TemplateDTO templateDTO = new TemplateDTO();
        templateDTO.setName(name);
        templateDTO.setDescription(description);
        templateDTO.setTimestamp(new Date());
        templateDTO.setSnippet(this.snippetUtils.populateFlowSnippet(snippet, true, true, true));
        templateDTO.setEncodingVersion("1.3");
        String uuid = idGenerationSeed.isPresent() ? UUID.nameUUIDFromBytes(idGenerationSeed.get().getBytes(StandardCharsets.UTF_8)).toString() : UUID.randomUUID().toString();
        templateDTO.setId(uuid);
        Template template = this.templateDAO.createTemplate(templateDTO, groupId);
        this.snippetDAO.dropSnippet(snippetId);
        this.controllerFacade.save();
        return this.dtoFactory.createTemplateDTO(template);
    }

    private void ensureDefaultPropertyValuesArePopulated(FlowSnippetDTO snippet) {
        if (snippet != null) {
            if (snippet.getControllerServices() != null) {
                snippet.getControllerServices().forEach(dto -> {
                    if (dto.getProperties() == null) {
                        dto.setProperties(new LinkedHashMap());
                    }
                    try {
                        ConfigurableComponent configurableComponent = this.controllerFacade.getTemporaryComponent(dto.getType(), dto.getBundle());
                        configurableComponent.getPropertyDescriptors().forEach(descriptor -> {
                            if (dto.getProperties().get(descriptor.getName()) == null) {
                                dto.getProperties().put(descriptor.getName(), descriptor.getDefaultValue());
                            }
                        });
                    }
                    catch (Exception e) {
                        logger.warn(String.format("Unable to create ControllerService of type %s to populate default values.", dto.getType()));
                    }
                });
            }
            if (snippet.getProcessors() != null) {
                snippet.getProcessors().forEach(dto -> {
                    ProcessorConfigDTO config;
                    if (dto.getConfig() == null) {
                        dto.setConfig(new ProcessorConfigDTO());
                    }
                    if ((config = dto.getConfig()).getProperties() == null) {
                        config.setProperties(new LinkedHashMap());
                    }
                    try {
                        ConfigurableComponent configurableComponent = this.controllerFacade.getTemporaryComponent(dto.getType(), dto.getBundle());
                        configurableComponent.getPropertyDescriptors().forEach(descriptor -> {
                            if (config.getProperties().get(descriptor.getName()) == null) {
                                config.getProperties().put(descriptor.getName(), descriptor.getDefaultValue());
                            }
                        });
                    }
                    catch (Exception e) {
                        logger.warn(String.format("Unable to create Processor of type %s to populate default values.", dto.getType()));
                    }
                });
            }
            if (snippet.getProcessGroups() != null) {
                snippet.getProcessGroups().forEach(processGroup -> this.ensureDefaultPropertyValuesArePopulated(processGroup.getContents()));
            }
        }
    }

    public TemplateDTO importTemplate(TemplateDTO templateDTO, String groupId, Optional<String> idGenerationSeed) {
        String uuid = idGenerationSeed.isPresent() ? UUID.nameUUIDFromBytes(idGenerationSeed.get().getBytes(StandardCharsets.UTF_8)).toString() : UUID.randomUUID().toString();
        templateDTO.setId(uuid);
        templateDTO.setTimestamp(new Date());
        this.ensureDefaultPropertyValuesArePopulated(templateDTO.getSnippet());
        Template template = this.templateDAO.importTemplate(templateDTO, groupId);
        this.controllerFacade.save();
        return this.dtoFactory.createTemplateDTO(template);
    }

    private FlowDTO postProcessNewFlowSnippet(String groupId, FlowSnippetDTO snippet) {
        this.validateSnippetContents(snippet);
        HashSet identifiers = new HashSet();
        snippet.getProcessors().stream().map(proc -> proc.getId()).forEach(id -> identifiers.add(id));
        snippet.getConnections().stream().map(conn -> conn.getId()).forEach(id -> identifiers.add(id));
        snippet.getInputPorts().stream().map(port -> port.getId()).forEach(id -> identifiers.add(id));
        snippet.getOutputPorts().stream().map(port -> port.getId()).forEach(id -> identifiers.add(id));
        snippet.getProcessGroups().stream().map(group -> group.getId()).forEach(id -> identifiers.add(id));
        snippet.getRemoteProcessGroups().stream().map(remoteGroup -> remoteGroup.getId()).forEach(id -> identifiers.add(id));
        snippet.getRemoteProcessGroups().stream().filter(remoteGroup -> remoteGroup.getContents() != null && remoteGroup.getContents().getInputPorts() != null).flatMap(remoteGroup -> remoteGroup.getContents().getInputPorts().stream()).map(remoteInputPort -> remoteInputPort.getId()).forEach(id -> identifiers.add(id));
        snippet.getRemoteProcessGroups().stream().filter(remoteGroup -> remoteGroup.getContents() != null && remoteGroup.getContents().getOutputPorts() != null).flatMap(remoteGroup -> remoteGroup.getContents().getOutputPorts().stream()).map(remoteOutputPort -> remoteOutputPort.getId()).forEach(id -> identifiers.add(id));
        snippet.getLabels().stream().map(label -> label.getId()).forEach(id -> identifiers.add(id));
        ProcessGroup group2 = this.processGroupDAO.getProcessGroup(groupId);
        ProcessGroupStatus groupStatus = this.controllerFacade.getProcessGroupStatus(groupId);
        return this.dtoFactory.createFlowDto(group2, groupStatus, snippet, this.revisionManager, arg_0 -> this.getProcessGroupBulletins(arg_0));
    }

    public FlowEntity createTemplateInstance(String groupId, Double originX, Double originY, String templateEncodingVersion, FlowSnippetDTO requestSnippet, String idGenerationSeed) {
        FlowSnippetDTO snippet = this.templateDAO.instantiateTemplate(groupId, originX, originY, templateEncodingVersion, requestSnippet, idGenerationSeed);
        this.controllerFacade.save();
        FlowDTO flowDto = this.postProcessNewFlowSnippet(groupId, snippet);
        FlowEntity flowEntity = new FlowEntity();
        flowEntity.setFlow(flowDto);
        return flowEntity;
    }

    public ControllerServiceEntity createControllerService(Revision revision, String groupId, ControllerServiceDTO controllerServiceDTO) {
        controllerServiceDTO.setParentGroupId(groupId);
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        StandardRevisionClaim claim = new StandardRevisionClaim(new Revision[]{revision});
        RevisionUpdate snapshot = groupId == null ? this.revisionManager.updateRevision((RevisionClaim)claim, user, () -> {
            ControllerServiceNode controllerService = this.controllerServiceDAO.createControllerService(controllerServiceDTO);
            this.controllerFacade.save();
            this.awaitValidationCompletion((ComponentNode)controllerService);
            ControllerServiceDTO dto = this.dtoFactory.createControllerServiceDto(controllerService);
            FlowModification lastMod = new FlowModification(revision.incrementRevision(revision.getClientId()), user.getIdentity());
            return new StandardRevisionUpdate((Object)dto, lastMod);
        }) : this.revisionManager.updateRevision((RevisionClaim)claim, user, () -> {
            ControllerServiceNode controllerService = this.controllerServiceDAO.createControllerService(controllerServiceDTO);
            this.controllerFacade.save();
            this.awaitValidationCompletion((ComponentNode)controllerService);
            ControllerServiceDTO dto = this.dtoFactory.createControllerServiceDto(controllerService);
            FlowModification lastMod = new FlowModification(revision.incrementRevision(revision.getClientId()), user.getIdentity());
            return new StandardRevisionUpdate((Object)dto, lastMod);
        });
        ControllerServiceNode controllerService = this.controllerServiceDAO.getControllerService(controllerServiceDTO.getId());
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)controllerService);
        PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)controllerService));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(controllerServiceDTO.getId()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createControllerServiceEntity((ControllerServiceDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, operatePermissions, bulletinEntities);
    }

    public ControllerServiceEntity updateControllerService(Revision revision, ControllerServiceDTO controllerServiceDTO) {
        ControllerServiceNode controllerService = this.controllerServiceDAO.getControllerService(controllerServiceDTO.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)controllerService, () -> this.controllerServiceDAO.updateControllerService(controllerServiceDTO), cs -> {
            this.awaitValidationCompletion((ComponentNode)cs);
            ControllerServiceDTO dto = this.dtoFactory.createControllerServiceDto(cs);
            ControllerServiceReference ref = controllerService.getReferences();
            ControllerServiceReferencingComponentsEntity referencingComponentsEntity = this.createControllerServiceReferencingComponentsEntity(ref, (Set)Sets.newHashSet((Object[])new String[]{controllerService.getIdentifier()}));
            dto.setReferencingComponents(referencingComponentsEntity.getControllerServiceReferencingComponents());
            return dto;
        });
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)controllerService);
        PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)controllerService));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(controllerServiceDTO.getId()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createControllerServiceEntity((ControllerServiceDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, operatePermissions, bulletinEntities);
    }

    public ControllerServiceReferencingComponentsEntity updateControllerServiceReferencingComponents(Map<String, Revision> referenceRevisions, String controllerServiceId, ScheduledState scheduledState, ControllerServiceState controllerServiceState) {
        StandardRevisionClaim claim = new StandardRevisionClaim(referenceRevisions.values());
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        RevisionUpdate update = this.revisionManager.updateRevision((RevisionClaim)claim, user, (UpdateRevisionTask)new /* Unavailable Anonymous Inner Class!! */);
        return (ControllerServiceReferencingComponentsEntity)update.getComponent();
    }

    private void findControllerServiceReferencingComponentIdentifiers(ControllerServiceReference reference, Set<ControllerServiceNode> visited) {
        for (ComponentNode component : reference.getReferencingComponents()) {
            ControllerServiceNode node;
            if (!(component instanceof ControllerServiceNode) || visited.contains(node = (ControllerServiceNode)component)) continue;
            visited.add(node);
            this.findControllerServiceReferencingComponentIdentifiers(node.getReferences(), visited);
        }
    }

    private ControllerServiceReferencingComponentsEntity createControllerServiceReferencingComponentsEntity(ControllerServiceReference reference, Set<String> lockedIds) {
        HashSet<ControllerServiceNode> visited = new HashSet<ControllerServiceNode>();
        visited.add(reference.getReferencedComponent());
        this.findControllerServiceReferencingComponentIdentifiers(reference, visited);
        HashMap<String, Revision> referencingRevisions = new HashMap<String, Revision>();
        for (ComponentNode component : reference.getReferencingComponents()) {
            referencingRevisions.put(component.getIdentifier(), this.revisionManager.getRevision(component.getIdentifier()));
        }
        return this.createControllerServiceReferencingComponentsEntity(reference, referencingRevisions);
    }

    private ControllerServiceReferencingComponentsEntity createControllerServiceReferencingComponentsEntity(ControllerServiceReference reference, Map<String, Revision> revisions) {
        HashSet<ControllerServiceNode> visited = new HashSet<ControllerServiceNode>();
        visited.add(reference.getReferencedComponent());
        return this.createControllerServiceReferencingComponentsEntity(reference, revisions, visited);
    }

    private ControllerServiceReferencingComponentsEntity createControllerServiceReferencingComponentsEntity(ControllerServiceReference reference, Map<String, Revision> revisions, Set<ControllerServiceNode> visited) {
        String modifier = NiFiUserUtils.getNiFiUserIdentity();
        Set referencingComponents = reference.getReferencingComponents();
        HashSet<ControllerServiceReferencingComponentEntity> componentEntities = new HashSet<ControllerServiceReferencingComponentEntity>();
        for (ComponentNode refComponent : referencingComponents) {
            PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)refComponent);
            PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)refComponent));
            Revision revision = revisions.get(refComponent.getIdentifier());
            FlowModification flowMod = new FlowModification(revision, modifier);
            RevisionDTO revisionDto = this.dtoFactory.createRevisionDTO(flowMod);
            ControllerServiceReferencingComponentDTO dto = this.dtoFactory.createControllerServiceReferencingComponentDTO(refComponent);
            if (refComponent instanceof ControllerServiceNode) {
                ControllerServiceNode node = (ControllerServiceNode)refComponent;
                dto.setReferenceCycle(Boolean.valueOf(visited.contains(node)));
                visited.add(node);
                if (!dto.getReferenceCycle().booleanValue()) {
                    ControllerServiceReference refReferences = node.getReferences();
                    HashMap<String, Revision> referencingRevisions = new HashMap<String, Revision>(revisions);
                    for (ComponentNode component : refReferences.getReferencingComponents()) {
                        referencingRevisions.putIfAbsent(component.getIdentifier(), this.revisionManager.getRevision(component.getIdentifier()));
                    }
                    ControllerServiceReferencingComponentsEntity references = this.createControllerServiceReferencingComponentsEntity(refReferences, referencingRevisions, visited);
                    dto.setReferencingComponents(references.getControllerServiceReferencingComponents());
                }
            }
            List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(refComponent.getIdentifier()));
            componentEntities.add(this.entityFactory.createControllerServiceReferencingComponentEntity(refComponent.getIdentifier(), dto, revisionDto, permissions, operatePermissions, bulletins));
        }
        ControllerServiceReferencingComponentsEntity entity = new ControllerServiceReferencingComponentsEntity();
        entity.setControllerServiceReferencingComponents(componentEntities);
        return entity;
    }

    public ControllerServiceEntity deleteControllerService(Revision revision, String controllerServiceId) {
        ControllerServiceNode controllerService = this.controllerServiceDAO.getControllerService(controllerServiceId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)controllerService);
        PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)controllerService));
        ControllerServiceDTO snapshot = (ControllerServiceDTO)this.deleteComponent(revision, controllerService.getResource(), () -> this.controllerServiceDAO.deleteControllerService(controllerServiceId), true, (Object)this.dtoFactory.createControllerServiceDto(controllerService));
        return this.entityFactory.createControllerServiceEntity(snapshot, null, permissions, operatePermissions, null);
    }

    public RegistryClientEntity createRegistryClient(Revision revision, RegistryDTO registryDTO) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        StandardRevisionClaim claim = new StandardRevisionClaim(new Revision[]{revision});
        RevisionUpdate revisionUpdate = this.revisionManager.updateRevision((RevisionClaim)claim, user, () -> {
            FlowRegistry registry = this.registryDAO.createFlowRegistry(registryDTO);
            this.controllerFacade.save();
            FlowModification lastMod = new FlowModification(revision.incrementRevision(revision.getClientId()), user.getIdentity());
            return new StandardRevisionUpdate((Object)registry, lastMod);
        });
        FlowRegistry registry = (FlowRegistry)revisionUpdate.getComponent();
        return this.createRegistryClientEntity(registry);
    }

    public RegistryClientEntity getRegistryClient(String registryId) {
        FlowRegistry registry = this.registryDAO.getFlowRegistry(registryId);
        return this.createRegistryClientEntity(registry);
    }

    private RegistryClientEntity createRegistryClientEntity(FlowRegistry flowRegistry) {
        if (flowRegistry == null) {
            return null;
        }
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(flowRegistry.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto(this.authorizableLookup.getController());
        RegistryDTO dto = this.dtoFactory.createRegistryDto(flowRegistry);
        return this.entityFactory.createRegistryClientEntity(dto, revision, permissions);
    }

    private VersionedFlowEntity createVersionedFlowEntity(String registryId, VersionedFlow versionedFlow) {
        if (versionedFlow == null) {
            return null;
        }
        VersionedFlowDTO dto = new VersionedFlowDTO();
        dto.setRegistryId(registryId);
        dto.setBucketId(versionedFlow.getBucketIdentifier());
        dto.setFlowId(versionedFlow.getIdentifier());
        dto.setFlowName(versionedFlow.getName());
        dto.setDescription(versionedFlow.getDescription());
        VersionedFlowEntity entity = new VersionedFlowEntity();
        entity.setVersionedFlow(dto);
        return entity;
    }

    private VersionedFlowSnapshotMetadataEntity createVersionedFlowSnapshotMetadataEntity(String registryId, VersionedFlowSnapshotMetadata metadata) {
        if (metadata == null) {
            return null;
        }
        VersionedFlowSnapshotMetadataEntity entity = new VersionedFlowSnapshotMetadataEntity();
        entity.setRegistryId(registryId);
        entity.setVersionedFlowMetadata(metadata);
        return entity;
    }

    public Set<RegistryClientEntity> getRegistryClients() {
        return this.registryDAO.getFlowRegistries().stream().map(arg_0 -> this.createRegistryClientEntity(arg_0)).collect(Collectors.toSet());
    }

    public Set<RegistryEntity> getRegistriesForUser(NiFiUser user) {
        return this.registryDAO.getFlowRegistriesForUser(user).stream().map(flowRegistry -> this.entityFactory.createRegistryEntity(this.dtoFactory.createRegistryDto(flowRegistry))).collect(Collectors.toSet());
    }

    public Set<BucketEntity> getBucketsForUser(String registryId, NiFiUser user) {
        return this.registryDAO.getBucketsForUser(registryId, user).stream().map(bucket -> {
            if (bucket == null) {
                return null;
            }
            BucketDTO dto = new BucketDTO();
            dto.setId(bucket.getIdentifier());
            dto.setName(bucket.getName());
            dto.setDescription(bucket.getDescription());
            dto.setCreated(Long.valueOf(bucket.getCreatedTimestamp()));
            Permissions regPermissions = bucket.getPermissions();
            PermissionsDTO permissions = new PermissionsDTO();
            permissions.setCanRead(Boolean.valueOf(regPermissions.getCanRead()));
            permissions.setCanWrite(Boolean.valueOf(regPermissions.getCanWrite()));
            return this.entityFactory.createBucketEntity(dto, permissions);
        }).collect(Collectors.toSet());
    }

    public Set<VersionedFlowEntity> getFlowsForUser(String registryId, String bucketId, NiFiUser user) {
        return this.registryDAO.getFlowsForUser(registryId, bucketId, user).stream().map(vf -> this.createVersionedFlowEntity(registryId, vf)).collect(Collectors.toSet());
    }

    public Set<VersionedFlowSnapshotMetadataEntity> getFlowVersionsForUser(String registryId, String bucketId, String flowId, NiFiUser user) {
        return this.registryDAO.getFlowVersionsForUser(registryId, bucketId, flowId, user).stream().map(md -> this.createVersionedFlowSnapshotMetadataEntity(registryId, md)).collect(Collectors.toSet());
    }

    public RegistryClientEntity updateRegistryClient(Revision revision, RegistryDTO registryDTO) {
        StandardRevisionClaim revisionClaim = new StandardRevisionClaim(new Revision[]{revision});
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        FlowRegistry registry = this.registryDAO.getFlowRegistry(registryDTO.getId());
        RevisionUpdate revisionUpdate = this.revisionManager.updateRevision((RevisionClaim)revisionClaim, user, () -> {
            boolean duplicateName = this.registryDAO.getFlowRegistries().stream().anyMatch(reg -> reg.getName().equals(registryDTO.getName()) && !reg.getIdentifier().equals(registryDTO.getId()));
            if (duplicateName) {
                throw new IllegalStateException("Cannot update Flow Registry because a Flow Registry already exists with the name " + registryDTO.getName());
            }
            registry.setDescription(registryDTO.getDescription());
            registry.setName(registryDTO.getName());
            registry.setURL(registryDTO.getUri());
            this.controllerFacade.save();
            Revision updatedRevision = this.revisionManager.getRevision(revision.getComponentId()).incrementRevision(revision.getClientId());
            FlowModification lastModification = new FlowModification(updatedRevision, user.getIdentity());
            return new StandardRevisionUpdate((Object)registry, lastModification);
        });
        FlowRegistry updatedReg = (FlowRegistry)revisionUpdate.getComponent();
        return this.createRegistryClientEntity(updatedReg);
    }

    public void verifyDeleteRegistry(String registryId) {
        this.processGroupDAO.verifyDeleteFlowRegistry(registryId);
    }

    public RegistryClientEntity deleteRegistryClient(Revision revision, String registryId) {
        StandardRevisionClaim claim = new StandardRevisionClaim(new Revision[]{revision});
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        FlowRegistry registry = (FlowRegistry)this.revisionManager.deleteRevision((RevisionClaim)claim, user, () -> {
            FlowRegistry reg = this.registryDAO.removeFlowRegistry(registryId);
            this.controllerFacade.save();
            return reg;
        });
        return this.createRegistryClientEntity(registry);
    }

    public ReportingTaskEntity createReportingTask(Revision revision, ReportingTaskDTO reportingTaskDTO) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        StandardRevisionClaim claim = new StandardRevisionClaim(new Revision[]{revision});
        RevisionUpdate snapshot = this.revisionManager.updateRevision((RevisionClaim)claim, user, () -> {
            ReportingTaskNode reportingTask = this.reportingTaskDAO.createReportingTask(reportingTaskDTO);
            this.controllerFacade.save();
            this.awaitValidationCompletion((ComponentNode)reportingTask);
            ReportingTaskDTO dto = this.dtoFactory.createReportingTaskDto(reportingTask);
            FlowModification lastMod = new FlowModification(revision.incrementRevision(revision.getClientId()), user.getIdentity());
            return new StandardRevisionUpdate((Object)dto, lastMod);
        });
        ReportingTaskNode reportingTask = this.reportingTaskDAO.getReportingTask(reportingTaskDTO.getId());
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)reportingTask);
        PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)reportingTask));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(reportingTask.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createReportingTaskEntity((ReportingTaskDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, operatePermissions, bulletinEntities);
    }

    public ReportingTaskEntity updateReportingTask(Revision revision, ReportingTaskDTO reportingTaskDTO) {
        ReportingTaskNode reportingTask = this.reportingTaskDAO.getReportingTask(reportingTaskDTO.getId());
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)reportingTask, () -> this.reportingTaskDAO.updateReportingTask(reportingTaskDTO), rt -> {
            this.awaitValidationCompletion((ComponentNode)rt);
            return this.dtoFactory.createReportingTaskDto(rt);
        });
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)reportingTask);
        PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)reportingTask));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(reportingTask.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createReportingTaskEntity((ReportingTaskDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()), permissions, operatePermissions, bulletinEntities);
    }

    public ReportingTaskEntity deleteReportingTask(Revision revision, String reportingTaskId) {
        ReportingTaskNode reportingTask = this.reportingTaskDAO.getReportingTask(reportingTaskId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)reportingTask);
        PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)reportingTask));
        ReportingTaskDTO snapshot = (ReportingTaskDTO)this.deleteComponent(revision, reportingTask.getResource(), () -> this.reportingTaskDAO.deleteReportingTask(reportingTaskId), true, (Object)this.dtoFactory.createReportingTaskDto(reportingTask));
        return this.entityFactory.createReportingTaskEntity(snapshot, null, permissions, operatePermissions, null);
    }

    public void deleteActions(Date endDate) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user == null) {
            throw new WebApplicationException(new Throwable("Unable to access details for current user."));
        }
        FlowChangePurgeDetails details = new FlowChangePurgeDetails();
        details.setEndDate(endDate);
        FlowChangeAction purgeAction = new FlowChangeAction();
        purgeAction.setUserIdentity(user.getIdentity());
        purgeAction.setOperation(Operation.Purge);
        purgeAction.setTimestamp(new Date());
        purgeAction.setSourceId("Flow Controller");
        purgeAction.setSourceName("History");
        purgeAction.setSourceType(Component.Controller);
        purgeAction.setActionDetails((ActionDetails)details);
        this.auditService.purgeActions(endDate, (Action)purgeAction);
    }

    public ProvenanceDTO submitProvenance(ProvenanceDTO query) {
        return this.controllerFacade.submitProvenance(query);
    }

    public void deleteProvenance(String queryId) {
        this.controllerFacade.deleteProvenanceQuery(queryId);
    }

    public LineageDTO submitLineage(LineageDTO lineage) {
        return this.controllerFacade.submitLineage(lineage);
    }

    public void deleteLineage(String lineageId) {
        this.controllerFacade.deleteLineage(lineageId);
    }

    public ProvenanceEventDTO submitReplay(Long eventId) {
        return this.controllerFacade.submitReplay(eventId);
    }

    public SearchResultsDTO searchController(String query, String activeGroupId) {
        return this.controllerFacade.search(query, activeGroupId);
    }

    public DownloadableContent getContent(String connectionId, String flowFileUuid, String uri) {
        return this.connectionDAO.getContent(connectionId, flowFileUuid, uri);
    }

    public DownloadableContent getContent(Long eventId, String uri, ContentDirection contentDirection) {
        return this.controllerFacade.getContent(eventId, uri, contentDirection);
    }

    public ProvenanceDTO getProvenance(String queryId, Boolean summarize, Boolean incrementalResults) {
        return this.controllerFacade.getProvenanceQuery(queryId, summarize, incrementalResults);
    }

    public LineageDTO getLineage(String lineageId) {
        return this.controllerFacade.getLineage(lineageId);
    }

    public ProvenanceOptionsDTO getProvenanceSearchOptions() {
        return this.controllerFacade.getProvenanceSearchOptions();
    }

    public ProvenanceEventDTO getProvenanceEvent(Long id) {
        return this.controllerFacade.getProvenanceEvent(id);
    }

    public ProcessGroupStatusEntity getProcessGroupStatus(String groupId, boolean recursive) {
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(groupId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processGroup);
        ProcessGroupStatusDTO dto = this.dtoFactory.createProcessGroupStatusDto(processGroup, this.controllerFacade.getProcessGroupStatus(groupId));
        if (!recursive) {
            this.pruneChildGroups(dto.getAggregateSnapshot());
            if (dto.getNodeSnapshots() != null) {
                for (NodeProcessGroupStatusSnapshotDTO nodeSnapshot : dto.getNodeSnapshots()) {
                    this.pruneChildGroups(nodeSnapshot.getStatusSnapshot());
                }
            }
        }
        return this.entityFactory.createProcessGroupStatusEntity(dto, permissions);
    }

    private void pruneChildGroups(ProcessGroupStatusSnapshotDTO snapshot) {
        for (ProcessGroupStatusSnapshotEntity childProcessGroupStatusEntity : snapshot.getProcessGroupStatusSnapshots()) {
            ProcessGroupStatusSnapshotDTO childProcessGroupStatus = childProcessGroupStatusEntity.getProcessGroupStatusSnapshot();
            childProcessGroupStatus.setConnectionStatusSnapshots(null);
            childProcessGroupStatus.setProcessGroupStatusSnapshots(null);
            childProcessGroupStatus.setInputPortStatusSnapshots(null);
            childProcessGroupStatus.setOutputPortStatusSnapshots(null);
            childProcessGroupStatus.setProcessorStatusSnapshots(null);
            childProcessGroupStatus.setRemoteProcessGroupStatusSnapshots(null);
        }
    }

    public ControllerStatusDTO getControllerStatus() {
        return this.controllerFacade.getControllerStatus();
    }

    public ComponentStateDTO getProcessorState(String processorId) {
        StateMap clusterState = this.isClustered() ? this.processorDAO.getState(processorId, Scope.CLUSTER) : null;
        StateMap localState = this.processorDAO.getState(processorId, Scope.LOCAL);
        ProcessorNode processor = this.processorDAO.getProcessor(processorId);
        return this.dtoFactory.createComponentStateDTO(processorId, processor.getProcessor().getClass(), localState, clusterState);
    }

    public ComponentStateDTO getControllerServiceState(String controllerServiceId) {
        StateMap clusterState = this.isClustered() ? this.controllerServiceDAO.getState(controllerServiceId, Scope.CLUSTER) : null;
        StateMap localState = this.controllerServiceDAO.getState(controllerServiceId, Scope.LOCAL);
        ControllerServiceNode controllerService = this.controllerServiceDAO.getControllerService(controllerServiceId);
        return this.dtoFactory.createComponentStateDTO(controllerServiceId, controllerService.getControllerServiceImplementation().getClass(), localState, clusterState);
    }

    public ComponentStateDTO getReportingTaskState(String reportingTaskId) {
        StateMap clusterState = this.isClustered() ? this.reportingTaskDAO.getState(reportingTaskId, Scope.CLUSTER) : null;
        StateMap localState = this.reportingTaskDAO.getState(reportingTaskId, Scope.LOCAL);
        ReportingTaskNode reportingTask = this.reportingTaskDAO.getReportingTask(reportingTaskId);
        return this.dtoFactory.createComponentStateDTO(reportingTaskId, reportingTask.getReportingTask().getClass(), localState, clusterState);
    }

    public CountersDTO getCounters() {
        List counters = this.controllerFacade.getCounters();
        LinkedHashSet<CounterDTO> counterDTOs = new LinkedHashSet<CounterDTO>(counters.size());
        for (Counter counter : counters) {
            counterDTOs.add(this.dtoFactory.createCounterDto(counter));
        }
        CountersSnapshotDTO snapshotDto = this.dtoFactory.createCountersDto(counterDTOs);
        CountersDTO countersDto = new CountersDTO();
        countersDto.setAggregateSnapshot(snapshotDto);
        return countersDto;
    }

    private ConnectionEntity createConnectionEntity(Connection connection) {
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(connection.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)connection);
        ConnectionStatusDTO status = this.dtoFactory.createConnectionStatusDto(this.controllerFacade.getConnectionStatus(connection.getIdentifier()));
        return this.entityFactory.createConnectionEntity(this.dtoFactory.createConnectionDto(connection), revision, permissions, status);
    }

    public Set<ConnectionEntity> getConnections(String groupId) {
        Set connections = this.connectionDAO.getConnections(groupId);
        return connections.stream().map(connection -> this.createConnectionEntity(connection)).collect(Collectors.toSet());
    }

    public ConnectionEntity getConnection(String connectionId) {
        Connection connection = this.connectionDAO.getConnection(connectionId);
        return this.createConnectionEntity(connection);
    }

    public DropRequestDTO getFlowFileDropRequest(String connectionId, String dropRequestId) {
        return this.dtoFactory.createDropRequestDTO(this.connectionDAO.getFlowFileDropRequest(connectionId, dropRequestId));
    }

    public ListingRequestDTO getFlowFileListingRequest(String connectionId, String listingRequestId) {
        Connection connection = this.connectionDAO.getConnection(connectionId);
        ListingRequestDTO listRequest = this.dtoFactory.createListingRequestDTO(this.connectionDAO.getFlowFileListingRequest(connectionId, listingRequestId));
        if (connection.getSource() != null) {
            listRequest.setSourceRunning(Boolean.valueOf(connection.getSource().isRunning()));
        }
        if (connection.getDestination() != null) {
            listRequest.setDestinationRunning(Boolean.valueOf(connection.getDestination().isRunning()));
        }
        return listRequest;
    }

    public FlowFileDTO getFlowFile(String connectionId, String flowFileUuid) {
        return this.dtoFactory.createFlowFileDTO(this.connectionDAO.getFlowFile(connectionId, flowFileUuid));
    }

    public ConnectionStatusEntity getConnectionStatus(String connectionId) {
        Connection connection = this.connectionDAO.getConnection(connectionId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)connection);
        ConnectionStatusDTO dto = this.dtoFactory.createConnectionStatusDto(this.controllerFacade.getConnectionStatus(connectionId));
        return this.entityFactory.createConnectionStatusEntity(dto, permissions);
    }

    public StatusHistoryEntity getConnectionStatusHistory(String connectionId) {
        Connection connection = this.connectionDAO.getConnection(connectionId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)connection);
        StatusHistoryDTO dto = this.controllerFacade.getConnectionStatusHistory(connectionId);
        return this.entityFactory.createStatusHistoryEntity(dto, permissions);
    }

    public ConnectionStatisticsEntity getConnectionStatistics(String connectionId) {
        Connection connection = this.connectionDAO.getConnection(connectionId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)connection);
        ConnectionStatisticsDTO dto = this.dtoFactory.createConnectionStatisticsDto(connection, this.controllerFacade.getConnectionStatusAnalytics(connectionId));
        return this.entityFactory.createConnectionStatisticsEntity(dto, permissions);
    }

    private ProcessorEntity createProcessorEntity(ProcessorNode processor, NiFiUser user) {
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(processor.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processor, user);
        PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)processor));
        ProcessorStatusDTO status = this.dtoFactory.createProcessorStatusDto(this.controllerFacade.getProcessorStatus(processor.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(processor.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        ProcessorDTO processorDTO = this.dtoFactory.createProcessorDto(processor);
        return this.entityFactory.createProcessorEntity(processorDTO, revision, permissions, operatePermissions, status, bulletinEntities);
    }

    public Set<ProcessorEntity> getProcessors(String groupId, boolean includeDescendants) {
        Set processors = this.processorDAO.getProcessors(groupId, includeDescendants);
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        return processors.stream().map(processor -> this.createProcessorEntity(processor, user)).collect(Collectors.toSet());
    }

    public ProcessorsRunStatusDetailsEntity getProcessorsRunStatusDetails(Set<String> processorIds, NiFiUser user) {
        List runStatusDetails = processorIds.stream().map(arg_0 -> ((ProcessorDAO)this.processorDAO).getProcessor(arg_0)).map(processor -> this.createRunStatusDetailsEntity(processor, user)).collect(Collectors.toList());
        ProcessorsRunStatusDetailsEntity entity = new ProcessorsRunStatusDetailsEntity();
        entity.setRunStatusDetails(runStatusDetails);
        return entity;
    }

    private ProcessorRunStatusDetailsEntity createRunStatusDetailsEntity(ProcessorNode processor, NiFiUser user) {
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(processor.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processor, user);
        ProcessorStatus processorStatus = this.controllerFacade.getProcessorStatus(processor.getIdentifier());
        ProcessorRunStatusDetailsDTO runStatusDetailsDto = this.dtoFactory.createProcessorRunStatusDetailsDto(processor, processorStatus);
        if (!permissions.getCanRead().booleanValue()) {
            runStatusDetailsDto.setName(null);
            runStatusDetailsDto.setValidationErrors(null);
        }
        ProcessorRunStatusDetailsEntity entity = new ProcessorRunStatusDetailsEntity();
        entity.setPermissions(permissions);
        entity.setRevision(revision);
        entity.setRunStatusDetails(runStatusDetailsDto);
        return entity;
    }

    public TemplateDTO exportTemplate(String id) {
        Template template = this.templateDAO.getTemplate(id);
        TemplateDTO templateDetails = template.getDetails();
        TemplateDTO templateDTO = this.dtoFactory.createTemplateDTO(template);
        templateDTO.setSnippet(this.dtoFactory.copySnippetContents(templateDetails.getSnippet()));
        return templateDTO;
    }

    public TemplateDTO getTemplate(String id) {
        return this.dtoFactory.createTemplateDTO(this.templateDAO.getTemplate(id));
    }

    public Set<TemplateEntity> getTemplates() {
        return this.templateDAO.getTemplates().stream().map(template -> {
            TemplateDTO dto = this.dtoFactory.createTemplateDTO(template);
            PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)template);
            TemplateEntity entity = new TemplateEntity();
            entity.setId(dto.getId());
            entity.setPermissions(permissions);
            entity.setTemplate(dto);
            return entity;
        }).collect(Collectors.toSet());
    }

    public Set<DocumentedTypeDTO> getWorkQueuePrioritizerTypes() {
        return this.controllerFacade.getFlowFileComparatorTypes();
    }

    public Set<DocumentedTypeDTO> getProcessorTypes(String bundleGroup, String bundleArtifact, String type) {
        return this.controllerFacade.getFlowFileProcessorTypes(bundleGroup, bundleArtifact, type);
    }

    public Set<DocumentedTypeDTO> getControllerServiceTypes(String serviceType, String serviceBundleGroup, String serviceBundleArtifact, String serviceBundleVersion, String bundleGroup, String bundleArtifact, String type) {
        return this.controllerFacade.getControllerServiceTypes(serviceType, serviceBundleGroup, serviceBundleArtifact, serviceBundleVersion, bundleGroup, bundleArtifact, type);
    }

    public Set<DocumentedTypeDTO> getReportingTaskTypes(String bundleGroup, String bundleArtifact, String type) {
        return this.controllerFacade.getReportingTaskTypes(bundleGroup, bundleArtifact, type);
    }

    public ProcessorEntity getProcessor(String id) {
        ProcessorNode processor = this.processorDAO.getProcessor(id);
        return this.createProcessorEntity(processor, NiFiUserUtils.getNiFiUser());
    }

    public PropertyDescriptorDTO getProcessorPropertyDescriptor(String id, String property) {
        ProcessorNode processor = this.processorDAO.getProcessor(id);
        PropertyDescriptor descriptor = processor.getPropertyDescriptor(property);
        if (descriptor == null) {
            descriptor = new PropertyDescriptor.Builder().name(property).addValidator(Validator.INVALID).dynamic(true).build();
        }
        return this.dtoFactory.createPropertyDescriptorDto(descriptor, processor.getProcessGroup().getIdentifier());
    }

    public ProcessorStatusEntity getProcessorStatus(String id) {
        ProcessorNode processor = this.processorDAO.getProcessor(id);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processor);
        ProcessorStatusDTO dto = this.dtoFactory.createProcessorStatusDto(this.controllerFacade.getProcessorStatus(id));
        return this.entityFactory.createProcessorStatusEntity(dto, permissions);
    }

    public StatusHistoryEntity getProcessorStatusHistory(String id) {
        ProcessorNode processor = this.processorDAO.getProcessor(id);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processor);
        StatusHistoryDTO dto = this.controllerFacade.getProcessorStatusHistory(id);
        return this.entityFactory.createStatusHistoryEntity(dto, permissions);
    }

    public StatusHistoryEntity getNodeStatusHistory() {
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)this.controllerFacade, NiFiUserUtils.getNiFiUser());
        StatusHistoryDTO dto = this.controllerFacade.getNodeStatusHistory();
        return this.entityFactory.createStatusHistoryEntity(dto, permissions);
    }

    private boolean authorizeBulletin(Bulletin bulletin) {
        ControllerFacade authorizable;
        String sourceId = bulletin.getSourceId();
        org.apache.nifi.reporting.ComponentType type = bulletin.getSourceType();
        try {
            switch (15.$SwitchMap$org$apache$nifi$reporting$ComponentType[type.ordinal()]) {
                case 1: {
                    authorizable = this.authorizableLookup.getProcessor(sourceId).getAuthorizable();
                    break;
                }
                case 2: {
                    authorizable = this.authorizableLookup.getReportingTask(sourceId).getAuthorizable();
                    break;
                }
                case 3: {
                    authorizable = this.authorizableLookup.getControllerService(sourceId).getAuthorizable();
                    break;
                }
                case 4: {
                    authorizable = this.controllerFacade;
                    break;
                }
                case 5: {
                    authorizable = this.authorizableLookup.getInputPort(sourceId);
                    break;
                }
                case 6: {
                    authorizable = this.authorizableLookup.getOutputPort(sourceId);
                    break;
                }
                case 7: {
                    authorizable = this.authorizableLookup.getRemoteProcessGroup(sourceId);
                    break;
                }
                default: {
                    throw new WebApplicationException(Response.serverError().entity((Object)"An unexpected type of component is the source of this bulletin.").build());
                }
            }
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
        AuthorizationResult result = authorizable.checkAuthorization(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        return AuthorizationResult.Result.Approved.equals((Object)result.getResult());
    }

    public BulletinBoardDTO getBulletinBoard(BulletinQueryDTO query) {
        BulletinQuery.Builder queryBuilder = new BulletinQuery.Builder().groupIdMatches(query.getGroupId()).sourceIdMatches(query.getSourceId()).nameMatches(query.getName()).messageMatches(query.getMessage()).after(query.getAfter()).limit(query.getLimit());
        List results = this.bulletinRepository.findBulletins(queryBuilder.build());
        ArrayList<BulletinEntity> bulletinEntities = new ArrayList<BulletinEntity>();
        ListIterator bulletinIter = results.listIterator(results.size());
        while (bulletinIter.hasPrevious()) {
            Bulletin bulletin = (Bulletin)bulletinIter.previous();
            bulletinEntities.add(this.entityFactory.createBulletinEntity(this.dtoFactory.createBulletinDto(bulletin), this.authorizeBulletin(bulletin)));
        }
        BulletinBoardDTO bulletinBoard = new BulletinBoardDTO();
        bulletinBoard.setBulletins(bulletinEntities);
        bulletinBoard.setGenerated(new Date());
        return bulletinBoard;
    }

    public SystemDiagnosticsDTO getSystemDiagnostics() {
        SystemDiagnostics sysDiagnostics = this.controllerFacade.getSystemDiagnostics();
        return this.dtoFactory.createSystemDiagnosticsDto(sysDiagnostics);
    }

    public List<ResourceDTO> getResources() {
        List resources = this.controllerFacade.getResources();
        ArrayList<ResourceDTO> resourceDtos = new ArrayList<ResourceDTO>(resources.size());
        for (Resource resource : resources) {
            resourceDtos.add(this.dtoFactory.createResourceDto(resource));
        }
        return resourceDtos;
    }

    public void discoverCompatibleBundles(VersionedProcessGroup versionedGroup) {
        BundleUtils.discoverCompatibleBundles((ExtensionManager)this.controllerFacade.getExtensionManager(), (VersionedProcessGroup)versionedGroup);
    }

    public void resolveInheritedControllerServices(VersionedFlowSnapshot versionedFlowSnapshot, String processGroupId, NiFiUser user) {
        VersionedProcessGroup versionedGroup = versionedFlowSnapshot.getFlowContents();
        this.resolveInheritedControllerServices(versionedGroup, processGroupId, versionedFlowSnapshot.getExternalControllerServices(), user);
    }

    private void resolveInheritedControllerServices(VersionedProcessGroup versionedGroup, String processGroupId, Map<String, ExternalControllerServiceReference> externalControllerServiceReferences, NiFiUser user) {
        ConfigurableComponent tempComponent;
        BundleCoordinate compatibleBundle;
        Set availableControllerServiceIds = this.findAllControllerServiceIds(versionedGroup);
        ProcessGroup parentGroup = this.processGroupDAO.getProcessGroup(processGroupId);
        Set serviceNodes = parentGroup.getControllerServices(true).stream().filter(service -> service.isAuthorized(this.authorizer, RequestAction.READ, user)).collect(Collectors.toSet());
        ExtensionManager extensionManager = this.controllerFacade.getExtensionManager();
        for (VersionedProcessor processor : versionedGroup.getProcessors()) {
            compatibleBundle = BundleUtils.discoverCompatibleBundle((ExtensionManager)extensionManager, (String)processor.getType(), (Bundle)processor.getBundle());
            tempComponent = extensionManager.getTempComponent(processor.getType(), compatibleBundle);
            this.resolveInheritedControllerServices((VersionedConfigurableComponent)processor, availableControllerServiceIds, serviceNodes, externalControllerServiceReferences, arg_0 -> ((ConfigurableComponent)tempComponent).getPropertyDescriptor(arg_0));
        }
        for (VersionedControllerService service2 : versionedGroup.getControllerServices()) {
            compatibleBundle = BundleUtils.discoverCompatibleBundle((ExtensionManager)extensionManager, (String)service2.getType(), (Bundle)service2.getBundle());
            tempComponent = extensionManager.getTempComponent(service2.getType(), compatibleBundle);
            this.resolveInheritedControllerServices((VersionedConfigurableComponent)service2, availableControllerServiceIds, serviceNodes, externalControllerServiceReferences, arg_0 -> ((ConfigurableComponent)tempComponent).getPropertyDescriptor(arg_0));
        }
        for (VersionedProcessGroup child : versionedGroup.getProcessGroups()) {
            this.resolveInheritedControllerServices(child, processGroupId, externalControllerServiceReferences, user);
        }
    }

    private void resolveInheritedControllerServices(VersionedConfigurableComponent component, Set<String> availableControllerServiceIds, Set<ControllerServiceNode> availableControllerServices, Map<String, ExternalControllerServiceReference> externalControllerServiceReferences, Function<String, PropertyDescriptor> descriptorLookup) {
        Map descriptors = component.getPropertyDescriptors();
        Map properties = component.getProperties();
        this.resolveInheritedControllerServices(descriptors, properties, availableControllerServiceIds, availableControllerServices, externalControllerServiceReferences, descriptorLookup);
    }

    private void resolveInheritedControllerServices(Map<String, VersionedPropertyDescriptor> propertyDescriptors, Map<String, String> componentProperties, Set<String> availableControllerServiceIds, Set<ControllerServiceNode> availableControllerServices, Map<String, ExternalControllerServiceReference> externalControllerServiceReferences, Function<String, PropertyDescriptor> descriptorLookup) {
        for (Map.Entry<String, String> entry : new HashMap<String, String>(componentProperties).entrySet()) {
            Class referencedServiceClass;
            PropertyDescriptor descriptor;
            ExternalControllerServiceReference externalServiceReference;
            String propertyName = entry.getKey();
            String propertyValue = entry.getValue();
            VersionedPropertyDescriptor propertyDescriptor = propertyDescriptors.get(propertyName);
            if (propertyDescriptor == null || !propertyDescriptor.getIdentifiesControllerService() || availableControllerServiceIds.contains(propertyValue) || (externalServiceReference = externalControllerServiceReferences == null ? null : externalControllerServiceReferences.get(propertyValue)) == null || (descriptor = descriptorLookup.apply(propertyName)) == null || (referencedServiceClass = descriptor.getControllerServiceDefinition()) == null) continue;
            String externalControllerServiceName = externalServiceReference.getName();
            List matchingControllerServices = availableControllerServices.stream().filter(service -> service.getName().equals(externalControllerServiceName)).filter(service -> referencedServiceClass.isAssignableFrom(service.getProxiedControllerService().getClass())).collect(Collectors.toList());
            if (matchingControllerServices.size() != 1) continue;
            ControllerServiceNode matchingServiceNode = (ControllerServiceNode)matchingControllerServices.get(0);
            Optional versionedComponentId = matchingServiceNode.getVersionedComponentId();
            String resolvedId = versionedComponentId.orElseGet(() -> ((ControllerServiceNode)matchingServiceNode).getIdentifier());
            componentProperties.put(propertyName, resolvedId);
        }
    }

    private Set<String> findAllControllerServiceIds(VersionedProcessGroup group) {
        HashSet<String> ids = new HashSet<String>();
        this.findAllControllerServiceIds(group, ids);
        return ids;
    }

    private void findAllControllerServiceIds(VersionedProcessGroup group, Set<String> ids) {
        for (VersionedControllerService service : group.getControllerServices()) {
            ids.add(service.getIdentifier());
        }
        for (VersionedProcessGroup childGroup : group.getProcessGroups()) {
            this.findAllControllerServiceIds(childGroup, ids);
        }
    }

    public BundleCoordinate getCompatibleBundle(String type, BundleDTO bundleDTO) {
        return BundleUtils.getCompatibleBundle((ExtensionManager)this.controllerFacade.getExtensionManager(), (String)type, (BundleDTO)bundleDTO);
    }

    public ConfigurableComponent getTempComponent(String classType, BundleCoordinate bundleCoordinate) {
        return this.controllerFacade.getExtensionManager().getTempComponent(classType, bundleCoordinate);
    }

    private boolean isUserAuthorized(NiFiUser user, Port port) {
        HashMap<String, String> userContext;
        boolean isSiteToSiteSecure = Boolean.TRUE.equals(this.properties.isSiteToSiteSecure());
        if (!isSiteToSiteSecure) {
            return true;
        }
        if (user.getClientAddress() != null && !user.getClientAddress().trim().isEmpty()) {
            userContext = new HashMap<String, String>();
            userContext.put(UserContextKeys.CLIENT_ADDRESS.name(), user.getClientAddress());
        } else {
            userContext = null;
        }
        AuthorizationRequest request = new AuthorizationRequest.Builder().resource(ResourceFactory.getDataTransferResource((Resource)port.getResource())).identity(user.getIdentity()).groups(user.getAllGroups()).anonymous(Boolean.valueOf(user.isAnonymous())).accessAttempt(Boolean.valueOf(false)).action(RequestAction.WRITE).userContext(userContext).explanationSupplier(() -> "Unable to retrieve port details.").build();
        AuthorizationResult result = this.authorizer.authorize(request);
        return AuthorizationResult.Result.Approved.equals((Object)result.getResult());
    }

    public ControllerDTO getSiteToSiteDetails() {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user == null) {
            throw new WebApplicationException(new Throwable("Unable to access details for current user."));
        }
        LinkedHashSet<PortDTO> inputPortDtos = new LinkedHashSet<PortDTO>();
        for (Object inputPort : this.controllerFacade.getPublicInputPorts()) {
            if (!this.isUserAuthorized(user, (Port)inputPort)) continue;
            PortDTO dto = new PortDTO();
            dto.setId(inputPort.getIdentifier());
            dto.setName(inputPort.getName());
            dto.setComments(inputPort.getComments());
            dto.setState(inputPort.getScheduledState().toString());
            inputPortDtos.add(dto);
        }
        LinkedHashSet<PortDTO> outputPortDtos = new LinkedHashSet<PortDTO>();
        for (Port outputPort : this.controllerFacade.getPublicOutputPorts()) {
            if (!this.isUserAuthorized(user, outputPort)) continue;
            PortDTO dto = new PortDTO();
            dto.setId(outputPort.getIdentifier());
            dto.setName(outputPort.getName());
            dto.setComments(outputPort.getComments());
            dto.setState(outputPort.getScheduledState().toString());
            outputPortDtos.add(dto);
        }
        ProcessGroup rootGroup = this.processGroupDAO.getProcessGroup(this.controllerFacade.getRootGroupId());
        ProcessGroupCounts counts = rootGroup.getCounts();
        ControllerDTO controllerDTO = new ControllerDTO();
        controllerDTO.setId(this.controllerFacade.getRootGroupId());
        controllerDTO.setInstanceId(this.controllerFacade.getInstanceId());
        controllerDTO.setName(this.controllerFacade.getName());
        controllerDTO.setComments(this.controllerFacade.getComments());
        controllerDTO.setInputPorts(inputPortDtos);
        controllerDTO.setOutputPorts(outputPortDtos);
        controllerDTO.setInputPortCount(Integer.valueOf(inputPortDtos.size()));
        controllerDTO.setOutputPortCount(Integer.valueOf(outputPortDtos.size()));
        controllerDTO.setRunningCount(Integer.valueOf(counts.getRunningCount()));
        controllerDTO.setStoppedCount(Integer.valueOf(counts.getStoppedCount()));
        controllerDTO.setInvalidCount(Integer.valueOf(counts.getInvalidCount()));
        controllerDTO.setDisabledCount(Integer.valueOf(counts.getDisabledCount()));
        controllerDTO.setRemoteSiteListeningPort(this.controllerFacade.getRemoteSiteListeningPort());
        controllerDTO.setRemoteSiteHttpListeningPort(this.controllerFacade.getRemoteSiteListeningHttpPort());
        controllerDTO.setSiteToSiteSecure(this.controllerFacade.isRemoteSiteCommsSecure());
        return controllerDTO;
    }

    public ControllerConfigurationEntity getControllerConfiguration() {
        Revision rev = this.revisionManager.getRevision(FlowController.class.getSimpleName());
        ControllerConfigurationDTO dto = this.dtoFactory.createControllerConfigurationDto(this.controllerFacade);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)this.controllerFacade);
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(rev);
        return this.entityFactory.createControllerConfigurationEntity(dto, revision, permissions);
    }

    public ControllerBulletinsEntity getControllerBulletins() {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        ControllerBulletinsEntity controllerBulletinsEntity = new ControllerBulletinsEntity();
        ArrayList<BulletinEntity> controllerBulletinEntities = new ArrayList<BulletinEntity>();
        Authorizable controllerAuthorizable = this.authorizableLookup.getController();
        boolean authorized = controllerAuthorizable.isAuthorized(this.authorizer, RequestAction.READ, user);
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForController());
        controllerBulletinEntities.addAll(bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, authorized)).collect(Collectors.toList()));
        BulletinQuery controllerServiceQuery = new BulletinQuery.Builder().sourceType(org.apache.nifi.reporting.ComponentType.CONTROLLER_SERVICE).build();
        List allControllerServiceBulletins = this.bulletinRepository.findBulletins(controllerServiceQuery);
        ArrayList<BulletinEntity> controllerServiceBulletinEntities = new ArrayList<BulletinEntity>();
        for (Bulletin bulletin2 : allControllerServiceBulletins) {
            try {
                Authorizable controllerServiceAuthorizable = this.authorizableLookup.getControllerService(bulletin2.getSourceId()).getAuthorizable();
                boolean controllerServiceAuthorized = controllerServiceAuthorizable.isAuthorized(this.authorizer, RequestAction.READ, user);
                BulletinEntity controllerServiceBulletin = this.entityFactory.createBulletinEntity(this.dtoFactory.createBulletinDto(bulletin2), controllerServiceAuthorized);
                controllerServiceBulletinEntities.add(controllerServiceBulletin);
                controllerBulletinEntities.add(controllerServiceBulletin);
            }
            catch (ResourceNotFoundException controllerServiceAuthorizable) {}
        }
        controllerBulletinsEntity.setControllerServiceBulletins(controllerServiceBulletinEntities);
        BulletinQuery reportingTaskQuery = new BulletinQuery.Builder().sourceType(org.apache.nifi.reporting.ComponentType.REPORTING_TASK).build();
        List allReportingTaskBulletins = this.bulletinRepository.findBulletins(reportingTaskQuery);
        ArrayList<BulletinEntity> reportingTaskBulletinEntities = new ArrayList<BulletinEntity>();
        for (Bulletin bulletin3 : allReportingTaskBulletins) {
            try {
                Authorizable reportingTaskAuthorizable = this.authorizableLookup.getReportingTask(bulletin3.getSourceId()).getAuthorizable();
                boolean reportingTaskAuthorizableAuthorized = reportingTaskAuthorizable.isAuthorized(this.authorizer, RequestAction.READ, user);
                BulletinEntity reportingTaskBulletin = this.entityFactory.createBulletinEntity(this.dtoFactory.createBulletinDto(bulletin3), reportingTaskAuthorizableAuthorized);
                reportingTaskBulletinEntities.add(reportingTaskBulletin);
                controllerBulletinEntities.add(reportingTaskBulletin);
            }
            catch (ResourceNotFoundException resourceNotFoundException) {}
        }
        controllerBulletinsEntity.setReportingTaskBulletins(reportingTaskBulletinEntities);
        controllerBulletinsEntity.setBulletins(this.pruneAndSortBulletins(controllerBulletinEntities, 10));
        return controllerBulletinsEntity;
    }

    public FlowConfigurationEntity getFlowConfiguration() {
        FlowConfigurationDTO dto = this.dtoFactory.createFlowConfigurationDto(this.properties.getAutoRefreshInterval(), this.properties.getDefaultBackPressureObjectThreshold(), this.properties.getDefaultBackPressureDataSizeThreshold());
        FlowConfigurationEntity entity = new FlowConfigurationEntity();
        entity.setFlowConfiguration(dto);
        return entity;
    }

    public AccessPolicyEntity getAccessPolicy(String accessPolicyId) {
        AccessPolicy accessPolicy = this.accessPolicyDAO.getAccessPolicy(accessPolicyId);
        return this.createAccessPolicyEntity(accessPolicy);
    }

    public AccessPolicyEntity getAccessPolicy(RequestAction requestAction, String resource) {
        Authorizable authorizable;
        try {
            authorizable = this.authorizableLookup.getAuthorizableFromResource(resource);
        }
        catch (ResourceNotFoundException e) {
            authorizable = new /* Unavailable Anonymous Inner Class!! */;
        }
        AccessPolicy accessPolicy = this.accessPolicyDAO.getAccessPolicy(requestAction, authorizable);
        return this.createAccessPolicyEntity(accessPolicy);
    }

    private AccessPolicyEntity createAccessPolicyEntity(AccessPolicy accessPolicy) {
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(accessPolicy.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto(this.authorizableLookup.getAccessPolicyById(accessPolicy.getIdentifier()));
        ComponentReferenceEntity componentReference = this.createComponentReferenceEntity(accessPolicy.getResource());
        return this.entityFactory.createAccessPolicyEntity(this.dtoFactory.createAccessPolicyDto(accessPolicy, accessPolicy.getGroups().stream().map(this.mapUserGroupIdToTenantEntity(false)).collect(Collectors.toSet()), accessPolicy.getUsers().stream().map(this.mapUserIdToTenantEntity(false)).collect(Collectors.toSet()), componentReference), revision, permissions);
    }

    public UserEntity getUser(String userId) {
        User user = this.userDAO.getUser(userId);
        return this.createUserEntity(user, true);
    }

    public Set<UserEntity> getUsers() {
        Set users = this.userDAO.getUsers();
        return users.stream().map(user -> this.createUserEntity(user, false)).collect(Collectors.toSet());
    }

    private UserEntity createUserEntity(User user, boolean enforceUserExistence) {
        RevisionDTO userRevision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(user.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto(this.authorizableLookup.getTenant());
        Set userGroups = this.userGroupDAO.getUserGroupsForUser(user.getIdentifier()).stream().map(g -> g.getIdentifier()).map(this.mapUserGroupIdToTenantEntity(enforceUserExistence)).collect(Collectors.toSet());
        Set policyEntities = this.userGroupDAO.getAccessPoliciesForUser(user.getIdentifier()).stream().map(ap -> this.createAccessPolicySummaryEntity(ap)).collect(Collectors.toSet());
        return this.entityFactory.createUserEntity(this.dtoFactory.createUserDto(user, userGroups, policyEntities), userRevision, permissions);
    }

    private UserGroupEntity createUserGroupEntity(Group userGroup, boolean enforceGroupExistence) {
        RevisionDTO userGroupRevision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(userGroup.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto(this.authorizableLookup.getTenant());
        Set users = userGroup.getUsers().stream().map(this.mapUserIdToTenantEntity(enforceGroupExistence)).collect(Collectors.toSet());
        Set policyEntities = this.userGroupDAO.getAccessPoliciesForUserGroup(userGroup.getIdentifier()).stream().map(ap -> this.createAccessPolicySummaryEntity(ap)).collect(Collectors.toSet());
        return this.entityFactory.createUserGroupEntity(this.dtoFactory.createUserGroupDto(userGroup, users, policyEntities), userGroupRevision, permissions);
    }

    public UserGroupEntity getUserGroup(String userGroupId) {
        Group userGroup = this.userGroupDAO.getUserGroup(userGroupId);
        return this.createUserGroupEntity(userGroup, true);
    }

    public Set<UserGroupEntity> getUserGroups() {
        Set userGroups = this.userGroupDAO.getUserGroups();
        return userGroups.stream().map(userGroup -> this.createUserGroupEntity(userGroup, false)).collect(Collectors.toSet());
    }

    private LabelEntity createLabelEntity(Label label) {
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(label.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)label);
        return this.entityFactory.createLabelEntity(this.dtoFactory.createLabelDto(label), revision, permissions);
    }

    public Set<LabelEntity> getLabels(String groupId) {
        Set labels = this.labelDAO.getLabels(groupId);
        return labels.stream().map(label -> this.createLabelEntity(label)).collect(Collectors.toSet());
    }

    public LabelEntity getLabel(String labelId) {
        Label label = this.labelDAO.getLabel(labelId);
        return this.createLabelEntity(label);
    }

    private FunnelEntity createFunnelEntity(Funnel funnel) {
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(funnel.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)funnel);
        return this.entityFactory.createFunnelEntity(this.dtoFactory.createFunnelDto(funnel), revision, permissions);
    }

    public Set<FunnelEntity> getFunnels(String groupId) {
        Set funnels = this.funnelDAO.getFunnels(groupId);
        return funnels.stream().map(funnel -> this.createFunnelEntity(funnel)).collect(Collectors.toSet());
    }

    public FunnelEntity getFunnel(String funnelId) {
        Funnel funnel = this.funnelDAO.getFunnel(funnelId);
        return this.createFunnelEntity(funnel);
    }

    private PortEntity createInputPortEntity(Port port) {
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(port.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)port, NiFiUserUtils.getNiFiUser());
        PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)port), NiFiUserUtils.getNiFiUser());
        PortStatusDTO status = this.dtoFactory.createPortStatusDto(this.controllerFacade.getInputPortStatus(port.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(port.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createPortEntity(this.dtoFactory.createPortDto(port), revision, permissions, operatePermissions, status, bulletinEntities);
    }

    private PortEntity createOutputPortEntity(Port port) {
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(port.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)port, NiFiUserUtils.getNiFiUser());
        PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)port), NiFiUserUtils.getNiFiUser());
        PortStatusDTO status = this.dtoFactory.createPortStatusDto(this.controllerFacade.getOutputPortStatus(port.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(port.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createPortEntity(this.dtoFactory.createPortDto(port), revision, permissions, operatePermissions, status, bulletinEntities);
    }

    public Set<PortEntity> getInputPorts(String groupId) {
        Set inputPorts = this.inputPortDAO.getPorts(groupId);
        return inputPorts.stream().map(port -> this.createInputPortEntity(port)).collect(Collectors.toSet());
    }

    public Set<PortEntity> getOutputPorts(String groupId) {
        Set ports = this.outputPortDAO.getPorts(groupId);
        return ports.stream().map(port -> this.createOutputPortEntity(port)).collect(Collectors.toSet());
    }

    private ProcessGroupEntity createProcessGroupEntity(ProcessGroup group) {
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(group.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)group);
        ProcessGroupStatusDTO status = this.dtoFactory.createConciseProcessGroupStatusDto(this.controllerFacade.getProcessGroupStatus(group.getIdentifier()));
        List bulletins = this.getProcessGroupBulletins(group);
        return this.entityFactory.createProcessGroupEntity(this.dtoFactory.createProcessGroupDto(group), revision, permissions, status, bulletins);
    }

    private List<BulletinEntity> getProcessGroupBulletins(ProcessGroup group) {
        ArrayList bulletins = new ArrayList(this.bulletinRepository.findBulletinsForGroupBySource(group.getIdentifier()));
        for (ProcessGroup descendantGroup : group.findAllProcessGroups()) {
            bulletins.addAll(this.bulletinRepository.findBulletinsForGroupBySource(descendantGroup.getIdentifier()));
        }
        ArrayList<BulletinEntity> bulletinEntities = new ArrayList<BulletinEntity>();
        for (Bulletin bulletin : bulletins) {
            bulletinEntities.add(this.entityFactory.createBulletinEntity(this.dtoFactory.createBulletinDto(bulletin), this.authorizeBulletin(bulletin)));
        }
        return this.pruneAndSortBulletins(bulletinEntities, 5);
    }

    private List<BulletinEntity> pruneAndSortBulletins(List<BulletinEntity> bulletinEntities, int maxBulletins) {
        Collections.sort(bulletinEntities, new /* Unavailable Anonymous Inner Class!! */);
        if (bulletinEntities.size() > maxBulletins) {
            return bulletinEntities.subList(0, maxBulletins);
        }
        return bulletinEntities;
    }

    public Set<ProcessGroupEntity> getProcessGroups(String parentGroupId) {
        Set groups = this.processGroupDAO.getProcessGroups(parentGroupId);
        return groups.stream().map(group -> this.createProcessGroupEntity(group)).collect(Collectors.toSet());
    }

    private RemoteProcessGroupEntity createRemoteGroupEntity(RemoteProcessGroup rpg, NiFiUser user) {
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(rpg.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)rpg, user);
        PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)rpg), user);
        RemoteProcessGroupStatusDTO status = this.dtoFactory.createRemoteProcessGroupStatusDto(rpg, this.controllerFacade.getRemoteProcessGroupStatus(rpg.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(rpg.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createRemoteProcessGroupEntity(this.dtoFactory.createRemoteProcessGroupDto(rpg), revision, permissions, operatePermissions, status, bulletinEntities);
    }

    public Set<RemoteProcessGroupEntity> getRemoteProcessGroups(String groupId) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        Set rpgs = this.remoteProcessGroupDAO.getRemoteProcessGroups(groupId);
        return rpgs.stream().map(rpg -> this.createRemoteGroupEntity(rpg, user)).collect(Collectors.toSet());
    }

    public PortEntity getInputPort(String inputPortId) {
        Port port = this.inputPortDAO.getPort(inputPortId);
        return this.createInputPortEntity(port);
    }

    public PortStatusEntity getInputPortStatus(String inputPortId) {
        Port inputPort = this.inputPortDAO.getPort(inputPortId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)inputPort);
        PortStatusDTO dto = this.dtoFactory.createPortStatusDto(this.controllerFacade.getInputPortStatus(inputPortId));
        return this.entityFactory.createPortStatusEntity(dto, permissions);
    }

    public PortEntity getOutputPort(String outputPortId) {
        Port port = this.outputPortDAO.getPort(outputPortId);
        return this.createOutputPortEntity(port);
    }

    public PortStatusEntity getOutputPortStatus(String outputPortId) {
        Port outputPort = this.outputPortDAO.getPort(outputPortId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)outputPort);
        PortStatusDTO dto = this.dtoFactory.createPortStatusDto(this.controllerFacade.getOutputPortStatus(outputPortId));
        return this.entityFactory.createPortStatusEntity(dto, permissions);
    }

    public RemoteProcessGroupEntity getRemoteProcessGroup(String remoteProcessGroupId) {
        RemoteProcessGroup rpg = this.remoteProcessGroupDAO.getRemoteProcessGroup(remoteProcessGroupId);
        return this.createRemoteGroupEntity(rpg, NiFiUserUtils.getNiFiUser());
    }

    public RemoteProcessGroupStatusEntity getRemoteProcessGroupStatus(String id) {
        RemoteProcessGroup remoteProcessGroup = this.remoteProcessGroupDAO.getRemoteProcessGroup(id);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)remoteProcessGroup);
        RemoteProcessGroupStatusDTO dto = this.dtoFactory.createRemoteProcessGroupStatusDto(remoteProcessGroup, this.controllerFacade.getRemoteProcessGroupStatus(id));
        return this.entityFactory.createRemoteProcessGroupStatusEntity(dto, permissions);
    }

    public StatusHistoryEntity getRemoteProcessGroupStatusHistory(String id) {
        RemoteProcessGroup remoteProcessGroup = this.remoteProcessGroupDAO.getRemoteProcessGroup(id);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)remoteProcessGroup);
        StatusHistoryDTO dto = this.controllerFacade.getRemoteProcessGroupStatusHistory(id);
        return this.entityFactory.createStatusHistoryEntity(dto, permissions);
    }

    public CurrentUserEntity getCurrentUser() {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        CurrentUserEntity entity = new CurrentUserEntity();
        entity.setIdentity(user.getIdentity());
        entity.setAnonymous(user.isAnonymous());
        entity.setProvenancePermissions(this.dtoFactory.createPermissionsDto(this.authorizableLookup.getProvenance()));
        entity.setCountersPermissions(this.dtoFactory.createPermissionsDto(this.authorizableLookup.getCounters()));
        entity.setTenantsPermissions(this.dtoFactory.createPermissionsDto(this.authorizableLookup.getTenant()));
        entity.setControllerPermissions(this.dtoFactory.createPermissionsDto(this.authorizableLookup.getController()));
        entity.setPoliciesPermissions(this.dtoFactory.createPermissionsDto(this.authorizableLookup.getPolicies()));
        entity.setSystemPermissions(this.dtoFactory.createPermissionsDto(this.authorizableLookup.getSystem()));
        entity.setParameterContextPermissions(this.dtoFactory.createPermissionsDto(this.authorizableLookup.getParameterContexts()));
        entity.setCanVersionFlows(CollectionUtils.isNotEmpty((Collection)this.flowRegistryClient.getRegistryIdentifiers()));
        entity.setRestrictedComponentsPermissions(this.dtoFactory.createPermissionsDto(this.authorizableLookup.getRestrictedComponents()));
        HashSet componentRestrictionPermissions = new HashSet();
        Arrays.stream(RequiredPermission.values()).forEach(requiredPermission -> {
            PermissionsDTO restrictionPermissions = this.dtoFactory.createPermissionsDto(this.authorizableLookup.getRestrictedComponents(requiredPermission));
            RequiredPermissionDTO requiredPermissionDto = new RequiredPermissionDTO();
            requiredPermissionDto.setId(requiredPermission.getPermissionIdentifier());
            requiredPermissionDto.setLabel(requiredPermission.getPermissionLabel());
            ComponentRestrictionPermissionDTO componentRestrictionPermissionDto = new ComponentRestrictionPermissionDTO();
            componentRestrictionPermissionDto.setRequiredPermission(requiredPermissionDto);
            componentRestrictionPermissionDto.setPermissions(restrictionPermissions);
            componentRestrictionPermissions.add(componentRestrictionPermissionDto);
        });
        entity.setComponentRestrictionPermissions(componentRestrictionPermissions);
        return entity;
    }

    public ProcessGroupFlowEntity getProcessGroupFlow(String groupId) {
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(groupId);
        ProcessGroupStatus groupStatus = this.controllerFacade.getProcessGroupStatus(groupId, 1);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processGroup);
        return this.entityFactory.createProcessGroupFlowEntity(this.dtoFactory.createProcessGroupFlowDto(processGroup, groupStatus, this.revisionManager, arg_0 -> this.getProcessGroupBulletins(arg_0)), permissions);
    }

    public ProcessGroupEntity getProcessGroup(String groupId) {
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(groupId);
        return this.createProcessGroupEntity(processGroup);
    }

    private ControllerServiceEntity createControllerServiceEntity(ControllerServiceNode serviceNode, Set<String> serviceIds) {
        ControllerServiceDTO dto = this.dtoFactory.createControllerServiceDto(serviceNode);
        ControllerServiceReference ref = serviceNode.getReferences();
        ControllerServiceReferencingComponentsEntity referencingComponentsEntity = this.createControllerServiceReferencingComponentsEntity(ref, serviceIds);
        dto.setReferencingComponents(referencingComponentsEntity.getControllerServiceReferencingComponents());
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(serviceNode.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)serviceNode, NiFiUserUtils.getNiFiUser());
        PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)serviceNode), NiFiUserUtils.getNiFiUser());
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(serviceNode.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createControllerServiceEntity(dto, revision, permissions, operatePermissions, bulletinEntities);
    }

    public VariableRegistryEntity getVariableRegistry(String groupId, boolean includeAncestorGroups) {
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(groupId);
        if (processGroup == null) {
            throw new ResourceNotFoundException("Could not find group with ID " + groupId);
        }
        return this.createVariableRegistryEntity(processGroup, includeAncestorGroups);
    }

    private VariableRegistryEntity createVariableRegistryEntity(ProcessGroup processGroup, boolean includeAncestorGroups) {
        VariableRegistryDTO registryDto = this.dtoFactory.createVariableRegistryDto(processGroup, this.revisionManager);
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(processGroup.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processGroup);
        if (includeAncestorGroups) {
            for (ProcessGroup parent = processGroup.getParent(); parent != null; parent = parent.getParent()) {
                PermissionsDTO parentPerms = this.dtoFactory.createPermissionsDto((Authorizable)parent);
                if (!Boolean.TRUE.equals(parentPerms.getCanRead())) continue;
                VariableRegistryDTO parentRegistryDto = this.dtoFactory.createVariableRegistryDto(parent, this.revisionManager);
                Set parentVariables = parentRegistryDto.getVariables();
                registryDto.getVariables().addAll(parentVariables);
            }
        }
        return this.entityFactory.createVariableRegistryEntity(registryDto, revision, permissions);
    }

    public VariableRegistryEntity populateAffectedComponents(VariableRegistryDTO variableRegistryDto) {
        String groupId = variableRegistryDto.getProcessGroupId();
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(groupId);
        if (processGroup == null) {
            throw new ResourceNotFoundException("Could not find group with ID " + groupId);
        }
        VariableRegistryDTO registryDto = this.dtoFactory.populateAffectedComponents(variableRegistryDto, processGroup, this.revisionManager);
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(processGroup.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processGroup);
        return this.entityFactory.createVariableRegistryEntity(registryDto, revision, permissions);
    }

    public Set<ControllerServiceEntity> getControllerServices(String groupId, boolean includeAncestorGroups, boolean includeDescendantGroups) {
        Set serviceNodes = this.controllerServiceDAO.getControllerServices(groupId, includeAncestorGroups, includeDescendantGroups);
        Set serviceIds = serviceNodes.stream().map(service -> service.getIdentifier()).collect(Collectors.toSet());
        return serviceNodes.stream().map(serviceNode -> this.createControllerServiceEntity(serviceNode, serviceIds)).collect(Collectors.toSet());
    }

    public ControllerServiceEntity getControllerService(String controllerServiceId) {
        ControllerServiceNode controllerService = this.controllerServiceDAO.getControllerService(controllerServiceId);
        return this.createControllerServiceEntity(controllerService, (Set)Sets.newHashSet((Object[])new String[]{controllerServiceId}));
    }

    public PropertyDescriptorDTO getControllerServicePropertyDescriptor(String id, String property) {
        ControllerServiceNode controllerService = this.controllerServiceDAO.getControllerService(id);
        PropertyDescriptor descriptor = controllerService.getControllerServiceImplementation().getPropertyDescriptor(property);
        if (descriptor == null) {
            descriptor = new PropertyDescriptor.Builder().name(property).addValidator(Validator.INVALID).dynamic(true).build();
        }
        String groupId = controllerService.getProcessGroup() == null ? null : controllerService.getProcessGroup().getIdentifier();
        return this.dtoFactory.createPropertyDescriptorDto(descriptor, groupId);
    }

    public ControllerServiceReferencingComponentsEntity getControllerServiceReferencingComponents(String controllerServiceId) {
        ControllerServiceNode service = this.controllerServiceDAO.getControllerService(controllerServiceId);
        ControllerServiceReference ref = service.getReferences();
        return this.createControllerServiceReferencingComponentsEntity(ref, (Set)Sets.newHashSet((Object[])new String[]{controllerServiceId}));
    }

    private ReportingTaskEntity createReportingTaskEntity(ReportingTaskNode reportingTask) {
        RevisionDTO revision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(reportingTask.getIdentifier()));
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)reportingTask);
        PermissionsDTO operatePermissions = this.dtoFactory.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)reportingTask));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(reportingTask.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createReportingTaskEntity(this.dtoFactory.createReportingTaskDto(reportingTask), revision, permissions, operatePermissions, bulletinEntities);
    }

    public Set<ReportingTaskEntity> getReportingTasks() {
        Set reportingTasks = this.reportingTaskDAO.getReportingTasks();
        return reportingTasks.stream().map(reportingTask -> this.createReportingTaskEntity(reportingTask)).collect(Collectors.toSet());
    }

    public ReportingTaskEntity getReportingTask(String reportingTaskId) {
        ReportingTaskNode reportingTask = this.reportingTaskDAO.getReportingTask(reportingTaskId);
        return this.createReportingTaskEntity(reportingTask);
    }

    public PropertyDescriptorDTO getReportingTaskPropertyDescriptor(String id, String property) {
        ReportingTaskNode reportingTask = this.reportingTaskDAO.getReportingTask(id);
        PropertyDescriptor descriptor = reportingTask.getReportingTask().getPropertyDescriptor(property);
        if (descriptor == null) {
            descriptor = new PropertyDescriptor.Builder().name(property).addValidator(Validator.INVALID).dynamic(true).build();
        }
        return this.dtoFactory.createPropertyDescriptorDto(descriptor, null);
    }

    public StatusHistoryEntity getProcessGroupStatusHistory(String groupId) {
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(groupId);
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processGroup);
        StatusHistoryDTO dto = this.controllerFacade.getProcessGroupStatusHistory(groupId);
        return this.entityFactory.createStatusHistoryEntity(dto, permissions);
    }

    public VersionControlComponentMappingEntity registerFlowWithFlowRegistry(String groupId, StartVersionControlRequestEntity requestEntity) {
        VersionedFlowSnapshot registeredSnapshot;
        VersionedFlow registeredFlow;
        VersionControlInformation currentVci;
        VersionedFlowDTO versionedFlowDto = requestEntity.getVersionedFlow();
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(groupId);
        int snapshotVersion = "FORCE_COMMIT".equals(versionedFlowDto.getAction()) ? -1 : ((currentVci = processGroup.getVersionControlInformation()) == null ? 1 : currentVci.getVersion() + 1);
        InstantiatedVersionedProcessGroup versionedProcessGroup = this.createFlowSnapshot(groupId);
        Map parameterContexts = this.createVersionedParameterContexts(processGroup);
        String flowId = versionedFlowDto.getFlowId() == null ? UUID.randomUUID().toString() : versionedFlowDto.getFlowId();
        VersionedFlow versionedFlow = new VersionedFlow();
        versionedFlow.setBucketIdentifier(versionedFlowDto.getBucketId());
        versionedFlow.setCreatedTimestamp(System.currentTimeMillis());
        versionedFlow.setDescription(versionedFlowDto.getDescription());
        versionedFlow.setModifiedTimestamp(versionedFlow.getCreatedTimestamp());
        versionedFlow.setName(versionedFlowDto.getFlowName());
        versionedFlow.setIdentifier(flowId);
        String registryId = requestEntity.getVersionedFlow().getRegistryId();
        boolean registerNewFlow = versionedFlowDto.getFlowId() == null;
        try {
            registeredFlow = registerNewFlow ? this.registerVersionedFlow(registryId, versionedFlow) : this.getVersionedFlow(registryId, versionedFlowDto.getBucketId(), versionedFlowDto.getFlowId());
        }
        catch (NiFiRegistryException e) {
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Failed to communicate with Flow Registry when attempting to create the flow");
        }
        try {
            registeredSnapshot = this.registerVersionedFlowSnapshot(registryId, registeredFlow, (VersionedProcessGroup)versionedProcessGroup, parameterContexts, versionedProcessGroup.getExternalControllerServiceReferences(), versionedFlowDto.getComments(), snapshotVersion);
        }
        catch (NiFiCoreException e) {
            if (registerNewFlow) {
                logger.error("The flow has been created, but failed to add a snapshot. Returning the created flow information.", (Throwable)e);
                VersionControlInformationDTO vci = new VersionControlInformationDTO();
                vci.setBucketId(registeredFlow.getBucketIdentifier());
                vci.setBucketName(registeredFlow.getBucketName());
                vci.setFlowId(registeredFlow.getIdentifier());
                vci.setFlowName(registeredFlow.getName());
                vci.setFlowDescription(registeredFlow.getDescription());
                vci.setGroupId(groupId);
                vci.setRegistryId(registryId);
                vci.setRegistryName(this.getFlowRegistryName(registryId));
                vci.setVersion(Integer.valueOf(0));
                vci.setState(VersionedFlowState.SYNC_FAILURE.name());
                vci.setStateExplanation(e.getLocalizedMessage());
                return this.createVersionControlComponentMappingEntity(groupId, versionedProcessGroup, vci);
            }
            throw e;
        }
        Bucket bucket = registeredSnapshot.getBucket();
        VersionedFlow flow = registeredSnapshot.getFlow();
        VersionControlInformationDTO vci = new VersionControlInformationDTO();
        vci.setBucketId(bucket.getIdentifier());
        vci.setBucketName(bucket.getName());
        vci.setFlowId(flow.getIdentifier());
        vci.setFlowName(flow.getName());
        vci.setFlowDescription(flow.getDescription());
        vci.setGroupId(groupId);
        vci.setRegistryId(registryId);
        vci.setRegistryName(this.getFlowRegistryName(registryId));
        vci.setVersion(Integer.valueOf(registeredSnapshot.getSnapshotMetadata().getVersion()));
        vci.setState(VersionedFlowState.UP_TO_DATE.name());
        return this.createVersionControlComponentMappingEntity(groupId, versionedProcessGroup, vci);
    }

    private VersionControlComponentMappingEntity createVersionControlComponentMappingEntity(String groupId, InstantiatedVersionedProcessGroup versionedProcessGroup, VersionControlInformationDTO vci) {
        Map mapping = this.dtoFactory.createVersionControlComponentMappingDto(versionedProcessGroup);
        Revision groupRevision = this.revisionManager.getRevision(groupId);
        RevisionDTO groupRevisionDto = this.dtoFactory.createRevisionDTO(groupRevision);
        VersionControlComponentMappingEntity entity = new VersionControlComponentMappingEntity();
        entity.setVersionControlInformation(vci);
        entity.setProcessGroupRevision(groupRevisionDto);
        entity.setVersionControlComponentMapping(mapping);
        return entity;
    }

    public VersionedFlowSnapshot getCurrentFlowSnapshotByGroupId(String processGroupId) {
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(processGroupId);
        NiFiRegistryFlowMapper mapper = this.makeNiFiRegistryFlowMapper(this.controllerFacade.getExtensionManager());
        InstantiatedVersionedProcessGroup nonVersionedProcessGroup = mapper.mapNonVersionedProcessGroup(processGroup, this.controllerFacade.getControllerServiceProvider());
        Map parameterContexts = mapper.mapParameterContexts(processGroup, true);
        VersionedFlowSnapshot nonVersionedFlowSnapshot = new VersionedFlowSnapshot();
        nonVersionedFlowSnapshot.setFlowContents((VersionedProcessGroup)nonVersionedProcessGroup);
        nonVersionedFlowSnapshot.setExternalControllerServices(nonVersionedProcessGroup.getExternalControllerServiceReferences());
        nonVersionedFlowSnapshot.setParameterContexts(parameterContexts);
        nonVersionedFlowSnapshot.setFlowEncodingVersion("1.0");
        return nonVersionedFlowSnapshot;
    }

    public VersionedFlowSnapshot getVersionedFlowSnapshotByGroupId(String processGroupId) {
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(processGroupId);
        VersionControlInformation versionControlInfo = processGroup.getVersionControlInformation();
        return this.getVersionedFlowSnapshot(versionControlInfo.getRegistryIdentifier(), versionControlInfo.getBucketIdentifier(), versionControlInfo.getFlowIdentifier(), Integer.valueOf(versionControlInfo.getVersion()), true);
    }

    public VersionedFlowSnapshot getVersionedFlowSnapshot(VersionControlInformationDTO versionControlInfo, boolean fetchRemoteFlows) {
        return this.getVersionedFlowSnapshot(versionControlInfo.getRegistryId(), versionControlInfo.getBucketId(), versionControlInfo.getFlowId(), versionControlInfo.getVersion(), fetchRemoteFlows);
    }

    private VersionedFlowSnapshot getVersionedFlowSnapshot(String registryId, String bucketId, String flowId, Integer flowVersion, boolean fetchRemoteFlows) {
        VersionedFlowSnapshot snapshot;
        FlowRegistry flowRegistry = this.flowRegistryClient.getFlowRegistry(registryId);
        if (flowRegistry == null) {
            throw new ResourceNotFoundException("Could not find any Flow Registry registered with identifier " + registryId);
        }
        try {
            snapshot = flowRegistry.getFlowContents(bucketId, flowId, flowVersion.intValue(), fetchRemoteFlows, NiFiUserUtils.getNiFiUser());
        }
        catch (NiFiRegistryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("The Flow Registry with ID " + registryId + " reports that no Flow exists with Bucket " + bucketId + ", Flow " + flowId + ", Version " + flowVersion);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Failed to communicate with Flow Registry when attempting to retrieve a versioned flow");
        }
        return snapshot;
    }

    public VersionedFlow deleteVersionedFlow(String registryId, String bucketId, String flowId) {
        FlowRegistry registry = this.flowRegistryClient.getFlowRegistry(registryId);
        if (registry == null) {
            throw new IllegalArgumentException("No Flow Registry exists with ID " + registryId);
        }
        try {
            return registry.deleteVersionedFlow(bucketId, flowId, NiFiUserUtils.getNiFiUser());
        }
        catch (IOException | NiFiRegistryException e) {
            throw new NiFiCoreException("Failed to remove flow from Flow Registry due to " + e.getMessage(), e);
        }
    }

    public boolean isAnyProcessGroupUnderVersionControl(String groupId) {
        return this.isProcessGroupUnderVersionControl(this.processGroupDAO.getProcessGroup(groupId));
    }

    private boolean isProcessGroupUnderVersionControl(ProcessGroup processGroup) {
        if (processGroup.getVersionControlInformation() != null) {
            return true;
        }
        Set childGroups = processGroup.getProcessGroups();
        if (childGroups != null) {
            return childGroups.stream().anyMatch(childGroup -> this.isProcessGroupUnderVersionControl(childGroup));
        }
        return false;
    }

    public VersionControlInformationEntity getVersionControlInformation(String groupId) {
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(groupId);
        VersionControlInformation versionControlInfo = processGroup.getVersionControlInformation();
        if (versionControlInfo == null) {
            return null;
        }
        VersionControlInformationDTO versionControlDto = this.dtoFactory.createVersionControlInformationDto(processGroup);
        RevisionDTO groupRevision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(groupId));
        return this.entityFactory.createVersionControlInformationEntity(versionControlDto, groupRevision);
    }

    private InstantiatedVersionedProcessGroup createFlowSnapshot(String processGroupId) {
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(processGroupId);
        NiFiRegistryFlowMapper mapper = this.makeNiFiRegistryFlowMapper(this.controllerFacade.getExtensionManager());
        InstantiatedVersionedProcessGroup versionedGroup = mapper.mapProcessGroup(processGroup, this.controllerFacade.getControllerServiceProvider(), this.flowRegistryClient, false);
        return versionedGroup;
    }

    private Map<String, VersionedParameterContext> createVersionedParameterContexts(ProcessGroup processGroup) {
        NiFiRegistryFlowMapper mapper = this.makeNiFiRegistryFlowMapper(this.controllerFacade.getExtensionManager());
        return mapper.mapParameterContexts(processGroup, false);
    }

    public FlowComparisonEntity getLocalModifications(String processGroupId) {
        VersionedFlowSnapshot versionedFlowSnapshot;
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(processGroupId);
        VersionControlInformation versionControlInfo = processGroup.getVersionControlInformation();
        if (versionControlInfo == null) {
            throw new IllegalStateException("Process Group with ID " + processGroupId + " is not under Version Control");
        }
        FlowRegistry flowRegistry = this.flowRegistryClient.getFlowRegistry(versionControlInfo.getRegistryIdentifier());
        if (flowRegistry == null) {
            throw new IllegalStateException("Process Group with ID " + processGroupId + " is tracking to a flow in Flow Registry with ID " + versionControlInfo.getRegistryIdentifier() + " but cannot find a Flow Registry with that identifier");
        }
        try {
            versionedFlowSnapshot = flowRegistry.getFlowContents(versionControlInfo.getBucketIdentifier(), versionControlInfo.getFlowIdentifier(), versionControlInfo.getVersion(), true, NiFiUserUtils.getNiFiUser());
        }
        catch (IOException | NiFiRegistryException e) {
            throw new NiFiCoreException("Failed to retrieve flow with Flow Registry in order to calculate local differences due to " + e.getMessage(), e);
        }
        NiFiRegistryFlowMapper mapper = this.makeNiFiRegistryFlowMapper(this.controllerFacade.getExtensionManager());
        InstantiatedVersionedProcessGroup localGroup = mapper.mapProcessGroup(processGroup, this.controllerFacade.getControllerServiceProvider(), this.flowRegistryClient, true);
        VersionedProcessGroup registryGroup = versionedFlowSnapshot.getFlowContents();
        StandardComparableDataFlow localFlow = new StandardComparableDataFlow("Local Flow", (VersionedProcessGroup)localGroup);
        StandardComparableDataFlow registryFlow = new StandardComparableDataFlow("Versioned Flow", registryGroup);
        Set ancestorServiceIds = processGroup.getAncestorServiceIds();
        StandardFlowComparator flowComparator = new StandardFlowComparator((ComparableDataFlow)registryFlow, (ComparableDataFlow)localFlow, ancestorServiceIds, (DifferenceDescriptor)new ConciseEvolvingDifferenceDescriptor());
        FlowComparison flowComparison = flowComparator.compare();
        Set differenceDtos = this.dtoFactory.createComponentDifferenceDtos(flowComparison, this.controllerFacade.getFlowManager());
        FlowComparisonEntity entity = new FlowComparisonEntity();
        entity.setComponentDifferences(differenceDtos);
        return entity;
    }

    public VersionedFlow registerVersionedFlow(String registryId, VersionedFlow flow) {
        FlowRegistry registry = this.flowRegistryClient.getFlowRegistry(registryId);
        if (registry == null) {
            throw new ResourceNotFoundException("No Flow Registry exists with ID " + registryId);
        }
        try {
            return registry.registerVersionedFlow(flow, NiFiUserUtils.getNiFiUser());
        }
        catch (IOException | NiFiRegistryException e) {
            throw new NiFiCoreException("Failed to register flow with Flow Registry due to " + e.getMessage(), e);
        }
    }

    private VersionedFlow getVersionedFlow(String registryId, String bucketId, String flowId) throws IOException, NiFiRegistryException {
        FlowRegistry registry = this.flowRegistryClient.getFlowRegistry(registryId);
        if (registry == null) {
            throw new ResourceNotFoundException("No Flow Registry exists with ID " + registryId);
        }
        return registry.getVersionedFlow(bucketId, flowId, NiFiUserUtils.getNiFiUser());
    }

    public VersionedFlowSnapshot registerVersionedFlowSnapshot(String registryId, VersionedFlow flow, VersionedProcessGroup snapshot, Map<String, VersionedParameterContext> parameterContexts, Map<String, ExternalControllerServiceReference> externalControllerServiceReferences, String comments, int expectedVersion) {
        FlowRegistry registry = this.flowRegistryClient.getFlowRegistry(registryId);
        if (registry == null) {
            throw new ResourceNotFoundException("No Flow Registry exists with ID " + registryId);
        }
        try {
            return registry.registerVersionedFlowSnapshot(flow, snapshot, externalControllerServiceReferences, parameterContexts, comments, expectedVersion, NiFiUserUtils.getNiFiUser());
        }
        catch (IOException | NiFiRegistryException e) {
            throw new NiFiCoreException("Failed to register flow with Flow Registry due to " + e.getMessage(), e);
        }
    }

    public VersionControlInformationEntity setVersionControlInformation(Revision revision, String processGroupId, VersionControlInformationDTO versionControlInfo, Map<String, String> versionedComponentMapping) {
        ProcessGroup group = this.processGroupDAO.getProcessGroup(processGroupId);
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)group, () -> this.processGroupDAO.updateVersionControlInformation(versionControlInfo, versionedComponentMapping), processGroup -> this.dtoFactory.createVersionControlInformationDto(processGroup));
        return this.entityFactory.createVersionControlInformationEntity((VersionControlInformationDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()));
    }

    public VersionControlInformationEntity deleteVersionControl(Revision revision, String processGroupId) {
        ProcessGroup group = this.processGroupDAO.getProcessGroup(processGroupId);
        RevisionUpdate snapshot = this.updateComponent(revision, (Authorizable)group, () -> this.processGroupDAO.disconnectVersionControl(processGroupId), processGroup -> this.dtoFactory.createVersionControlInformationDto(group));
        return this.entityFactory.createVersionControlInformationEntity((VersionControlInformationDTO)snapshot.getComponent(), this.dtoFactory.createRevisionDTO(snapshot.getLastModification()));
    }

    public void verifyCanUpdate(String groupId, VersionedFlowSnapshot proposedFlow, boolean verifyConnectionRemoval, boolean verifyNotDirty) {
        ProcessGroup group = this.processGroupDAO.getProcessGroup(groupId);
        group.verifyCanUpdate(proposedFlow, verifyConnectionRemoval, verifyNotDirty);
    }

    public void verifyCanSaveToFlowRegistry(String groupId, String registryId, String bucketId, String flowId, String saveAction) {
        ProcessGroup group = this.processGroupDAO.getProcessGroup(groupId);
        group.verifyCanSaveToFlowRegistry(registryId, bucketId, flowId, saveAction);
    }

    public void verifyCanRevertLocalModifications(String groupId, VersionedFlowSnapshot versionedFlowSnapshot) {
        ProcessGroup group = this.processGroupDAO.getProcessGroup(groupId);
        group.verifyCanRevertLocalModifications();
        group.verifyCanUpdate(versionedFlowSnapshot, false, false);
    }

    public Set<AffectedComponentEntity> getComponentsAffectedByFlowUpdate(String processGroupId, VersionedFlowSnapshot updatedSnapshot) {
        ProcessGroup group = this.processGroupDAO.getProcessGroup(processGroupId);
        NiFiRegistryFlowMapper mapper = this.makeNiFiRegistryFlowMapper(this.controllerFacade.getExtensionManager());
        InstantiatedVersionedProcessGroup localContents = mapper.mapProcessGroup(group, this.controllerFacade.getControllerServiceProvider(), this.flowRegistryClient, true);
        StandardComparableDataFlow localFlow = new StandardComparableDataFlow("Current Flow", (VersionedProcessGroup)localContents);
        StandardComparableDataFlow proposedFlow = new StandardComparableDataFlow("New Flow", updatedSnapshot.getFlowContents());
        Set ancestorServiceIds = group.getAncestorServiceIds();
        StandardFlowComparator flowComparator = new StandardFlowComparator((ComparableDataFlow)localFlow, (ComparableDataFlow)proposedFlow, ancestorServiceIds, (DifferenceDescriptor)new StaticDifferenceDescriptor());
        FlowComparison comparison = flowComparator.compare();
        FlowManager flowManager = this.controllerFacade.getFlowManager();
        Set affectedComponents = comparison.getDifferences().stream().filter(difference -> difference.getDifferenceType() != DifferenceType.COMPONENT_ADDED).filter(difference -> difference.getDifferenceType() != DifferenceType.BUNDLE_CHANGED).filter(FlowDifferenceFilters.FILTER_ADDED_REMOVED_REMOTE_PORTS).filter(FlowDifferenceFilters.FILTER_IGNORABLE_VERSIONED_FLOW_COORDINATE_CHANGES).filter(diff -> !FlowDifferenceFilters.isNewPropertyWithDefaultValue((FlowDifference)diff, (FlowManager)flowManager)).filter(arg_0 -> StandardNiFiServiceFacade.lambda$getComponentsAffectedByFlowUpdate$207((ComparableDataFlow)proposedFlow, flowManager, arg_0)).filter(diff -> !FlowDifferenceFilters.isScheduledStateNew((FlowDifference)diff)).map(difference -> {
            String state;
            VersionedComponent localComponent = difference.getComponentA();
            switch (15.$SwitchMap$org$apache$nifi$registry$flow$ComponentType[localComponent.getComponentType().ordinal()]) {
                case 1: {
                    String serviceId = ((InstantiatedVersionedControllerService)localComponent).getInstanceId();
                    state = this.controllerServiceDAO.getControllerService(serviceId).getState().name();
                    break;
                }
                case 2: {
                    String processorId = ((InstantiatedVersionedProcessor)localComponent).getInstanceId();
                    state = this.processorDAO.getProcessor(processorId).getPhysicalScheduledState().name();
                    break;
                }
                case 3: {
                    InstantiatedVersionedRemoteGroupPort remoteInputPort = (InstantiatedVersionedRemoteGroupPort)localComponent;
                    state = this.remoteProcessGroupDAO.getRemoteProcessGroup(remoteInputPort.getInstanceGroupId()).getInputPort(remoteInputPort.getInstanceId()).getScheduledState().name();
                    break;
                }
                case 4: {
                    InstantiatedVersionedRemoteGroupPort remoteOutputPort = (InstantiatedVersionedRemoteGroupPort)localComponent;
                    state = this.remoteProcessGroupDAO.getRemoteProcessGroup(remoteOutputPort.getInstanceGroupId()).getOutputPort(remoteOutputPort.getInstanceId()).getScheduledState().name();
                    break;
                }
                case 5: {
                    InstantiatedVersionedPort versionedInputPort = (InstantiatedVersionedPort)localComponent;
                    Port inputPort = this.getInputPort(versionedInputPort);
                    state = inputPort == null ? null : inputPort.getScheduledState().name();
                    break;
                }
                case 6: {
                    InstantiatedVersionedPort versionedOutputPort = (InstantiatedVersionedPort)localComponent;
                    Port outputPort = this.getOutputPort(versionedOutputPort);
                    state = outputPort == null ? null : outputPort.getScheduledState().name();
                    break;
                }
                default: {
                    state = null;
                }
            }
            return this.createAffectedComponentEntity((InstantiatedVersionedComponent)localComponent, localComponent.getComponentType().name(), state);
        }).collect(Collectors.toCollection(HashSet::new));
        for (FlowDifference difference2 : comparison.getDifferences()) {
            Object referencingService2;
            VersionedComponent localComponent;
            if (difference2.getDifferenceType() == DifferenceType.BUNDLE_CHANGED || FlowDifferenceFilters.isAddedOrRemovedRemotePort((FlowDifference)difference2) || FlowDifferenceFilters.isPublicPortNameChange((FlowDifference)difference2) || FlowDifferenceFilters.isIgnorableVersionedFlowCoordinateChange((FlowDifference)difference2) || FlowDifferenceFilters.isNewPropertyWithDefaultValue((FlowDifference)difference2, (FlowManager)this.controllerFacade.getFlowManager()) || FlowDifferenceFilters.isNewRelationshipAutoTerminatedAndDefaulted((FlowDifference)difference2, (VersionedProcessGroup)updatedSnapshot.getFlowContents(), (FlowManager)this.controllerFacade.getFlowManager()) || (localComponent = difference2.getComponentA()) == null) continue;
            if (difference2.getDifferenceType() == DifferenceType.COMPONENT_REMOVED && localComponent.getComponentType() == ComponentType.PROCESS_GROUP) {
                String localGroupId = ((InstantiatedVersionedProcessGroup)localComponent).getInstanceId();
                ProcessGroup localGroup = this.processGroupDAO.getProcessGroup(localGroupId);
                localGroup.findAllProcessors().stream().map(comp -> this.createAffectedComponentEntity((Connectable)comp)).forEach(affectedComponents::add);
                localGroup.findAllFunnels().stream().map(comp -> this.createAffectedComponentEntity((Connectable)comp)).forEach(affectedComponents::add);
                localGroup.findAllInputPorts().stream().map(comp -> this.createAffectedComponentEntity((Connectable)comp)).forEach(affectedComponents::add);
                localGroup.findAllOutputPorts().stream().map(comp -> this.createAffectedComponentEntity((Connectable)comp)).forEach(affectedComponents::add);
                localGroup.findAllRemoteProcessGroups().stream().flatMap(rpg -> Stream.concat(rpg.getInputPorts().stream(), rpg.getOutputPorts().stream())).map(comp -> this.createAffectedComponentEntity((Connectable)comp)).forEach(affectedComponents::add);
                localGroup.findAllControllerServices().stream().map(comp -> this.createAffectedComponentEntity(comp)).forEach(affectedComponents::add);
            }
            if (localComponent.getComponentType() != ComponentType.CONTROLLER_SERVICE) continue;
            String serviceId = ((InstantiatedVersionedControllerService)localComponent).getInstanceId();
            ControllerServiceNode serviceNode = this.controllerServiceDAO.getControllerService(serviceId);
            List referencingServices = serviceNode.getReferences().findRecursiveReferences(ControllerServiceNode.class);
            for (Object referencingService2 : referencingServices) {
                affectedComponents.add(this.createAffectedComponentEntity((ControllerServiceNode)referencingService2));
            }
            List referencingProcessors = serviceNode.getReferences().findRecursiveReferences(ProcessorNode.class);
            referencingService2 = referencingProcessors.iterator();
            while (referencingService2.hasNext()) {
                ProcessorNode referencingProcessor = (ProcessorNode)referencingService2.next();
                affectedComponents.add(this.createAffectedComponentEntity((Connectable)referencingProcessor));
            }
        }
        HashMap connectablesByVersionId = new HashMap();
        this.mapToConnectableId((Collection)group.findAllFunnels(), connectablesByVersionId);
        this.mapToConnectableId((Collection)group.findAllInputPorts(), connectablesByVersionId);
        this.mapToConnectableId((Collection)group.findAllOutputPorts(), connectablesByVersionId);
        this.mapToConnectableId((Collection)group.findAllProcessors(), connectablesByVersionId);
        ArrayList remotePorts = new ArrayList();
        for (RemoteProcessGroup rpg2 : group.findAllRemoteProcessGroups()) {
            remotePorts.addAll(rpg2.getInputPorts());
            remotePorts.addAll(rpg2.getOutputPorts());
        }
        this.mapToConnectableId(remotePorts, connectablesByVersionId);
        for (FlowDifference difference3 : comparison.getDifferences()) {
            String destinationVersionId;
            List destinations;
            VersionedComponent component = difference3.getComponentA();
            if (component == null) {
                component = difference3.getComponentB();
            }
            if (component.getComponentType() != ComponentType.CONNECTION) continue;
            VersionedConnection connection = (VersionedConnection)component;
            String sourceVersionedId = connection.getSource().getId();
            List sources = (List)connectablesByVersionId.get(sourceVersionedId);
            if (sources != null) {
                for (Connectable source : sources) {
                    affectedComponents.add(this.createAffectedComponentEntity(source));
                }
            }
            if ((destinations = (List)connectablesByVersionId.get(destinationVersionId = connection.getDestination().getId())) == null) continue;
            for (Connectable destination : destinations) {
                affectedComponents.add(this.createAffectedComponentEntity(destination));
            }
        }
        return affectedComponents;
    }

    private Port getInputPort(InstantiatedVersionedPort port) {
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(port.getInstanceGroupId());
        if (processGroup == null) {
            return null;
        }
        return processGroup.getInputPort(port.getInstanceId());
    }

    private Port getOutputPort(InstantiatedVersionedPort port) {
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(port.getInstanceGroupId());
        if (processGroup == null) {
            return null;
        }
        return processGroup.getOutputPort(port.getInstanceId());
    }

    private void mapToConnectableId(Collection<? extends Connectable> connectables, Map<String, List<Connectable>> destination) {
        for (Connectable connectable : connectables) {
            Optional versionedIdOption = connectable.getVersionedComponentId();
            String versionedId = versionedIdOption.isPresent() ? (String)versionedIdOption.get() : NiFiRegistryFlowMapper.generateVersionedComponentId((String)connectable.getIdentifier());
            List byVersionedId = destination.computeIfAbsent(versionedId, key -> new ArrayList());
            byVersionedId.add(connectable);
        }
    }

    private AffectedComponentEntity createAffectedComponentEntity(Connectable connectable) {
        AffectedComponentEntity entity = new AffectedComponentEntity();
        entity.setRevision(this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(connectable.getIdentifier())));
        entity.setId(connectable.getIdentifier());
        Authorizable authorizable = this.getAuthorizable(connectable);
        PermissionsDTO permissionsDto = this.dtoFactory.createPermissionsDto(authorizable);
        entity.setPermissions(permissionsDto);
        AffectedComponentDTO dto = new AffectedComponentDTO();
        dto.setId(connectable.getIdentifier());
        dto.setReferenceType(connectable.getConnectableType().name());
        dto.setState(connectable.getScheduledState().name());
        String groupId = connectable instanceof RemoteGroupPort ? ((RemoteGroupPort)connectable).getRemoteProcessGroup().getIdentifier() : connectable.getProcessGroupIdentifier();
        dto.setProcessGroupId(groupId);
        entity.setComponent(dto);
        return entity;
    }

    private AffectedComponentEntity createAffectedComponentEntity(ControllerServiceNode serviceNode) {
        AffectedComponentEntity entity = new AffectedComponentEntity();
        entity.setRevision(this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(serviceNode.getIdentifier())));
        entity.setId(serviceNode.getIdentifier());
        Authorizable authorizable = this.authorizableLookup.getControllerService(serviceNode.getIdentifier()).getAuthorizable();
        PermissionsDTO permissionsDto = this.dtoFactory.createPermissionsDto(authorizable);
        entity.setPermissions(permissionsDto);
        AffectedComponentDTO dto = new AffectedComponentDTO();
        dto.setId(serviceNode.getIdentifier());
        dto.setReferenceType("CONTROLLER_SERVICE");
        dto.setProcessGroupId(serviceNode.getProcessGroupIdentifier());
        dto.setState(serviceNode.getState().name());
        entity.setComponent(dto);
        return entity;
    }

    private AffectedComponentEntity createAffectedComponentEntity(InstantiatedVersionedComponent instance, String componentTypeName, String componentState) {
        AffectedComponentEntity entity = new AffectedComponentEntity();
        entity.setRevision(this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(instance.getInstanceId())));
        entity.setId(instance.getInstanceId());
        Authorizable authorizable = this.getAuthorizable(componentTypeName, instance);
        PermissionsDTO permissionsDto = this.dtoFactory.createPermissionsDto(authorizable);
        entity.setPermissions(permissionsDto);
        AffectedComponentDTO dto = new AffectedComponentDTO();
        dto.setId(instance.getInstanceId());
        dto.setReferenceType(componentTypeName);
        dto.setProcessGroupId(instance.getInstanceGroupId());
        dto.setState(componentState);
        entity.setComponent(dto);
        return entity;
    }

    private Authorizable getAuthorizable(Connectable connectable) {
        switch (15.$SwitchMap$org$apache$nifi$connectable$ConnectableType[connectable.getConnectableType().ordinal()]) {
            case 1: 
            case 2: {
                String rpgId = ((RemoteGroupPort)connectable).getRemoteProcessGroup().getIdentifier();
                return this.authorizableLookup.getRemoteProcessGroup(rpgId);
            }
        }
        return this.authorizableLookup.getLocalConnectable(connectable.getIdentifier());
    }

    private Authorizable getAuthorizable(String componentTypeName, InstantiatedVersionedComponent versionedComponent) {
        String componentId = versionedComponent.getInstanceId();
        if (componentTypeName.equals(ComponentType.CONTROLLER_SERVICE.name())) {
            return this.authorizableLookup.getControllerService(componentId).getAuthorizable();
        }
        if (componentTypeName.equals(ComponentType.CONNECTION.name())) {
            return this.authorizableLookup.getConnection(componentId).getAuthorizable();
        }
        if (componentTypeName.equals(ComponentType.FUNNEL.name())) {
            return this.authorizableLookup.getFunnel(componentId);
        }
        if (componentTypeName.equals(ComponentType.INPUT_PORT.name())) {
            return this.authorizableLookup.getInputPort(componentId);
        }
        if (componentTypeName.equals(ComponentType.OUTPUT_PORT.name())) {
            return this.authorizableLookup.getOutputPort(componentId);
        }
        if (componentTypeName.equals(ComponentType.LABEL.name())) {
            return this.authorizableLookup.getLabel(componentId);
        }
        if (componentTypeName.equals(ComponentType.PROCESS_GROUP.name())) {
            return this.authorizableLookup.getProcessGroup(componentId).getAuthorizable();
        }
        if (componentTypeName.equals(ComponentType.PROCESSOR.name())) {
            return this.authorizableLookup.getProcessor(componentId).getAuthorizable();
        }
        if (componentTypeName.equals(ComponentType.REMOTE_INPUT_PORT.name())) {
            return this.authorizableLookup.getRemoteProcessGroup(versionedComponent.getInstanceGroupId());
        }
        if (componentTypeName.equals(ComponentType.REMOTE_OUTPUT_PORT.name())) {
            return this.authorizableLookup.getRemoteProcessGroup(versionedComponent.getInstanceGroupId());
        }
        if (componentTypeName.equals(ComponentType.REMOTE_PROCESS_GROUP.name())) {
            return this.authorizableLookup.getRemoteProcessGroup(componentId);
        }
        return null;
    }

    public String getFlowRegistryName(String flowRegistryId) {
        FlowRegistry flowRegistry = this.flowRegistryClient.getFlowRegistry(flowRegistryId);
        return flowRegistry == null ? flowRegistryId : flowRegistry.getName();
    }

    private List<Revision> getComponentRevisions(ProcessGroup processGroup, boolean includeGroupRevision) {
        ArrayList<Revision> revisions = new ArrayList<Revision>();
        if (includeGroupRevision) {
            revisions.add(this.revisionManager.getRevision(processGroup.getIdentifier()));
        }
        processGroup.findAllConnections().stream().map(component -> this.revisionManager.getRevision(component.getIdentifier())).forEach(revisions::add);
        processGroup.findAllControllerServices().stream().map(component -> this.revisionManager.getRevision(component.getIdentifier())).forEach(revisions::add);
        processGroup.findAllFunnels().stream().map(component -> this.revisionManager.getRevision(component.getIdentifier())).forEach(revisions::add);
        processGroup.findAllInputPorts().stream().map(component -> this.revisionManager.getRevision(component.getIdentifier())).forEach(revisions::add);
        processGroup.findAllOutputPorts().stream().map(component -> this.revisionManager.getRevision(component.getIdentifier())).forEach(revisions::add);
        processGroup.findAllLabels().stream().map(component -> this.revisionManager.getRevision(component.getIdentifier())).forEach(revisions::add);
        processGroup.findAllProcessGroups().stream().map(component -> this.revisionManager.getRevision(component.getIdentifier())).forEach(revisions::add);
        processGroup.findAllProcessors().stream().map(component -> this.revisionManager.getRevision(component.getIdentifier())).forEach(revisions::add);
        processGroup.findAllRemoteProcessGroups().stream().map(component -> this.revisionManager.getRevision(component.getIdentifier())).forEach(revisions::add);
        processGroup.findAllRemoteProcessGroups().stream().flatMap(rpg -> Stream.concat(rpg.getInputPorts().stream(), rpg.getOutputPorts().stream())).map(component -> this.revisionManager.getRevision(component.getIdentifier())).forEach(revisions::add);
        return revisions;
    }

    public ProcessGroupEntity updateProcessGroupContents(Revision revision, String groupId, VersionControlInformationDTO versionControlInfo, VersionedFlowSnapshot proposedFlowSnapshot, String componentIdSeed, boolean verifyNotModified, boolean updateSettings, boolean updateDescendantVersionedFlows) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(groupId);
        List revisions = this.getComponentRevisions(processGroup, false);
        revisions.add(revision);
        StandardRevisionClaim revisionClaim = new StandardRevisionClaim((Collection)revisions);
        RevisionUpdate revisionUpdate = this.revisionManager.updateRevision((RevisionClaim)revisionClaim, user, (UpdateRevisionTask)new /* Unavailable Anonymous Inner Class!! */);
        FlowModification lastModification = revisionUpdate.getLastModification();
        PermissionsDTO permissions = this.dtoFactory.createPermissionsDto((Authorizable)processGroup);
        RevisionDTO updatedRevision = this.dtoFactory.createRevisionDTO(lastModification);
        ProcessGroupStatusDTO status = this.dtoFactory.createConciseProcessGroupStatusDto(this.controllerFacade.getProcessGroupStatus(processGroup.getIdentifier()));
        List bulletins = this.dtoFactory.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(processGroup.getIdentifier()));
        List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
        return this.entityFactory.createProcessGroupEntity((ProcessGroupDTO)revisionUpdate.getComponent(), updatedRevision, permissions, status, bulletinEntities);
    }

    private AuthorizationResult authorizeAction(Action action) {
        ControllerFacade authorizable;
        String sourceId = action.getSourceId();
        Component type = action.getSourceType();
        try {
            switch (15.$SwitchMap$org$apache$nifi$action$Component[type.ordinal()]) {
                case 1: {
                    authorizable = this.authorizableLookup.getProcessor(sourceId).getAuthorizable();
                    break;
                }
                case 2: {
                    authorizable = this.authorizableLookup.getReportingTask(sourceId).getAuthorizable();
                    break;
                }
                case 3: {
                    authorizable = this.authorizableLookup.getControllerService(sourceId).getAuthorizable();
                    break;
                }
                case 4: {
                    authorizable = this.controllerFacade;
                    break;
                }
                case 5: {
                    authorizable = this.authorizableLookup.getInputPort(sourceId);
                    break;
                }
                case 6: {
                    authorizable = this.authorizableLookup.getOutputPort(sourceId);
                    break;
                }
                case 7: {
                    authorizable = this.authorizableLookup.getProcessGroup(sourceId).getAuthorizable();
                    break;
                }
                case 8: {
                    authorizable = this.authorizableLookup.getRemoteProcessGroup(sourceId);
                    break;
                }
                case 9: {
                    authorizable = this.authorizableLookup.getFunnel(sourceId);
                    break;
                }
                case 10: {
                    authorizable = this.authorizableLookup.getConnection(sourceId).getAuthorizable();
                    break;
                }
                case 11: {
                    authorizable = this.authorizableLookup.getParameterContext(sourceId);
                    break;
                }
                case 12: {
                    authorizable = this.authorizableLookup.getAccessPolicyById(sourceId);
                    break;
                }
                case 13: 
                case 14: {
                    authorizable = this.authorizableLookup.getTenant();
                    break;
                }
                default: {
                    throw new WebApplicationException(Response.serverError().entity((Object)"An unexpected type of component is the source of this action.").build());
                }
            }
        }
        catch (ResourceNotFoundException e) {
            authorizable = this.controllerFacade;
        }
        return authorizable.checkAuthorization(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
    }

    public HistoryDTO getActions(HistoryQueryDTO historyQueryDto) {
        HistoryQuery historyQuery = new HistoryQuery();
        historyQuery.setStartDate(historyQueryDto.getStartDate());
        historyQuery.setEndDate(historyQueryDto.getEndDate());
        historyQuery.setSourceId(historyQueryDto.getSourceId());
        historyQuery.setUserIdentity(historyQueryDto.getUserIdentity());
        historyQuery.setOffset(historyQueryDto.getOffset());
        historyQuery.setCount(historyQueryDto.getCount());
        historyQuery.setSortColumn(historyQueryDto.getSortColumn());
        historyQuery.setSortOrder(historyQueryDto.getSortOrder());
        History history = this.auditService.getActions(historyQuery);
        HistoryDTO historyDto = this.dtoFactory.createHistoryDto(history);
        if (history.getActions() != null) {
            ArrayList<ActionEntity> actionEntities = new ArrayList<ActionEntity>();
            for (Action action : history.getActions()) {
                AuthorizationResult result = this.authorizeAction(action);
                actionEntities.add(this.entityFactory.createActionEntity(this.dtoFactory.createActionDto(action), AuthorizationResult.Result.Approved.equals((Object)result.getResult())));
            }
            historyDto.setActions(actionEntities);
        }
        return historyDto;
    }

    public ActionEntity getAction(Integer actionId) {
        Action action = this.auditService.getAction(actionId);
        if (action == null) {
            throw new ResourceNotFoundException(String.format("Unable to find action with id '%s'.", actionId));
        }
        AuthorizationResult result = this.authorizeAction(action);
        boolean authorized = AuthorizationResult.Result.Approved.equals((Object)result.getResult());
        if (!authorized) {
            throw new AccessDeniedException(result.getExplanation());
        }
        return this.entityFactory.createActionEntity(this.dtoFactory.createActionDto(action), authorized);
    }

    public ComponentHistoryDTO getComponentHistory(String componentId) {
        LinkedHashMap propertyHistoryDtos = new LinkedHashMap();
        Map propertyHistory = this.auditService.getPreviousValues(componentId);
        for (Map.Entry entry : propertyHistory.entrySet()) {
            ArrayList<PreviousValueDTO> previousValueDtos = new ArrayList<PreviousValueDTO>();
            for (PreviousValue previousValue : (List)entry.getValue()) {
                PreviousValueDTO dto = new PreviousValueDTO();
                dto.setPreviousValue(previousValue.getPreviousValue());
                dto.setTimestamp(previousValue.getTimestamp());
                dto.setUserIdentity(previousValue.getUserIdentity());
                previousValueDtos.add(dto);
            }
            if (previousValueDtos.isEmpty()) continue;
            PropertyHistoryDTO propertyHistoryDto = new PropertyHistoryDTO();
            propertyHistoryDto.setPreviousValues(previousValueDtos);
            propertyHistoryDtos.put(entry.getKey(), propertyHistoryDto);
        }
        ComponentHistoryDTO history = new ComponentHistoryDTO();
        history.setComponentId(componentId);
        history.setPropertyHistory(propertyHistoryDtos);
        return history;
    }

    public ProcessorDiagnosticsEntity getProcessorDiagnostics(String id) {
        boolean bl;
        boolean canReadSystem;
        ProcessorNode processor = this.processorDAO.getProcessor(id);
        ProcessorStatus processorStatus = this.controllerFacade.getProcessorStatus(id);
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        ProcessorDiagnosticsDTO dto = this.controllerFacade.getProcessorDiagnostics(processor, processorStatus, this.bulletinRepository, serviceId -> {
            ControllerServiceNode serviceNode = this.controllerServiceDAO.getControllerService(serviceId);
            return this.createControllerServiceEntity(serviceNode, Collections.emptySet());
        });
        ArrayList<JVMDiagnosticsSnapshotDTO> jvmDiagnosticsSnaphots = new ArrayList<JVMDiagnosticsSnapshotDTO>();
        JVMDiagnosticsDTO jvmDiagnostics = dto.getJvmDiagnostics();
        jvmDiagnosticsSnaphots.add(jvmDiagnostics.getAggregateSnapshot());
        boolean canReadController = this.authorizableLookup.getController().isAuthorized(this.authorizer, RequestAction.READ, user);
        if (!canReadController) {
            for (JVMDiagnosticsSnapshotDTO jVMDiagnosticsSnapshotDTO : jvmDiagnosticsSnaphots) {
                jVMDiagnosticsSnapshotDTO.setControllerDiagnostics(null);
            }
        }
        if (!(canReadSystem = this.authorizableLookup.getSystem().isAuthorized(this.authorizer, RequestAction.READ, user))) {
            for (JVMDiagnosticsSnapshotDTO jVMDiagnosticsSnapshotDTO : jvmDiagnosticsSnaphots) {
                jVMDiagnosticsSnapshotDTO.setSystemDiagnosticsDto(null);
            }
        }
        if (!(bl = this.authorizableLookup.getFlow().isAuthorized(this.authorizer, RequestAction.READ, user))) {
            for (JVMDiagnosticsSnapshotDTO snapshot : jvmDiagnosticsSnaphots) {
                snapshot.setFlowDiagnosticsDto(null);
            }
        }
        Predicate<ConnectionDiagnosticsDTO> predicate = connectionDiagnostics -> {
            String connectionId = connectionDiagnostics.getConnection().getId();
            return this.authorizableLookup.getConnection(connectionId).getAuthorizable().isAuthorized(this.authorizer, RequestAction.READ, user);
        };
        Set incoming = dto.getIncomingConnections();
        Set filteredIncoming = incoming.stream().filter(predicate).collect(Collectors.toSet());
        dto.setIncomingConnections(filteredIncoming);
        Set outgoing = dto.getOutgoingConnections();
        Set filteredOutgoing = outgoing.stream().filter(predicate).collect(Collectors.toSet());
        dto.setOutgoingConnections(filteredOutgoing);
        Set referencedServices = dto.getReferencedControllerServices();
        Set filteredReferencedServices = referencedServices.stream().filter(csDiagnostics -> {
            String csId = csDiagnostics.getControllerService().getId();
            return this.authorizableLookup.getControllerService(csId).getAuthorizable().isAuthorized(this.authorizer, RequestAction.READ, user);
        }).map(csDiagnostics -> {
            ControllerServiceDTO serviceDto = csDiagnostics.getControllerService().getComponent();
            if (serviceDto != null) {
                serviceDto.setReferencingComponents(null);
            }
            return csDiagnostics;
        }).collect(Collectors.toSet());
        dto.setReferencedControllerServices(filteredReferencedServices);
        Revision revision = this.revisionManager.getRevision(id);
        RevisionDTO revisionDto = this.dtoFactory.createRevisionDTO(revision);
        PermissionsDTO permissionsDto = this.dtoFactory.createPermissionsDto((Authorizable)processor);
        List bulletins = this.bulletinRepository.findBulletinsForSource(id).stream().map(bulletin -> this.dtoFactory.createBulletinDto(bulletin)).map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissionsDto.getCanRead().booleanValue())).collect(Collectors.toList());
        ProcessorStatusDTO processorStatusDto = this.dtoFactory.createProcessorStatusDto(this.controllerFacade.getProcessorStatus(processor.getIdentifier()));
        return this.entityFactory.createProcessorDiagnosticsEntity(dto, revisionDto, permissionsDto, processorStatusDto, bulletins);
    }

    public Collection<CollectorRegistry> generateFlowMetrics() {
        String instanceId = StringUtils.isEmpty((String)this.controllerFacade.getInstanceId()) ? "" : this.controllerFacade.getInstanceId();
        ProcessGroupStatus rootPGStatus = this.controllerFacade.getProcessGroupStatus("root");
        PrometheusMetricsUtil.createNifiMetrics((NiFiMetricsRegistry)this.nifiMetricsRegistry, (ProcessGroupStatus)rootPGStatus, (String)instanceId, (String)"", (String)"RootProcessGroup", (String)PrometheusMetricsUtil.METRICS_STRATEGY_COMPONENTS.getValue());
        FlowFileEventRepository flowFileEventRepository = this.controllerFacade.getFlowFileEventRepository();
        String rootPGId = StringUtils.isEmpty((String)rootPGStatus.getId()) ? "" : rootPGStatus.getId();
        String rootPGName = StringUtils.isEmpty((String)rootPGStatus.getName()) ? "" : rootPGStatus.getName();
        FlowFileEvent aggregateEvent = flowFileEventRepository.reportAggregateEvent();
        this.nifiMetricsRegistry.setDataPoint((double)aggregateEvent.getBytesRead(), "TOTAL_BYTES_READ", new String[]{instanceId, "RootProcessGroup", rootPGName, rootPGId, ""});
        this.nifiMetricsRegistry.setDataPoint((double)aggregateEvent.getBytesWritten(), "TOTAL_BYTES_WRITTEN", new String[]{instanceId, "RootProcessGroup", rootPGName, rootPGId, ""});
        this.nifiMetricsRegistry.setDataPoint((double)aggregateEvent.getBytesSent(), "TOTAL_BYTES_SENT", new String[]{instanceId, "RootProcessGroup", rootPGName, rootPGId, ""});
        this.nifiMetricsRegistry.setDataPoint((double)aggregateEvent.getBytesReceived(), "TOTAL_BYTES_RECEIVED", new String[]{instanceId, "RootProcessGroup", rootPGName, rootPGId, ""});
        PrometheusMetricsUtil.createJvmMetrics((JvmMetricsRegistry)this.jvmMetricsRegistry, (JvmMetrics)JmxJvmMetrics.getInstance(), (String)instanceId);
        Set connections = this.controllerFacade.getFlowManager().findAllConnections();
        for (Connection c : connections) {
            try {
                PrometheusMetricsUtil.createConnectionStatusAnalyticsMetrics((ConnectionAnalyticsMetricsRegistry)this.connectionAnalyticsMetricsRegistry, (StatusAnalytics)this.controllerFacade.getConnectionStatusAnalytics(c.getIdentifier()), (String)instanceId, (String)"Connection", (String)c.getName(), (String)c.getIdentifier(), (String)c.getProcessGroup().getIdentifier(), (String)c.getSource().getName(), (String)c.getSource().getIdentifier(), (String)c.getDestination().getName(), (String)c.getDestination().getIdentifier());
            }
            catch (ResourceNotFoundException rnfe) {
                break;
            }
        }
        BulletinQueryDTO query = new BulletinQueryDTO();
        BulletinBoardDTO bulletinBoardDTO = this.getBulletinBoard(query);
        for (BulletinEntity bulletinEntity : bulletinBoardDTO.getBulletins()) {
            BulletinDTO bulletin = bulletinEntity.getBulletin();
            if (bulletin == null) continue;
            PrometheusMetricsUtil.createBulletinMetrics((BulletinMetricsRegistry)this.bulletinMetricsRegistry, (String)instanceId, (String)"Bulletin", (String)String.valueOf(bulletin.getId()), (String)(bulletin.getGroupId() == null ? "" : bulletin.getGroupId()), (String)(bulletin.getNodeAddress() == null ? "" : bulletin.getNodeAddress()), (String)bulletin.getCategory(), (String)bulletin.getSourceName(), (String)bulletin.getSourceId(), (String)bulletin.getLevel());
        }
        return this.ALL_REGISTRIES;
    }

    public boolean isClustered() {
        return this.controllerFacade.isClustered();
    }

    public String getNodeId() {
        NodeIdentifier nodeId = this.controllerFacade.getNodeId();
        if (nodeId != null) {
            return nodeId.getId();
        }
        return null;
    }

    public ClusterDTO getCluster() {
        ClusterDTO clusterDto = new ClusterDTO();
        clusterDto.setGenerated(new Date());
        List nodeDtos = this.clusterCoordinator.getNodeIdentifiers(new NodeConnectionState[0]).stream().map(nodeId -> this.getNode(nodeId)).collect(Collectors.toList());
        clusterDto.setNodes(nodeDtos);
        return clusterDto;
    }

    public NodeDTO getNode(String nodeId) {
        NodeIdentifier nodeIdentifier = this.clusterCoordinator.getNodeIdentifier(nodeId);
        return this.getNode(nodeIdentifier);
    }

    private NodeDTO getNode(NodeIdentifier nodeId) {
        NodeConnectionStatus nodeStatus = this.clusterCoordinator.getConnectionStatus(nodeId);
        List events = this.clusterCoordinator.getNodeEvents(nodeId);
        Set roles = this.getRoles(nodeId);
        NodeHeartbeat heartbeat = this.heartbeatMonitor.getLatestHeartbeat(nodeId);
        return this.dtoFactory.createNodeDTO(nodeId, nodeStatus, heartbeat, events, roles);
    }

    private Set<String> getRoles(NodeIdentifier nodeId) {
        HashSet<String> roles = new HashSet<String>();
        String nodeAddress = nodeId.getSocketAddress() + ":" + nodeId.getSocketPort();
        for (String roleName : ClusterRoles.getAllRoles()) {
            String leader = this.leaderElectionManager.getLeader(roleName);
            if (leader == null || !leader.equals(nodeAddress)) continue;
            roles.add(roleName);
        }
        return roles;
    }

    public void deleteNode(String nodeId) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user == null) {
            throw new WebApplicationException(new Throwable("Unable to access details for current user."));
        }
        String userDn = user.getIdentity();
        NodeIdentifier nodeIdentifier = this.clusterCoordinator.getNodeIdentifier(nodeId);
        if (nodeIdentifier == null) {
            throw new UnknownNodeException("Cannot remove Node with ID " + nodeId + " because it is not part of the cluster");
        }
        NodeConnectionStatus nodeConnectionStatus = this.clusterCoordinator.getConnectionStatus(nodeIdentifier);
        if (!nodeConnectionStatus.getState().equals((Object)NodeConnectionState.OFFLOADED) && !nodeConnectionStatus.getState().equals((Object)NodeConnectionState.DISCONNECTED)) {
            throw new IllegalNodeDeletionException("Cannot remove Node with ID " + nodeId + " because it is not disconnected or offloaded, current state = " + nodeConnectionStatus.getState());
        }
        this.clusterCoordinator.removeNode(nodeIdentifier, userDn);
        this.heartbeatMonitor.removeHeartbeat(nodeIdentifier);
    }

    private Function<String, TenantEntity> mapUserGroupIdToTenantEntity(boolean enforceGroupExistence) {
        return userGroupId -> {
            RevisionDTO userGroupRevision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(userGroupId));
            Group group = enforceGroupExistence || this.userGroupDAO.hasUserGroup(userGroupId) ? this.userGroupDAO.getUserGroup(userGroupId) : new Group.Builder().identifier(userGroupId).name("Group ID - " + userGroupId + " (removed externally)").build();
            return this.entityFactory.createTenantEntity(this.dtoFactory.createTenantDTO(group), userGroupRevision, this.dtoFactory.createPermissionsDto(this.authorizableLookup.getTenant()));
        };
    }

    private Function<String, TenantEntity> mapUserIdToTenantEntity(boolean enforceUserExistence) {
        return userId -> {
            RevisionDTO userRevision = this.dtoFactory.createRevisionDTO(this.revisionManager.getRevision(userId));
            User user = enforceUserExistence || this.userDAO.hasUser(userId) ? this.userDAO.getUser(userId) : new User.Builder().identifier(userId).identity("User ID - " + userId + " (removed externally)").build();
            return this.entityFactory.createTenantEntity(this.dtoFactory.createTenantDTO(user), userRevision, this.dtoFactory.createPermissionsDto(this.authorizableLookup.getTenant()));
        };
    }

    public void verifyPublicInputPortUniqueness(String portId, String portName) {
        this.inputPortDAO.verifyPublicPortUniqueness(portId, portName);
    }

    public void verifyPublicOutputPortUniqueness(String portId, String portName) {
        this.outputPortDAO.verifyPublicPortUniqueness(portId, portName);
    }

    protected NiFiRegistryFlowMapper makeNiFiRegistryFlowMapper(ExtensionManager extensionManager) {
        return new NiFiRegistryFlowMapper(extensionManager);
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public void setControllerFacade(ControllerFacade controllerFacade) {
        this.controllerFacade = controllerFacade;
    }

    public void setRemoteProcessGroupDAO(RemoteProcessGroupDAO remoteProcessGroupDAO) {
        this.remoteProcessGroupDAO = remoteProcessGroupDAO;
    }

    public void setLabelDAO(LabelDAO labelDAO) {
        this.labelDAO = labelDAO;
    }

    public void setFunnelDAO(FunnelDAO funnelDAO) {
        this.funnelDAO = funnelDAO;
    }

    public void setSnippetDAO(SnippetDAO snippetDAO) {
        this.snippetDAO = snippetDAO;
    }

    public void setProcessorDAO(ProcessorDAO processorDAO) {
        this.processorDAO = processorDAO;
    }

    public void setConnectionDAO(ConnectionDAO connectionDAO) {
        this.connectionDAO = connectionDAO;
    }

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    public void setRevisionManager(RevisionManager revisionManager) {
        this.revisionManager = revisionManager;
    }

    public void setDtoFactory(DtoFactory dtoFactory) {
        this.dtoFactory = dtoFactory;
    }

    public void setEntityFactory(EntityFactory entityFactory) {
        this.entityFactory = entityFactory;
    }

    public void setInputPortDAO(PortDAO inputPortDAO) {
        this.inputPortDAO = inputPortDAO;
    }

    public void setOutputPortDAO(PortDAO outputPortDAO) {
        this.outputPortDAO = outputPortDAO;
    }

    public void setProcessGroupDAO(ProcessGroupDAO processGroupDAO) {
        this.processGroupDAO = processGroupDAO;
    }

    public void setControllerServiceDAO(ControllerServiceDAO controllerServiceDAO) {
        this.controllerServiceDAO = controllerServiceDAO;
    }

    public void setReportingTaskDAO(ReportingTaskDAO reportingTaskDAO) {
        this.reportingTaskDAO = reportingTaskDAO;
    }

    public void setParameterContextDAO(ParameterContextDAO parameterContextDAO) {
        this.parameterContextDAO = parameterContextDAO;
    }

    public void setTemplateDAO(TemplateDAO templateDAO) {
        this.templateDAO = templateDAO;
    }

    public void setSnippetUtils(SnippetUtils snippetUtils) {
        this.snippetUtils = snippetUtils;
    }

    public void setAuthorizableLookup(AuthorizableLookup authorizableLookup) {
        this.authorizableLookup = authorizableLookup;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }

    public void setUserGroupDAO(UserGroupDAO userGroupDAO) {
        this.userGroupDAO = userGroupDAO;
    }

    public void setAccessPolicyDAO(AccessPolicyDAO accessPolicyDAO) {
        this.accessPolicyDAO = accessPolicyDAO;
    }

    public void setClusterCoordinator(ClusterCoordinator coordinator) {
        this.clusterCoordinator = coordinator;
    }

    public void setHeartbeatMonitor(HeartbeatMonitor heartbeatMonitor) {
        this.heartbeatMonitor = heartbeatMonitor;
    }

    public void setBulletinRepository(BulletinRepository bulletinRepository) {
        this.bulletinRepository = bulletinRepository;
    }

    public void setLeaderElectionManager(LeaderElectionManager leaderElectionManager) {
        this.leaderElectionManager = leaderElectionManager;
    }

    public void setRegistryDAO(RegistryDAO registryDao) {
        this.registryDAO = registryDao;
    }

    public void setFlowRegistryClient(FlowRegistryClient flowRegistryClient) {
        this.flowRegistryClient = flowRegistryClient;
    }

    private static /* synthetic */ boolean lambda$getComponentsAffectedByFlowUpdate$207(ComparableDataFlow proposedFlow, FlowManager flowManager, FlowDifference diff) {
        return !FlowDifferenceFilters.isNewRelationshipAutoTerminatedAndDefaulted((FlowDifference)diff, (VersionedProcessGroup)proposedFlow.getContents(), (FlowManager)flowManager);
    }

    static /* synthetic */ ControllerFacade access$000(StandardNiFiServiceFacade x0) {
        return x0.controllerFacade;
    }

    static /* synthetic */ RevisionManager access$100(StandardNiFiServiceFacade x0) {
        return x0.revisionManager;
    }

    static /* synthetic */ SnippetDAO access$200(StandardNiFiServiceFacade x0) {
        return x0.snippetDAO;
    }

    static /* synthetic */ DtoFactory access$300(StandardNiFiServiceFacade x0) {
        return x0.dtoFactory;
    }

    static /* synthetic */ ProcessGroupDAO access$400(StandardNiFiServiceFacade x0) {
        return x0.processGroupDAO;
    }

    static /* synthetic */ Logger access$500() {
        return logger;
    }

    static /* synthetic */ void access$600(StandardNiFiServiceFacade x0, Resource x1) {
        x0.cleanUpPolicies(x1);
    }

    static /* synthetic */ ControllerServiceDAO access$700(StandardNiFiServiceFacade x0) {
        return x0.controllerServiceDAO;
    }

    static /* synthetic */ ControllerServiceReferencingComponentsEntity access$800(StandardNiFiServiceFacade x0, ControllerServiceReference x1, Map x2) {
        return x0.createControllerServiceReferencingComponentsEntity(x1, x2);
    }
}

