/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web;

import java.util.Arrays;
import javax.servlet.Filter;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.CsrfCookieRequestMatcher;
import org.apache.nifi.web.NiFiCsrfTokenRepository;
import org.apache.nifi.web.security.anonymous.NiFiAnonymousAuthenticationFilter;
import org.apache.nifi.web.security.anonymous.NiFiAnonymousAuthenticationProvider;
import org.apache.nifi.web.security.jwt.JwtAuthenticationFilter;
import org.apache.nifi.web.security.jwt.JwtAuthenticationProvider;
import org.apache.nifi.web.security.knox.KnoxAuthenticationFilter;
import org.apache.nifi.web.security.knox.KnoxAuthenticationProvider;
import org.apache.nifi.web.security.otp.OtpAuthenticationFilter;
import org.apache.nifi.web.security.otp.OtpAuthenticationProvider;
import org.apache.nifi.web.security.x509.X509AuthenticationFilter;
import org.apache.nifi.web.security.x509.X509AuthenticationProvider;
import org.apache.nifi.web.security.x509.X509CertificateExtractor;
import org.apache.nifi.web.security.x509.X509IdentityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.preauth.x509.X509PrincipalExtractor;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class NiFiWebApiSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(NiFiWebApiSecurityConfiguration.class);
    private NiFiProperties properties;
    private X509AuthenticationFilter x509AuthenticationFilter;
    private X509CertificateExtractor certificateExtractor;
    private X509PrincipalExtractor principalExtractor;
    private X509IdentityProvider certificateIdentityProvider;
    private X509AuthenticationProvider x509AuthenticationProvider;
    private JwtAuthenticationFilter jwtAuthenticationFilter;
    private JwtAuthenticationProvider jwtAuthenticationProvider;
    private OtpAuthenticationFilter otpAuthenticationFilter;
    private OtpAuthenticationProvider otpAuthenticationProvider;
    private KnoxAuthenticationFilter knoxAuthenticationFilter;
    private KnoxAuthenticationProvider knoxAuthenticationProvider;
    private NiFiAnonymousAuthenticationFilter anonymousAuthenticationFilter;
    private NiFiAnonymousAuthenticationProvider anonymousAuthenticationProvider;

    public NiFiWebApiSecurityConfiguration() {
        super(true);
    }

    public void configure(WebSecurity webSecurity) throws Exception {
        webSecurity.ignoring().antMatchers(new String[]{"/access", "/access/config", "/access/token", "/access/kerberos", "/access/oidc/exchange", "/access/oidc/request", "/access/oidc/callback", "/access/oidc/logoutCallback", "/access/knox/callback", "/access/knox/request", "/access/saml/metadata", "/access/samllogin/request", "/access/saml/login/consumer", "/access/saml/login/exchange", "/access/saml/single-logout/request", "/access/saml/single-logout/consumer", "/access/saml/local-logout", "/access/logout/complete"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        NiFiCsrfTokenRepository csrfRepository = new NiFiCsrfTokenRepository();
        csrfRepository.setHeaderName("Authorization");
        csrfRepository.setCookieName("__Host-Authorization-Bearer");
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.cors().and()).rememberMe().disable()).authorizeRequests().anyRequest()).fullyAuthenticated().and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).csrf().requireCsrfProtectionMatcher((RequestMatcher)new AndRequestMatcher(new RequestMatcher[]{CsrfFilter.DEFAULT_CSRF_MATCHER, new CsrfCookieRequestMatcher()})).csrfTokenRepository((CsrfTokenRepository)csrfRepository);
        http.addFilterBefore((Filter)this.x509FilterBean(), AnonymousAuthenticationFilter.class);
        http.addFilterBefore((Filter)this.jwtFilterBean(), AnonymousAuthenticationFilter.class);
        http.addFilterBefore((Filter)this.otpFilterBean(), AnonymousAuthenticationFilter.class);
        http.addFilterBefore((Filter)this.knoxFilterBean(), AnonymousAuthenticationFilter.class);
        http.addFilterAfter((Filter)this.anonymousFilterBean(), AnonymousAuthenticationFilter.class);
        http.anonymous().disable();
    }

    @Bean
    CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedMethods(Arrays.asList("HEAD", "GET"));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/process-groups/*/templates/upload", configuration);
        return source;
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider((AuthenticationProvider)this.x509AuthenticationProvider).authenticationProvider((AuthenticationProvider)this.jwtAuthenticationProvider).authenticationProvider((AuthenticationProvider)this.otpAuthenticationProvider).authenticationProvider((AuthenticationProvider)this.knoxAuthenticationProvider).authenticationProvider((AuthenticationProvider)this.anonymousAuthenticationProvider);
    }

    @Bean
    public JwtAuthenticationFilter jwtFilterBean() throws Exception {
        if (this.jwtAuthenticationFilter == null) {
            this.jwtAuthenticationFilter = new JwtAuthenticationFilter();
            this.jwtAuthenticationFilter.setProperties(this.properties);
            this.jwtAuthenticationFilter.setAuthenticationManager(this.authenticationManager());
        }
        return this.jwtAuthenticationFilter;
    }

    @Bean
    public OtpAuthenticationFilter otpFilterBean() throws Exception {
        if (this.otpAuthenticationFilter == null) {
            this.otpAuthenticationFilter = new OtpAuthenticationFilter();
            this.otpAuthenticationFilter.setProperties(this.properties);
            this.otpAuthenticationFilter.setAuthenticationManager(this.authenticationManager());
        }
        return this.otpAuthenticationFilter;
    }

    @Bean
    public KnoxAuthenticationFilter knoxFilterBean() throws Exception {
        if (this.knoxAuthenticationFilter == null) {
            this.knoxAuthenticationFilter = new KnoxAuthenticationFilter();
            this.knoxAuthenticationFilter.setProperties(this.properties);
            this.knoxAuthenticationFilter.setAuthenticationManager(this.authenticationManager());
        }
        return this.knoxAuthenticationFilter;
    }

    @Bean
    public X509AuthenticationFilter x509FilterBean() throws Exception {
        if (this.x509AuthenticationFilter == null) {
            this.x509AuthenticationFilter = new X509AuthenticationFilter();
            this.x509AuthenticationFilter.setProperties(this.properties);
            this.x509AuthenticationFilter.setCertificateExtractor(this.certificateExtractor);
            this.x509AuthenticationFilter.setPrincipalExtractor(this.principalExtractor);
            this.x509AuthenticationFilter.setAuthenticationManager(this.authenticationManager());
        }
        return this.x509AuthenticationFilter;
    }

    @Bean
    public NiFiAnonymousAuthenticationFilter anonymousFilterBean() throws Exception {
        if (this.anonymousAuthenticationFilter == null) {
            this.anonymousAuthenticationFilter = new NiFiAnonymousAuthenticationFilter();
            this.anonymousAuthenticationFilter.setProperties(this.properties);
            this.anonymousAuthenticationFilter.setAuthenticationManager(this.authenticationManager());
        }
        return this.anonymousAuthenticationFilter;
    }

    @Autowired
    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    @Autowired
    public void setJwtAuthenticationProvider(JwtAuthenticationProvider jwtAuthenticationProvider) {
        this.jwtAuthenticationProvider = jwtAuthenticationProvider;
    }

    @Autowired
    public void setOtpAuthenticationProvider(OtpAuthenticationProvider otpAuthenticationProvider) {
        this.otpAuthenticationProvider = otpAuthenticationProvider;
    }

    @Autowired
    public void setKnoxAuthenticationProvider(KnoxAuthenticationProvider knoxAuthenticationProvider) {
        this.knoxAuthenticationProvider = knoxAuthenticationProvider;
    }

    @Autowired
    public void setAnonymousAuthenticationProvider(NiFiAnonymousAuthenticationProvider anonymousAuthenticationProvider) {
        this.anonymousAuthenticationProvider = anonymousAuthenticationProvider;
    }

    @Autowired
    public void setX509AuthenticationProvider(X509AuthenticationProvider x509AuthenticationProvider) {
        this.x509AuthenticationProvider = x509AuthenticationProvider;
    }

    @Autowired
    public void setCertificateExtractor(X509CertificateExtractor certificateExtractor) {
        this.certificateExtractor = certificateExtractor;
    }

    @Autowired
    public void setPrincipalExtractor(X509PrincipalExtractor principalExtractor) {
        this.principalExtractor = principalExtractor;
    }

    @Autowired
    public void setCertificateIdentityProvider(X509IdentityProvider certificateIdentityProvider) {
        this.certificateIdentityProvider = certificateIdentityProvider;
    }
}

