/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.DefaultCsrfToken;

public final class NiFiCsrfTokenRepository
implements CsrfTokenRepository {
    private static String EMPTY = "empty";
    private CookieCsrfTokenRepository cookieRepository = new CookieCsrfTokenRepository();

    public CsrfToken generateToken(HttpServletRequest request) {
        return new DefaultCsrfToken(EMPTY, EMPTY, EMPTY);
    }

    public void saveToken(CsrfToken token, HttpServletRequest request, HttpServletResponse response) {
    }

    public CsrfToken loadToken(HttpServletRequest request) {
        CsrfToken cookie = this.cookieRepository.loadToken(request);
        return cookie != null ? new DefaultCsrfToken(cookie.getHeaderName(), cookie.getParameterName(), String.format("Bearer %s", cookie.getToken())) : null;
    }

    public void setParameterName(String parameterName) {
        this.cookieRepository.setParameterName(parameterName);
    }

    public void setHeaderName(String headerName) {
        this.cookieRepository.setHeaderName(headerName);
    }

    public void setCookieName(String cookieName) {
        this.cookieRepository.setCookieName(cookieName);
    }
}

