/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.audit;

import java.io.StringReader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.Component;
import org.apache.nifi.action.FlowChangeAction;
import org.apache.nifi.action.Operation;
import org.apache.nifi.action.component.details.ComponentDetails;
import org.apache.nifi.action.component.details.FlowChangeExtensionDetails;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.action.details.FlowChangeConfigureDetails;
import org.apache.nifi.audit.NiFiAuditor;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.dao.ProcessorDAO;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Aspect
public class ProcessorAuditor
extends NiFiAuditor {
    private static final Logger logger = LoggerFactory.getLogger(ProcessorAuditor.class);
    private static final String COMMENTS = "Comments";
    private static final String PENALTY_DURATION = "Penalty Duration";
    private static final String YIELD_DURATION = "Yield Duration";
    private static final String CONCURRENTLY_SCHEDULABLE_TASKS = "Concurrent Tasks";
    private static final String NAME = "Name";
    private static final String BULLETIN_LEVEL = "Bulletin Level";
    private static final String ANNOTATION_DATA = "Annotation Data";
    private static final String AUTO_TERMINATED_RELATIONSHIPS = "Auto Terminated Relationships";
    private static final String SCHEDULING_PERIOD = "Run Schedule";
    private static final String SCHEDULING_STRATEGY = "Scheduling Strategy";
    private static final String EXECUTION_NODE = "Execution Node";
    private static final String EXTENSION_VERSION = "Extension Version";

    @Around(value="within(org.apache.nifi.web.dao.ProcessorDAO+) && execution(org.apache.nifi.controller.ProcessorNode createProcessor(java.lang.String, org.apache.nifi.web.api.dto.ProcessorDTO))")
    public ProcessorNode createProcessorAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        ProcessorNode processor = (ProcessorNode)proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(processor, Operation.Add);
        if (action != null) {
            this.saveAction(action, logger);
        }
        return processor;
    }

    @Around(value="within(org.apache.nifi.web.dao.ProcessorDAO+) && execution(org.apache.nifi.controller.ProcessorNode updateProcessor(org.apache.nifi.web.api.dto.ProcessorDTO)) && args(processorDTO) && target(processorDAO)")
    public ProcessorNode updateProcessorAdvice(ProceedingJoinPoint proceedingJoinPoint, ProcessorDTO processorDTO, ProcessorDAO processorDAO) throws Throwable {
        ProcessorNode processor = processorDAO.getProcessor(processorDTO.getId());
        Map values = this.extractConfiguredPropertyValues(processor, processorDTO);
        ScheduledState scheduledState = processor.getScheduledState();
        ProcessorNode updatedProcessor = (ProcessorNode)proceedingJoinPoint.proceed();
        processor = processorDAO.getProcessor(updatedProcessor.getIdentifier());
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            Map updatedValues = this.extractConfiguredPropertyValues(processor, processorDTO);
            FlowChangeExtensionDetails processorDetails = new FlowChangeExtensionDetails();
            processorDetails.setType(processor.getComponentType());
            Date actionTimestamp = new Date();
            ArrayList<FlowChangeAction> actions = new ArrayList<FlowChangeAction>();
            for (String property : updatedValues.keySet()) {
                String newValue = (String)updatedValues.get(property);
                String oldValue = (String)values.get(property);
                Operation operation = null;
                if (oldValue == null || newValue == null || !newValue.equals(oldValue)) {
                    operation = Operation.Configure;
                }
                if (operation == null) continue;
                PropertyDescriptor propertyDescriptor = processor.getProcessor().getPropertyDescriptor(property);
                if (propertyDescriptor != null && propertyDescriptor.isSensitive()) {
                    if (newValue != null) {
                        newValue = "********";
                    }
                    if (oldValue != null) {
                        oldValue = "********";
                    }
                } else if (ANNOTATION_DATA.equals(property) && newValue != null && oldValue != null) {
                    try {
                        InputSource is = new InputSource();
                        is.setCharacterStream(new StringReader(newValue));
                        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                        Document doc = dBuilder.parse(is);
                        NodeList nList = doc.getChildNodes();
                        HashMap<String, Node> xmlDumpNew = new HashMap<String, Node>();
                        this.getItemPaths(nList, "" + doc.getNodeName(), xmlDumpNew);
                        is.setCharacterStream(new StringReader(oldValue));
                        doc = dBuilder.parse(is);
                        nList = doc.getChildNodes();
                        HashMap<String, Node> xmlDumpOld = new HashMap<String, Node>();
                        this.getItemPaths(nList, "" + doc.getNodeName(), xmlDumpOld);
                        HashMap<String, Object> xmlDumpSame = new HashMap<String, Object>();
                        xmlDumpNew.forEach((k, v) -> {
                            if (xmlDumpOld.containsKey(k)) {
                                xmlDumpSame.put((String)k, v);
                            }
                        });
                        xmlDumpSame.forEach((k, v) -> {
                            xmlDumpNew.remove(k);
                            xmlDumpOld.remove(k);
                        });
                        AtomicReference<String> oldReference = new AtomicReference<String>("");
                        AtomicReference<String> newReference = new AtomicReference<String>("");
                        xmlDumpNew.forEach((k, v) -> newReference.set((String)newReference.get() + ":" + k + System.lineSeparator()));
                        xmlDumpOld.forEach((k, v) -> oldReference.set((String)oldReference.get() + ":" + k + System.lineSeparator()));
                        newValue = newReference.get();
                        oldValue = oldReference.get();
                    }
                    catch (Exception is) {
                        // empty catch block
                    }
                }
                FlowChangeConfigureDetails actionDetails = new FlowChangeConfigureDetails();
                actionDetails.setName(property);
                actionDetails.setValue(newValue);
                actionDetails.setPreviousValue(oldValue);
                FlowChangeAction configurationAction = new FlowChangeAction();
                configurationAction.setUserIdentity(user.getIdentity());
                configurationAction.setOperation(operation);
                configurationAction.setTimestamp(actionTimestamp);
                configurationAction.setSourceId(processor.getIdentifier());
                configurationAction.setSourceName(processor.getName());
                configurationAction.setSourceType(Component.Processor);
                configurationAction.setComponentDetails((ComponentDetails)processorDetails);
                configurationAction.setActionDetails((ActionDetails)actionDetails);
                actions.add(configurationAction);
            }
            ScheduledState updatedScheduledState = processor.getScheduledState();
            if (scheduledState != updatedScheduledState) {
                FlowChangeAction processorAction = new FlowChangeAction();
                processorAction.setUserIdentity(user.getIdentity());
                processorAction.setTimestamp(new Date());
                processorAction.setSourceId(processor.getIdentifier());
                processorAction.setSourceName(processor.getName());
                processorAction.setSourceType(Component.Processor);
                processorAction.setComponentDetails((ComponentDetails)processorDetails);
                if (ScheduledState.RUNNING.equals((Object)updatedScheduledState)) {
                    processorAction.setOperation(Operation.Start);
                } else if (ScheduledState.DISABLED.equals((Object)updatedScheduledState)) {
                    processorAction.setOperation(Operation.Disable);
                } else if (ScheduledState.RUNNING.equals((Object)scheduledState)) {
                    processorAction.setOperation(Operation.Stop);
                } else if (ScheduledState.DISABLED.equals((Object)scheduledState)) {
                    processorAction.setOperation(Operation.Enable);
                }
                actions.add(processorAction);
            }
            if (!actions.isEmpty()) {
                this.saveActions(actions, logger);
            }
        }
        return updatedProcessor;
    }

    @Around(value="within(org.apache.nifi.web.dao.ProcessorDAO+) && execution(void deleteProcessor(java.lang.String)) && args(processorId) && target(processorDAO)")
    public void removeProcessorAdvice(ProceedingJoinPoint proceedingJoinPoint, String processorId, ProcessorDAO processorDAO) throws Throwable {
        ProcessorNode processor = processorDAO.getProcessor(processorId);
        proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(processor, Operation.Remove);
        if (action != null) {
            this.saveAction(action, logger);
        }
    }

    public Action generateAuditRecord(ProcessorNode processor, Operation operation) {
        return this.generateAuditRecord(processor, operation, null);
    }

    public Action generateAuditRecord(ProcessorNode processor, Operation operation, ActionDetails actionDetails) {
        FlowChangeAction action = null;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            FlowChangeExtensionDetails processorDetails = new FlowChangeExtensionDetails();
            processorDetails.setType(processor.getComponentType());
            action = new FlowChangeAction();
            action.setUserIdentity(user.getIdentity());
            action.setOperation(operation);
            action.setTimestamp(new Date());
            action.setSourceId(processor.getIdentifier());
            action.setSourceName(processor.getName());
            action.setSourceType(Component.Processor);
            action.setComponentDetails((ComponentDetails)processorDetails);
            if (actionDetails != null) {
                action.setActionDetails(actionDetails);
            }
        }
        return action;
    }

    private Map<String, String> extractConfiguredPropertyValues(ProcessorNode processor, ProcessorDTO processorDTO) {
        HashMap<String, String> values = new HashMap<String, String>();
        if (processorDTO.getName() != null) {
            values.put(NAME, processor.getName());
        }
        if (processorDTO.getBundle() != null) {
            BundleCoordinate bundle = processor.getBundleCoordinate();
            values.put(EXTENSION_VERSION, this.formatExtensionVersion(processor.getComponentType(), bundle));
        }
        if (processorDTO.getConfig() != null) {
            ProcessorConfigDTO newConfig = processorDTO.getConfig();
            if (newConfig.getConcurrentlySchedulableTaskCount() != null) {
                values.put(CONCURRENTLY_SCHEDULABLE_TASKS, String.valueOf(processor.getMaxConcurrentTasks()));
            }
            if (newConfig.getPenaltyDuration() != null) {
                values.put(PENALTY_DURATION, processor.getPenalizationPeriod());
            }
            if (newConfig.getYieldDuration() != null) {
                values.put(YIELD_DURATION, processor.getYieldPeriod());
            }
            if (newConfig.getBulletinLevel() != null) {
                values.put(BULLETIN_LEVEL, processor.getBulletinLevel().name());
            }
            if (newConfig.getAnnotationData() != null) {
                values.put(ANNOTATION_DATA, processor.getAnnotationData());
            }
            if (newConfig.getSchedulingPeriod() != null) {
                values.put(SCHEDULING_PERIOD, String.valueOf(processor.getSchedulingPeriod()));
            }
            if (newConfig.getAutoTerminatedRelationships() != null) {
                Set autoTerminatedRelationships = processor.getAutoTerminatedRelationships();
                ArrayList<String> autoTerminatedRelationshipNames = new ArrayList<String>(autoTerminatedRelationships.size());
                for (Relationship relationship : autoTerminatedRelationships) {
                    autoTerminatedRelationshipNames.add(relationship.getName());
                }
                Collections.sort(autoTerminatedRelationshipNames, Collator.getInstance(Locale.US));
                values.put(AUTO_TERMINATED_RELATIONSHIPS, StringUtils.join(autoTerminatedRelationshipNames, (String)", "));
            }
            if (newConfig.getProperties() != null) {
                Map properties = newConfig.getProperties();
                Map configuredProperties = processor.getRawPropertyValues();
                for (String propertyName : properties.keySet()) {
                    PropertyDescriptor propertyDescriptor = new PropertyDescriptor.Builder().name(propertyName).build();
                    String configuredPropertyValue = (String)configuredProperties.get(propertyDescriptor);
                    if (configuredPropertyValue == null) {
                        propertyDescriptor = this.locatePropertyDescriptor(configuredProperties.keySet(), propertyDescriptor);
                        configuredPropertyValue = propertyDescriptor.getDefaultValue();
                    }
                    values.put(propertyName, configuredPropertyValue);
                }
            }
            if (newConfig.getComments() != null) {
                values.put(COMMENTS, processor.getComments());
            }
            if (newConfig.getSchedulingStrategy() != null) {
                values.put(SCHEDULING_STRATEGY, processor.getSchedulingStrategy().name());
            }
            if (newConfig.getExecutionNode() != null) {
                values.put(EXECUTION_NODE, processor.getExecutionNode().name());
            }
        }
        return values;
    }

    private PropertyDescriptor locatePropertyDescriptor(Set<PropertyDescriptor> propertyDescriptors, PropertyDescriptor specDescriptor) {
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (!propertyDescriptor.equals((Object)specDescriptor)) continue;
            return propertyDescriptor;
        }
        return specDescriptor;
    }

    private void getItemPaths(NodeList nl, String path, Map<String, Node> map) {
        if (nl != null) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (n == null || n.getNodeType() != 1 && n.getNodeType() != 3) continue;
                if (n.hasChildNodes() && n.getNodeType() == 1) {
                    this.getItemPaths(n.getChildNodes(), path + ":" + n.getNodeName(), map);
                }
                if (!n.hasChildNodes()) {
                    map.put(path + ":" + n.getNodeName().trim() + ":" + n.getNodeValue(), n);
                }
                if (!n.hasAttributes()) continue;
                NamedNodeMap na = n.getAttributes();
                for (int j = 0; j < na.getLength(); ++j) {
                    map.put(path + ":" + n.getNodeName() + ":" + na.item(j).getNodeName().trim() + ":" + na.item(j).getNodeValue(), n);
                }
            }
        }
    }
}

