/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.salesforce;

import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.FieldType;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.ws.ConnectionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.metamodel.salesforce.SalesforceUtils;
import org.apache.metamodel.schema.AbstractTable;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.Relationship;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.TableType;
import org.apache.metamodel.util.LazyRef;

final class SalesforceTable
extends AbstractTable {
    private static final long serialVersionUID = 1L;
    private final transient Supplier<List<Column>> _columnRef;
    private final transient PartnerConnection _connection;
    private final String _name;
    private final String _remarks;
    private final Schema _schema;

    public SalesforceTable(String name, String remarks, Schema schema, PartnerConnection connection) {
        this._name = name;
        this._remarks = remarks;
        this._schema = schema;
        this._connection = connection;
        this._columnRef = new LazyRef<List<Column>>(){

            protected List<Column> fetch() {
                DescribeSObjectResult describeSObject;
                ArrayList<Column> result = new ArrayList<Column>();
                try {
                    describeSObject = SalesforceTable.this._connection.describeSObject(SalesforceTable.this._name);
                }
                catch (ConnectionException e) {
                    throw SalesforceUtils.wrapException(e, "Failed to invoke describeSObject service");
                }
                Field[] fields = describeSObject.getFields();
                int i = 0;
                for (Field field : fields) {
                    String columnName = field.getName();
                    String columnLabel = field.getLabel();
                    Boolean nillable = field.isNillable();
                    FieldType type = field.getType();
                    Integer columnSize = field.getLength();
                    ColumnType columnType = SalesforceTable.toColumnType(type);
                    MutableColumn column = new MutableColumn(columnName, columnType);
                    column.setTable((Table)SalesforceTable.this);
                    column.setRemarks(columnLabel);
                    column.setNullable(nillable);
                    column.setNativeType(type.toString());
                    column.setColumnSize(columnSize);
                    column.setColumnNumber(i);
                    if (type == FieldType.id) {
                        column.setPrimaryKey(true);
                    }
                    ++i;
                    result.add((Column)column);
                }
                return result;
            }
        };
    }

    protected static ColumnType toColumnType(FieldType type) {
        switch (type) {
            case _boolean: {
                return ColumnType.BOOLEAN;
            }
            case _int: {
                return ColumnType.INTEGER;
            }
            case _double: 
            case currency: {
                return ColumnType.DOUBLE;
            }
            case date: {
                return ColumnType.DATE;
            }
            case datetime: {
                return ColumnType.TIMESTAMP;
            }
            case time: {
                return ColumnType.TIME;
            }
            case string: 
            case email: 
            case url: 
            case phone: 
            case reference: 
            case textarea: 
            case encryptedstring: 
            case base64: 
            case id: 
            case picklist: {
                return ColumnType.VARCHAR;
            }
        }
        return ColumnType.OTHER;
    }

    public String getName() {
        return this._name;
    }

    public List<Column> getColumns() {
        if (this._columnRef == null) {
            return new ArrayList<Column>();
        }
        List<Column> columns = this._columnRef.get();
        return Collections.unmodifiableList(columns);
    }

    public Schema getSchema() {
        return this._schema;
    }

    public TableType getType() {
        return TableType.TABLE;
    }

    public List<Relationship> getRelationships() {
        return new ArrayList<Relationship>();
    }

    public String getRemarks() {
        return this._remarks;
    }

    public String getQuote() {
        return null;
    }
}

