/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc.dialects;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.jdbc.dialects.AbstractQueryRewriter;
import org.apache.metamodel.query.AggregateFunction;
import org.apache.metamodel.query.AverageAggregateFunction;
import org.apache.metamodel.query.CountAggregateFunction;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.FromItem;
import org.apache.metamodel.query.FunctionType;
import org.apache.metamodel.query.MaxAggregateFunction;
import org.apache.metamodel.query.MinAggregateFunction;
import org.apache.metamodel.query.OperatorType;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.ScalarFunction;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.query.SumAggregateFunction;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultQueryRewriter
extends AbstractQueryRewriter {
    private static final Logger logger = LoggerFactory.getLogger(DefaultQueryRewriter.class);
    private static final String SPECIAL_ALIAS_CHARACTERS = "- ,.|*%()!#\u00a4/\\=?;:~";
    private static final Set<Class<? extends FunctionType>> SUPPORTED_FUNCTION_CLASSES = new HashSet<Class>(Arrays.asList(CountAggregateFunction.class, SumAggregateFunction.class, MaxAggregateFunction.class, MinAggregateFunction.class, AverageAggregateFunction.class));

    public DefaultQueryRewriter(JdbcDataContext dataContext) {
        super(dataContext);
    }

    @Override
    protected Query beforeRewrite(Query query) {
        String identifierQuoteString;
        query = query.clone();
        JdbcDataContext dataContext = this.getDataContext();
        if (dataContext != null && (identifierQuoteString = dataContext.getIdentifierQuoteString()) != null) {
            List selectItems = query.getSelectClause().getItems();
            for (SelectItem item : selectItems) {
                String alias = item.getAlias();
                if (!this.needsQuoting(alias, identifierQuoteString)) continue;
                item.setAlias(identifierQuoteString + alias + identifierQuoteString);
            }
            List fromItems = query.getFromClause().getItems();
            for (FromItem item : fromItems) {
                String alias = item.getAlias();
                if (!this.needsQuoting(alias, identifierQuoteString)) continue;
                item.setAlias(identifierQuoteString + alias + identifierQuoteString);
            }
        }
        return query;
    }

    @Override
    public String rewriteColumnType(ColumnType columnType, Integer columnSize) {
        if (columnType == ColumnType.STRING) {
            return this.rewriteColumnType(ColumnType.VARCHAR, columnSize);
        }
        if (columnType == ColumnType.NUMBER) {
            return this.rewriteColumnType(ColumnType.FLOAT, columnSize);
        }
        return super.rewriteColumnType(columnType, columnSize);
    }

    protected boolean needsQuoting(String alias, String identifierQuoteString) {
        boolean result = false;
        if (alias != null && identifierQuoteString != null && alias.indexOf(identifierQuoteString) == -1) {
            for (int i = 0; i < SPECIAL_ALIAS_CHARACTERS.length(); ++i) {
                char specialCharacter = SPECIAL_ALIAS_CHARACTERS.charAt(i);
                if (alias.indexOf(specialCharacter) == -1) continue;
                result = true;
                break;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("needsQuoting(" + alias + "," + identifierQuoteString + ") = " + result);
        }
        return result;
    }

    @Override
    public String rewriteFilterItem(FilterItem item) {
        Object operand = item.getOperand();
        if (operand != null) {
            if (operand instanceof String) {
                String str = (String)operand;
                if (str.indexOf(39) != -1) {
                    str = this.escapeQuotes(str);
                    FilterItem replacementFilterItem = new FilterItem(item.getSelectItem(), item.getOperator(), (Object)str);
                    return super.rewriteFilterItem(replacementFilterItem);
                }
            } else {
                if (operand instanceof Timestamp) {
                    String timestampLiteral = this.rewriteTimestamp((Timestamp)operand);
                    return this.rewriteFilterItemWithOperandLiteral(item, timestampLiteral);
                }
                if (operand instanceof Iterable || operand.getClass().isArray()) {
                    assert (OperatorType.IN.equals(item.getOperator()) || OperatorType.NOT_IN.equals(item.getOperator()));
                    List elements = CollectionUtils.toList((Object)operand);
                    ListIterator<String> it = elements.listIterator();
                    while (it.hasNext()) {
                        String str;
                        Object next = it.next();
                        if (next == null) {
                            logger.warn("element in IN list is NULL, which isn't supported by SQL. Stripping the element from the list: {}", (Object)item);
                            it.remove();
                            continue;
                        }
                        if (!(next instanceof String) || (str = (String)next).indexOf(39) == -1) continue;
                        str = this.escapeQuotes(str);
                        it.set(str);
                    }
                    FilterItem replacementFilterItem = new FilterItem(item.getSelectItem(), item.getOperator(), (Object)elements);
                    return super.rewriteFilterItem(replacementFilterItem);
                }
            }
        }
        return super.rewriteFilterItem(item);
    }

    protected String rewriteFilterItemWithOperandLiteral(FilterItem item, String operandLiteral) {
        OperatorType operator = item.getOperator();
        SelectItem selectItem = item.getSelectItem();
        StringBuilder sb = new StringBuilder();
        sb.append(selectItem.getSameQueryAlias(false));
        FilterItem.appendOperator((StringBuilder)sb, (Object)item.getOperand(), (OperatorType)operator);
        sb.append(operandLiteral);
        return sb.toString();
    }

    protected String rewriteTimestamp(Timestamp ts) {
        return "{ts '" + ts.toString() + "'}";
    }

    @Override
    public boolean isScalarFunctionSupported(ScalarFunction function) {
        return SUPPORTED_FUNCTION_CLASSES.contains(function.getClass());
    }

    @Override
    public boolean isAggregateFunctionSupported(AggregateFunction function) {
        return SUPPORTED_FUNCTION_CLASSES.contains(function.getClass());
    }

    @Override
    public boolean isFirstRowSupported(Query query) {
        return false;
    }

    @Override
    public boolean isMaxRowsSupported() {
        return false;
    }

    @Override
    public String escapeQuotes(String item) {
        return item.replaceAll("\\'", "\\'\\'");
    }
}

