/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc.dialects;

import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.jdbc.dialects.OffsetFetchQueryRewriter;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.schema.ColumnType;

public class OracleQueryRewriter
extends OffsetFetchQueryRewriter {
    public static final int FIRST_FETCH_SUPPORTING_VERSION = 12;

    public OracleQueryRewriter(JdbcDataContext dataContext) {
        super(dataContext, 12, false);
    }

    @Override
    public String rewriteColumnType(ColumnType columnType, Integer columnSize) {
        if (columnType == ColumnType.NUMBER || columnType == ColumnType.NUMERIC || columnType == ColumnType.DECIMAL) {
            super.rewriteColumnTypeInternal("NUMBER", columnSize);
        }
        if (columnType == ColumnType.BOOLEAN || columnType == ColumnType.BIT) {
            return "NUMBER(3)";
        }
        if (columnType == ColumnType.DOUBLE) {
            return "BINARY_DOUBLE";
        }
        if (columnType == ColumnType.FLOAT) {
            return "BINARY_FLOAT";
        }
        if (columnType == ColumnType.BINARY || columnType == ColumnType.VARBINARY) {
            return "RAW";
        }
        if (columnType == ColumnType.TINYINT) {
            return "NUMBER(3)";
        }
        if (columnType == ColumnType.SMALLINT) {
            return "NUMBER(5)";
        }
        if (columnType == ColumnType.INTEGER) {
            return "NUMBER(10)";
        }
        if (columnType == ColumnType.BIGINT) {
            return "NUMBER(19)";
        }
        if (columnType == ColumnType.TIME) {
            super.rewriteColumnType(ColumnType.DATE, columnSize);
        }
        return super.rewriteColumnType(columnType, columnSize);
    }

    @Override
    public String rewriteFilterItem(FilterItem item) {
        if (item.getOperand() instanceof String && item.getOperand().equals("")) {
            return super.rewriteFilterItem(new FilterItem(item.getSelectItem(), item.getOperator(), null));
        }
        return super.rewriteFilterItem(item);
    }
}

