/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.create.AbstractTableCreationBuilder;
import org.apache.metamodel.jdbc.JdbcSchema;
import org.apache.metamodel.jdbc.JdbcUpdateCallback;
import org.apache.metamodel.jdbc.JdbcUtils;
import org.apache.metamodel.jdbc.dialects.IQueryRewriter;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JdbcCreateTableBuilder
extends AbstractTableCreationBuilder<JdbcUpdateCallback> {
    private static final Logger logger = LoggerFactory.getLogger(JdbcCreateTableBuilder.class);

    public JdbcCreateTableBuilder(JdbcUpdateCallback updateCallback, Schema schema, String name) {
        super((UpdateCallback)updateCallback, schema, name);
        if (!(schema instanceof JdbcSchema)) {
            throw new IllegalArgumentException("Not a valid JDBC schema: " + schema);
        }
    }

    public Table execute() {
        String sql = this.createSqlStatement();
        logger.info("Create table statement created: {}", (Object)sql);
        Connection connection = ((JdbcUpdateCallback)this.getUpdateCallback()).getConnection();
        Statement st = null;
        try {
            st = connection.createStatement();
            int rowsAffected = st.executeUpdate(sql);
            logger.debug("Create table statement executed, {} rows affected", (Object)rowsAffected);
        }
        catch (SQLException e) {
            try {
                throw JdbcUtils.wrapException(e, "execute create table statement: " + sql, JdbcUtils.JdbcActionType.UPDATE);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{st});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{st});
        JdbcSchema schema = (JdbcSchema)this.getSchema();
        schema.refreshTables(connection);
        return schema.getTableByName(this.getTable().getName());
    }

    protected String createSqlStatement() {
        return this.createSqlStatement((Table)this.getTable());
    }

    private String createSqlStatement(Table table) {
        IQueryRewriter queryRewriter = ((JdbcUpdateCallback)this.getUpdateCallback()).getJdbcDataContext().getQueryRewriter();
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        Schema schema = this.getSchema();
        if (schema != null && schema.getName() != null) {
            sb.append(schema.getQualifiedLabel());
            sb.append(".");
        }
        sb.append(((JdbcUpdateCallback)this.getUpdateCallback()).quoteIfNescesary(table.getName()));
        sb.append(" (");
        List columns = table.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            Column column = (Column)columns.get(i);
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(((JdbcUpdateCallback)this.getUpdateCallback()).quoteIfNescesary(column.getName()));
            sb.append(' ');
            String nativeType = column.getNativeType();
            Integer columnSize = column.getColumnSize();
            if (nativeType == null) {
                ColumnType columnType = column.getType();
                if (columnType == null) {
                    columnType = ColumnType.VARCHAR;
                }
                String columnTypeString = queryRewriter.rewriteColumnType(columnType, columnSize);
                sb.append(columnTypeString);
            } else {
                sb.append(nativeType);
                if (columnSize != null) {
                    sb.append('(');
                    sb.append(columnSize);
                    sb.append(')');
                }
            }
            if (column.isNullable() == null || column.isNullable().booleanValue()) continue;
            sb.append(" NOT NULL");
        }
        boolean primaryKeyExists = false;
        for (int i = 0; i < columns.size(); ++i) {
            if (!((Column)columns.get(i)).isPrimaryKey()) continue;
            if (!primaryKeyExists) {
                sb.append(", PRIMARY KEY(");
                sb.append(((Column)columns.get(i)).getName());
                primaryKeyExists = true;
                continue;
            }
            sb.append(",");
            sb.append(((Column)columns.get(i)).getName());
        }
        if (primaryKeyExists) {
            sb.append(")");
        }
        sb.append(")");
        return sb.toString();
    }
}

