/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc;

import java.sql.SQLException;
import java.util.List;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.jdbc.JdbcCompiledQueryLease;
import org.apache.metamodel.jdbc.JdbcCompiledQueryLeaseFactory;
import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.jdbc.JdbcUtils;
import org.apache.metamodel.query.CompiledQuery;
import org.apache.metamodel.query.DefaultCompiledQuery;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.SelectItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JdbcCompiledQuery
extends DefaultCompiledQuery
implements CompiledQuery {
    private static final Logger logger = LoggerFactory.getLogger(JdbcCompiledQuery.class);
    private final String _sql;
    private final Query _query;
    private final GenericObjectPool<JdbcCompiledQueryLease> _pool;
    private boolean _closed;

    public JdbcCompiledQuery(JdbcDataContext dc, Query query) {
        super(query);
        this._query = query;
        this._sql = dc.getQueryRewriter().rewriteQuery(query);
        GenericObjectPool.Config config = new GenericObjectPool.Config();
        config.maxActive = this.getSystemPropertyValue("metamodel.jdbc.compiledquery.pool.max.size", -1);
        config.minEvictableIdleTimeMillis = this.getSystemPropertyValue("metamodel.jdbc.compiledquery.pool.idle.timeout", 500);
        config.timeBetweenEvictionRunsMillis = this.getSystemPropertyValue("metamodel.jdbc.compiledquery.pool.eviction.period.millis", 1000);
        this._pool = new GenericObjectPool((PoolableObjectFactory)new JdbcCompiledQueryLeaseFactory(dc, this._sql), config);
        this._closed = false;
        logger.debug("Created compiled JDBC query: {}", (Object)this._sql);
    }

    private int getSystemPropertyValue(String property, int defaultValue) {
        String str = System.getProperty(property);
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            logger.debug("Failed to parse system property '{}': '{}'", (Object)property, (Object)str);
            return defaultValue;
        }
    }

    public JdbcCompiledQueryLease borrowLease() {
        if (logger.isDebugEnabled()) {
            logger.debug("Borrowing lease. Leases (before): Active={}, Idle={}", (Object)this.getActiveLeases(), (Object)this.getIdleLeases());
        }
        try {
            return (JdbcCompiledQueryLease)this._pool.borrowObject();
        }
        catch (Exception e) {
            throw this.handleError(e, "borrow lease");
        }
    }

    public void returnLease(JdbcCompiledQueryLease lease) {
        if (logger.isDebugEnabled()) {
            logger.debug("Returning lease. Leases (before): Active={}, Idle={}", (Object)this.getActiveLeases(), (Object)this.getIdleLeases());
        }
        try {
            this._pool.returnObject((Object)lease);
        }
        catch (Exception e) {
            throw this.handleError(e, "return lease");
        }
    }

    private RuntimeException handleError(Exception e, String message) {
        if (logger.isWarnEnabled()) {
            logger.warn("Unexpected error occurred in compiled JDBC query: " + message, (Throwable)e);
        }
        if (e instanceof SQLException) {
            return JdbcUtils.wrapException((SQLException)e, message, JdbcUtils.JdbcActionType.OTHER);
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new MetaModelException(message, e);
    }

    protected int getActiveLeases() {
        return this._pool.getNumActive();
    }

    protected int getIdleLeases() {
        return this._pool.getNumIdle();
    }

    protected Query getQuery() {
        return this._query;
    }

    public String toSql() {
        return this._sql;
    }

    public void close() {
        logger.debug("Closing compiled JDBC query: {}", (Object)this._sql);
        try {
            this._pool.close();
        }
        catch (Exception e) {
            throw this.handleError(e, "close pool of leases");
        }
        finally {
            this._closed = true;
        }
    }

    protected List<SelectItem> getSelectItems() {
        return this._query.getSelectClause().getItems();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this._closed) {
            logger.warn("finalize() invoked, but DataSet is not closed. Invoking close() on {}", (Object)this);
            this.close();
        }
    }
}

