/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.jdbc.JdbcUpdateCallback;
import org.apache.metamodel.jdbc.JdbcUtils;
import org.apache.metamodel.jdbc.dialects.IQueryRewriter;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.FromItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.update.AbstractRowUpdationBuilder;
import org.apache.metamodel.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JdbcUpdateBuilder
extends AbstractRowUpdationBuilder {
    private static final Logger logger = LoggerFactory.getLogger(JdbcUpdateBuilder.class);
    private final boolean _inlineValues;
    private final JdbcUpdateCallback _updateCallback;
    private final IQueryRewriter _queryRewriter;

    public JdbcUpdateBuilder(JdbcUpdateCallback updateCallback, Table table, IQueryRewriter queryRewriter) {
        this(updateCallback, table, queryRewriter, false);
    }

    public JdbcUpdateBuilder(JdbcUpdateCallback updateCallback, Table table, IQueryRewriter queryRewriter, boolean inlineValues) {
        super(table);
        this._updateCallback = updateCallback;
        this._queryRewriter = queryRewriter;
        this._inlineValues = inlineValues;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MetaModelException {
        String sql = this.createSqlStatement();
        logger.debug("Update statement created: {}", (Object)sql);
        boolean reuseStatement = !this._inlineValues;
        PreparedStatement st = this._updateCallback.getPreparedStatement(sql, reuseStatement);
        try {
            if (reuseStatement) {
                Column[] columns = this.getColumns();
                Object[] values = this.getValues();
                boolean[] explicitNulls = this.getExplicitNulls();
                int valueCounter = 1;
                for (int i = 0; i < columns.length; ++i) {
                    boolean explicitNull = explicitNulls[i];
                    if (values[i] == null && !explicitNull) continue;
                    this._queryRewriter.setStatementParameter(st, valueCounter, columns[i], values[i]);
                    ++valueCounter;
                }
                List whereItems = this.getWhereItems();
                for (FilterItem whereItem : whereItems) {
                    if (!JdbcUtils.isPreparedParameterCandidate(whereItem)) continue;
                    Object operand = whereItem.getOperand();
                    Column column = whereItem.getSelectItem().getColumn();
                    this._queryRewriter.setStatementParameter(st, valueCounter, column, operand);
                    ++valueCounter;
                }
            }
            this._updateCallback.executePreparedStatement(st, reuseStatement);
            if (!this._inlineValues) return;
        }
        catch (SQLException e) {
            try {
                throw JdbcUtils.wrapException(e, "execute update statement: " + sql);
            }
            catch (Throwable throwable) {
                if (!this._inlineValues) throw throwable;
                FileHelper.safeClose((Object[])new Object[]{st});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{st});
        return;
    }

    protected String createSqlStatement() {
        return this.createSqlStatement(this._inlineValues);
    }

    private String createSqlStatement(boolean inlineValues) {
        Object[] values = this.getValues();
        Table table = this.getTable();
        StringBuilder sb = new StringBuilder();
        String tableLabel = this._queryRewriter.rewriteFromItem(new FromItem(table));
        sb.append("UPDATE ");
        sb.append(tableLabel);
        sb.append(" SET ");
        Column[] columns = this.getColumns();
        boolean[] explicitNulls = this.getExplicitNulls();
        boolean firstValue = true;
        for (int i = 0; i < columns.length; ++i) {
            Object value = values[i];
            if (value == null && !explicitNulls[i]) continue;
            if (firstValue) {
                firstValue = false;
            } else {
                sb.append(',');
            }
            String columnName = columns[i].getName();
            columnName = this._updateCallback.quoteIfNescesary(columnName);
            sb.append(columnName);
            sb.append('=');
            if (inlineValues) {
                sb.append(JdbcUtils.getValueAsSql(columns[i], value, this._queryRewriter));
                continue;
            }
            sb.append('?');
        }
        sb.append(JdbcUtils.createWhereClause(this.getWhereItems(), this._queryRewriter, inlineValues));
        String sql = sb.toString();
        return sql;
    }

    public String toSql() {
        return this.createSqlStatement(true);
    }
}

